/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.database;

import com.evermind.server.ejb.database.DatabaseField;
import com.evermind.server.ejb.database.TableNameContainer;
import com.evermind.util.ArraySet;
import java.util.Iterator;
import java.util.Set;

public class Table {
    private String dataSourceName;
    private TableNameContainer name;
    private Set fields = new ArraySet();
    private String schemaName;
    private String tableName;

    public Table(TableNameContainer name, String[] parsedNames) {
        this.name = name;
        this.schemaName = parsedNames[1];
        this.tableName = parsedNames[2];
    }

    public Table(TableNameContainer name) {
        this.name = name;
        this.setNames(this.name.getTableName());
    }

    public Table(String tname) {
        if (this.name != null) {
            this.name.setTableName(tname);
            this.setNames(this.name.getTableName());
        }
    }

    public boolean isDatabaseNameTaken(String name) {
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            DatabaseField field = (DatabaseField)iterator.next();
            if (!field.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name.getTableName();
    }

    private void setNames(String tableName) {
        String[] parsedNames = Table.parseTableName(tableName);
        this.schemaName = parsedNames[1];
        this.tableName = parsedNames[2];
    }

    public static String[] parseTableName(String fullTableName) {
        String fullPrefix = null;
        String schemaName = null;
        String tableName = fullTableName;
        int delimiterPos = tableName.lastIndexOf(46);
        if (delimiterPos >= 0) {
            tableName = fullTableName.substring(delimiterPos + 1);
            fullPrefix = fullTableName.substring(0, delimiterPos);
            schemaName = fullPrefix;
            if ((delimiterPos = schemaName.lastIndexOf(46)) > 0) {
                schemaName = schemaName.substring(delimiterPos + 1);
            } else {
                delimiterPos = schemaName.lastIndexOf(64);
                if (delimiterPos > 0) {
                    schemaName = schemaName.substring(delimiterPos + 1);
                }
            }
        } else {
            delimiterPos = tableName.lastIndexOf(64);
            if (delimiterPos >= 0) {
                fullPrefix = tableName.substring(0, delimiterPos);
                tableName = tableName.substring(delimiterPos + 1);
            }
        }
        String[] parsedNames = new String[]{fullPrefix, schemaName, tableName};
        return parsedNames;
    }

    public String getShortName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public TableNameContainer getTableNameContainer() {
        return this.name;
    }
}

