/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.LocalStatelessSessionEJBObject;
import com.evermind.server.ejb.RemoteStatelessSessionEJBObject;
import com.evermind.server.ejb.compilation.BeanCompilation;
import com.evermind.server.ejb.compilation.Compilation;
import com.evermind.server.ejb.compilation.InterceptorBeanMethodCompilation;
import com.evermind.server.ejb.compilation.MethodCompilation;
import com.evermind.server.ejb.compilation.StatelessSessionHomeCompilation;
import com.evermind.server.ejb.deployment.ExposableBeanDescriptor;
import com.evermind.server.ejb.deployment.SessionBeanDescriptor;
import java.lang.reflect.Method;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;

public class StatelessSessionBeanCompilation
extends BeanCompilation {
    public StatelessSessionHomeCompilation home;
    public SessionBeanDescriptor descriptor;

    public StatelessSessionBeanCompilation(Compilation compilation, SessionBeanDescriptor descriptor, boolean local) throws CompilationException {
        super(compilation, "StatelessSessionBeanWrapper", local ? descriptor.getLocalInterface() : descriptor.getRemoteInterface(), local);
        this.descriptor = descriptor;
        if (local) {
            if (descriptor.getLocalHomeWrapperName() == null) {
                this.home = new StatelessSessionHomeCompilation(this);
            }
        } else if (descriptor.getRemoteHomeWrapperName() == null) {
            this.home = new StatelessSessionHomeCompilation(this);
        }
        if (local) {
            descriptor.setLocalWrapperName(this.getName());
        } else {
            descriptor.setRemoteWrapperName(this.getName());
        }
    }

    public ExposableBeanDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void cleanSource() {
        this.resetSource();
    }

    public void compile() throws CompilationException {
        this.compileMethods();
        if (this.descriptor.isServiceEndpoint() && this.descriptor.getRemoteInterface() != null) {
            this.compileMethods(this.descriptor.getServiceEndpoint());
        }
        this.source.append("import javax.ejb.*;\nimport java.rmi.NoSuchObjectException;\nimport com.evermind.server.ejb.*;\nimport com.evermind.server.*;\nimport javax.transaction.*;\n\n");
        this.addSharedImports();
        this.appendClassHeader();
        this.appendConstructor();
        this.appendCreateBeanInstanceMethod();
        this.appendMethods();
        this.appendStaticDeclaration();
        this.appendStaticFunction();
        this.source.append("}\n");
        this.compilation.addGenerator(this);
        if (this.home != null) {
            this.home.compile();
        }
    }

    private void appendClassHeader() {
        this.source.append("public class " + this.className + " extends " + this.getBaseClass().getName() + " implements " + this.interfaceClass.getName());
        if (this.descriptor.isServiceEndpoint() && !this.interfaceClass.getName().equals(this.descriptor.getServiceEndpointName())) {
            this.source.append(", " + this.descriptor.getServiceEndpointName());
        }
        this.source.append(" {\n");
        this.source.append("static final long serialVersionUID = ApplicationServer.computeSerialVersionUID(\"" + this.className + "\");\n");
    }

    private Class getBaseClass() {
        Class clazz = this.local ? LocalStatelessSessionEJBObject.class : RemoteStatelessSessionEJBObject.class;
        return clazz;
    }

    private void appendConstructor() {
        this.source.append("public " + this.className + "( StatelessSessionEJBHome home ) {\n" + "super(home);\n");
        this.source.append("}\n\n");
    }

    private void appendCreateBeanInstanceMethod() {
        this.source.append("public Object OC4J_createBeanInstance() throws Exception {\nreturn new " + this.getDescriptor().getEJBClassName() + "();\n");
        this.source.append("}\n\n");
    }

    public MethodCompilation compileMethod(Method method) throws CompilationException {
        return this.compileMethod(method, this.local);
    }

    public MethodCompilation compileMethod(Method method, boolean isLocal) throws CompilationException {
        Class clazz = isLocal ? EJBLocalObject.class : EJBObject.class;
        if (method.getDeclaringClass() == clazz) {
            return null;
        }
        InterceptorBeanMethodCompilation methodWrapper = new InterceptorBeanMethodCompilation(this, this.getDescriptor(), method, false, false, method.getName(), isLocal);
        ((MethodCompilation)methodWrapper).compile();
        return methodWrapper;
    }
}

