/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.compilation.EJBCompilationUtils;
import com.evermind.server.ejb.compilation.EntityBeanCompilation;
import com.evermind.server.ejb.compilation.EntityBeanMethodCompilation;
import com.evermind.server.ejb.database.TableIteration;
import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.util.ByteString;
import com.evermind.util.ClassUtils;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.ejb.TimedObject;

public class RemoveEntityBeanMethodCompilation
extends EntityBeanMethodCompilation {
    String quickHome = "((EntityEJBHome) getMyHome())";
    String quickWrapper;
    String qqWrapper;
    private boolean useSuperUserTransaction = true;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Set;

    public RemoveEntityBeanMethodCompilation(EntityBeanCompilation bean, Method method, boolean local) throws CompilationException {
        super(bean, method, "ejbRemove", local);
        if (local) {
            this.quickWrapper = "((EntityEJBObject)context.localWrapper)";
            this.qqWrapper = "context.localWrapper";
        } else {
            this.quickWrapper = "((EntityEJBObject)context.remoteWrapper)";
            this.qqWrapper = "context.remoteWrapper";
        }
    }

    public String getIsUserTransactionExpression() {
        if (this.useSuperUserTransaction) {
            return super.getIsUserTransactionExpression();
        }
        return "isUserTransaction";
    }

    public void compile() throws CompilationException {
        if (this.compilation.getEntityBeanDescriptor().isReadOnlyBMP()) {
            this.compileForReadOnlyBMP();
            return;
        }
        if (this.compilation.getEntityBeanDescriptor().isContainerManaged()) {
            this.source.append("// ");
            this.source.append(this.compilation.persistenceManagerCompilation.table.getPreparedDeleteStatement(false), true);
            this.source.append("\n");
        }
        this.addMethodWrapperStart();
        this.addTransactionWrapperStart(true);
        this.source.append("methodException = __removeCore(thread, methodException, " + super.getIsUserTransactionExpression() + ");\n");
        ByteString newSource = new ByteString(200);
        ByteString originalSource = this.source;
        this.source = newSource;
        this.useSuperUserTransaction = false;
        this.source.append("\npublic Throwable __removeCore(ThreadState thread, Throwable methodException, boolean isUserTransaction) throws javax.ejb.RemoveException" + (this.local ? "" : ", java.rmi.RemoteException") + "\n" + "{\n");
        this.source.append("Transaction tx = " + EJBCompilationUtils.getTransactionString() + ";\n");
        if (!this.isGetterOnly) {
            this.source.append(this.compilation.createStateKeepers());
        }
        this.addEJBInvocation(false);
        this.source.append("if(methodException != null)\n{\n" + this.qqWrapper + " = null;\n" + "((EntityEJBHome)getMyHome()).releaseContextInstance(this.context);\n" + "this.context = null;\n " + "return methodException;\n" + "}\n");
        this.source.append("try\n{\n");
        TableIteration tableIteration = new TableIteration();
        if (this.compilation.getEntityBeanDescriptor().isContainerManaged()) {
            this.source.append("DataSourceConnection connection = " + EJBCompilationUtils.getTransactionEqualsNullString() + " ? ((EntityEJBHome)getMyHome()).dataSourceContainer.get" + (this.isLocal() ? "Local" : "") + "Connection() : " + EJBCompilationUtils.getTransactionString() + ".get" + (this.isLocal() ? "Local" : "") + "Connection(((EntityEJBHome)getMyHome()).dataSourceContainer);\n");
            this.source.append("String sqlStatement = null;\n");
            this.source.append("try\n{\n");
            this.source.append("if(this.context.getObject() != null && methodException == null) {\n");
            Iterator cmfs = this.compilation.getEntityBeanDescriptor().getContainerManagedFields().iterator();
            while (cmfs.hasNext()) {
                ContainerManagedField field = (ContainerManagedField)cmfs.next();
                if (field.getPeer() != null) {
                    if (field.getPeer().isCascadeDelete()) {
                        if (field.getORMapping() != null) {
                            this.source.append("if(this._getObject()." + field.getName() + " == null)\n");
                            this.source.append("this._getObject()." + field.getName() + " = new " + field.getORMapping().getWrapperName() + "(context);\n");
                            this.source.append("com.evermind.server.ejb.EJBUtils.deleteOR(this._getObject()." + field.getName() + ", true);\n\n");
                        } else {
                            this.source.append("if(this.context.getObject() != null && this._getObject()." + field.getName() + " != null)\n" + "{\n" + "try\n" + "{\n" + "com.evermind.server.ejb.EntityEJBObject cascadeRemove = (com.evermind.server.ejb.EntityEJBObject)this._getObject()." + field.getName() + ";\n" + "this._getObject()." + field.getName() + " = null;\n" + "if (!cascadeRemove.__isRemoved())\n" + "    cascadeRemove.__removeIfAlive();\n" + "}\n" + "catch(java.rmi.RemoteException e)\n" + "{\n" + this.getLogAndRollbackCode("e", true) + "}\n" + "catch(javax.ejb.EJBException e)\n" + "{\n" + this.getLogAndRollbackCode("e", true) + "}\n" + "catch(javax.ejb.RemoveException e)\n" + "{\n" + this.getLogAndRollbackCode("e", true) + "}\n" + "}\n");
                        }
                    } else if (field.getPeer().getRelation() != null) {
                        String emptyType;
                        block32: {
                            if (field.getType() == (class$java$util$Collection == null ? RemoveEntityBeanMethodCompilation.class$("java.util.Collection") : class$java$util$Collection)) {
                                emptyType = "java.util.Collections.EMPTY_LIST";
                            } else if (field.getType() == (class$java$util$Set == null ? RemoveEntityBeanMethodCompilation.class$("java.util.Set") : class$java$util$Set)) {
                                emptyType = null;
                                try {
                                    Class<?> c = Class.forName("java.util.Collections");
                                    if (c.getField("EMPTY_SET") == null) {
                                        emptyType = "new java.util.HashSet()";
                                        break block32;
                                    }
                                    emptyType = "java.util.Collections.EMPTY_SET";
                                }
                                catch (Throwable t) {
                                    emptyType = "new java.util.HashSet()";
                                }
                            } else {
                                emptyType = "null";
                            }
                        }
                        this.source.append("if(this.context != null && this.context.getObject() != null) this._getObject().__core__set" + field.getName() + "(" + emptyType + ");\n");
                    }
                }
                this.compilation.persistenceManagerCompilation.table.appendPreparedSet(this.source, false, "statement", field.getType(), tableIteration, "this._getObject()." + field.getName(), field, "context", false);
            }
            this.source.append("}\n");
        }
        if (this.compilation.getEntityBeanDescriptor().isContainerManaged()) {
            long timeout;
            this.source.append("if(this.context != null)\n{\n");
            this.addRemoveTimers();
            this.source.append("PreparedStatement statement = EJBPrivileged.getCustomStatement(connection, \"");
            this.source.append(this.compilation.persistenceManagerCompilation.table.getPreparedDeleteStatement(false), true);
            this.source.append("\"");
            EntityBeanDescriptor bean = this.compilation.descriptor;
            if (bean.getBatchSize() > 1) {
                this.source.append("," + bean.getBatchSize() + ",false");
            }
            this.source.append(");\n");
            this.source.append("sqlStatement = \"" + this.compilation.persistenceManagerCompilation.table.getPreparedDeleteStatement(false) + "\";\n");
            if (this.compilation.getEntityBeanDescriptor().getPrimaryKeyFieldName() != null || this.compilation.getEntityBeanDescriptor().isAutomaticIdentity()) {
                ContainerManagedField mainField = this.compilation.getEntityBeanDescriptor().getPrimaryKey();
                try {
                    this.compilation.persistenceManagerCompilation.table.appendPreparedSet(this.source, false, "statement", mainField.getType(), tableIteration, ClassUtils.getConvertSource("this.primaryKey", this.compilation.descriptor.getPrimaryKeyClass(), mainField.getType()), mainField, "context", true);
                }
                catch (IllegalArgumentException e) {
                    throw new CompilationException("Incompatible type for prim-key-class and the type of the specified primkey-field: " + e.getMessage());
                }
            } else {
                Iterator pfs = this.compilation.descriptor.getPrimaryKey().getPropertyFields().iterator();
                while (pfs.hasNext()) {
                    ContainerManagedField field = (ContainerManagedField)pfs.next();
                    this.compilation.persistenceManagerCompilation.table.appendPreparedSet(this.source, false, "statement", field.getType(), tableIteration, "this.__" + field.getName(), field, "context", true);
                }
            }
            if ((timeout = this.compilation.getEntityBeanDescriptor().getCallTimeout()) > 0L) {
                this.source.append(" statement.setQueryTimeout(" + (int)(timeout / 1000L) + ");\n");
            }
            this.source.append("try\n{");
            if (bean.getBatchSize() > 1) {
                this.source.append("statement.executeUpdate();\n");
            } else {
                this.source.append("if(statement.executeUpdate() < 1)\n{\nmethodException = new javax.ejb.RemoveException(\"No such entity: \" + this.getPrimaryKey());\n}\n");
            }
            this.source.append("} finally { try{\n statement.close();\n } catch(java.sql.SQLException e) {}\n }\n");
            this.source.append("}\n");
        }
        if (this.compilation.getEntityBeanDescriptor().isContainerManaged() && this.compilation.getEntityBeanDescriptor().getCommitOption().isCacheable()) {
            this.source.append("this._getObject()._setState(ExtendedContainerManagedObject.State.k_removed, false);");
        }
        this.source.append("}\n");
        if (this.compilation.getEntityBeanDescriptor().isContainerManaged()) {
            this.source.append("catch(SQLException e) {\n");
            this.source.append(this.getLogAndRollbackCode("e", true) + "if (SystemProperties.SQLLOG) \n" + "{\n" + "methodException = new " + (this.isLocal() ? "javax.ejb.EJBException" : "oracle.oc4j.rmi.OracleRemoteException") + "(\"Database error: \" + e.getMessage()\n +  sqlStatement, e);\n" + "}\n" + "else \n" + "{\n" + "methodException = new " + (this.isLocal() ? "javax.ejb.EJBException" : "oracle.oc4j.rmi.OracleRemoteException") + "(\"Database error: \" + e.getMessage(), e);\n" + "}\n");
            this.source.append("}\n");
            this.source.append("finally\n{\n");
            this.source.append("if( tx == null )\n{\n" + "" + "connection.close(true);\n" + "connection = null;\n" + "this.context.setLazy(true);\n" + "}\n");
            this.source.append("}\n");
            this.source.append("}\n");
        }
        this.source.append("finally\n{\n");
        this.source.append("ApplicationServerTransactionSynchronization sync = " + EJBCompilationUtils.getSynchronizationString() + ";\nif (sync != null) {\n" + "sync.unregisterEntityBean(this);\n" + "}\n");
        this.source.append("if(this.context != null)\n{\nif(methodException == null) {\n" + this.quickHome + ".releaseContextInstance(this.context);\n" + "this.context = null;\n" + "}\n");
        if (!this.compilation.getEntityBeanDescriptor().isContainerManaged()) {
            this.source.append("if (transaction != null) transaction.removeBean(this);");
            if (this.compilation.getEntityBeanDescriptor().isReadOnlyBMP() || this.compilation.getEntityBeanDescriptor().isBMP() && this.compilation.getEntityBeanDescriptor().getCommitOption().isCacheableOptionA()) {
                this.source.append("((com.evermind.server.ejb.cache.BMPCacheManager) _cacheMgr).removeForBMP(getPrimaryKey(), getBeanDescriptor());");
            }
        }
        this.source.append("}\n}\n");
        this.source.append("return methodException;\n}\n");
        this.useSuperUserTransaction = true;
        this.source = originalSource;
        this.addTransactionWrapperEnd(true);
        this.addMethodWrapperEnd();
        this.source.append(newSource);
    }

    protected void compileForReadOnlyBMP() {
        this.appendMethodWrapperStart(this.synced);
        this.source.append("\n{ throw new javax.ejb.RemoveException(\"Can not remove read-only entity bean.\"); \n}");
        this.source.append("public Throwable __removeCore(ThreadState thread, Throwable methodException, boolean isUserTransaction) \n   throws javax.ejb.RemoveException, java.rmi.RemoteException \n");
        this.source.append("\n{ throw new javax.ejb.RemoveException(\"Can not remove read-only entity bean.\"); \n}");
    }

    protected void addTargetInvocation(String variableName) {
        this.source.append("this.getMyHome().getBeanDescriptor().getLifecycleManager().preDestroy(this._getObject(), context);\n");
        if (this.compilation.getEntityBeanDescriptor().isBMP()) {
            this.addRemoveTimers();
        }
    }

    protected void addRemoveTimers() {
        if (TimedObject.class.isAssignableFrom(this.compilation.getEntityBeanDescriptor().getEJBClass())) {
            this.source.append("try { context.removeTimers();\n} catch (Exception e ) {\n   traceLog(\"Warning: unable to cancel timers during entity bean remove, exception = \" + e.getMessage());\n}\n");
        }
    }

    protected void addPostCallSource(ByteString source) {
    }
}

