/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.Compilable;
import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.compilation.BeanCompilation;
import com.evermind.server.ejb.compilation.BeanMethodCompilation;
import com.evermind.server.ejb.compilation.ClassCompilation;
import com.evermind.server.ejb.compilation.EJBCompilationUtils;
import com.evermind.server.ejb.compilation.EntityBeanCompilation;
import com.evermind.server.ejb.database.AssociateTableView;
import com.evermind.server.ejb.database.Table;
import com.evermind.server.ejb.database.TableIteration;
import com.evermind.server.ejb.database.TableView;
import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.deployment.ORMapping;
import com.evermind.util.ByteString;
import com.evermind.util.ClassUtils;
import java.util.HashSet;
import java.util.TreeSet;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;

public abstract class ORCompilation
implements Compilable {
    protected boolean local = true;
    protected ORMapping mapping;
    protected ByteString source = new ByteString(256);
    protected EntityBeanCompilation compilation;
    protected TableView primaryKeysTable;
    protected TableView nonPrimaryKeyTable;
    protected ContainerManagedField orField;
    private String name;
    protected String valueTypeName;
    protected ORCompilation slave;

    public ORCompilation(ORCompilation slave) {
        this.slave = slave;
    }

    public ORCompilation() {
    }

    public void cleanSource() {
        this.source.reset();
        this.compilation.cleanSource();
    }

    public void setEnvironment(ContainerManagedField orField, EntityBeanCompilation compilation) {
        if (orField == null) {
            throw new NullPointerException("orField was null");
        }
        this.orField = orField;
        this.compilation = compilation;
    }

    public abstract boolean init() throws CompilationException;

    protected boolean init(String name) throws CompilationException {
        this.mapping = this.orField.getORMapping();
        if (this.name == null) {
            String masterName = this.compilation.descriptor.getRemoteInterfaceName() == null ? this.compilation.descriptor.getLocalInterfaceName() : this.compilation.descriptor.getRemoteInterfaceName();
            masterName = masterName.substring(masterName.lastIndexOf(46) + 1);
            String className = this.orField.getORMapping().getValueField().getType().getName();
            className = className.substring(className.lastIndexOf(46) + 1);
            this.name = masterName + '_' + className + '_' + name + ClassCompilation.getNextID();
        }
        try {
            if (!this.constructTable()) {
                return false;
            }
        }
        catch (InstantiationException e) {
            throw new CompilationException(e.getMessage());
        }
        this.compilation.compilation.addGenerator(this);
        this.valueTypeName = this.mapping.getValueField().getType().getName();
        return true;
    }

    protected void appendImports() {
        this.source.append("// DMS begins\n");
        this.source.append("import com.evermind.server.ApplicationServer;\nimport oracle.dms.instrument.*;\n\n");
        this.source.append("// DMS ends\n");
        this.source.append("import java.util.*;\n");
        this.source.append("import java.sql.*;\n");
        this.source.append("import com.evermind.server.*;\n");
        this.source.append("import com.evermind.server.ejb.*;\n");
        this.source.append("\n");
    }

    public void appendInitializeObject() throws CompilationException {
        if (this.mapping.peer != null) {
            EntityBeanCompilation entity;
            String ejbName;
            ORMapping peerMapping;
            BeanCompilation compilation;
            this.source.append("public void notifyAddedObject(Object object)\n{\nthis.checkScope();\ncom.evermind.server.ejb.EJBUtils.confirmAlive(object);\n");
            if (this.mapping.peer.getRoleSource() != null && (compilation = this.compilation.compilation.getCompilation(this.mapping.peer.getRoleSource().getName())) instanceof EntityBeanCompilation) {
                this.source.append("if(!(object instanceof " + compilation.getName() + ")) throw new IllegalArgumentException(\"Illegal adding to collecion cmr-field, not the specified content type of this field, See the EJB 2.0 specification chapter 10.3.8\");\n");
            }
            if (this.mapping.peer.getPeer().isMany()) {
                try {
                    peerMapping = ORMapping.getPeerORMapping(this.orField, this.mapping.peer);
                }
                catch (InstantiationException e) {
                    throw new CompilationException(e.getMessage());
                }
                ejbName = peerMapping.compilation.compilation.getName();
                if (peerMapping.peer.getPeer().getRelation() != null) {
                    this.source.append(this.compilation.persistenceManagerCompilation.getName() + " fromPersistenceManager = (" + this.compilation.persistenceManagerCompilation.getName() + ")context.getObject();\n");
                    this.source.append("fromPersistenceManager.__setDirty(\"" + this.orField.getName() + "\");\n");
                    if (!this.orField.isBiDirectional() || !this.orField.isManyToMany()) {
                        this.source.append("if (((CMRCollectionField)(((" + peerMapping.compilation.compilation.persistenceManagerCompilation.getName() + ")((" + ejbName + ")object).context.getObject())." + peerMapping.peer.getPeer().getRelation().getName() + ")) != null)\n");
                        this.source.append("{\n");
                        this.source.append("boolean _loaded = ((CMRCollectionField)(((" + peerMapping.compilation.compilation.persistenceManagerCompilation.getName() + ")((" + ejbName + ")object).context.getObject())." + peerMapping.peer.getPeer().getRelation().getName() + ")).isLoaded(); \n" + "if (!_loaded) return ;\n");
                        this.source.append("}\n");
                    }
                    this.source.append("com.evermind.server.ejb.EJBUtils.notifyManyToManyAdd((" + ejbName + ")object, ((" + peerMapping.compilation.compilation.persistenceManagerCompilation.getName() + ")((" + ejbName + ")object).context.getObject())." + peerMapping.peer.getPeer().getRelation().getName() + ", (com.evermind.server.ejb.AbstractEJBObject)context.getAnEJBObject_Local_or_Remote());\n");
                }
            } else if (this.getPeerField() != null) {
                entity = (EntityBeanCompilation)this.compilation.compilation.getCompilation(this.mapping.peer.getRoleSource().getName());
                if (entity == null) {
                    throw new CompilationException("No such EJB: '" + this.mapping.peer.getRoleSource().getName() + "'");
                }
                this.source.append("com.evermind.server.ThreadState state = com.evermind.server.ThreadState.getCurrentState();\ncom.evermind.server.ApplicationServerTransaction transaction = (com.evermind.server.ApplicationServerTransaction)" + EJBCompilationUtils.getTransactionManagerString() + ".getTransaction();\n" + this.compilation.persistenceManagerCompilation.getName() + " fromPersistenceManager;\n" + entity.persistenceManagerCompilation.getName() + " toPersistenceManager;\n" + entity.getName() + " entity = (" + entity.getName() + ")object;\n" + "toPersistenceManager = (" + entity.persistenceManagerCompilation.getName() + ")entity.getEntityBean();\n" + this.compilation.getName() + " oldValue = (" + this.compilation.getName() + ")toPersistenceManager." + this.getPeerField() + ";\n" + this.compilation.getName() + " newValue = (" + this.compilation.getName() + ")this.context.getEJB" + (this.compilation.local ? "Local" : "") + "Object();\n" + "if(newValue == oldValue) return;\n" + "\n" + "if(oldValue != null)\n" + "{\n" + "boolean oldInCall = oldValue.__allocateCoreInstance(state, 900001, true);\n" + "oldValue = (" + this.compilation.getName() + ")oldValue.__getCoreInstance();\n" + "\n" + "try\n" + "{\n" + "if(transaction != null)\n" + "{\n" + EJBCompilationUtils.getRegisterBeanUncheckedString("oldValue") + ";\n" + "oldValue.transaction = transaction;\n" + "}\n" + "\n" + "fromPersistenceManager = (" + this.compilation.persistenceManagerCompilation.getName() + ")oldValue.getEntityBean();\n" + "if(fromPersistenceManager." + this.orField.getName() + " == null)\n" + "fromPersistenceManager." + this.orField.getName() + " = new " + this.getName() + "(oldValue.context);\n" + "\n");
                if (!(ORMapping.ASSOC_TABLES_USER_PREF && !this.orField.isManyToMany() || this.orField.isBiDirectional() && this.orField.isManyToMany())) {
                    this.source.append("if (((CMRCollectionField)(fromPersistenceManager." + this.orField.getName() + ")).isLoaded())\n" + "{\n");
                }
                this.source.append("((CMRCollectionField)(fromPersistenceManager." + this.orField.getName() + ")).remove(entity, true, false);\n" + "fromPersistenceManager.__setDirty(\"" + this.orField.getName() + "\");\n");
                if (!(ORMapping.ASSOC_TABLES_USER_PREF && !this.orField.isManyToMany() || this.orField.isBiDirectional() && this.orField.isManyToMany())) {
                    this.source.append("}\n");
                }
                this.source.append("}\nfinally\n{\noldValue.endCallLocal(oldInCall);\n}\n}\n\nboolean inCall = entity.__allocateCoreInstance(state, 90000l, true);\nentity = (" + entity.getName() + ")entity.__getCoreInstance();\n" + "try\n" + "{\n" + "if(transaction != null)\n" + "{\n" + EJBCompilationUtils.getRegisterBeanUncheckedString("entity") + ";\n" + "entity.transaction = transaction;\n" + "}\n" + "\n");
                if (this.mapping.isOneToManyBiSlave() && !this.orField.isSynthetic()) {
                    this.source.append("if(entity.context.isSqlExecuted() && ((EntityEJBObject)entity).context.isLazy()) {\ntry {\nentity.loadState(transaction);\n} catch(javax.ejb.NoSuchEntityException e) {\nthrow new IllegalArgumentException(\"Illegal adding of null to a collection cmr-field, see the EJB specification 10.3.8\");\n} catch(Exception e) {\n}\n}\n");
                }
                this.source.append("toPersistenceManager." + this.getPeerField() + " = newValue;\n" + "toPersistenceManager.__setDirty(\"" + this.getPeerField() + "\");\n" + "fromPersistenceManager = (" + this.compilation.persistenceManagerCompilation.getName() + ")newValue.getEntityBean();\n" + "fromPersistenceManager.__setDirty(\"" + this.orField.getName() + "\");\n" + "}\n" + "finally\n" + "{\n" + "entity.endCallLocal(inCall);\n" + "}\n");
            }
            this.source.append("}\n");
            if (this.mapping.peer.getPeer().isMany()) {
                try {
                    peerMapping = ORMapping.getPeerORMapping(this.orField, this.mapping.peer);
                }
                catch (InstantiationException e) {
                    throw new CompilationException(e.getMessage());
                }
                ejbName = peerMapping.compilation.compilation.getName();
                if (peerMapping.peer.getPeer().getRelation() != null) {
                    this.source.append("public void notifyRemovedObject(Object object)\n{\nthis.checkScope();\ncom.evermind.server.ejb.EJBUtils.confirmAlive(object);\n" + this.compilation.persistenceManagerCompilation.getName() + " fromPersistenceManager = (" + this.compilation.persistenceManagerCompilation.getName() + ")context.getObject();\n" + "fromPersistenceManager.__setDirty(\"" + this.orField.getName() + "\");\n");
                    if (!this.orField.isBiDirectional() || !this.orField.isManyToMany()) {
                        this.source.append("if (((CMRCollectionField)(((" + peerMapping.compilation.compilation.persistenceManagerCompilation.getName() + ")((" + ejbName + ")object).context.getObject())." + peerMapping.peer.getPeer().getRelation().getName() + ")) != null) \n" + "{\n" + "boolean _loaded = ((CMRCollectionField)(((" + peerMapping.compilation.compilation.persistenceManagerCompilation.getName() + ")((" + ejbName + ")object).context.getObject())." + peerMapping.peer.getPeer().getRelation().getName() + ")).isLoaded(); \n" + "if (!_loaded) return ;\n" + "}\n");
                    }
                    this.source.append("com.evermind.server.ejb.EJBUtils.notifyManyToManyRemove((" + ejbName + ")object, ((" + peerMapping.compilation.compilation.persistenceManagerCompilation.getName() + ")((" + ejbName + ")object).context.getObject())." + peerMapping.peer.getPeer().getRelation().getName() + ", context.getAnEJBObject_Local_or_Remote());\n" + "}\n" + "\n");
                }
            } else if (this.mapping.peer.getRelation() != null) {
                entity = (EntityBeanCompilation)this.compilation.compilation.getCompilation(this.mapping.peer.getRoleSource().getName());
                if (entity == null) {
                    throw new CompilationException("No such EJB: '" + this.mapping.peer.getRoleSource().getName() + "'");
                }
                this.source.append("public void notifyRemovedObject(Object object)\n{\nthis.checkScope();\ncom.evermind.server.ThreadState state = com.evermind.server.ThreadState.getCurrentState();\ncom.evermind.server.ApplicationServerTransaction transaction = (com.evermind.server.ApplicationServerTransaction)" + EJBCompilationUtils.getTransactionManagerString() + ".getTransaction();\n" + entity.getName() + " entity = (" + entity.getName() + ")object;\n" + "boolean inCall = entity.__allocateCoreInstance(state, 90000l, true);\n" + "entity = (" + entity.getName() + ")entity.__getCoreInstance();\n" + "try\n" + "{\n" + "if(transaction != null)\n" + "{\n" + EJBCompilationUtils.getRegisterBeanUncheckedString("entity") + ";\n" + "entity.transaction = transaction;\n" + "}\n" + "\n" + "if(((EntityEJBObject)entity).context.isLazy()) {\n" + "try {\n" + "entity.loadState(transaction);\n" + "} catch(javax.ejb.NoSuchEntityException e) {\n" + "} catch(Exception e) {\n" + "}\n" + "}\n" + this.compilation.persistenceManagerCompilation.getName() + " fromPersistenceManager;\n" + entity.persistenceManagerCompilation.getName() + " toPersistenceManager = (" + entity.persistenceManagerCompilation.getName() + ")entity.getEntityBean();\n" + this.compilation.getName() + " oldValue = (" + this.compilation.getName() + ")toPersistenceManager." + this.getPeerField() + ";\n" + "\n" + "if(oldValue != null)\n" + "{\n" + "boolean oldInCall = oldValue.__allocateCoreInstance(state, 900001, true);\n" + "oldValue = (" + this.compilation.getName() + ")oldValue.__getCoreInstance();\n" + "\n" + "try\n" + "{\n" + "if(transaction != null)\n" + "{\n" + EJBCompilationUtils.getRegisterBeanUncheckedString("oldValue") + ";\n" + "oldValue.transaction = transaction;\n" + "}\n" + "\n" + "fromPersistenceManager = (" + this.compilation.persistenceManagerCompilation.getName() + ")oldValue.getEntityBean();\n" + "if(fromPersistenceManager." + this.orField.getName() + " == null)\n" + "\tfromPersistenceManager." + this.orField.getName() + " = new " + this.getName() + "(oldValue.context);\n" + "fromPersistenceManager.__setDirty(\"" + this.orField.getName() + "\");\n" + "}\n" + "finally\n" + "{\n" + "oldValue.endCallLocal(oldInCall);\n" + "}\n" + "}\n" + "\n" + "toPersistenceManager." + this.getPeerField() + " = null;\n" + "toPersistenceManager.__setDirty(\"" + this.getPeerField() + "\");\n" + "}\n" + "finally\n" + "{\n" + "entity.endCallLocal(inCall);\n" + "}\n" + "}\n" + "\n");
            }
        } else if (EJBObject.class.isAssignableFrom(this.mapping.getValueField().getType()) || EJBLocalObject.class.isAssignableFrom(this.mapping.getValueField().getType())) {
            this.source.append("public void notifyAddedObject(Object object)\n{\nthis.checkScope();\ncom.evermind.server.ejb.EJBUtils.confirmAlive(object);\n}\n\n");
        }
    }

    public boolean constructTable() throws InstantiationException, CompilationException {
        Table table = null;
        if (this.primaryKeysTable != null) {
            return true;
        }
        boolean manyToManySlave = this.mapping.isManyToManySlave();
        if (this.slave != null) {
            this.slave.init();
            this.slave.compile();
        }
        if (this.mapping.isManyToMany()) {
            ORMapping peerMapping = ORMapping.getPeerORMapping(this.orField, this.mapping.peer);
            if (peerMapping.compilation == null) {
                peerMapping.compilation = this.compilation.createORCompilation(peerMapping.getORField(), this);
                return false;
            }
        }
        TreeSet<ContainerManagedField> fields = new TreeSet<ContainerManagedField>();
        fields.add(this.mapping.getKeyField());
        fields.add(this.mapping.getValueField());
        ContainerManagedField theKey = new ContainerManagedField(null, this.orField.getContext(), "");
        theKey.setProperties(fields);
        theKey.setPersistenceType(3);
        if (table == null) {
            table = this.compilation.compilation.getTable(this.mapping);
        }
        this.primaryKeysTable = new AssociateTableView(table, theKey, new HashSet(), false, this.compilation);
        this.primaryKeysTable.setEnvironment(this.compilation.getContainer(), this.compilation.getSchema());
        fields = new TreeSet();
        fields.add(this.mapping.getValueField());
        this.nonPrimaryKeyTable = new AssociateTableView(table, this.mapping.getKeyField(), fields, false, this.compilation);
        this.mapping.setTableName(this.nonPrimaryKeyTable.getTable().getName());
        this.nonPrimaryKeyTable.setEnvironment(this.compilation.getContainer(), this.compilation.getSchema());
        this.createTable();
        return true;
    }

    protected abstract void createTable() throws CompilationException;

    public void appendIsValueImmutable() {
        this.source.append("public boolean isImmutable()\n{\nthis.checkScope();\nreturn " + this.mapping.isValueImmutable() + ";\n" + "}\n" + "\n");
    }

    public String getName() {
        return this.name;
    }

    public ByteString getSource() {
        return this.source;
    }

    public void appendCheckScope() {
        this.source.append("public void checkScope() \n");
        this.source.append("{  \n");
        this.source.append("\tif(" + EJBCompilationUtils.getTransactionManagerString() + ".getTransaction() != this._transaction)\n");
        this.source.append("\t\tthrow new IllegalStateException(\"Invalid transaction state, see chapter 10 of the EJB 2.0 specification\");\n");
        this.source.append("} \n");
        this.source.append("\n");
    }

    public void appendGetObjectsStart() {
        this.appendCheckScope();
        this.source.append("public Object[] getObjects()\n{\nthis.checkScope();\nEntityEJBHome theHome = (context.localHome==null) ? (EntityEJBHome)context.remoteHome : (EntityEJBHome)context.localHome;\nPreparedStatement statement = null;\ntry\n{\nThreadState state = ThreadState.getCurrentState();\ncom.evermind.server.ApplicationServerTransaction transaction = (com.evermind.server.ApplicationServerTransaction)" + EJBCompilationUtils.getTransactionManagerString() + ".getTransaction();\n" + "DataSourceConnection connection = transaction == null ? theHome.dataSourceContainer.getConnection() : transaction.getConnection(theHome.dataSourceContainer);\n" + "List found = new ArrayList();" + "\n" + "try\n" + "{\n");
    }

    public void appendGetTransaction() {
        this.source.append("public ApplicationServerTransaction getTransaction() \n{\n\nreturn _transaction;\n}\n\n");
    }

    public void appendClassStart(String baseClass) {
        this.source.append("public class " + this.name + " extends " + baseClass + "\n" + "{\n\n" + "private ApplicationServerTransaction _transaction = null; \n");
        this.source.append("public " + this.getName() + "(EvermindEntityContext context)\n" + "{\n");
        this.source.append("this(context.getPrimaryKey());\nthis.context = context;\n}\n\n");
        this.source.append("public " + this.getName() + "(EvermindEntityContext context, boolean forcedRefresh)\n" + "{\n" + "this(context);\n" + "if(this.objects == null || forcedRefresh)\n" + "this.objects = this.getObjects();\n" + "}\n\n");
        this.source.append("public " + this.getName() + "(Object primaryKey)\n" + "{\n");
        if (this.orField.isSynthetic()) {
            this.source.append("objects = new Object[0];\n");
        }
        this.source.append("this.primaryKey = primaryKey;\n_transaction = (com.evermind.server.ApplicationServerTransaction)\n" + EJBCompilationUtils.getTransactionManagerString() + ".getTransaction(); \n" + "}\n\n");
        this.source.append("public " + this.getName() + "(java.util.Collection newCollection)\n" + "{\n" + "_transaction = (com.evermind.server.ApplicationServerTransaction)\n" + EJBCompilationUtils.getTransactionManagerString() + ".getTransaction(); \n" + "if(newCollection instanceof CMRCollectionField)\n" + "{\n" + "CMRCollectionField field = ((CMRCollectionField)newCollection);\n" + "this.context = field.__getContext();\n" + "this.primaryKey = field.getPrimaryKey();\n" + "}\n" + "Iterator iterator = newCollection.iterator();\n" + "int i = 0;\n" + "objects = new Object[newCollection.size()];\n" + "while(iterator.hasNext())\n" + "objects[i++] = (Object)iterator.next();\n" + "}\n" + "\n");
    }

    public void appendGetObjectsEnd() {
        this.source.append("}\n\nif(transaction == null)\n{\nconnection.release();\n}\n");
        this.appendGetObjectsEndInterceptor();
        this.source.append("setToLoaded();\n");
        this.source.append("return (Object[])found.toArray(new Object[found.size()]);\n}\ncatch(SQLException sqle)\n{\n");
        this.source.append("if (context.localHome != null)\ncontext.localHome.OC4J_log(\"Database Error\", sqle);\nelse\ncontext.remoteHome.OC4J_log(\"Database Error\", sqle);\n");
        this.source.append("connection.close(true);\n" + BeanMethodCompilation.getRollbackTransaction("\"Database error: \" + sqle", "sqle", "(com.evermind.server.ApplicationServerTransaction)" + EJBCompilationUtils.getTransactionManagerString() + ".getTransaction()", "context.") + "throw com.evermind.server.ejb.EJBUtils.createEJBException(\"Database error: \" + sqle.getMessage(), sqle);\n" + "}\n" + "}\n" + "catch(java.rmi.RemoteException re)\n" + "{\n" + "throw com.evermind.server.ejb.EJBUtils.createEJBException(re);\n" + "}\n" + "catch(java.lang.Exception ge)\n" + "{\n" + "throw com.evermind.server.ejb.EJBUtils.createEJBException(ge);\n" + "}\n" + "finally { if(statement != null) {\n" + "try { statement.close(); } catch(java.sql.SQLException e) {}\n" + "}\n }\n" + "}\n" + "\n");
    }

    public void appendGetObjectsEndInterceptor() {
    }

    public void appendGetObjectsMethod() throws CompilationException {
        this.appendGetObjectsStart();
        this.source.append("Flag statementCached = new Flag(false);\n statement = EJBPrivileged.getCustomStatement(connection, statementCached,\"");
        boolean lazyLoading = this.mapping.isLazyLoading();
        if (!lazyLoading) {
            ContainerManagedField aField = this.mapping.getValueField();
            this.source.append(this.nonPrimaryKeyTable.getCMREagerLoadSelectStatement(true, "statement", this.mapping.peer.getRoleSource().getName(), aField), true);
        } else {
            this.source.append(this.nonPrimaryKeyTable.getPreparedSelectStatement(false, "statement"), true);
        }
        this.appendDefinePrimaryKey();
        this.nonPrimaryKeyTable.appendPreparedSet(this.source, false, "statement", this.mapping.getPrimaryKey().getType(), new TableIteration(), "__thePrimaryKey", this.mapping.getPrimaryKey(), "context", true);
        this.source.append("ResultSet set = statement.executeQuery();\n");
        this.source.append("while(set.next())\n{\n");
        this.source.append(this.valueTypeName + " instance = null;\n");
        TableIteration tableIteration = new TableIteration();
        EntityBeanCompilation.appendJDBCGetterMethod(this.local, "instance", this.source, false, "set", this.mapping.getValueField(), tableIteration, this.compilation, "context", false, !lazyLoading, this);
        this.source.append("found.add(instance);\n");
        this.source.append("this.setLoaded(true);\n");
        this.appendGetObjectsEnd();
    }

    public abstract void compile() throws CompilationException;

    protected void appendDefinePrimaryKey() {
        Class primaryKeyClass = this.compilation.descriptor.isAutomaticIdentity() ? this.compilation.descriptor.getPrimaryKey().getType() : this.compilation.descriptor.getPrimaryKeyClass();
        String primaryKeyVariable = ClassUtils.getConvertSource("((" + primaryKeyClass.getName() + ")primaryKey)", primaryKeyClass, this.mapping.getPrimaryKey().getType());
        this.source.append(this.mapping.getPrimaryKey().getType().getName() + " __thePrimaryKey = " + primaryKeyVariable + ";\n");
    }

    public void appendInsertObjects() throws CompilationException {
        this.source.append("PreparedStatement insertAllStatement = EJBPrivileged.getCustomStatement(connection, \"");
        this.source.append(this.nonPrimaryKeyTable.getPreparedInsertStatement(false), true);
        this.source.append("\"");
        EntityBeanDescriptor bean = this.compilation.descriptor;
        if (bean.getBatchSize() > 1) {
            this.source.append("," + bean.getBatchSize() + ",false");
        }
        this.source.append(");\n");
        this.source.append("try {\n");
        this.source.append("for(int i = 0; i < objects.length; i++)\n{\n" + this.valueTypeName + " object = objects[i] instanceof ChangedValue ? ((" + this.valueTypeName + ")((ChangedValue)objects[i]).newValue) : (" + this.valueTypeName + ")objects[i];\n");
        TableIteration updateIteration = new TableIteration();
        this.nonPrimaryKeyTable.appendPreparedSet(this.source, false, "insertAllStatement", this.mapping.getValueField().getType(), updateIteration, "object", this.mapping.getValueField(), "context", true);
        this.nonPrimaryKeyTable.appendPreparedSet(this.source, false, "insertAllStatement", this.mapping.getPrimaryKey().getType(), updateIteration, "__thePrimaryKey", this.mapping.getPrimaryKey(), "context", true);
        this.source.append("insertAllStatement.executeUpdate();\n}\n} finally { try { insertAllStatement.close(); } catch(java.sql.SQLException e){}\n }\n");
    }

    protected String getCatches() {
        return "";
    }

    public void addDeleteEntriesMethod() throws CompilationException {
        String primaryKeyVar = ClassUtils.getConvertSource("((" + this.compilation.descriptor.getRuntimePrimaryKeyClassName() + ")primaryKey)", this.compilation.descriptor.getPrimaryKeyClass(), this.mapping.getPrimaryKey().getType());
        this.source.append("public void deleteEntries(DataSourceConnection connection) throws SQLException\n{\nthis.checkScope();\n");
        if (this.mapping.isOneToManyBiSlave()) {
            this.source.append("return;\n}\n\n");
            return;
        }
        this.source.append("if(!this.context.isSqlExecuted())\nreturn;\n");
        this.source.append("PreparedStatement statement = EJBPrivileged.getCustomStatement(connection, \"");
        this.source.append(this.nonPrimaryKeyTable.getPreparedDeleteStatement(false), true);
        this.source.append("\"");
        EntityBeanDescriptor bean = this.compilation.descriptor;
        if (bean.getBatchSize() > 1) {
            this.source.append("," + bean.getBatchSize() + ",false");
        }
        this.source.append(");\n");
        this.primaryKeysTable.appendPreparedSet(this.source, false, "statement", this.mapping.getPrimaryKey().getType(), new TableIteration(), primaryKeyVar, this.mapping.getPrimaryKey(), "context", true);
        this.source.append("try{\nstatement.executeUpdate();\n} finally { try { statement.close();\n } catch(java.sql.SQLException e) {}\n }\n}\n\n");
    }

    public String getPeerField() {
        if (this.mapping.peer == null) {
            return null;
        }
        if (this.mapping.peer.getRelation() == null) {
            return null;
        }
        return this.mapping.peer.getRelation().getName();
    }

    public TableView getPrimaryKeysTable() throws CompilationException {
        return this.primaryKeysTable;
    }

    public TableView getNonPrimaryKeyTable() throws CompilationException {
        return this.nonPrimaryKeyTable;
    }

    public void setPrimaryKeysTable(TableView view) {
        this.primaryKeysTable = view;
    }

    public void setNonPrimaryKeyTable(TableView view) {
        this.nonPrimaryKeyTable = view;
    }

    public ORMapping getMapping() {
        return this.mapping;
    }
}

