/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.compilation.BeanMethodCompilation;
import com.evermind.server.ejb.compilation.EntityHomeCompilation;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.util.ByteString;
import com.evermind.util.ClassUtils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import javax.ejb.FinderException;

public class FinderMethodCompilation
extends BeanMethodCompilation {
    protected EntityHomeCompilation compilation;
    protected boolean needsConvertor;
    protected boolean multiResponse;
    protected boolean collectionResponse;
    protected boolean enumerationResponse;
    protected boolean containerManaged;

    public FinderMethodCompilation(EntityHomeCompilation compilation, Method method, String methodName, boolean local) throws CompilationException {
        super(compilation, compilation.beanCompilation.descriptor, method, true, true, methodName, local);
        this.compilation = compilation;
        this.setSynchronized(false);
        this.containerManaged = compilation.descriptor.isContainerManaged();
        this.collectionResponse = this.method.getReturnType() == Collection.class;
        this.enumerationResponse = this.method.getReturnType() == Enumeration.class;
        boolean bl = this.method.getReturnType() == Collection.class || this.method.getReturnType() == Enumeration.class ? true : (this.multiResponse = false);
        if (!this.containerManaged && !this.multiResponse && method.getReturnType() != this.beanMethod.getReturnType() && this.beanMethod.getReturnType() != compilation.descriptor.getPrimaryKeyClass()) {
            this.needsConvertor = true;
        }
        this.synced = false;
        if (!this.checkIfThrows(FinderException.class)) {
            throw new CompilationException("Finder method " + method + " does not throw javax.ejb.FinderException");
        }
    }

    private final void append_boolean_lazyloading(ByteString _source) {
        _source.append("boolean doing_lazyloading_here;\n");
        if (!this.canBeTransaction()) {
            _source.append("// do not bother loading here because the data will be thrown away before returning from this finder\n");
            _source.append("doing_lazyloading_here = true;\n");
            return;
        }
        if (this.compilation.descriptor.getFindByPrimaryKeyLazyLoading()) {
            _source.append("// customers specify lazy loading ON for findByPrimaryKey\ndoing_lazyloading_here = true;\n");
        } else {
            _source.append("// customers specify lazy loading OFF for findByPrimaryKey, still do lazy loading on if tx==null\ndoing_lazyloading_here = (transaction == null);\n");
        }
        if (this.transactionType == 1) {
            _source.append("// always doing lazy loading if a new tx is created\n if (created) doing_lazyloading_here = true;\n");
        }
    }

    public void addEJBInvocation() throws CompilationException {
        this.setInvocationTarget("((" + this.compilation.descriptor.getEJBClassName() + ")context.getObject())");
        this.append_boolean_lazyloading(this.source);
        if (this.containerManaged) {
            this.source.append(this.compilation.descriptor.getPrimaryKeyClassName() + " key = " + ClassUtils.getConvertSource("argument0", this.method.getParameterTypes()[0], this.compilation.descriptor.getPrimaryKeyClass()) + ";\n");
        } else {
            this.source.append(this.compilation.descriptor.getPrimaryKeyClassName() + " key = null;\n");
        }
        if (!this.containerManaged) {
            this.source.append("EvermindEntityContext context = this.get" + (this.local ? "Local" : "") + "ContextInstance();\n");
        }
        if (this.needsConvertor) {
            this.source.append(ClassUtils.getSourceNotation(this.beanMethod.getReturnType(), 0) + " tempKey = " + ClassUtils.getDefaultValue(this.beanMethod.getReturnType()) + ";\n");
        }
        if (!this.containerManaged) {
            if (!this.multiResponse) {
                this.finderResponseTypeName = this.compilation.descriptor.getPrimaryKeyClassName();
            }
            super.addEJBInvocation(this.multiResponse ? "response" : (this.needsConvertor ? "tempKey" : "key"), false);
        }
        if (this.needsConvertor) {
            this.source.append("key = " + ClassUtils.getConvertSource("tempKey", this.beanMethod.getReturnType(), this.compilation.beanCompilation.descriptor.getPrimaryKeyClass()) + ";\n");
        }
        this.source.append("if(methodException == null)\n{\n");
        this.appendResponseProcessing();
        this.source.append("}\n");
    }

    protected void appendResponseProcessing() throws CompilationException {
        long callTimeout = this.compilation.descriptor.getCallTimeout();
        if (this.multiResponse) {
            this.source.append("java.util.Collection collection = new java.util.ArrayList();\n");
        }
        if (this.collectionResponse) {
            this.source.append("Iterator iterator = response.iterator();\n\nwhile(iterator.hasNext())\n{\nkey = (" + this.compilation.beanCompilation.getEntityBeanDescriptor().getPrimaryKeyClassName() + ")iterator.next();\n");
        } else if (this.enumerationResponse) {
            this.source.append("if (methodException == null && response != null) {\nwhile(response.hasMoreElements()) {\nkey = (" + this.compilation.beanCompilation.getEntityBeanDescriptor().getPrimaryKeyClassName() + ")response.nextElement();\n");
        }
        String myTx = this.canBeTransaction() ? "transaction" : "null";
        if (this.method.getName().equals("findByPrimaryKey") && this.compilation.beanCompilation.descriptor.isContainerManaged()) {
            this.source.append("if (doing_lazyloading_here) {\n");
            if (this.local) {
                this.source.append("try{\n");
            }
            this.source.append("boolean isValidPK = ifEntityExist(key);\n");
            this.source.append("if (!isValidPK) \n");
            this.source.append("throw new javax.ejb.ObjectNotFoundException(\"No such entity: \" + key);\n");
            if (this.local) {
                this.source.append("} catch (RemoteException ee) {\n");
                this.source.append("throw new FinderException(ee.getMessage());\n");
                this.source.append("}\n");
            }
            this.source.append("}\n");
        }
        if (this.getResponseTypeName().equals("java.util.Collection") || this.getResponseTypeName().equals("java.util.Enumeration")) {
            if (this.local) {
                this.source.append("try {\n");
            }
            this.source.append("collection.add(" + this.getHomeReference() + ".getApplication().getTransportManager().getTransportSpecificResponseObject(getWrapperByPK(" + myTx + ", key)));\n");
            if (this.local) {
                this.source.append("} catch (RemoteException ex) {\n");
                this.source.append("OC4J_log(ex);\n");
                this.source.append("throw new javax.ejb.FinderException(ex.getMessage());\n");
                this.source.append("}\n");
            }
        } else {
            String _allowForUpdate;
            if (this.method.getName().equals("findByPrimaryKey") || this.local) {
                this.source.append("try{\n");
            }
            String string = _allowForUpdate = this.transactionType != 6 ? "true" : "false";
            if (this.method.getName().equals("findByPrimaryKey")) {
                this.source.append("if (doing_lazyloading_here) {\nif (created)\nresponse = (" + this.compilation.beanCompilation.getName() + ")getWrapperByPK(null, key);\n" + "else\n" + "response = (" + this.compilation.beanCompilation.getName() + ")getWrapperByPK(transaction, key);\n" + " } else {\n" + "response = (" + this.compilation.beanCompilation.getName() + ")getWrapperByPK(transaction, key);\n" + "((" + this.compilation.beanCompilation.getName() + ") response).loadStateCheckObject(transaction);\n" + "}\n");
            } else {
                if (this.local) {
                    this.source.append("try {\n");
                }
                this.source.append("response = (" + this.compilation.beanCompilation.getName() + ")getWrapperByPK(" + myTx + ", key);\n");
                if (this.local) {
                    this.source.append("} catch (RemoteException ex) {\n");
                    this.source.append("OC4J_log(ex);\n");
                    this.source.append("throw new javax.ejb.FinderException(ex.getMessage());\n");
                    this.source.append("}\n");
                }
            }
            if (this.method.getName().equals("findByPrimaryKey")) {
                this.source.append("} catch (Exception e) {\nOC4J_log(e);\nOC4J_log(new Exception (\"The key used for query \" + key));\nif ((transaction != null) && ( response != null )) transaction.removeBean( ( AbstractEJBObject ) response );\ntry {\nif (((" + this.compilation.beanCompilation.getName() + ")response).context.getObject() != null) {\n" + "boolean _recursive = ((" + this.compilation.beanCompilation.getName() + ")response).startCall(thread, 90000l, true);\n" + " ((" + this.compilation.beanCompilation.getName() + ")response).releaseContext(false);\n" + "((" + this.compilation.beanCompilation.getName() + ")response).endCall(_recursive);\n" + "}\n" + "} catch (Exception e2) {\n" + " OC4J_log(e2);\n" + "}\n" + "throw new javax.ejb.ObjectNotFoundException(\"No such entity: \" + key);\n" + "}\n");
            } else if (this.local) {
                this.source.append("} catch (Exception e) {\n");
                this.source.append("try {\nif (((" + this.compilation.beanCompilation.getName() + ")response).context.getObject() != null) {\n" + "boolean _recursive = ((" + this.compilation.beanCompilation.getName() + ")response).startCall(thread, 90000l, true);\n" + " ((" + this.compilation.beanCompilation.getName() + ")response).releaseContext(false);\n" + "((" + this.compilation.beanCompilation.getName() + ")response).endCall(_recursive);\n" + "}\n" + "} catch (Exception e2) {\n" + " OC4J_log(e2);\n" + "}\n");
                this.source.append("  throw new FinderException(e.getMessage());\n");
                this.source.append("}\n");
            }
        }
        if (this.multiResponse) {
            this.source.append("}\n");
        }
        if (this.multiResponse) {
            if (this.collectionResponse) {
                this.source.append("response = collection;\n");
            } else if (this.enumerationResponse) {
                this.source.append("}\nif(methodException == null) response = new com.evermind.util.CollectionEnumeration(collection);\n");
            } else {
                throw new CompilationException("Unknown return-type for custom finder method: " + this.getResponseTypeName());
            }
        }
    }

    protected void checkReturnType(Class returnType, Class beanReturnType) throws CompilationException {
        EntityBeanDescriptor descriptor = ((EntityHomeCompilation)this.declaringClass).descriptor;
        if (returnType == (this.local ? descriptor.getLocalInterface() : descriptor.getRemoteInterface())) {
            if (!this.containerManaged && !ClassUtils.equalsIgnorePrimitive(beanReturnType, descriptor.getPrimaryKeyClass())) {
                throw new CompilationException(this.beanMethod + " must return either a Collection, Enumeration or a " + descriptor.getPrimaryKeyClassName() + ", not a " + (beanReturnType == null ? this.beanMethod.getReturnType().getName() : beanReturnType.getName()));
            }
        } else if (returnType != Collection.class && returnType != Enumeration.class) {
            throw new CompilationException(this.method + " must return either a Collection, Enumeration or " + descriptor.getRemoteInterfaceName() + ", not a " + returnType.getName());
        }
        if (!this.containerManaged && returnType != beanReturnType && !ClassUtils.equalsIgnorePrimitive(beanReturnType, descriptor.getPrimaryKeyClass())) {
            throw new CompilationException("Method " + this.beanMethod.getReturnType().getName() + " " + this.beanMethod.getDeclaringClass().getName() + "." + this.beanMethod.getName() + "(...) does not return " + ClassUtils.getSourceNotation(this.method.getReturnType(), 0) + " as specified by the remote interface " + this.method.getDeclaringClass().getName());
        }
    }

    protected void appendPostEJBInvocation() {
        if (this.multiResponse) {
            this.source.append("if(response == null)\n\tthrow new NullPointerException(\"finder returned null\");\n");
        }
        this.source.append("this.releaseContextInstance(context);\n");
    }

    public void appendApplicationExceptionHandling() {
        if (!this.containerManaged) {
            this.source.append("this.releaseContextInstance(context);\ncontext = null;\n");
        }
    }
}

