/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.Compilable;
import com.evermind.server.ejb.compilation.ClassCompilation;
import com.evermind.util.ByteString;
import com.evermind.util.ClassUtils;
import java.lang.reflect.Method;
import java.util.Vector;

public class FinderCacheCompilation
implements Compilable {
    private String name;
    private Method method;
    private ByteString source = new ByteString(1000);
    private Class[] parameterTypes;

    public FinderCacheCompilation(Method method, String name) {
        this.method = method;
        this.parameterTypes = method.getParameterTypes();
        this.name = name + ClassCompilation.getNextID();
    }

    public String getName() {
        return this.name;
    }

    public void cleanSource() {
        this.source.reset();
        this.source = null;
    }

    public ByteString getSource() {
        return this.source;
    }

    public Vector getDependentClasses() {
        return null;
    }

    public void compile() {
        int i;
        this.source.append("public class " + this.name + " extends com.evermind.server.ejb.FinderCache\n" + "{\n");
        for (i = 0; i < this.parameterTypes.length; ++i) {
            this.source.append(this.parameterTypes[i].getName() + " param" + i + ";\n");
        }
        this.source.append("\npublic " + this.name + "(");
        for (i = 0; i < this.parameterTypes.length; ++i) {
            if (i > 0) {
                this.source.append(", ");
            }
            this.source.append(this.parameterTypes[i].getName());
            this.source.append(" param");
            this.source.append(String.valueOf(i));
        }
        this.source.append(")\n{\n");
        for (i = 0; i < this.parameterTypes.length; ++i) {
            this.source.append("this.param" + i + " = param" + i + ";\n");
        }
        this.source.append("}\n\n");
        this.source.append("public boolean equals(Object otherGeneric)\n{\nif(otherGeneric instanceof " + this.name + ")\n" + "{\n" + this.name + " other = (" + this.name + ")otherGeneric;\n" + "return ");
        String[] fieldNames = new String[this.parameterTypes.length];
        for (int i2 = 0; i2 < this.parameterTypes.length; ++i2) {
            fieldNames[i2] = "param" + i2;
        }
        this.source.append(ClassUtils.getComparationExpression("this.", "other.", fieldNames, this.parameterTypes));
        this.source.append(";\n}else return false;\n}\n\n");
        this.source.append("public int hashCode()\n{\nreturn " + ClassUtils.getHashCodeExpression("this.", fieldNames, this.parameterTypes) + ";" + "}\n" + "}\n");
    }
}

