/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.compiler.CompiledObject;
import com.evermind.compiler.LinkedCompiler;
import com.evermind.naming.ContextUtils;
import com.evermind.server.ejb.compilation.Compilation;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.logging.EJBCompilationMessages;
import com.evermind.util.CompilerProperties;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.classloader.SharedCodeSource;

public class EJBCompilationUtils {
    public static final String WRAPPER_SUB_DIR = "generated";

    public static String getDeploymentPath(EJBPackage ejbPackage) throws CompilationException {
        try {
            return ContextUtils.getFile(ejbPackage.getDeploymentContext(), false).getAbsolutePath();
        }
        catch (InstantiationException ie) {
            throw new CompilationException(ie.getMessage(), ie);
        }
    }

    public static String getWrapperCodeGenDir(EJBPackage ejbPackage) throws CompilationException {
        StringBuffer wrapperBuf = new StringBuffer();
        if (CompilerProperties.getWrapperCodeDir() != null && !CompilerProperties.getWrapperCodeDir().equalsIgnoreCase("null")) {
            wrapperBuf.append(CompilerProperties.getWrapperCodeDir()).append(File.separator).append(ejbPackage.getApplication().getName()).append(File.separator).append(EJBCompilationUtils.moduleName(ejbPackage.getName())).append(File.separator).append(WRAPPER_SUB_DIR);
            if (EJBCompilationUtils.validateWrapperDir(wrapperBuf.toString(), ejbPackage)) {
                return wrapperBuf.toString();
            }
        }
        return wrapperBuf.append(EJBCompilationUtils.getDeploymentPath(ejbPackage)).append(File.separator).append(WRAPPER_SUB_DIR).toString();
    }

    private static String moduleName(String name) {
        String pathAndModuleName = name;
        if (pathAndModuleName.startsWith("/") | pathAndModuleName.startsWith("\\")) {
            pathAndModuleName = pathAndModuleName.substring(1);
        }
        return pathAndModuleName.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    private static boolean validateWrapperDir(String givenWrapperDir, EJBPackage ejbPackage) throws CompilationException {
        File file = new File(givenWrapperDir);
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception e) {
                EJBCompilationMessages.warningCreateWrapperDir(ejbPackage, givenWrapperDir, EJBCompilationUtils.getDeploymentPath(ejbPackage), e.getMessage());
                return false;
            }
        }
        if (!file.canWrite()) {
            EJBCompilationMessages.warningWrapperDirPermission(ejbPackage, givenWrapperDir, EJBCompilationUtils.getDeploymentPath(ejbPackage));
            return false;
        }
        return true;
    }

    static String getTransactionManagerString() {
        return "((ApplicationServerTransactionManager)ApplicationServer.getInstance().getTransactionManager())";
    }

    static String getTransactionString() {
        return "((ApplicationServerTransaction)(" + EJBCompilationUtils.getTransactionManagerString() + ".getTransaction()))";
    }

    static String getRegisterBeanString(String abstractEJBObject) {
        return EJBCompilationUtils.getSynchronizationString() + ".registerBean( " + abstractEJBObject + ")";
    }

    static String getRegisterBeanUncheckedString(String abstractEJBObject) {
        return EJBCompilationUtils.getSynchronizationString() + ".registerBeanUnchecked( " + abstractEJBObject + ")";
    }

    static String getSynchronizationString() {
        return "((ApplicationServerTransactionSynchronization)" + EJBCompilationUtils.getTransactionManagerString() + ".getTransaction())";
    }

    static String getTransactionDoesNotEqualNullString() {
        return EJBCompilationUtils.getTransactionManagerString() + ".getTransaction( ) != null";
    }

    static String getTransactionEqualsNullString() {
        return EJBCompilationUtils.getTransactionManagerString() + ".getTransaction( ) == null";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void batchCompileDefaultHomes(Compilation compilation, EJBPackage ejbPackage, List listSources, boolean isBatch) throws IOException, InstantiationException, CompilationException {
        LinkedCompiler compiler = compilation.getContainer().getApplication().getServer().getCompiler();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        String dPath = EJBCompilationUtils.getWrapperCodeGenDir(ejbPackage);
        Context deploymentContext = ejbPackage.getDeployment().getGeneratedInterfaceClassContext();
        Context wrapperContext = ejbPackage.getDeployment().getWrapperClassContext();
        properties.put("classpath", compilation.classpath + File.pathSeparatorChar + ContextUtils.getFile(deploymentContext, false));
        properties.put("classLoader", compilation.parent);
        HashMap<String, List> mapSources = new HashMap<String, List>();
        mapSources.put(dPath, listSources);
        Collection binaries = null;
        if (!isBatch) {
            properties.put("target.directory", dPath);
            properties.put("source.directory", dPath);
            binaries = compiler.compile(mapSources, properties);
        } else {
            properties.put("deploy.batch", "generate");
            compiler.compile(mapSources, properties);
            properties.put("deploy.batch", "compile");
            compiler.compile(mapSources, properties);
            properties.put("deploy.batch", "load");
            binaries = compiler.compile(mapSources, properties);
        }
        compiler.reset();
        Iterator binariesIterator = binaries.iterator();
        while (binariesIterator.hasNext()) {
            Object var16_14;
            CompiledObject binary = (CompiledObject)binariesIterator.next();
            SharedCodeSource codeSrc = ejbPackage.getDeployment().addGeneratedInterfaceCodeSource();
            try {
                try {
                    if (codeSrc != null) {
                        codeSrc.suspend();
                    }
                    deploymentContext.rebind(binary.getName().replace('.', '/') + ".class", (Object)binary.getData());
                    ContextUtils.flush(deploymentContext);
                    wrapperContext.rebind(binary.getName().replace('.', '/') + ".class", (Object)binary.getData());
                    if (codeSrc == null) {
                        codeSrc = ejbPackage.getDeployment().addGeneratedInterfaceCodeSource();
                    }
                    binary.clean();
                }
                catch (NamingException e) {
                    throw (InstantiationException)new InstantiationException("Error writing to cache: " + e.getMessage()).initCause(e);
                }
                var16_14 = null;
                if (codeSrc == null) continue;
            }
            catch (Throwable throwable) {
                var16_14 = null;
                if (codeSrc != null) {
                    codeSrc.release();
                    codeSrc.list();
                }
                throw throwable;
            }
            codeSrc.release();
            codeSrc.list();
        }
        return;
    }

    public static Class getDefaultHomeClass(EJBPackage ejbPackage, String homeName) throws CompilationException {
        try {
            return ejbPackage.getDeployment().getEJBClassLoader().loadClass(homeName);
        }
        catch (ClassNotFoundException e) {
            throw new CompilationException("Unable to load class instance of " + homeName, e);
        }
    }
}

