/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

public class PrimitiveTypeCache {
    public static String convertFromPrimitive(String _variable) {
        return "PrimitiveTypeCache.valueOf(" + _variable + ")";
    }

    public static Integer valueOf(int i) {
        int offset = 128;
        if (i >= -128 && i <= 127) {
            return IntegerCache.cache[i + 128];
        }
        return new Integer(i);
    }

    public static Character valueOf(char c) {
        if (c <= '\u007f') {
            return CharacterCache.cache[c];
        }
        return new Character(c);
    }

    public static Byte valueOf(byte b) {
        int offset = 128;
        return ByteCache.cache[b + 128];
    }

    public static Short valueOf(short s) {
        int offset = 128;
        short sAsInt = s;
        if (sAsInt >= -128 && sAsInt <= 127) {
            return ShortCache.cache[sAsInt + 128];
        }
        return new Short(s);
    }

    public static Long valueOf(long l) {
        int offset = 128;
        if (l >= -128L && l <= 127L) {
            return LongCache.cache[(int)l + 128];
        }
        return new Long(l);
    }

    public static Boolean valueOf(boolean b) {
        return b ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Float valueOf(float f) {
        return new Float(f);
    }

    public static Double valueOf(double d) {
        return new Double(d);
    }

    private static class LongCache {
        static final Long[] cache = new Long[256];

        private LongCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                LongCache.cache[i] = new Long(i - 128);
            }
        }
    }

    private static class ShortCache {
        static final Short[] cache = new Short[256];

        private ShortCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                ShortCache.cache[i] = new Short((short)(i - 128));
            }
        }
    }

    private static class ByteCache {
        static final Byte[] cache = new Byte[256];

        private ByteCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                ByteCache.cache[i] = new Byte((byte)(i - 128));
            }
        }
    }

    private static class CharacterCache {
        static final Character[] cache = new Character[128];

        private CharacterCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                CharacterCache.cache[i] = new Character((char)i);
            }
        }
    }

    private static class IntegerCache {
        static final Integer[] cache = new Integer[256];

        private IntegerCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                IntegerCache.cache[i] = new Integer(i - 128);
            }
        }
    }
}

