/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ApplicationConfig;
import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.EJBInternalOutputStream;
import com.evermind.server.ejb.RemoteStatefulSessionEJBObject;
import com.evermind.server.ejb.SessionReplicationService;
import com.evermind.server.ejb.StatefulSessionContext;
import com.evermind.server.ejb.StatefulSessionEJBHome;
import com.evermind.server.ejb.StatefulSessionEJBObject;
import com.evermind.server.ejb.logging.EJBRuntimeMessages;
import com.oracle.bricks.SessionManagerFactory;
import com.oracle.bricks.j2ee.EJBSession;
import com.oracle.bricks.j2ee.JGroupConfig;
import com.oracle.bricks.j2ee.SessionManager;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import oracle.j2ee.clustering.ClusteringMessages;
import oracle.j2ee.clustering.ClusteringTraceLogger;
import org.jgroups.ChannelException;

public class JGroupEJBService
implements SessionReplicationService {
    static Logger m_logger = ClusteringTraceLogger.getEJBTraceLogger(JGroupEJBService.class);
    private SessionManager manager;
    private int promiseTimeout;
    private EJBContainer container;

    protected JGroupEJBService() {
    }

    public JGroupEJBService(EJBContainer ejbContainer, ApplicationConfig config) throws ChannelException {
        JGroupConfig jconfig = config.getClusterConfig();
        this.container = ejbContainer;
        this.promiseTimeout = jconfig.getPromiseTimeout();
        this.manager = SessionManagerFactory.create(config);
        this.manager.start();
        if (!this.container.getApplication().getConfig().getEJBPackages().isEmpty()) {
            String appName = ejbContainer.getApplication().getName();
            String channelName = config.getClusterConfig().getGroupName();
            String protocol = config.getClusterConfig().getProtocol();
            String address = this.manager.getLocalAddress().getAddress().getHostAddress();
            String port = Integer.toString(this.manager.getLocalAddress().getPort());
            ClusteringMessages.infoSessionManagerStarted("EJB", appName, channelName, protocol, address, port);
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "EJB Clustering Service started for Application " + appName + " - state replication enabled over channel " + channelName + " using " + protocol + " protocol on " + address + ":" + port);
            }
        }
    }

    public boolean attemptSessionMigration(StatefulSessionEJBHome home) {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "attemptSessionMigration" + home);
        }
        try {
            this.container.storeSessions(null, home, true);
        }
        catch (IOException e) {
            this.container.application.log("Error persisting sessions for " + home.bindingPath, e);
            return false;
        }
        return true;
    }

    public void destroy() {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "destroy");
        }
    }

    public void restoreSessions() throws JMSException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "restoreSessions");
        }
    }

    public void MigrateSFSBAtEndCall(StatefulSessionEJBObject sfsbObj) throws Exception, IOException, InterruptedException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "MigrateSFSBAtEndCall: " + sfsbObj.getObject());
        }
        if (sfsbObj.OC4J_isInvalidated() || sfsbObj.OC4J_isPassivated()) {
            return;
        }
        if (!sfsbObj.isRemote) {
            return;
        }
        this.flushSession(null, sfsbObj, false);
    }

    public void flushEJB(String bindingPath, Object primaryKey_x) throws JMSException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "flushEJB - not supported");
        }
    }

    public void sendSessionValueUpdate(StatefulSessionContext statefulSessionContext, String name, Object value) {
        block4: {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "sendSessionValueUpdate");
            }
            RemoteStatefulSessionEJBObject rsfso = (RemoteStatefulSessionEJBObject)statefulSessionContext.remoteWrapper;
            try {
                EJBSession internalSession = this.getEJBSession(rsfso.OC4J_getId());
                if (internalSession == null) {
                    internalSession = this.createSession(rsfso);
                }
                internalSession.setContextAttribute(name, (Serializable)value);
            }
            catch (Exception e) {
                if (!m_logger.isLoggable(Level.FINEST)) break block4;
                e.fillInStackTrace();
                m_logger.log(Level.FINEST, "Exception while sending session state", e);
            }
        }
    }

    public boolean shouldGetUser() {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "shouldGetUser");
        }
        return false;
    }

    public void requestSession(String bindingPath, long id, long checksum) {
        block6: {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "requestSession id: " + id + ", bindingPath: " + bindingPath);
            }
            EJBSession internalSession = null;
            try {
                internalSession = this.getEJBSession(id, this.promiseTimeout);
                if (internalSession != null) {
                    internalSession.setContainer(this.container);
                    internalSession.unmarshall();
                }
            }
            catch (IllegalStateException e) {
                if (m_logger.isLoggable(Level.FINEST)) {
                    e.fillInStackTrace();
                    m_logger.log(Level.FINEST, "trouble getting requested session", e);
                }
            }
            catch (Exception e) {
                if (!m_logger.isLoggable(Level.FINEST)) break block6;
                e.fillInStackTrace();
                m_logger.log(Level.FINEST, "trouble getting requested session", e);
            }
        }
    }

    public void remove(StatefulSessionEJBObject sfsbObject) throws InterruptedException {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "remove");
        }
        this.manager.remove(sfsbObject.OC4J_getId());
        ClusteringMessages.fineInvalidateEjbSession(new Long(sfsbObject.OC4J_getId()));
    }

    public void create(StatefulSessionEJBObject sfsbObject) {
        if (!sfsbObject.isRemote) {
            return;
        }
        this.createSession(sfsbObject);
    }

    private EJBSession createSession(StatefulSessionEJBObject sfsbObject) {
        ClusteringMessages.fineEjbSessionCreatedWithId(sfsbObject.OC4J_getId());
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "EJB Clustering Session created with id = '" + Long.toString(sfsbObject.OC4J_getId()) + "'");
        }
        try {
            EJBSession session = this.manager.createEJB(sfsbObject.OC4J_getId(), sfsbObject.OC4J_getCreationTime());
            session.setContainer(this.container);
            session.setEJBObject(sfsbObject);
            return session;
        }
        catch (Exception e) {
            if (m_logger.isLoggable(Level.FINEST)) {
                e.fillInStackTrace();
                m_logger.log(Level.FINEST, "Exception while creating session", e);
            }
            return null;
        }
    }

    public void reified(StatefulSessionEJBObject sfsbObject, long id) {
        block7: {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "reified session id: " + id + ", sfsbObj: " + sfsbObject);
            }
            EJBSession internalSession = null;
            JGroupEJBService.logNullSFSObject(sfsbObject, this.container.getApplication().getName());
            try {
                internalSession = this.getEJBSession(id);
                if (internalSession == null) break block7;
                try {
                    if (sfsbObject == null) {
                        this.manager.remove(id);
                        break block7;
                    }
                    internalSession.setEJBObject(sfsbObject);
                }
                catch (IllegalStateException e) {
                    if (m_logger.isLoggable(Level.FINEST)) {
                        e.fillInStackTrace();
                        m_logger.log(Level.FINEST, "Exception while reifying EJB session", e);
                    }
                }
            }
            catch (Exception e) {
                if (!m_logger.isLoggable(Level.FINEST)) break block7;
                e.fillInStackTrace();
                m_logger.log(Level.FINEST, "Exception while reifying EJB session", e);
            }
        }
    }

    protected static void logNullSFSObject(StatefulSessionEJBObject sfsbObject, String appName) {
        if (sfsbObject == null) {
            EJBRuntimeMessages.warningNullSFSObject(appName);
        }
    }

    public void flushSession(EJBInternalOutputStream out, StatefulSessionEJBObject wrapper, boolean passivate) throws Exception {
        EJBSession internalSession = this.getEJBSession(wrapper.OC4J_getId());
        if (internalSession != null) {
            internalSession.flush(passivate);
        } else {
            m_logger.log(Level.FINEST, "asked to flush non-existing session" + wrapper.OC4J_getId() + " " + wrapper.getEJBHome_X().OC4J_getBindingPath());
        }
    }

    protected EJBSession getEJBSession(long id) throws Exception {
        return this.getEJBSession(id, 1);
    }

    private EJBSession getEJBSession(long id, int timeout) throws Exception {
        return (EJBSession)this.manager.get(id, timeout);
    }
}

