/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.security.SecuritySensitive;
import com.evermind.xml.XMLConfig;
import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import oracle.oc4j.runtime.ServerExtensionProviderSpec;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InternalSettingsDescriptor
extends XMLConfig {
    private List serverExtensionsProviders;
    private List m_providerSpecs = new ArrayList();

    protected void verifyDocumentType(String type) throws InstantiationException {
        if (!type.equals("internal-settings")) {
            throw new InstantiationException("Expected 'internal-settings' document, no '" + type + "'");
        }
    }

    public void parseDeploymentMainNode(Node node) throws InstantiationException {
        String name = node.getNodeName();
        if (name.startsWith("#")) {
            return;
        }
        if (name.equals("server-extension-provider")) {
            String sepName = XMLUtils.getNodeAttribute(node, "name");
            String className = XMLUtils.getNodeAttribute(node, "class");
            if (className == null) {
                throw new InstantiationException("'server-extension-provider' tag with missing 'class' attribute");
            }
            Hashtable props = new Hashtable();
            this.getAttributes().put(sepName, props);
            this.parseProperties(node, props);
            this.m_providerSpecs.add(new ServerExtensionProviderSpec(sepName, className, props));
        } else {
            super.parseDeploymentMainNode(node);
        }
    }

    public ServerExtensionProviderSpec[] getServerExtensionSpecs() {
        return this.m_providerSpecs.toArray(new ServerExtensionProviderSpec[this.m_providerSpecs.size()]);
    }

    protected void writeConfig(PrintWriter out) throws IOException {
        this.writeXML(out, "");
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<internal-settings " + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://xmlns.oracle.com/oracleas/schema/internal-settings-10_0.xsd\" " + " schema-major-version=\"10\" schema-minor-version=\"0\" " + " >");
        if (this.serverExtensionsProviders != null) {
            XMLUtils.writeAttributeTags(this.serverExtensionsProviders, "server-extension-provider", "class", out, indention + "\t");
        }
        out.println(indention + "</internal-settings>");
    }

    public void addServerExtensionProvider(String className) {
        this.m_providerSpecs.add(new ServerExtensionProviderSpec("", className, new Hashtable()));
        if (this.serverExtensionsProviders == null) {
            this.serverExtensionsProviders = new ArrayList();
        }
        this.serverExtensionsProviders.add(className);
    }

    private void parseProperties(Node parent, Hashtable props) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node childNode = list.item(i);
                String childName = childNode.getNodeName();
                if (childName.startsWith("#")) continue;
                if (childName.equals("sep-property")) {
                    String propName = XMLUtils.getNodeAttribute(childNode, "name");
                    String propValue = SecuritySensitive.global().decode(XMLUtils.getNodeAttribute(childNode, "value"));
                    if (propName == null || propValue == null) {
                        throw new InstantiationException("property tag in server-extension-providers has invalid/null values");
                    }
                    props.put(propName, propValue);
                    continue;
                }
                throw new InstantiationException("invalid tag in server-extension-providers: " + childName);
            }
        }
    }
}

