/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.server.deployment.InjectableReference;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EnvironmentEntry
extends InjectableReference
implements XMLizable,
Serializable {
    protected String value;
    protected String type;
    protected String runtimeValue;

    public EnvironmentEntry(String name, String value, String type, String description) {
        this.setName(name);
        this.setDescription(description);
        this.value = value;
        this.setType(type);
    }

    public EnvironmentEntry(Node parent) throws InstantiationException {
        this.parseXML(parent);
    }

    public void parseXML(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        boolean nameSet = false;
        boolean typeSet = false;
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = node.getNodeName();
                if (name.startsWith("#")) continue;
                String value = XMLUtils.getStringValue(node);
                if (name.equals("env-entry-name") && !value.equals("")) {
                    this.setName(value);
                    nameSet = true;
                    continue;
                }
                if (name.equals("env-entry-value")) {
                    this.value = value;
                    continue;
                }
                if (name.equals("env-entry-type")) {
                    this.setType(value);
                    typeSet = true;
                    continue;
                }
                if (name.equals("description")) {
                    this.setDescription(value);
                    continue;
                }
                if (name.equals("mapped-name")) {
                    throw new InstantiationException("mapped-name is not supported as a subtag of env-entry.");
                }
                if (this.parseInjectionTarget(node)) continue;
                throw new InstantiationException("Unknown environment-entry tag: " + name);
            }
        }
        if (!nameSet) {
            throw new InstantiationException("env-entry with missing env-entry-name subtag or empty value");
        }
        if (!typeSet) {
            throw new InstantiationException("env-entry '" + this.getName() + "' lacks an env-entry-type subtag");
        }
        String type = this.getType();
        if (!(type.equals("java.lang.Boolean") || type.equals("java.lang.String") || type.equals("java.lang.Integer") || type.equals("java.lang.Double") || type.equals("java.lang.Byte") || type.equals("java.lang.Short") || type.equals("java.lang.Long") || type.equals("java.lang.Character") || type.equals("java.lang.Float"))) {
            throw new InstantiationException("Invalid env-entry-type for env-entry '" + this.getName() + "': '" + type + "', legal values are: 'java.lang.Boolean', " + "'java.lang.String', 'java.lang.Integer', 'java.lang.Double', 'java.lang.Byte', 'java.lang.Short', 'java.lang.Long', 'java.lang.Character' and 'java.lang.Float'");
        }
    }

    public Object getValue() throws InstantiationException {
        return EnvironmentEntry.getValue("env-entry", "env-entry-type", this.getName(), this.getType(), this.runtimeValue == null ? this.value : this.runtimeValue);
    }

    public String internalGetValue() {
        return this.runtimeValue == null ? this.value : this.runtimeValue;
    }

    public String getEnvEntryValue() {
        return this.value;
    }

    public static Object getValue(String tagName, String typeTagName, String name, String type, String value) throws InstantiationException {
        if (value == null) {
            throw new InstantiationException("Value not set for env-entry " + name);
        }
        if (type == null) {
            return value;
        }
        try {
            if (type.equals("java.lang.Boolean")) {
                return Boolean.valueOf(value);
            }
            if (type.equals("java.lang.String")) {
                return value;
            }
            if (type.equals("java.lang.Integer")) {
                return Integer.valueOf(value);
            }
            if (type.equals("java.lang.Double")) {
                return Double.valueOf(value);
            }
            if (type.equals("java.lang.Byte")) {
                return Byte.valueOf(value);
            }
            if (type.equals("java.lang.Short")) {
                return Short.valueOf(value);
            }
            if (type.equals("java.lang.Long")) {
                return Long.valueOf(value);
            }
            if (type.equals("java.lang.Character")) {
                if (value.length() == 0) {
                    throw new InstantiationException("No value specified for java.lang.Character env-entry '" + name + "'");
                }
                if (value.length() > 1) {
                    throw new InstantiationException("Invalid value specified for java.lang.Character env-entry '" + name + "': '" + value + "'");
                }
                return new Character(value.charAt(0));
            }
            if (type.equals("java.lang.Float")) {
                return Float.valueOf(value);
            }
            throw new InstantiationException("Unknown " + typeTagName + " for " + tagName + " " + name + ": '" + type + "'");
        }
        catch (NumberFormatException e) {
            throw new InstantiationException("Invalid numeric value: " + value);
        }
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<env-entry>");
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.getName() != null) {
            out.println(indention + "\t<env-entry-name>" + XMLUtils.encode(this.getName()) + "</env-entry-name>");
        } else {
            out.println(indention + "\t<env-entry-name>unnamed</env-entry-name>");
        }
        if (this.getType() != null) {
            out.println(indention + "\t<env-entry-type>" + XMLUtils.encode(this.getType()) + "</env-entry-type>");
        } else {
            out.println(indention + "\t<env-entry-type>java.lang.String</env-entry-type>");
        }
        if (this.value != null) {
            out.println(indention + "\t<env-entry-value>" + XMLUtils.encode(this.value) + "</env-entry-value>");
        } else if (this.hasInjectionTarget()) {
            out.println(indention + "\t<!--env-entry-value>This environment variable was created in code from the injection of @Resource. Uncomment and add a valid value to override the value in code</env-entry-value-->");
        }
        this.writeInjectableXML(out, indention + "\t");
        out.println(indention + "</env-entry>");
    }

    public void parseOrionXML(Node parent) throws InstantiationException {
        this.runtimeValue = XMLUtils.getStringValue(parent);
        if (this.runtimeValue == null) {
            this.runtimeValue = XMLUtils.getNodeAttribute(parent, "value");
            if (this.runtimeValue == null) {
                throw new InstantiationException("env-entry-mapping '" + this.getName() + "' must contain a body (value)");
            }
        }
    }

    public void writeOrionXML(PrintWriter out, String indention) {
        String val = this.internalGetValue();
        if (val == null) {
            return;
        }
        out.println(indention + "<env-entry-mapping name=\"" + XMLUtils.encode(this.getName()) + "\">" + XMLUtils.encode(val) + "</env-entry-mapping>");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("  description:  ");
        buf.append(this.getDescription());
        buf.append("\n");
        buf.append("  env-entry-name:  ");
        buf.append(this.getName() != null ? this.getName() : "unnamed");
        buf.append("\n");
        buf.append("  env-entry-type:  ");
        buf.append(this.getType() != null ? this.getType() : "java.lang.String");
        buf.append("\n");
        buf.append("  env-entry-value:  ");
        buf.append(this.value);
        buf.append("\n");
        buf.append("  env-entry-mapping:  ");
        buf.append(this.runtimeValue);
        buf.append("\n");
        return buf.toString();
    }

    public boolean hasRuntimeValue() {
        return this.runtimeValue != null;
    }

    public static void initializeEnvironmentEntries(Map map, List entries) throws InstantiationException {
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            EnvironmentEntry entry = (EnvironmentEntry)iterator.next();
            if (entry.internalGetValue() == null) continue;
            map.put(entry.getName(), entry.getValue());
        }
    }

    public void setValue(String value) {
        this.value = value;
        this.firePropertyChangeEvent("value", this.value, value);
    }

    public void setRuntimeValue(String value) {
        this.runtimeValue = value;
        this.firePropertyChangeEvent("value", this.runtimeValue, value);
    }

    public String getRuntimeValue() {
        return this.runtimeValue;
    }

    public String getType() {
        return this.getReferenceClass();
    }

    public void setType(String type) {
        this.setReferenceClass(type);
    }
}

