/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.naming.memory.MapContext;
import com.evermind.server.J2EEComponent;
import com.evermind.server.deployment.DestinationReference;
import com.evermind.server.deployment.EnvironmentEntry;
import com.evermind.server.deployment.EnvironmentEntryContainer;
import com.evermind.server.deployment.IconDescriptor;
import com.evermind.server.deployment.MailSessionInfo;
import com.evermind.server.deployment.ResourceEnvironmentReference;
import com.evermind.server.deployment.ResourceReference;
import com.evermind.server.deployment.ResourceReferenceContainer;
import com.evermind.server.ejb.deployment.EJBReference;
import com.evermind.server.ejb.deployment.EJBReferenceContainer;
import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.naming.Context;
import oracle.j2ee.deployment.DeploymentMessages;
import oracle.j2ee.ws.server.deployment.ServiceReferenceContainer;
import oracle.j2ee.ws.server.deployment.ServiceReferenceDescriptor;
import oracle.oc4j.configuration.J2EEContextConfigDelegate;
import oracle.oc4j.configuration.J2EEContextDescriptor;
import org.w3c.dom.Node;

public class ApplicationClientArchive
extends J2EEComponent
implements ResourceReferenceContainer,
EnvironmentEntryContainer,
EJBReferenceContainer,
ServiceReferenceContainer,
J2EEContextDescriptor {
    private J2EEContextConfigDelegate m_configDelegate = new J2EEContextConfigDelegate(this);
    private IconDescriptor icon;
    private List mailSessions = null;
    private String callbackHandler;

    public ApplicationClientArchive(String name) {
        this(name, new MapContext());
    }

    public ApplicationClientArchive(String name, Context context) {
        this.setName(name);
        this.setContext(context);
        this.mailSessions = new ArrayList();
    }

    public void setMailSessions(List newMailSessions) {
        this.mailSessions = newMailSessions;
    }

    private void logNameNotFound(String tag, String name) {
        DeploymentMessages.warningApplicationConfigHasNoMatchingEntry(tag, name);
    }

    public void parseDeploymentMainNode(Node node) throws InstantiationException {
        String name = node.getNodeName();
        if (name.equals("env-entry-mapping")) {
            String entryName = XMLUtils.getNodeAttribute(node, "name");
            if (entryName != null) {
                EnvironmentEntry entry = this.getEnvironmentEntry(entryName);
                if (entry != null) {
                    entry.parseOrionXML(node);
                } else {
                    this.logNameNotFound(name, entryName);
                }
            }
        } else if (name.equals("ejb-ref-mapping")) {
            String referenceName = XMLUtils.getNodeAttribute(node, "name");
            if (referenceName != null) {
                EJBReference reference = this.getEJBReference(referenceName);
                if (reference != null) {
                    reference.parseOrionXML(node);
                } else {
                    this.logNameNotFound(name, referenceName);
                }
            }
        } else if (name.equals("service-ref-mapping")) {
            String referenceName = XMLUtils.getNodeAttribute(node, "name");
            if (referenceName != null) {
                ServiceReferenceDescriptor reference = this.getServiceReference(referenceName);
                if (reference != null) {
                    reference.parseOrionXML(node);
                } else {
                    this.logNameNotFound(name, referenceName);
                }
            }
        } else if (name.equals("resource-ref-mapping")) {
            String resName = XMLUtils.getNodeAttribute(node, "name");
            if (resName != null) {
                ResourceReference reference = this.getResourceReference(resName);
                if (reference != null) {
                    reference.parseOrionXML(node);
                } else {
                    this.logNameNotFound(name, resName);
                }
            }
        } else if (name.equals("resource-env-ref-mapping")) {
            String envName = XMLUtils.getNodeAttribute(node, "name");
            if (envName != null) {
                ResourceEnvironmentReference reference = this.getResourceEnvironmentReference(envName);
                if (reference != null) {
                    reference.parseOrionXML(node);
                } else {
                    this.logNameNotFound(name, envName);
                }
            }
        } else if (name.equals("message-destination-ref-mapping")) {
            String destName = XMLUtils.getNodeAttribute(node, "name");
            if (destName != null) {
                DestinationReference reference = this.getDestinationReference(destName);
                if (reference != null) {
                    reference.parseOrionXML(node);
                } else {
                    this.logNameNotFound(name, destName);
                }
            }
        } else if (name.equals("mail-session")) {
            this.addMailSession(new MailSessionInfo(node));
        } else {
            super.parseDeploymentMainNode(node);
        }
    }

    public synchronized void addMailSession(MailSessionInfo session) {
        this.mailSessions.add(session);
    }

    public void parseMainNode(Node node) throws InstantiationException {
        String name = node.getNodeName();
        if (name.equals("persistence-unit-ref")) {
            throw new InstantiationException("<persistence-unit-ref> not supported for application clients.");
        }
        if (name.equals("persistence-context-ref")) {
            throw new InstantiationException("<persistence-context-ref> not supported for application clients.");
        }
        if (this.m_configDelegate.parseNode(node)) {
            return;
        }
        if (name.equals("icon")) {
            this.icon = new IconDescriptor(node);
        } else if (name.equals("callback-handler")) {
            this.setCallbackHandler(XMLUtils.getStringValue(node));
        } else {
            super.parseMainNode(node);
        }
    }

    protected void verifyDocumentType(String name) throws InstantiationException {
        if (!name.equalsIgnoreCase("application-client") && !name.equalsIgnoreCase("orion-application-client")) {
            throw new InstantiationException("Document-type of application-client expected");
        }
    }

    public void addEnvironmentEntry(EnvironmentEntry entry) {
        this.m_configDelegate.addEnvironmentEntry(entry);
    }

    public void removeEnvironmentEntry(int pos) {
        this.m_configDelegate.removeEnvironmentEntry(pos);
    }

    public void addEJBReference(EJBReference reference) {
        this.m_configDelegate.addEJBReference(reference);
    }

    public void removeEJBReference(EJBReference reference) {
        this.m_configDelegate.removeEJBReference(reference);
    }

    public void addServiceReference(ServiceReferenceDescriptor serviceReference) {
        this.m_configDelegate.addServiceReference(serviceReference);
    }

    public void removeServiceReference(ServiceReferenceDescriptor reference) {
        this.m_configDelegate.removeServiceReference(reference);
    }

    public synchronized ServiceReferenceDescriptor getServiceReference(String name) {
        return this.m_configDelegate.getServiceReference(name);
    }

    public void addResourceReference(ResourceReference reference) {
        this.m_configDelegate.addResourceReference(reference);
    }

    public void addResourceEnvironmentReference(ResourceEnvironmentReference reference) {
        this.m_configDelegate.addResourceEnvironmentReference(reference);
    }

    public void addDestinationReference(DestinationReference reference) {
        this.m_configDelegate.addDestinationReference(reference);
    }

    public void removeResourceReference(ResourceReference reference) {
        this.m_configDelegate.removeResourceReference(reference);
    }

    public void removeResourceEnvironmentReference(ResourceEnvironmentReference reference) {
        this.m_configDelegate.removeResourceEnvironmentReference(reference);
    }

    public void removeDestinationReference(DestinationReference reference) {
        this.m_configDelegate.removeDestinationReference(reference);
    }

    public List getResourceReferences() {
        return this.m_configDelegate.getResourceReferences();
    }

    public List getResourceEnvironmentReferences() {
        return this.m_configDelegate.getResourceEnvironmentReferences();
    }

    public List getDestinationReferences() {
        return this.m_configDelegate.getDestinationReferences();
    }

    public List getEJBReferences() {
        return this.m_configDelegate.getEJBReferences();
    }

    public List getServiceReferences() {
        return this.m_configDelegate.getServiceReferences();
    }

    public List getEnvironmentEntries() {
        return this.m_configDelegate.getEnvironmentEntries();
    }

    public List getMailSessions() {
        return this.mailSessions;
    }

    public J2EEContextConfigDelegate getConfigDelegate() {
        return this.m_configDelegate;
    }

    public List getPersistenceUnitReferences() {
        return Collections.EMPTY_LIST;
    }

    public List getPersistenceContextReferences() {
        return Collections.EMPTY_LIST;
    }

    protected void writeConfig(PrintWriter out) throws IOException {
        out.println("<?xml version=\"1.0\"?>");
        out.println("<!DOCTYPE application-client PUBLIC \"-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN\" \"http://java.sun.com/dtd/application-client_1_3.dtd\">");
        out.println();
        this.writeXML(out, "");
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        List serviceReferences;
        out.println(indention + "<application-client>");
        if (this.getDisplayName() != null) {
            out.println(indention + "\t<display-name>" + XMLUtils.encode(this.getDisplayName()) + "</display-name>");
        } else {
            out.println(indention + "\t<display-name>Unnamed</display-name>");
        }
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.icon != null) {
            this.icon.writeXML(out, indention + "\t");
        }
        XMLUtils.writeAll(this.getEnvironmentEntries(), out, indention + "\t");
        XMLUtils.writeAll(this.getResourceReferences(), out, indention + "\t");
        XMLUtils.writeAll(this.getResourceEnvironmentReferences(), out, indention + "\t");
        XMLUtils.writeAll(this.getDestinationReferences(), out, indention + "\t");
        List ejbReferences = this.getEJBReferences();
        if (ejbReferences != null) {
            Collections.sort(ejbReferences);
            XMLUtils.writeAll(ejbReferences, out, indention + "\t");
        }
        if (!(serviceReferences = this.getServiceReferences()).isEmpty()) {
            Collections.sort(serviceReferences);
            XMLUtils.writeAll(serviceReferences, out, "\t");
        }
        XMLUtils.writeAll(this.getResourceEnvironmentReferences(), out, indention + "\t");
        if (this.callbackHandler != null) {
            out.println(indention + "\t<callback-handler>" + XMLUtils.encode(this.callbackHandler) + "</callback-handler>");
        }
        out.println(indention + "</application-client>");
    }

    protected void writeOrionConfig(PrintWriter out) throws IOException {
        out.println("<?xml version=\"1.0\"?>");
        out.println();
        this.writeOrionXML(out, "");
    }

    public void writeOrionXML(PrintWriter out, String indention) throws IOException {
        Iterator iterator;
        List destinationReferences;
        List resourceEnvironmentReferences;
        List resourceReferences;
        List serviceReferences;
        out.println(indention + "<orion-application-client xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://xmlns.oracle.com/oracleas/schema/orion-application-client-10_0.xsd\" " + " schema-major-version=\"10\" schema-minor-version=\"0\" " + " >");
        List environmentEntries = this.getEnvironmentEntries();
        for (int i = 0; i < environmentEntries.size(); ++i) {
            EnvironmentEntry entry = (EnvironmentEntry)environmentEntries.get(i);
            if (!entry.hasRuntimeValue()) continue;
            entry.writeOrionXML(out, indention + "\t");
        }
        List ejbReferences = this.getEJBReferences();
        if (!ejbReferences.isEmpty()) {
            for (int i = 0; i < ejbReferences.size(); ++i) {
                EJBReference reference = (EJBReference)ejbReferences.get(i);
                reference.writeOrionXML(out, indention + "\t");
            }
        }
        if (!(serviceReferences = this.getServiceReferences()).isEmpty()) {
            for (int i = 0; i < serviceReferences.size(); ++i) {
                ServiceReferenceDescriptor reference = (ServiceReferenceDescriptor)serviceReferences.get(i);
                reference.writeOrionXML(out, indention + "\t");
            }
        }
        if (!(resourceReferences = this.getResourceReferences()).isEmpty()) {
            Iterator iterator2 = resourceReferences.iterator();
            while (iterator2.hasNext()) {
                ((ResourceReference)iterator2.next()).writeOrionXML(out, indention + "\t");
            }
        }
        if (!(resourceEnvironmentReferences = this.getResourceEnvironmentReferences()).isEmpty()) {
            Iterator iterator3 = resourceEnvironmentReferences.iterator();
            while (iterator3.hasNext()) {
                ((ResourceEnvironmentReference)iterator3.next()).writeOrionXML(out, indention + "\t");
            }
        }
        if (!(destinationReferences = this.getDestinationReferences()).isEmpty()) {
            iterator = destinationReferences.iterator();
            while (iterator.hasNext()) {
                ((DestinationReference)iterator.next()).writeOrionXML(out, indention + "\t");
            }
        }
        if (this.mailSessions != null) {
            iterator = this.mailSessions.iterator();
            while (iterator.hasNext()) {
                ((MailSessionInfo)iterator.next()).writeXML(out, indention + "\t");
            }
        }
        out.println(indention + "</orion-application-client>");
    }

    public String getName() {
        String name = super.getName();
        if (name != null) {
            return name;
        }
        return "Generic Client-jar";
    }

    private EJBReference getEJBReference(String name) {
        return this.m_configDelegate.getEJBReference(name);
    }

    private ResourceReference getResourceReference(String name) {
        return this.m_configDelegate.getResourceReference(name);
    }

    private ResourceEnvironmentReference getResourceEnvironmentReference(String name) {
        return this.m_configDelegate.getResourceEnvironmentReference(name);
    }

    private DestinationReference getDestinationReference(String name) {
        return this.m_configDelegate.getDestinationReference(name);
    }

    protected String getDefaultDeploymentSubname() {
        return "META-INF";
    }

    protected String getAssemblyDescriptorPath() {
        return "META-INF/application-client.xml";
    }

    public String getDeploymentDescriptorPath() {
        return "orion-application-client.xml";
    }

    private EnvironmentEntry getEnvironmentEntry(String name) {
        return this.m_configDelegate.getEnvironmentEntry(name);
    }

    public String getCallbackHandler() {
        return this.callbackHandler;
    }

    private void setCallbackHandler(String callbackHandler) {
        this.callbackHandler = callbackHandler;
    }
}

