/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.connector.deployment;

import com.evermind.server.connector.deployment.ConnectorArchive;
import com.evermind.util.TaskManager;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.dms.instrument.NounIntf;
import oracle.j2ee.connector.ConnectionPool;
import oracle.j2ee.connector.ConnectionPoolImpl;
import oracle.oc4j.admin.management.callbackinterfaces.JCAConnectionPoolCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.JCAConnectionPoolMetricCallBackIf;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SharedConnectionPool
implements XMLizable,
Serializable,
JCAConnectionPoolCallBackIf {
    private Properties m_connectionPoolProperties;
    private transient ConnectionPool m_connectionPool;
    private String m_name;
    private String m_mcfClassName;
    private static final String DEFAULT_CONNECTION_POOL_IMPL_CLASS = "oracle.j2ee.connector.ConnectionPoolImpl";
    private List m_users = new ArrayList();
    private ConnectorArchive archive;
    private transient Map m_contexts;

    public SharedConnectionPool(String name) {
        this.m_name = name;
    }

    public SharedConnectionPool(String name, ConnectorArchive archive) {
        this.m_name = name;
        this.archive = archive;
    }

    public SharedConnectionPool(ConnectorArchive archive, Node parent) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        if (list == null) {
            return;
        }
        this.archive = archive;
        this.m_name = XMLUtils.getNodeAttribute(parent, "name");
        if (this.m_name == null) {
            throw new InstantiationException("must provide a name for connection-pool in " + archive.getDeploymentDescriptorPath() + ".");
        }
        for (int i = 0; i < list.getLength(); ++i) {
            Node childnode = list.item(i);
            String childname = childnode.getNodeName();
            if (childname.startsWith("#") || !childname.equals("property")) continue;
            String propertyName = XMLUtils.getNodeAttribute(childnode, "name");
            String propertyValue = XMLUtils.getNodeAttribute(childnode, "value");
            if (propertyName == null) {
                throw new InstantiationException("connection-pool property tag in " + archive.getDeploymentDescriptorPath() + " with missing name attribute");
            }
            if (propertyValue == null) {
                throw new InstantiationException("connection-pool property tag in " + archive.getDeploymentDescriptorPath() + " with missing value attribute");
            }
            this.setConnectionPoolProperty(propertyName, propertyValue);
        }
    }

    public void setConnectionPoolProperty(String name, String value) throws InstantiationException {
        if (name == null) {
            throw new InstantiationException("name cannot be null");
        }
        if (value == null) {
            throw new InstantiationException("value cannot be null");
        }
        if (this.m_connectionPoolProperties == null) {
            this.m_connectionPoolProperties = new Properties();
        }
        this.m_connectionPoolProperties.setProperty(name, value);
    }

    public String getName() {
        return this.m_name;
    }

    public Properties getConnectionPoolProperties() {
        return this.m_connectionPoolProperties;
    }

    public Map getContexts() {
        if (this.m_contexts == null) {
            this.m_contexts = new HashMap();
        }
        return this.m_contexts;
    }

    public ConnectionPool getConnectionPool() {
        return this.m_connectionPool;
    }

    public ConnectionPool getConnectionPool(boolean isReAuthenticationSupported, PrintWriter logWriter, NounIntf parentNoun, TaskManager taskManager, String mcfClassName, String connectionPoolClassName) throws InstantiationException {
        if (mcfClassName == null) {
            throw new InstantiationException("ManagedConnectionFactory class name cannot be null");
        }
        if (this.m_mcfClassName == null) {
            this.m_mcfClassName = mcfClassName;
        } else if (!this.m_mcfClassName.equals(mcfClassName)) {
            throw new InstantiationException("Shared connection pool named '" + this.m_name + " can only be used for " + "connection factory with ManagedConnectionFactory implementation " + "class " + this.m_mcfClassName + ". It cannot be used for a different " + "ManagedConnectionFactory ipmlementation class " + mcfClassName + ".");
        }
        if (this.m_connectionPool == null) {
            try {
                if (connectionPoolClassName == null) {
                    connectionPoolClassName = DEFAULT_CONNECTION_POOL_IMPL_CLASS;
                }
                Class<?> connectionPoolClass = Class.forName(connectionPoolClassName);
                ConnectionPool pool = (ConnectionPool)connectionPoolClass.newInstance();
                pool.init(null, null, this.m_connectionPoolProperties, isReAuthenticationSupported, logWriter, this.m_name, parentNoun);
                if (taskManager != null) {
                    taskManager.addTask(pool);
                }
                this.m_connectionPool = pool;
            }
            catch (ClassNotFoundException e) {
                throw new InstantiationException("Unable to find ConnectionPool implementation class " + connectionPoolClassName + " for shared connection pool named \"" + this.m_name + "\".");
            }
            catch (Exception e) {
                throw new InstantiationException("Error in initializing a shared connection pool named \"" + this.m_name + "\". Exception is: " + e);
            }
        }
        return this.m_connectionPool;
    }

    public synchronized boolean isInUse() {
        return !this.m_users.isEmpty();
    }

    public synchronized void usePool(String connectionFactoryLocation) {
        this.m_users.add(connectionFactoryLocation);
    }

    public synchronized void releasePool(String connectionFactoryLocation) {
        this.m_users.remove(connectionFactoryLocation);
        if (this.m_users.isEmpty() && this.m_connectionPool != null) {
            this.m_connectionPool.destroy();
            this.m_connectionPool = null;
        }
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
    }

    public void writeOrionXML(PrintWriter out, String indention) {
        out.println(indention + "<connection-pool name=\"" + XMLUtils.encode(this.m_name) + "\">");
        if (this.m_connectionPoolProperties != null) {
            XMLUtils.writeCompressedMap(this.m_connectionPoolProperties, "property", out, "name", "value", indention + "\t");
        }
        out.println(indention + "</connection-pool>");
    }

    private String getConnectionPoolProperty(String property) {
        if (this.m_connectionPoolProperties != null) {
            return (String)this.m_connectionPoolProperties.get(property);
        }
        return null;
    }

    public void setConnectionPoolProperty(String name, int value) throws InstantiationException {
        this.setConnectionPoolProperty(name, Integer.toString(value));
    }

    public String getPoolName() {
        return this.m_name;
    }

    public String getScheme() {
        if (this.m_connectionPool != null) {
            return this.m_connectionPool.getScheme();
        }
        return this.getConnectionPoolProperty("scheme");
    }

    public void setScheme(String newScheme) throws Exception {
        if (this.m_connectionPool != null) {
            this.m_connectionPool.setScheme(newScheme);
        }
        this.setConnectionPoolProperty("scheme", newScheme);
    }

    public int getInitialCapacity() {
        return Integer.parseInt(this.getConnectionPoolProperty("initial-capacity"));
    }

    public void setInitialCapacity(int newValue) throws Exception {
        if (this.m_connectionPool != null) {
            this.m_connectionPool.setInitialCapacity(newValue);
        }
        this.setConnectionPoolProperty("initial-capacity", newValue);
    }

    public int getMinConnections() {
        String minConnections = this.getConnectionPoolProperty("minConnections");
        if (minConnections != null) {
            return Integer.parseInt(minConnections);
        }
        return ConnectionPoolImpl.DEFAULT_MIN_CONNECTIONS;
    }

    public void setMinConnections(int newValue) throws Exception {
        if (this.m_connectionPool != null) {
            this.m_connectionPool.setMinConnections(newValue);
        }
        this.setConnectionPoolProperty("minConnections", newValue);
    }

    public int getMaxConnections() {
        String maxConnections = this.getConnectionPoolProperty("maxConnections");
        if (maxConnections != null) {
            return Integer.parseInt(maxConnections);
        }
        return ConnectionPoolImpl.DEFAULT_MAX_CONNECTIONS;
    }

    public void setMaxConnections(int newValue) throws Exception {
        if (this.m_connectionPool != null) {
            this.m_connectionPool.setMaxConnections(newValue);
        }
        this.setConnectionPoolProperty("maxConnections", newValue);
    }

    public int getWaitTimeout() {
        String timeout = this.getConnectionPoolProperty("waitTimeout");
        if (timeout != null) {
            return Integer.parseInt(timeout);
        }
        return ConnectionPoolImpl.DEFAULT_WAIT_TIMEOUT;
    }

    public void setWaitTimeout(int newValue) throws Exception {
        if (this.m_connectionPool != null) {
            this.m_connectionPool.setWaitTimeout(newValue);
        }
        this.setConnectionPoolProperty("waitTimeout", newValue);
    }

    public String getInactivityTimeoutCheck() {
        return this.getConnectionPoolProperty("inactivity-timeout-check");
    }

    public void setInactivityTimeoutCheck(String newValue) throws Exception {
        if (this.m_connectionPool != null) {
            this.m_connectionPool.setInactivityTimeoutCheck(newValue);
        }
        this.setConnectionPoolProperty("inactivity-timeout-check", newValue);
    }

    public int getInactivityTimeout() {
        String timeout = this.getConnectionPoolProperty("inactivity-timeout");
        if (timeout != null) {
            return Integer.parseInt(timeout);
        }
        return ConnectionPoolImpl.DEFAULT_INACTIVITY_TIMEOUT;
    }

    public void setInactivityTimeout(int newValue) throws Exception {
        if (this.m_connectionPool != null) {
            this.m_connectionPool.setInactivityTimeout(newValue);
        }
        this.setConnectionPoolProperty("inactivity-timeout", newValue);
    }

    public void pruneInvalidAndExpiredConnections() {
        if (this.m_connectionPool != null) {
            this.m_connectionPool.purgeCandidateSet();
        }
    }

    public String getManagedConnectionFactoryClass() {
        return this.m_mcfClassName;
    }

    public boolean isPoolInUse() {
        return this.isInUse();
    }

    public JCAConnectionPoolMetricCallBackIf getDMSMetrics() {
        return (JCAConnectionPoolMetricCallBackIf)((Object)this.m_connectionPool);
    }

    public void persistConfigChange() {
        this.archive.persistConfigChange();
    }
}

