/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.connector.deployment;

import com.evermind.server.connector.deployment.ActivationSpecConfig;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageListener
extends AbstractDescribable
implements XMLizable {
    protected String m_type;
    protected ActivationSpecConfig m_activationSpecConfig;

    public MessageListener(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.startsWith("#")) continue;
                String value = XMLUtils.getStringValue(node);
                if (nodeName.equals("messagelistener-type")) {
                    this.m_type = value;
                    continue;
                }
                if (nodeName.equals("activationspec")) {
                    this.m_activationSpecConfig = new ActivationSpecConfig(node);
                    continue;
                }
                throw new InstantiationException("Unknown messagelistener subtag: " + nodeName);
            }
        }
        if (this.m_type == null) {
            throw new InstantiationException("Missing 'messagelistener-type' subtag in messagelistener tag");
        }
        if (this.m_activationSpecConfig == null) {
            throw new InstantiationException("Missing 'activationspec' subtag in messagelistener tag");
        }
    }

    public String getMessageListenerType() {
        return this.m_type;
    }

    public ActivationSpecConfig getActivationSpecConfig() {
        return this.m_activationSpecConfig;
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<messagelistener>");
        out.println(indention + "\t<messagelistener-type>" + XMLUtils.encode(this.m_type) + "</messagelistener-type>");
        if (this.m_activationSpecConfig != null) {
            this.m_activationSpecConfig.writeXML(out, indention + "\t");
        }
        out.println(indention + "</messagelistener>");
    }

    public void writeOrionXML(PrintWriter out, String indention) throws IOException {
    }
}

