/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.connector.deployment;

import com.evermind.server.connector.deployment.AdminObject;
import com.evermind.server.connector.deployment.ConfigurationProperty;
import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import oracle.oc4j.admin.management.callbackinterfaces.JCAAdminObjectInstanceCallBackIf;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdminObjectInstance
extends AdminObject
implements JCAAdminObjectInstanceCallBackIf {
    private String m_location;
    private boolean m_isExampleOnly;

    AdminObjectInstance(String _adminObjectInterface, String _adminObjectClass, Map _configurationProperties) {
        this.m_location = null;
        this.m_adminObjectInterface = _adminObjectInterface;
        this.m_adminObjectClass = _adminObjectClass;
        this.m_configurationProperties = _configurationProperties;
        this.m_isExampleOnly = false;
    }

    public boolean isExampleOnly() {
        return this.m_isExampleOnly;
    }

    public AdminObjectInstance(Node parent) throws InstantiationException {
        this.m_location = XMLUtils.getNodeAttribute(parent, "location");
        if (this.m_location == null) {
            throw new InstantiationException("Missing 'location' subtag in adminobject-config' tag");
        }
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (nodeName.startsWith("#")) continue;
                String value = XMLUtils.getStringValue(node);
                if (nodeName.equals("adminobject-class")) {
                    this.m_adminObjectClass = value;
                    continue;
                }
                if (nodeName.equals("config-property")) {
                    this.addConfigurationProperty(new ConfigurationProperty(node, 2));
                    continue;
                }
                throw new InstantiationException("Unknown adminobject-config subtag: " + nodeName);
            }
        }
        if (this.m_adminObjectClass == null) {
            throw new InstantiationException("Missing 'adminobject-class' subtag in 'adminobject-config' tag");
        }
    }

    public String getLocation() {
        return this.m_location;
    }

    public void setLocation(String location) throws InstantiationException {
        this.m_location = location;
    }

    public void setIsExampleOnly(boolean _isExampleOnly) {
        this.m_isExampleOnly = _isExampleOnly;
    }

    public void setConfigurationProperty(String name, String value) throws InstantiationException {
        if (name == null) {
            throw new InstantiationException("name cannot be null in AdminObjectInstance.setConfigurationProperty");
        }
        if (this.m_configurationProperties == null) {
            throw new InstantiationException("This AdminObjectInstance does not have any configurable property");
        }
        ConfigurationProperty configProp = (ConfigurationProperty)this.m_configurationProperties.get(name);
        if (configProp == null) {
            throw new InstantiationException("This AdminObjectInstance does not have a property named '" + name + "'");
        }
        configProp.setRuntimeValue(value);
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
    }

    public void writeOrionXML(PrintWriter out, String indention) {
        if (this.m_isExampleOnly) {
            out.println(indention + "<!-- Default element generated by OC4J. Please uncomment and modify to suit your configuration needs.");
        }
        out.println(indention + "<adminobject-config location=\"" + XMLUtils.encode(this.m_location) + "\">");
        out.println(indention + "\t<adminobject-class>" + XMLUtils.encode(this.m_adminObjectClass) + "</adminobject-class>");
        if (!this.getConfigurationProperties().isEmpty()) {
            Iterator iter = this.getConfigurationProperties().iterator();
            while (iter.hasNext()) {
                ConfigurationProperty config = (ConfigurationProperty)iter.next();
                config.writeOrionXML(out, indention + "\t");
            }
        }
        out.println(indention + "</adminobject-config>");
        if (this.m_isExampleOnly) {
            out.println(indention + "-->");
        }
    }

    public String toString() {
        return "[AdminObjectInstance: interface = " + this.m_adminObjectInterface + ", class = " + this.m_adminObjectClass + ", location = " + this.m_location + ", configurationProperties = " + this.m_configurationProperties + "]";
    }
}

