/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.security.AbstractGroup;
import com.evermind.security.AbstractUser;
import com.evermind.security.BasicUser;
import com.evermind.security.Group;
import com.evermind.security.User;
import com.evermind.security.UserManager;
import com.evermind.server.UserSubjectBridgeI;
import java.security.Principal;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.security.BasicUserProxy;
import oracle.oc4j.security.SecurityUtil;
import oracle.oc4j.security.ShieldedUser;
import oracle.security.jazn.oc4j.JAZNUserAdaptor;
import oracle.security.jazn.oc4j.SubjectUtil;

public class UserSubjectBridge
implements UserSubjectBridgeI {
    private static final UserSubjectBridge s_singleton = new UserSubjectBridge();
    private static final Logger s_logger = TraceLogger.getLogger(UserSubjectBridge.class);

    protected UserSubjectBridge() {
    }

    public static UserSubjectBridge getInstance() {
        return s_singleton;
    }

    public BasicUser toBasicUser(Subject subject) {
        if (null == subject) {
            return null;
        }
        Principal userPrincipal = this.pickUserPrincipal(subject);
        if (null == userPrincipal || userPrincipal instanceof BasicUser) {
            return this.shield((BasicUser)userPrincipal);
        }
        s_logger.log(Level.FINE, "unable to map principal {0} to a User", userPrincipal);
        User user = this.newUser(userPrincipal);
        Iterator<Principal> iter = subject.getPrincipals().iterator();
        while (iter.hasNext()) {
            Principal p = iter.next();
            if (p instanceof BasicUser) {
                return this.shield((BasicUser)p);
            }
            if (userPrincipal == p) continue;
            user.addToGroup(this.newGroup(p));
        }
        return this.shield(user);
    }

    public User toUser(BasicUser user, UserManager um) {
        if (null == user || user instanceof User) {
            return (User)user;
        }
        if (user instanceof ShieldedUser) {
            try {
                BasicUser delegate = ((ShieldedUser)((Object)user)).getShieldedUser();
                if (null != delegate) {
                    return this.toUser(delegate, um);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (null == um) {
            throw new UnsupportedOperationException("unable to resolve user - UserManager is required");
        }
        return um.getUser(user.getName());
    }

    public User toUser(Subject subject, UserManager um) {
        return this.toUser(this.toBasicUser(subject), um);
    }

    public Subject toSubject(BasicUser user) {
        if (null == user) {
            return null;
        }
        if (user instanceof JAZNUserAdaptor) {
            Subject subject = ((JAZNUserAdaptor)user).getSubject();
            if (null != subject) {
                subject = new Subject(false, subject.getPrincipals(), subject.getPublicCredentials(), Collections.EMPTY_SET);
                return subject;
            }
            s_logger.log(Level.FINE, "Subject in JAZNUserAdaptor null");
        }
        BasicUser tempUser = user;
        if (user instanceof BasicUserProxy) {
            tempUser = ((BasicUserProxy)user).getShieldedUser();
        }
        Subject subject = new Subject();
        subject.getPrincipals().add(this.shield(tempUser));
        try {
            Set groups = user.getGroups();
            if (null != groups) {
                Iterator iter = groups.iterator();
                while (iter.hasNext()) {
                    this.addPrincipalToSubject(subject, (Principal)iter.next());
                }
            }
        }
        catch (Exception e) {
            s_logger.log(Level.INFO, "caught exception in user.getGroups() - unable to build full Subject for user {0}", tempUser);
        }
        return subject;
    }

    private void addPrincipalToSubject(Subject subject, Principal p) {
        if (!(p instanceof User)) {
            if (p instanceof PrincipalGroup) {
                subject.getPrincipals().add(((PrincipalGroup)p).getPrincipal());
            } else {
                subject.getPrincipals().add(p);
            }
        }
    }

    protected User newUser(Principal delegate) {
        return new PrincipalUser(delegate);
    }

    protected Group newGroup(Principal delegate) {
        return new PrincipalGroup(delegate);
    }

    protected Principal pickUserPrincipal(Subject subject) {
        return SubjectUtil.getAuthenticatedUser((Subject)subject);
    }

    protected BasicUser shield(BasicUser inUser) {
        return SecurityUtil.shield(inUser, false);
    }

    static class PrincipalUser
    extends AbstractUser {
        private Principal m_delegate;

        public PrincipalUser(Principal p) {
            super(p.getName());
            this.m_delegate = p;
        }

        public Principal getPrincipal() {
            return this.m_delegate;
        }

        public String toString() {
            return ((Object)this.m_delegate).toString();
        }

        public boolean equals(Object another) {
            return ((Object)this.m_delegate).equals(another);
        }
    }

    static class PrincipalGroup
    extends AbstractGroup {
        private Principal m_delegate;

        public PrincipalGroup(Principal p) {
            super(p.getName());
            this.m_delegate = p;
        }

        public Principal getPrincipal() {
            return this.m_delegate;
        }

        public String toString() {
            return ((Object)this.m_delegate).toString();
        }

        public boolean equals(Object another) {
            return ((Object)this.m_delegate).equals(another);
        }
    }
}

