/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.Application;
import com.evermind.server.ServerMessageBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.CustomerLogger;
import oracle.j2ee.util.LoggingUtils;

public class ServerMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.runtime", ServerMessageBundle.class.getName());

    static Logger getLogger() {
        return m_logger;
    }

    public static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }

    public static void warningMissingPortsValue() {
        m_logger.log(Level.WARNING, "J2EE OJR-00001");
    }

    public static void warningInvalidPortsValue(String value) {
        m_logger.log(Level.WARNING, "J2EE OJR-00002", value);
    }

    public static void warningDMSInitializeFail(Throwable e) {
        m_logger.log(Level.WARNING, "J2EE OJR-00003", e);
    }

    public static void infoWebSiteError(Throwable e) {
        m_logger.log(Level.FINER, "J2EE OJR-00004", e);
    }

    public static void warningWebAppNotFound(String appName) {
        m_logger.log(Level.WARNING, "J2EE OJR-00005", appName);
    }

    public static void warningUnableWriteWebsite(String fileName) {
        m_logger.log(Level.WARNING, "J2EE OJR-00006", fileName);
    }

    public static void warningWebAppNotFound(String fileName, String appName) {
        m_logger.log(Level.WARNING, "J2EE OJR-00007", new Object[]{fileName, appName});
    }

    public static void warningGlobalTldCacheBuildFailure(String loc, Throwable reason) {
        m_logger.log(Level.WARNING, "J2EE OJR-00008", loc);
        ServerMessages.logException(reason);
    }

    public static void warningApplicationInitializationFailed(String appName, Throwable reason) {
        m_logger.log(Level.WARNING, "J2EE OJR-00013", new Object[]{appName, reason.getMessage()});
        ServerMessages.logException(reason);
    }

    public static void warningServerXAResourceInitFailed(Throwable t) {
        m_logger.log(Level.WARNING, "J2EE OJR-00014", t.getMessage());
    }

    public static void logException(Throwable reason) {
        m_logger.log(Level.FINER, "J2EE OJR-00000", reason);
    }

    public static String getMessageDSCreateCompNameInUse(String component, String name) {
        return LoggingUtils.getMessage(m_logger, "J2EE OJR-00100", component, name);
    }

    public static String severeDSCreateJNDIOccupied(String component, String jndiLocation) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE OJR-00101", new Object[]{component, jndiLocation});
    }

    public static String severeDSCreateNamingException(String component, String exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE OJR-00102", new Object[]{component, exception});
    }

    public static String severeDSCreateConnectorPropertySetException(String exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE OJR-00105", new Object[]{exception});
    }

    public static String warningDSCreateCreateMBeanException(String name, Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE OJR-00103", new Object[]{name, exception});
    }

    public static String warningDSCreateNoConnectionPool(String connectionPoolName) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE OJR-00104", new Object[]{connectionPoolName});
    }

    public static String warningDSCreateConnectionPoolExists(String connectionPoolName) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE OJR-00106", new Object[]{connectionPoolName});
    }

    public static String warningDSCreateConnectionPoolException(String exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE OJR-00107", new Object[]{exception});
    }

    public static String warningDSCopyNonExistentDS(String component, String name) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE OJR-00108", new Object[]{component, name});
    }

    public static String warningDSRenameNonExistentDS(String component, String exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE OJR-00109", new Object[]{component, exception});
    }

    public static String warningDSRenameNameNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE OJR-00110", new Object[0]);
    }

    public static String warningDSRenameNewNameEmpty() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE OJR-00111", new Object[0]);
    }

    public static String warningDSRenameDSExists(String newName) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE OJR-00112", new Object[]{newName});
    }

    public static String warningDSRenameMissingConfig(String name) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE OJR-00113", new Object[]{name});
    }

    public static String warningDSRemoveNonExistentConnectionPool(String name) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE OJR-00114", new Object[]{name});
    }

    public static String warningDSRemoveManagedDataSourcesExist() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE OJR-00115", new Object[0]);
    }

    public static String warningDSRemoveConnectionPoolException(String exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE OJR-00116", new Object[]{exception});
    }

    public static String warningDSRemoveNonExistentDataSource(String component, String name) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE OJR-00117", new Object[]{component, name});
    }

    public static String warningDSRemoveJNDIObjectNotDataSource(String jndiLocation, String className) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE OJR-00118", new Object[]{jndiLocation, className});
    }

    public static String warningDSRemoveNamingException(String name, String jndiLocation, String exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE OJR-00119", new Object[]{name, jndiLocation, exception});
    }

    public static String warningDSCopyConnectionPoolNonExistentPool(String name) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE OJR-00120", new Object[]{name});
    }

    public static String warningDSRemoveConnectionFactoryFromRA(String dsName, String exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE OJR-00121", new Object[]{dsName, exception});
    }

    public static String getUnableToCreateDataSourceMessage(String component) {
        return LoggingUtils.getMessage(m_logger, "J2EE OJR-00122", component);
    }

    public static String getUnableToRemoveDataSourceMessage(String component) {
        return LoggingUtils.getMessage(m_logger, "J2EE OJR-00123", component);
    }

    public static String getUnableToCopyDataSourceMessage(String component) {
        return LoggingUtils.getMessage(m_logger, "J2EE OJR-00124", component);
    }

    public static String getUnableToRenameDataSourceMessage(String component) {
        return LoggingUtils.getMessage(m_logger, "J2EE OJR-00125", component);
    }

    public static String severeDSRegisterMBeanException(String component, String name, String exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE OJR-00126", new Object[]{component, name, exception});
    }

    public static String severeDSUnRegisterMBeanException(String component, String name, String exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE OJR-00127", new Object[]{component, name, exception});
    }

    public static String warningDSUnRegisterMBeanNoConnectionFactory(String name) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE OJR-00128", new Object[]{name});
    }

    public static String warningPersistDataSourceException(String exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE OJR-00129", new Object[]{exception});
    }

    public static String severeHttpStartupException(String exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE OJR-00010", new Object[]{exception});
    }

    public static void severeOc4jServerStartupException() {
        m_logger.log(Level.SEVERE, "J2EE OJR-00009");
    }

    public static void severeJmsServerStartupException(String exception) {
        m_logger.log(Level.SEVERE, "J2EE OJR-00011", exception);
    }

    public static void severeRMIServerStartupException(Exception e) {
        m_logger.log(Level.SEVERE, "J2EE OJR-00012", e);
    }

    public static void infoCheckForUpdatesUsage() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00015");
        }
    }

    public static void warningAppServerConfigUpdateFailed(Exception e) {
        m_logger.log(Level.WARNING, "J2EE OJR-00018", e.getMessage());
        ServerMessages.logException(e);
    }

    public static void infoCheckForUpdatesIASSetting() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00016");
        }
    }

    public static void infoCheckForUpdatesStandaloneSetting() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00017");
        }
    }

    public static void warningDuplicateApplicationError(String appName) {
        m_logger.log(Level.WARNING, "J2EE OJR-00019", appName);
    }

    public static void infoContainerManagerServicesStarting() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00020");
        }
    }

    public static void infoLaunchingContainerService(String name) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00021", name);
        }
    }

    public static void infoContainerManagerServicesStarted() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00022");
        }
    }

    public static void infoJavaCacheStarting() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00023");
        }
    }

    public static void infoJavaCacheStarted() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00024");
        }
    }

    public static void warningJavaCacheNotAvailable(Exception e) {
        m_logger.log(Level.FINE, "J2EE OJR-00025", e.getMessage());
        ServerMessages.logException(e);
    }

    public static void warningJavaCacheStartFailure(Exception e) {
        m_logger.log(Level.FINE, "J2EE OJR-00026", e.getMessage());
        ServerMessages.logException(e);
    }

    public static void infoPreInitServerExtensions(String extensionProvider) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00027", extensionProvider);
        }
    }

    public static void infoPostInitServerExtensions(String extensionProvider) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00028", extensionProvider);
        }
    }

    public static void warningExceptionSettingAutoDeploymentDir(Exception e) {
        m_logger.log(Level.WARNING, "J2EE OJR-00029", e.getMessage());
        ServerMessages.logException(e);
    }

    public static void infoInitLibraryClassLoader(String classLoader) {
        if (ServerMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE OJR-00031", classLoader);
        } else if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00030");
        }
    }

    public static void infoInitLibraryClassLoaderDetail(String classLoader) {
        if (ServerMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINE, "J2EE OJR-00030", classLoader);
        }
    }

    public static void infoInitSharedLibraryLoaders() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00032");
        }
    }

    public static void infoAddingSharedLibrary(String uniqueName) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00033", uniqueName);
        }
    }

    public static void infoJMSServerStarting() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00034");
        }
    }

    public static void infoJMSServerStarted() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00035");
        }
    }

    public static void infoPreDeployStartupClasses(String className) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00039", className);
        }
    }

    public static void infoRMIServerStarting() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00036");
        }
    }

    public static void infoRMIServerStarted() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00037");
        }
    }

    public static void severePreDeployStartupClassesFailure(Exception e) {
        m_logger.log(Level.SEVERE, "J2EE OJR-00040", e.getMessage());
        ServerMessages.logException(e);
    }

    public static void infoAppStarting(String name) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00200", name);
        }
    }

    public static void infoAppStarted(String name) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00201", name);
        }
    }

    public static void infoRegisterSystemMBeans() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00043");
        }
    }

    public static void infoPostDeployStartupClasses(String className) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00041", className);
        }
    }

    public static void severePostDeployStartupClassesFailure(Exception e) {
        m_logger.log(Level.SEVERE, "J2EE OJR-00042", e.getMessage());
        ServerMessages.logException(e);
    }

    public static void infoRMIServerReady() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00038");
        }
    }

    public static void infoHttpServerStarting() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00044");
        }
    }

    public static void infoHttpServerStarted() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00045");
        }
    }

    public static void infoTaskManagerStarted() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00046");
        }
    }

    public static void infoThreadPoolsInitializing() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00047");
        }
    }

    public static void infoThreadPoolInit(String poolName) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00048", poolName);
        }
    }

    public static void infoConnectionPoolSameAsSystemPool() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00049");
        }
    }

    public static void infoDoneInitializingThreadPools() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00050");
        }
    }

    public static void warningReassigningSystemStreams(Exception e) {
        m_logger.log(Level.WARNING, "J2EE OJR-00051", e.getMessage());
        ServerMessages.logException(e);
    }

    public static void warningInitShutdownHandler(Throwable t) {
        m_logger.log(Level.WARNING, "J2EE OJR-00052", t.getMessage());
        ServerMessages.logException(t);
    }

    public static void infoServerStartupTime(String startTime) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00053", startTime);
        }
    }

    public static void infoDestroyingClassLoaders() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00054");
        }
    }

    public static void infoClosedSharedLibraryLoader(String uniqueName) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00055", uniqueName);
        }
    }

    public static void infoClosedLibraryClassLoader(String uniqueName) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00056", uniqueName);
        }
    }

    public static void infoCompleteClassLoaderDestroy() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00057");
        }
    }

    public static void infoTransactionManagerStarting() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00058");
        }
    }

    public static void infoTransactionManagerStarted() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00059");
        }
    }

    public static void infoNoTasksExecuting() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00060");
        }
    }

    public static void infoWaitingForTaskToComplete(String name) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00061", name);
        }
    }

    public static void infoTaskComplete(String name) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00062", name);
        }
    }

    public static void infoStoppingContainerService(String name) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00063", name);
        }
    }

    public static void infoOC4JShutdownStart() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00064");
        }
    }

    public static void infoReceivedTerminate() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00065");
        }
    }

    public static void infoRMIServerStopping() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00066");
        }
    }

    public static void infoRMIServerStartDestroy() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00067");
        }
    }

    public static void infoRMIServerDestroyComplete() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00068");
        }
    }

    public static void infoHttpServerStartDestroy() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00069");
        }
    }

    public static void infoHttpServerDestroyComplete() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00070");
        }
    }

    public static void infoJMSServerStartDestroy() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00071");
        }
    }

    public static void infoJMSServerDestroyComplete() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00072");
        }
    }

    public static void infoTaskManagerStopping() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00073");
        }
    }

    public static void infoTaskManagerStopped() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00074");
        }
    }

    public static void infoContainerServiceStopping() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00075");
        }
    }

    public static void infoContainerServiceStopped() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00076");
        }
    }

    public static void infoPreDestroyServerExtensions(String name) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00077", name);
        }
    }

    public static void infoPostDestroyServerExtensions(String name) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00078", name);
        }
    }

    public static void infoTMShutDown() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00079");
        }
    }

    public static void infoIIOPServerShutdownStart() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00080");
        }
    }

    public static void infoIIOPServerShutdownComplete() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00081");
        }
    }

    public static void infoOC4JShutdownComplete() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00082");
        }
    }

    public static void infoApplicationStopping(String name) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00202", name);
        }
    }

    public static void infoApplicationStopped(String name) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00203", name);
        }
    }

    public static void infoThreadPoolDestroyStart() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00083");
        }
    }

    public static void infoThreadPoolDestroyComplete() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00084");
        }
    }

    public static void infoThreadPoolDestroy(String poolName) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00085", poolName);
        }
    }

    public static void infoShutdownConfiguredClasses(String mClassName) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00086", mClassName);
        }
    }

    public static void infoStartServerInitialization() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00087");
        }
    }

    public static void infoServerInitializationComplete() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00088");
        }
    }

    public static void infoInitializingClassLoader(String uniqueName) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00204", uniqueName);
        }
    }

    public static void warningContextClassLoaderNeedsReset(String currentClassLoader, String classLoader) {
        m_logger.log(Level.WARNING, "J2EE OJR-00215", new Object[]{currentClassLoader, classLoader});
    }

    public static void infoInitializedResourceProviders() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00205");
        }
    }

    public static void infoEJBContainerInitializing() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00207");
        }
    }

    public static void infoLoadingConnectors() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00209");
        }
    }

    public static void infoInitializingDataSources() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00211");
        }
    }

    public static void infoEjbContainerInitialized() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00208");
        }
    }

    public static void infoClassLoaderCommitted(String name, String classLoader) {
        if (ServerMessages.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE OJR-00204", classLoader);
        } else if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00214", name);
        }
    }

    public static void infoInitializingAppClients() {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00213");
        }
    }

    public static void infoInitializingResourceProvider(String name) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00206", name);
        }
    }

    public static void infoInitializingDataSource(String name) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00212", name);
        }
    }

    public static void infoInitializingConnector(String name) {
        if (ServerMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE OJR-00210", name);
        }
    }

    public static void warningAppComponentInFailedState(String appComponent, String appName) {
        m_logger.log(Level.WARNING, "J2EE OJR-00217", new Object[]{appComponent, appName});
    }

    public static void warningUnableToStartApplication(String name, Throwable throwable) {
        m_logger.log(Level.WARNING, "J2EE OJR-00218", name);
        ServerMessages.logException(throwable);
    }

    public static void warningUndefinedUserManagerPreventsMBeanRegistration(Application application) {
        m_logger.log(Level.WARNING, "J2EE OJR-00219", application.getName());
        m_logger.log(Level.WARNING, "J2EE OJR-00220");
    }

    public static void warningWrongUserManagerPreventsMBeanRegistration(Application application) {
        m_logger.log(Level.WARNING, "J2EE OJR-00219", application.getName());
        m_logger.log(Level.WARNING, "J2EE OJR-00221");
    }
}

