/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.io.LastModifiedContainer;
import com.evermind.naming.ContextUtils;
import com.evermind.server.J2EEComponent;
import com.evermind.server.ServerBase;
import com.evermind.server.deployment.EnvironmentEntry;
import com.evermind.xml.XMLConfig;
import com.oracle.naming.J2EEContext;
import java.io.IOException;
import java.net.URL;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.j2ee.ws.server.deployment.oc4j.WebServicesDescriptor;
import oracle.j2ee.ws.server.deployment.oc4j.WebServicesDescriptorHolder;
import oracle.oc4j.util.FileUtils;

public abstract class ServerComponent
extends J2EEComponent
implements WebServicesDescriptorHolder {
    protected WebServicesDescriptor webServicesDescriptor;
    protected XMLConfig parent;

    protected ServerComponent() {
    }

    protected ServerComponent(XMLConfig parent) {
    }

    public WebServicesDescriptor getWebServicesDescriptor() {
        return this.webServicesDescriptor;
    }

    public static void setEnvironmentEntry(ServerComponent serverComponent, String name, Object value, EnvironmentEntry entry, Context context) throws InstantiationException, IOException {
        Object newValue;
        if (entry == null) {
            throw new InstantiationException("No such environment entry: '" + name + "'");
        }
        Object oldValue = entry.getValue();
        entry.setRuntimeValue(value.toString());
        try {
            newValue = entry.getValue();
        }
        catch (InstantiationException e) {
            entry.setRuntimeValue(oldValue.toString());
            throw e;
        }
        try {
            ((J2EEContext)context).backDoorRebind(name, newValue);
        }
        catch (NamingException e) {
            throw new InstantiationException("Naming error: " + e);
        }
        serverComponent.storeDeployment();
    }

    public String isDeployed() throws InstantiationException {
        if (FORCE_REDEPLOYMENT) {
            return "Redeployment forced";
        }
        if (this.alwaysRedeploy) {
            return "Deployment forced by redeployment switch";
        }
        if (this.isArchiveUpdated()) {
            return "Archive was updated";
        }
        if (this.getDeploymentVersion() == null) {
            return "No previous deployment found";
        }
        if (!ServerBase.version.equals(this.getDeploymentVersion())) {
            return "New server version detected";
        }
        try {
            long lastModified;
            if (this.getDeploymentContext() instanceof LastModifiedContainer && (lastModified = ((LastModifiedContainer)((Object)this.getDeploymentContext())).getLastModified(this.getDeploymentDescriptorPath())) > this.deploymentTime) {
                return this.getDeploymentDescriptorPath() + " had been updated since the previous deployment";
            }
            lastModified = ContextUtils.getFileLastModified(this.getDeploymentContext(), this.getDeploymentDescriptorPath());
            if (ContextUtils.getFileLastModified(this.getContext(), this.getAssemblyDescriptorPath()) > lastModified) {
                return this.getAssemblyDescriptorPath() + " had been touched since the previous deployment";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws InstantiationException {
        try {
            URL url = FileUtils.autoUnpack(this.getArchiveURL() == null ? this.getURL() : this.getArchiveURL(), this.autoUnpack, this.logger);
            this.setURL(url);
            this.init();
            if (this.getContext() != null) {
                this.initDeployment();
            }
        }
        finally {
            this.initLastModifieds();
        }
    }
}

