/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.io.IOUtils;
import com.evermind.io.LastModifiedContainer;
import com.evermind.naming.ContextUtils;
import com.evermind.naming.archive.MemoryArchiveContext;
import com.evermind.naming.file.ContentFileContext;
import com.evermind.server.ServerBase;
import com.evermind.util.ByteString;
import com.evermind.util.ConfigUtils;
import com.evermind.util.ServerProperties;
import com.evermind.xml.XMLConfig;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import oracle.j2ee.util.TraceLogger;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class J2EEComponent
extends XMLConfig {
    public static final boolean FORCE_REDEPLOYMENT = ServerProperties.getForceRedeployment();
    private boolean separateDeploymentContext;
    private Context deploymentContext;
    private File deploymentFile;
    private long deploymentFileLastModified;
    private String deploymentVersion;
    protected long deploymentTime;
    protected boolean alwaysRedeploy;
    private String altDD = null;
    private File archiveURLFile;
    private long archiveURLLastModified;
    private long archiveURLTempLastModified;
    protected boolean autoUnpack;
    private URL archiveURL;
    private boolean _readPreviousDeploymentDescriptor = false;
    private byte[] m_deplData;
    private static Logger m_logger = TraceLogger.getLogger(J2EEComponent.class);

    private Context getAssemblyContext() {
        return this.getContext();
    }

    public final Context getDeploymentContext() throws InstantiationException {
        try {
            if (this.deploymentContext == null) {
                if (this.getContext() == null) {
                    return null;
                }
                try {
                    this.deploymentContext = (Context)this.getContext().lookup(this.getDefaultDeploymentSubname());
                }
                catch (NameNotFoundException e) {
                    this.deploymentContext = this.getContext().createSubcontext(this.getDefaultDeploymentSubname());
                }
                catch (ClassCastException e) {
                    throw new NamingException("Deployment directory " + this.getDefaultDeploymentSubname() + " was a file");
                }
            }
            return this.deploymentContext;
        }
        catch (NamingException e) {
            throw new InstantiationException("Error creating deployment directory: " + e.getMessage());
        }
    }

    protected String getDefaultDeploymentSubname() {
        throw new InternalError("Should never get called for " + this);
    }

    protected void parseDeploymentRootNodeValue(String name, String value) throws InstantiationException {
        this.deploymentVersion = ServerBase.version;
        if (name.equals("deployment-time")) {
            try {
                this.deploymentTime = Long.parseLong(value, 16);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (name.equals("deployment-version")) {
            this.deploymentVersion = value;
        } else if (name.equals("always-redeploy")) {
            this.alwaysRedeploy = "true".equalsIgnoreCase(value);
        } else {
            super.parseDeploymentRootNodeValue(name, value);
        }
    }

    public void init() throws InstantiationException {
        if (this.getContext() == null) {
            try {
                this.init(this.getURL());
            }
            catch (IOException e) {
                throw (InstantiationException)new InstantiationException("IO error reading " + this).initCause(e);
            }
            return;
        }
        try {
            ByteString readBytes;
            if (this.getAltDD() != null) {
                byte[] data = IOUtils.getContent(new File(this.getAltDD()));
                readBytes = new ByteString(data, 0, data.length);
            } else {
                readBytes = ContextUtils.readFromContext(this.getContext(), this.getAssemblyDescriptorPath(), false);
            }
            this.init(readBytes.data, readBytes.offset, readBytes.length, false);
        }
        catch (SAXException e) {
            throw (InstantiationException)new InstantiationException("Error parsing " + this.getAssemblyDescriptorPath() + " in " + this.getContext()).initCause(e);
        }
        catch (IOException e) {
            throw (InstantiationException)new InstantiationException("IO Error parsing " + this.getAssemblyDescriptorPath() + " in " + this.getContext()).initCause(e);
        }
    }

    public String initDeployment() throws InstantiationException {
        Object dataObject;
        this.logging("initDeployment(): begin");
        if (this.m_deplData != null) {
            return this.initDeployment(this.m_deplData, 0, this.m_deplData.length);
        }
        Context deploymentContext = this.getDeploymentContext();
        try {
            ByteString string;
            String deploymentDescriptorPath = this.getDeploymentDescriptorPath();
            if (deploymentContext instanceof MemoryArchiveContext && (string = ((MemoryArchiveContext)deploymentContext).lookupString("/" + deploymentDescriptorPath)) != null) {
                String string2 = this.initDeployment(string.data, string.offset, string.length);
                return string2;
            }
            dataObject = deploymentContext.lookup(deploymentDescriptorPath);
            byte[] data = (byte[])dataObject;
            this._readPreviousDeploymentDescriptor = true;
            String string3 = this.initDeployment(data, 0, data.length);
            return string3;
        }
        catch (NameNotFoundException e) {
            dataObject = this.copyAndDeploy(true);
            return dataObject;
        }
        catch (NamingException e) {
            String message = "Unable to find/read deployment info for " + deploymentContext + " (" + e.getMessage() + ")";
            InstantiationException exception = new InstantiationException(message);
            exception.initCause(e);
            throw exception;
        }
        finally {
            this.logging("initDeployment(): end");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String initDeployment(byte[] data, int start, int length) throws InstantiationException {
        String string;
        this.logging("initDeployment(data, 0, " + length + "): begin");
        Context deploymentContext = this.getDeploymentContext();
        try {
            try {
                this.init(data, start, length, true);
                this.logging("initDeployment: returning NULL");
                string = null;
                Object var7_8 = null;
            }
            catch (SAXException e) {
                throw new InstantiationException("Error parsing " + this.getDeploymentDescriptorPath() + " at " + deploymentContext + ": " + e.getMessage());
            }
            catch (IOException e) {
                throw new InstantiationException("Error parsing " + this.getDeploymentDescriptorPath() + " in " + deploymentContext + ": " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.initLastModifieds();
            this.logging("initDeployment(data, 0, " + length + "): end");
            throw throwable;
        }
        this.initLastModifieds();
        this.logging("initDeployment(data, 0, " + length + "): end");
        return string;
    }

    private String copyAndDeploy(boolean bind) throws InstantiationException {
        this.logging("copyAndDeploy(" + bind + "): begin");
        try {
            if (this.isSeparateDeploymentContext() && this.getAssemblyContext() != null) {
                Context assemblyContext = (Context)this.getAssemblyContext().lookup(this.getDefaultDeploymentSubname());
                String deploymentDescriptorPath = this.getDeploymentDescriptorPath();
                this.logging("deploymentDescriptorPath = " + deploymentDescriptorPath);
                Object dataObject = assemblyContext.lookup(deploymentDescriptorPath);
                byte[] data = (byte[])dataObject;
                if (bind) {
                    this.getDeploymentContext().bind(deploymentDescriptorPath, (Object)data);
                }
                String string = this.initDeployment(data, 0, data.length);
                return string;
            }
        }
        catch (NameNotFoundException nnfe) {
            this.logging(Level.FINE, "NameNotFoundException: Unable to find/read deployment info for " + this.getAssemblyContext() + " (" + nnfe.getMessage() + ")");
        }
        catch (NamingException ne) {
            this.logging(Level.FINE, "NamingException: Unable to find/read deployment info for " + this.getAssemblyContext() + " (" + ne.getMessage() + ")");
            String message = "Unable to find/read deployment info for " + this.getAssemblyContext() + " (" + ne.getMessage() + ")";
            InstantiationException exception = new InstantiationException(message);
            exception.initCause(ne);
            throw exception;
        }
        finally {
            this.logging("copyAndDeploy(" + bind + "): end--initDeployment");
        }
        this.logging("copyAndDeploy(" + bind + "): end--Previous deployment not found");
        return "Previous deployment not found";
    }

    protected void parseDeploymentMainNode(Node node) throws InstantiationException {
        if (this.getDeploymentContext() != null) {
            throw new InstantiationException("Unknown deployment tag in " + this.getDeploymentContext() + "/" + this.getDeploymentDescriptorPath() + ": <" + node.getNodeName() + ">");
        }
        super.parseDeploymentMainNode(node);
    }

    protected String getAssemblyDescriptorPath() {
        throw new InternalError("Should never get called for " + this);
    }

    protected long getAssemblyDescriptorLastModified(LastModifiedContainer c) throws IOException {
        if (null != this.getAltDD()) {
            return new File(this.getAltDD()).lastModified();
        }
        return ConfigUtils.getLastModified(c, this.getAssemblyDescriptorPath());
    }

    public String getDeploymentDescriptorPath() {
        throw new InternalError("Should never get called for " + this);
    }

    public void setDeploymentURL(URL deploymentURL) throws InstantiationException, IOException {
        if (!deploymentURL.getProtocol().equals("file")) {
            throw new InstantiationException("deployment-directory attributes must be file URLs");
        }
        File file = new File(deploymentURL.getFile());
        if (!file.exists()) {
            IOUtils.makePath(new File(file.getCanonicalPath() + File.separator + "dummy"));
        }
        this.setDeploymentContext(new ContentFileContext(file, null));
    }

    public void setDeploymentContext(Context deploymentContext) {
        this.deploymentContext = deploymentContext;
        this.separateDeploymentContext = deploymentContext != null;
    }

    public final boolean isSeparateDeploymentContext() {
        return this.separateDeploymentContext;
    }

    protected byte[] getConfigContent() throws IOException {
        ByteArrayOutputStream assemblyDescriptorOut = new ByteArrayOutputStream();
        PrintWriter assemblyDescriptorWriter = new PrintWriter(new OutputStreamWriter((OutputStream)assemblyDescriptorOut, this.getDocumentEncoding()));
        this.writeConfig(assemblyDescriptorWriter);
        assemblyDescriptorWriter.flush();
        return assemblyDescriptorOut.toByteArray();
    }

    protected byte[] getDeploymentContent() throws IOException {
        ByteArrayOutputStream orionDescriptorOut = new ByteArrayOutputStream();
        PrintWriter orionDescriptorWriter = new PrintWriter(new OutputStreamWriter((OutputStream)orionDescriptorOut, this.getDocumentEncoding()));
        this.writeOrionConfig(orionDescriptorWriter);
        orionDescriptorWriter.flush();
        return orionDescriptorOut.toByteArray();
    }

    public void store() throws IOException {
        if (this.getContext() == null) {
            super.store();
            return;
        }
        byte[] assemblyDescriptorData = this.getConfigContent();
        try {
            String assemblyPath = this.getAssemblyDescriptorPath();
            if (assemblyPath.indexOf("/") >= 0) {
                try {
                    this.getContext().createSubcontext(assemblyPath.substring(0, assemblyPath.lastIndexOf(47)));
                }
                catch (NamingException e) {
                    // empty catch block
                }
            }
            this.getContext().rebind(this.getAssemblyDescriptorPath(), (Object)assemblyDescriptorData);
            if (this.getContext() instanceof LastModifiedContainer && (this.deploymentContext == null || this.deploymentContext instanceof LastModifiedContainer)) {
                try {
                    ((LastModifiedContainer)((Object)this.getContext())).setLastModified(this.getAssemblyDescriptorPath(), ConfigUtils.getLastModified((LastModifiedContainer)((Object)this.getDeploymentContext()), this.getDeploymentDescriptorPath()));
                }
                catch (IOException e) {}
            }
        }
        catch (NamingException e) {
            try {
                throw new IOException("Error writing descriptor '" + this.getAssemblyDescriptorPath() + "' at '" + this.getContext().getNameInNamespace() + "': " + e.getMessage());
            }
            catch (NamingException ne) {
                throw new IOException("Error writing descriptor '" + this.getAssemblyDescriptorPath() + "': " + e.getMessage());
            }
        }
        catch (InstantiationException e) {
            throw new IOException("Error reading directory: " + e.getMessage());
        }
        try {
            this.initLastModifieds();
        }
        catch (InstantiationException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void storeDeployment() throws IOException, InstantiationException {
        if (this.getContext() == null) {
            IOUtils.writeContent(this.getURL(), this.getDeploymentContent());
            return;
        }
        byte[] orionDescriptorData = this.getDeploymentContent();
        try {
            this.getDeploymentContext().rebind(this.getDeploymentDescriptorPath(), (Object)orionDescriptorData);
            if (this.getContext() instanceof LastModifiedContainer && (this.deploymentContext == null || this.deploymentContext instanceof LastModifiedContainer)) {
                ((LastModifiedContainer)((Object)this.deploymentContext)).setLastModified(this.getDeploymentDescriptorPath(), this.getAssemblyDescriptorLastModified((LastModifiedContainer)((Object)this.getContext())));
            }
        }
        catch (NamingException e) {
            throw new InstantiationException("Error writing orion-descriptor: " + e.getMessage());
        }
        this.initLastModifieds();
    }

    public void initLastModifieds() throws InstantiationException {
        if (this.getContext() == null) {
            super.initLastModifieds();
            return;
        }
        this.file = ContextUtils.getFile(this.getContext(), this.getAssemblyDescriptorPath(), false);
        if (this.file == null) {
            this.file = ContextUtils.getFile(this.getContext(), false);
        }
        this.deploymentFile = ContextUtils.getFile(this.getDeploymentContext(), this.getDeploymentDescriptorPath(), false);
        this.deploymentFileLastModified = this.deploymentFile != null ? this.deploymentFile.lastModified() : 0L;
        this.lastModified = this.file != null ? this.file.lastModified() : 0L;
        if (this.archiveURLFile != null) {
            this.archiveURLLastModified = this.archiveURLFile.lastModified();
        }
    }

    public String getDeploymentVersion() {
        return this.deploymentVersion;
    }

    public void setArchiveURL(URL url) {
        this.archiveURL = url;
        this.archiveURLFile = new File(url.getFile());
        this.archiveURLLastModified = this.archiveURLFile.lastModified();
    }

    public boolean isUpdated() {
        if (!ServerProperties.getPollFiles()) {
            return false;
        }
        if (this.archiveURLFile != null && this.archiveURLFile.lastModified() != this.archiveURLLastModified) {
            if (this.archiveURLTempLastModified != this.archiveURLFile.lastModified()) {
                this.archiveURLTempLastModified = this.archiveURLFile.lastModified();
            } else {
                return true;
            }
        }
        if (this.file != null && this.file.lastModified() != this.lastModified) {
            return true;
        }
        return this.deploymentFile != null && this.deploymentFile.lastModified() != this.deploymentFileLastModified;
    }

    public URL getDeploymentURL() {
        if (this.deploymentContext != null && this.getContext() != null) {
            try {
                URL url;
                File urlFile = ContextUtils.getFile(this.deploymentContext, false);
                URL uRL = url = urlFile == null ? null : urlFile.toURL();
                if (url != null) {
                    return url;
                }
            }
            catch (IOException e) {}
        } else if (this.getContext() != null) {
            File file = ContextUtils.getFile(this.getContext(), false);
            try {
                if (file != null) {
                    return file.toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.getURL();
    }

    protected abstract void writeOrionConfig(PrintWriter var1) throws IOException;

    public boolean isArchiveUpdated() {
        if (this.archiveURLFile == null) {
            return false;
        }
        return this.archiveURLFile.lastModified() != this.archiveURLLastModified;
    }

    public URL getArchiveURL() {
        return this.archiveURL;
    }

    public void setAltDD(String path) {
        this.altDD = path;
    }

    protected String getAltDD() {
        return this.altDD;
    }

    public boolean readPreviousDeploymentDescriptor() {
        return this._readPreviousDeploymentDescriptor;
    }

    public String getDeploymentCacheName() throws InstantiationException {
        return this.getContext() == this.getDeploymentContext() ? "orion-deployment-cache.jar" : "deployment-cache.jar";
    }

    public void setDeploymentData(String deploymentData) {
        if (deploymentData != null) {
            try {
                this.m_deplData = deploymentData.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsEx) {
                this.m_deplData = deploymentData.getBytes();
            }
        }
    }

    private void logging(Level level, String msg) {
        m_logger.log(level, msg);
    }

    private void logging(String msg) {
        this.logging(Level.FINEST, msg);
    }

    public String getdeploymentDescriptor() {
        try {
            return new String(this.getConfigContent(), this.getDocumentEncoding());
        }
        catch (IOException iox) {
            iox.printStackTrace();
            return null;
        }
    }

    public String getproprietaryDeploymentDescriptor() {
        try {
            return new String(this.getDeploymentContent(), this.getDocumentEncoding());
        }
        catch (UnsupportedEncodingException unsEx) {
            try {
                return new String(this.getDeploymentContent());
            }
            catch (IOException iox) {
                iox.printStackTrace();
                return null;
            }
        }
        catch (IOException iox) {
            iox.printStackTrace();
            return null;
        }
    }
}

