/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.io.IOUtils;
import com.evermind.io.QuietPrintStream;
import com.evermind.server.ApplicationServer;
import com.evermind.server.OC4JServer;
import com.evermind.util.OC4JProperties;
import com.evermind.util.OC4JProperty;
import com.evermind.util.SystemStreamRotater;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import oracle.classloader.ClassLoaderQuery;

public class CommandLineArgs {
    private int verbosity = 3;
    private boolean install = false;
    private boolean secure = false;
    private boolean monitorEventThread = false;
    private String clusterIDString = null;
    private InetAddress defaultHost = null;
    private String ejbSecPropPath;
    private String configParentDir = new File(ClassLoaderQuery.getHomeDirectory(), "config").getAbsolutePath();
    private String configPath = this.configParentDir + File.separator + "server.xml";
    private String specifiedConfigParentDir;
    private String propPath = null;
    private String otherOutPath = null;
    private PrintStream otherOut = null;
    private boolean configurationValid = true;
    private boolean abandonServerStartup = false;
    private StringBuffer errorMessages = new StringBuffer("");

    public String getConfigParentDir() {
        if (this.getSpecifiedConfigParentDir() != null) {
            return this.getSpecifiedConfigParentDir();
        }
        return this.configParentDir;
    }

    public String getSpecifiedConfigParentDir() {
        return this.specifiedConfigParentDir;
    }

    public void setConfigParentDir(String configParentDir) {
        this.configParentDir = configParentDir;
    }

    public String getEjbSecPropPath() {
        return this.ejbSecPropPath;
    }

    public void setEjbSecPropPath(String ejbSecPropPath) {
        this.ejbSecPropPath = ejbSecPropPath;
    }

    public boolean isConfigurationValid() {
        return this.configurationValid;
    }

    public PrintStream getOtherOut() {
        return this.otherOut;
    }

    public void setOtherOut(PrintStream otherOut) {
        this.otherOut = otherOut;
    }

    public String getOtherOutPath() {
        return this.otherOutPath;
    }

    public void setOtherOutPath(String otherOutPath) {
        this.otherOutPath = otherOutPath;
    }

    public String getPropPath() {
        return this.propPath;
    }

    public void setPropPath(String propPath) {
        this.propPath = propPath;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public InetAddress getDefaultHost() {
        return this.defaultHost;
    }

    public void setDefaultHost(InetAddress defaultHost) {
        this.defaultHost = defaultHost;
    }

    public String getClusterIDString() {
        return this.clusterIDString;
    }

    public void setClusterIDString(String clusterIDString) {
        this.clusterIDString = clusterIDString;
    }

    public boolean isMonitorEventThread() {
        return this.monitorEventThread;
    }

    public void setMonitorEventThread(boolean monitorEventThread) {
        this.monitorEventThread = monitorEventThread;
    }

    public boolean isInstall() {
        return this.install;
    }

    public void setInstall(boolean install) {
        this.install = install;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public int getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(int verbosity) {
        this.verbosity = verbosity;
    }

    public void PrintErrorMessages(PrintStream out) {
        out.println(this.errorMessages);
    }

    public CommandLineArgs(String[] args) {
        this.processArgs(args);
    }

    public boolean terminateServer() {
        return !this.isConfigurationValid() || this.abandonServerStartup;
    }

    private void processArgs(String[] args) {
        try {
            System.setProperty("oracle.j2ee.container.name", ApplicationServer.INFO);
            System.setProperty("oracle.j2ee.container.version", ApplicationServer.VERSION);
            for (int i = 0; i < args.length; ++i) {
                OC4JProperty property;
                if (args[i].equals("-helpAll")) {
                    CommandLineArgs.printAllUsage();
                    this.abandonServerStartup = true;
                    continue;
                }
                if (args[i].equals("-?") || args[i].equals("-help")) {
                    CommandLineArgs.printUsage();
                    this.abandonServerStartup = true;
                    continue;
                }
                if (args[i].equals("-install")) {
                    this.install = true;
                    continue;
                }
                if (args[i].equals("-validateXML")) {
                    System.setProperty("xml.validate", "true");
                    continue;
                }
                if (args[i].equals("-rewriteXML")) {
                    System.setProperty("xml.rewrite", "true");
                    continue;
                }
                if (args[i].equals("-secure")) {
                    this.secure = true;
                    continue;
                }
                if (args[i].equals("-version")) {
                    String buildNumber = ApplicationServer.getBuildNumber();
                    System.out.println(ApplicationServer.INFO + (buildNumber == null ? "" : " (build " + buildNumber + ")"));
                    this.abandonServerStartup = true;
                    continue;
                }
                if (args[i].equals("-config")) {
                    i = this.readDashConfigArg(args, i);
                    continue;
                }
                if (args[i].equals("-quiet")) {
                    System.setOut(new QuietPrintStream());
                    continue;
                }
                if (args[i].equals("-monitorResourceThreads")) {
                    this.monitorEventThread = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-defaultHost")) {
                    i = this.readDashDefaultHotsArg(args, i);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-clusterID")) {
                    i = this.readDashClusterId(args, i);
                    continue;
                }
                if (args[i].equals("-verbosity")) {
                    i = this.readDashVerbosityArg(args, i);
                    continue;
                }
                if (args[i].equals("-out")) {
                    i = this.readDashOutArg(i, args);
                    continue;
                }
                if (args[i].equals("-userThreads")) {
                    System.setProperty("oc4j.userThreads", "true");
                    continue;
                }
                if (args[i].equals("-err")) {
                    i = this.readDashErrArg(i, args);
                    continue;
                }
                if (args[i].equals("-p") || args[i].equals("-properties")) {
                    i = this.readDashPropertiesArg(i, args);
                    continue;
                }
                if (args[i].equals("-listProperties")) {
                    Enumeration e = OC4JProperties.getProperties();
                    while (e.hasMoreElements()) {
                        property = (OC4JProperty)e.nextElement();
                        if (property.isInternal() || property.isSystemProperty()) continue;
                        System.out.println(property.getName() + " - " + property.getDescription());
                    }
                    this.abandonServerStartup = true;
                    continue;
                }
                if (args[i].equals("-describeProperty")) {
                    if (args.length > i + 1) {
                        String propertyName = args[i + 1];
                        property = OC4JProperties.getOC4JProperty(propertyName);
                        if (property != null && !property.isInternal() && !property.isSystemProperty()) {
                            property.dumpPropertyInfo();
                        } else {
                            System.out.println("Unknown property: " + propertyName);
                        }
                    } else {
                        this.errorMessages.append("No property name is specified, type java -jar oc4j.jar -help for help");
                    }
                    ++i;
                    this.abandonServerStartup = true;
                    continue;
                }
                this.errorMessages.append("Unknown switch: " + args[i] + ", type java -jar oc4j.jar -help for help");
                this.configurationValid = false;
            }
        }
        catch (IOException e) {
            this.errorMessages.append("IO Error: " + e.getMessage());
            this.configurationValid = false;
        }
        if (this.propPath != null) {
            this.derivePropertiesFile();
        }
    }

    private void derivePropertiesFile() {
        if (this.propPath.equalsIgnoreCase("default")) {
            File configFile = new File(this.configPath);
            if (configFile != null) {
                this.propPath = configFile.getParent() + File.separator + "oc4j.properties";
            } else {
                this.errorMessages.append("Invalid path parameter to oc4j.properties: " + this.configPath);
                this.configurationValid = false;
            }
        }
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(this.propPath));
            System.getProperties().putAll((Map<?, ?>)properties);
        }
        catch (IOException e) {
            this.errorMessages.append("Unable to read properties at " + this.propPath + ", exiting");
            this.configurationValid = false;
        }
    }

    private int readDashPropertiesArg(int i, String[] args) {
        this.propPath = "default";
        if (i != args.length - 1 && !args[i + 1].substring(0, 1).equals("-")) {
            this.setPropPath(args[++i]);
        }
        return i;
    }

    private int readDashErrArg(int i, String[] args) throws IOException {
        if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
            CommandLineArgs.printUsage();
            this.configurationValid = false;
            return i;
        }
        if (this.otherOutPath != null && this.otherOutPath.equals(args[i + 1])) {
            ++i;
            if (SystemStreamRotater.isRotatable) {
                SystemStreamRotater.setShared(true);
            }
        } else {
            String errPath = this.otherOutPath = args[++i];
            if (OC4JServer.getInstanceId() != null) {
                errPath = IOUtils.getInstancePath(this.otherOutPath, OC4JServer.getInstanceId(), true);
            }
            SystemStreamRotater.setErrFile(errPath);
            this.otherOut = SystemStreamRotater.getNewErrPS();
        }
        System.setErr(this.otherOut);
        return i;
    }

    private int readDashOutArg(int i, String[] args) throws IOException {
        if (i + 1 >= args.length || args[i + 1].startsWith("-")) {
            CommandLineArgs.printUsage();
            this.configurationValid = false;
            return i;
        }
        if (this.otherOutPath != null && this.otherOutPath.equals(args[i + 1])) {
            ++i;
            if (SystemStreamRotater.isRotatable) {
                SystemStreamRotater.setShared(true);
            }
        } else {
            String outPath = this.otherOutPath = args[++i];
            if (OC4JServer.getInstanceId() != null) {
                outPath = IOUtils.getInstancePath(this.otherOutPath, OC4JServer.getInstanceId(), true);
            }
            SystemStreamRotater.setOutFile(outPath);
            this.otherOut = SystemStreamRotater.getNewOutPS();
        }
        System.setOut(this.otherOut);
        return i;
    }

    private int readDashVerbosityArg(String[] args, int i) {
        try {
            int temp = Integer.parseInt(args[++i]);
            if (temp < 0 || temp > 10) {
                this.errorMessages.append("-verbosity must have an integer parameter (0 to 10)");
                this.configurationValid = false;
            } else {
                this.verbosity = temp;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.errorMessages.append("-verbosity must have an integer parameter (0 to 10)");
            this.configurationValid = false;
        }
        catch (NumberFormatException e) {
            this.errorMessages.append("Illegal -verbosity argument, must be a number (0 to 10) " + args[i]);
            this.configurationValid = false;
        }
        return i;
    }

    private int readDashClusterId(String[] args, int i) {
        try {
            this.clusterIDString = args[++i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.errorMessages.append("-clusterID must have a cluster ID (number) parameter");
            this.configurationValid = false;
        }
        return i;
    }

    private int readDashDefaultHotsArg(String[] args, int i) throws UnknownHostException {
        try {
            this.defaultHost = InetAddress.getByName(args[++i]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.errorMessages.append("-defaultHost must have a hostname parameter");
            this.configurationValid = false;
        }
        return i;
    }

    private int readDashConfigArg(String[] args, int i) {
        try {
            this.configPath = args[++i];
            File configFile = new File(this.configPath);
            if (!configFile.canRead()) {
                this.errorMessages.append("-config has an invalid path parameter: " + this.configPath);
                this.configurationValid = false;
                return i;
            }
            this.ejbSecPropPath = configFile.getParent();
            this.specifiedConfigParentDir = configFile.getParent();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.errorMessages.append("-config must have a path parameter");
            this.configurationValid = false;
        }
        return i;
    }

    private static void printAllUsage() {
        PrintStream out = System.out;
        StringBuffer sbuf = CommandLineArgs.usage();
        sbuf.append("-ports \"ajp:<port>,rmi:<port>,...\" - specify ports number.\n");
        sbuf.append("-".concat("mcasthost").concat(" - specify multicast host for web state replication.\n"));
        sbuf.append("-".concat("mcastport").concat(" - specify multicast port for web state replication.\n"));
        sbuf.append("-helpAll - print the help message including the hidden switches\n");
        out.println(sbuf.toString());
    }

    private static void printUsage() {
        System.out.println(CommandLineArgs.usage().toString());
    }

    private static StringBuffer usage() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("Usage: java -jar oc4j.jar [switches]\n");
        sbuf.append("-install - installs the server, activates the admin account and rewrites text files to match the OS linefeed etc\n");
        sbuf.append("-quiet - supress standard output\n");
        sbuf.append("-userThreads - enables context lookup support from user-created threads\n");
        sbuf.append("-config [file] - specifies a location to server.xml\n");
        sbuf.append("-validateXML - validates (strictly) the XML files when reading them\n");
        sbuf.append("-rewriteXML - rewrites bad XML files (after prompting) as accurately as possible. Warning, if you have corrupt XML files you may lose data when rewriting if they're badly misformed, use with care\n");
        sbuf.append("-out [file] - redirects standard output stream to the specified file\n");
        sbuf.append("-err [file] - redirects standard error stream to the specified file\n");
        sbuf.append("-monitorResourceThreads - enables backup debugging of thread resources, enable this only if you have problems that seems to relate to threads getting stuck in critical sections of code\n");
        sbuf.append("-version - prints the version and exits\n");
        sbuf.append("-listProperties - prints a list of the properties in oc4j and their descriptions\n");
        sbuf.append("-describeProperty [property name] - prints all known meta data about a property\n");
        sbuf.append("-? -help - prints (this) help message. Uses '-?' if only running on the C shell\n");
        return sbuf;
    }
}

