/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.Application;
import com.evermind.server.deployment.EnterpriseArchive;
import com.oracle.bricks.j2ee.FlowControlPolicy;
import com.oracle.bricks.j2ee.JGroupConfig;
import com.oracle.bricks.j2ee.ReplicationPolicy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.callbackinterfaces.ClusteredApplicationCallBackIf;
import oracle.oc4j.admin.management.shared.PeerNode;

public class ClusteredApplicationConfigProxy
implements ClusteredApplicationCallBackIf {
    protected static final String MULTICAST = "MULTICAST";
    protected static final String PEER = "PEER";
    protected static final String DATABASE = "DATABASE";
    protected static final String PROTOCOL = "PROTOCOL";
    protected static final String IP = "IP";
    protected static final String PORT = "PORT";
    protected static final String BIND_ADDRESS = "BIND_ADDRESS";
    protected static final String START_PORT = "START_PORT";
    protected static final String RANGE = "RANGE";
    protected static final String TIMEOUT = "TIMEOUT";
    protected static final String DATA_SOURCE_NAME = "DATA_SOURCE_NAME";
    protected static final String PEER_LIST = "PEER_LIST";
    protected static final String WRITE_QUOTA = "WRITE_QUOTA";
    protected static final String ALLOW_COLOCATION = "ALLOW_COLOCATION";
    public static final String ENABLED = "ENABLED";
    public static final String MAX_BYTES = "MAX_BYTES";
    public static final String MIN_BYTES = "MIN_BYTES";
    public static final String THRESHOLD = "THRESHOLD";
    private Application application;
    private int state = 1;
    private long startTime;
    private boolean m_useParentConfig = false;

    public ClusteredApplicationConfigProxy(Application application) {
        this.application = application;
    }

    public String getApplicationName() {
        return this.application.getName();
    }

    public String getGroupName() {
        JGroupConfig aConfig = this.getJGroupConfig();
        if (aConfig == null) {
            return null;
        }
        return aConfig.getGroupName();
    }

    public boolean isHttpApplication() {
        try {
            return this.application.getHttpApplicationConfig(this.getApplicationName()) != null;
        }
        catch (InstantiationException instantiationException) {
            return false;
        }
    }

    public boolean isClustered() {
        JGroupConfig aConfig = this.getJGroupConfig();
        if (aConfig == null) {
            return false;
        }
        return aConfig.isEnabled();
    }

    public void setClustered(boolean flag) {
        if (this.validate()) {
            JGroupConfig aConfig = this.getJGroupConfig();
            if (aConfig == null) {
                aConfig = this.createNewConfig();
                this.updateConfig(aConfig);
            }
            aConfig.setEnabled(flag);
        }
    }

    public boolean isClusterTagAvailable() {
        return ((EnterpriseArchive)this.application.getConfig()).isClusterConfigured();
    }

    public boolean useParentClusterConfig() {
        return ((EnterpriseArchive)this.application.getConfig()).usingParentClusterConfig() || this.m_useParentConfig;
    }

    public void setUseParentClusterConfig(boolean useParent) {
        if (useParent) {
            this.m_useParentConfig = true;
        } else {
            this.updateConfig(this.createNewConfig());
        }
    }

    private void updateConfig(JGroupConfig config) {
        ((EnterpriseArchive)this.application.getConfig()).setClusterConfig(config);
    }

    public String getProtocol() {
        JGroupConfig aConfig = this.getJGroupConfig();
        if (aConfig == null) {
            return null;
        }
        return aConfig.getProtocol();
    }

    public void setProtocol(String protocol) {
        if (this.validate()) {
            JGroupConfig aConfig = this.getJGroupConfig();
            aConfig.setProtocol(protocol);
        }
    }

    public HashMap getProtocolSettings() {
        JGroupConfig aConfig = this.getJGroupConfig();
        if (aConfig == null) {
            return null;
        }
        String aProtocol = aConfig.getProtocol();
        if (aProtocol.equalsIgnoreCase(MULTICAST)) {
            return this.getMulticastSettings();
        }
        if (aProtocol.equalsIgnoreCase(PEER)) {
            return this.getPeerSettings();
        }
        if (aProtocol.equalsIgnoreCase(DATABASE)) {
            return this.getDatabaseSettings();
        }
        return null;
    }

    public void setProtocolSettings(HashMap settings) {
        if (this.validate()) {
            JGroupConfig aConfig = this.getJGroupConfig();
            if (settings.get(PROTOCOL) != null) {
                String aProtocol = (String)settings.get(PROTOCOL);
                aConfig.setProtocol(aProtocol);
                if (aProtocol.equalsIgnoreCase(MULTICAST)) {
                    this.setMulticastSettings(settings);
                } else if (aProtocol.equalsIgnoreCase(PEER)) {
                    this.setPeerSettings(settings);
                } else if (aProtocol.equalsIgnoreCase(DATABASE)) {
                    this.setDatabaseSettings(settings);
                }
            }
        }
    }

    private HashMap getMulticastSettings() {
        JGroupConfig aConfig = this.getJGroupConfig();
        if (aConfig == null) {
            return null;
        }
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(PROTOCOL, MULTICAST);
        settings.put(IP, aConfig.getMulticastAddress());
        settings.put(PORT, aConfig.getMulticastPort());
        settings.put(BIND_ADDRESS, aConfig.getBindAddress());
        settings.put(WRITE_QUOTA, Integer.toString(aConfig.getWriteQuota()));
        settings.put(ALLOW_COLOCATION, Boolean.toString(aConfig.allowColocation()));
        return settings;
    }

    private void setMulticastSettings(HashMap settings) {
        if (this.validate()) {
            JGroupConfig aConfig = this.getJGroupConfig();
            if (settings.get(IP) != null) {
                String multiCastAddress = (String)settings.get(IP);
                aConfig.setMulticastAddress(multiCastAddress);
            }
            if (settings.get(PORT) != null) {
                String multiCastPort = (String)settings.get(PORT);
                aConfig.setMultiCastPort(multiCastPort);
            }
            if (settings.get(BIND_ADDRESS) != null) {
                String bindAddress = (String)settings.get(BIND_ADDRESS);
                aConfig.setBindAddress(bindAddress);
            }
            if (settings.get(WRITE_QUOTA) != null) {
                String writeQuota = (String)settings.get(WRITE_QUOTA);
                aConfig.setWriteQuota(writeQuota);
            }
            if (settings.get(ALLOW_COLOCATION) != null) {
                String allowColocation = (String)settings.get(ALLOW_COLOCATION);
                aConfig.setAllowColocation(Boolean.valueOf(allowColocation));
            }
        }
    }

    private HashMap getPeerSettings() {
        JGroupConfig aConfig = this.getJGroupConfig();
        if (aConfig == null) {
            return null;
        }
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put(PROTOCOL, PEER);
        settings.put(BIND_ADDRESS, aConfig.getBindAddress());
        settings.put(START_PORT, aConfig.getTCPStartPort());
        settings.put(RANGE, aConfig.getTCPRange());
        settings.put(TIMEOUT, aConfig.getTCPTimeout());
        settings.put(WRITE_QUOTA, Integer.toString(aConfig.getWriteQuota()));
        settings.put(ALLOW_COLOCATION, Boolean.toString(aConfig.allowColocation()));
        if (settings.get(PEER_LIST) == null) {
            ArrayList peerList = aConfig.getPeerList();
            ArrayList<PeerNode> aNewList = new ArrayList<PeerNode>(peerList.size());
            for (int i = 0; i < peerList.size(); ++i) {
                String aString = (String)peerList.get(i);
                int beginIndex = aString.indexOf("[");
                int endIndex = aString.indexOf("]");
                PeerNode aPeerNode = new PeerNode(aString.substring(0, beginIndex), aString.substring(beginIndex, endIndex));
                aNewList.add(aPeerNode);
            }
            settings.put(PEER_LIST, aNewList);
        }
        return settings;
    }

    private void setPeerSettings(HashMap settings) {
        if (this.validate()) {
            JGroupConfig aConfig = this.getJGroupConfig();
            if (settings.get(BIND_ADDRESS) != null) {
                String bindAddress = (String)settings.get(BIND_ADDRESS);
                aConfig.setBindAddress(bindAddress);
            }
            if (settings.get(START_PORT) != null) {
                String startPort = (String)settings.get(START_PORT);
                aConfig.setTCPStartPort(startPort);
            }
            if (settings.get(RANGE) != null) {
                String aRange = (String)settings.get(RANGE);
                aConfig.setTCPRange(aRange);
            }
            if (settings.get(TIMEOUT) != null) {
                String aTimeout = (String)settings.get(TIMEOUT);
                aConfig.setTCPTimeout(aTimeout);
            }
            if (settings.get(WRITE_QUOTA) != null) {
                String writeQuota = (String)settings.get(WRITE_QUOTA);
                aConfig.setWriteQuota(writeQuota);
            }
            if (settings.get(ALLOW_COLOCATION) != null) {
                String allowColocation = (String)settings.get(ALLOW_COLOCATION);
                aConfig.setAllowColocation(Boolean.valueOf(allowColocation));
            }
            if (settings.get(PEER_LIST) != null) {
                Collection peerList = (Collection)settings.get(PEER_LIST);
                if (peerList == null || peerList.isEmpty()) {
                    return;
                }
                aConfig.setPeerList(new ArrayList(peerList.size()));
                Iterator anIterator = peerList.iterator();
                while (anIterator.hasNext()) {
                    PeerNode aPeerNode = (PeerNode)anIterator.next();
                    aConfig.addPeerList(aPeerNode.getHost(), aPeerNode.getPort());
                }
            }
        }
    }

    private HashMap getDatabaseSettings() {
        JGroupConfig aConfig = this.getJGroupConfig();
        if (aConfig == null) {
            return null;
        }
        HashMap<String, String> settings = new HashMap<String, String>(2);
        settings.put(PROTOCOL, DATABASE);
        settings.put(DATA_SOURCE_NAME, aConfig.getDataSourceName());
        return settings;
    }

    private void setDatabaseSettings(HashMap settings) {
        if (this.validate()) {
            JGroupConfig aConfig = this.getJGroupConfig();
            if (settings.get(DATA_SOURCE_NAME) != null) {
                String dataSourceName = (String)settings.get(DATA_SOURCE_NAME);
                aConfig.setDataSourceName(dataSourceName);
            }
        }
    }

    public String getReplicationPolicyTrigger() {
        JGroupConfig aConfig = this.getJGroupConfig();
        if (aConfig == null) {
            return null;
        }
        return aConfig.getReplicationPolicy().getReplicationTriggerName();
    }

    public String getReplicationPolicyScope() {
        JGroupConfig aConfig = this.getJGroupConfig();
        if (aConfig == null) {
            return null;
        }
        return aConfig.getReplicationPolicy().getReplicationScopeName();
    }

    public void setReplicationPolicy(String triggerName, String scopeName) {
        if (this.validate()) {
            JGroupConfig aConfig = this.getJGroupConfig();
            aConfig.getReplicationPolicy();
            int aTriggerPolicy = ReplicationPolicy.convertReplicationTrigger(triggerName);
            aConfig.getReplicationPolicy();
            int aScopePolicy = ReplicationPolicy.convertReplicationScope(scopeName);
            aConfig.getReplicationPolicy().setReplicationTrigger(aTriggerPolicy);
            aConfig.getReplicationPolicy().setReplicationScope(aScopePolicy);
        }
    }

    public void applyChanges() {
        if (this.m_useParentConfig) {
            this.application.resetSessionManager();
            this.updateConfig(null);
            this.m_useParentConfig = false;
        }
        this.restart();
    }

    public void setSynchronousReplication(String timeout) {
        if (this.validate()) {
            JGroupConfig aConfig = this.getJGroupConfig();
            aConfig.setAckTimeout(timeout);
        }
    }

    public boolean isSynchronousReplicationEnabled() {
        JGroupConfig aConfig = this.getJGroupConfig();
        if (aConfig == null) {
            return false;
        }
        return aConfig.hasAckTimeout();
    }

    public String getSynchronousReplicationTimeout() {
        JGroupConfig aConfig = this.getJGroupConfig();
        if (aConfig == null) {
            return Long.toString(-1L);
        }
        return Long.toString(aConfig.getAckTimeout());
    }

    public HashMap getFlowControlPolicy() {
        JGroupConfig aConfig = this.getJGroupConfig();
        if (aConfig == null || aConfig.getFlowControlPolicy() == null) {
            return null;
        }
        HashMap<String, String> settings = new HashMap<String, String>();
        FlowControlPolicy fcPolicy = aConfig.getFlowControlPolicy();
        settings.put(ENABLED, Boolean.toString(fcPolicy.isEnabled()));
        settings.put(MAX_BYTES, Long.toString(fcPolicy.getMaxCredits()));
        if (fcPolicy.isMinCreditsDefined()) {
            settings.put(MIN_BYTES, Long.toString(fcPolicy.getMinCredits()));
        } else {
            settings.put(THRESHOLD, Double.toString(fcPolicy.getThreshold()));
        }
        return settings;
    }

    private JGroupConfig getJGroupConfig() {
        JGroupConfig aConfig = this.application.getConfig().getClusterConfig();
        return aConfig;
    }

    public void setFlowControlPolicy(HashMap settings) {
        if (this.validate()) {
            JGroupConfig aConfig = this.getJGroupConfig();
            FlowControlPolicy fcPolicy = aConfig.getFlowControlPolicy();
            if (fcPolicy == null) {
                fcPolicy = new FlowControlPolicy();
            }
            if (settings.get(ENABLED) != null) {
                String enabled = (String)settings.get(ENABLED);
                fcPolicy.enable(Boolean.valueOf(enabled));
            }
            if (settings.get(MAX_BYTES) != null) {
                String maxBytes = (String)settings.get(MAX_BYTES);
                fcPolicy.setMaxCredits(Long.parseLong(maxBytes));
            }
            if (settings.get(THRESHOLD) != null) {
                String threshold = (String)settings.get(THRESHOLD);
                fcPolicy.setThreshold(Double.parseDouble(threshold));
            }
            if (settings.get(MIN_BYTES) != null) {
                String minBytes = (String)settings.get(MIN_BYTES);
                fcPolicy.setMinCredits(Long.parseLong(minBytes));
            }
            aConfig.setFlowControlPolicy(fcPolicy);
        }
    }

    public boolean isFlowControlEnabled() {
        JGroupConfig aConfig = this.getJGroupConfig();
        if (aConfig == null) {
            return false;
        }
        return aConfig.hasFlowControl();
    }

    public void storeClusterConfig() {
        try {
            ((EnterpriseArchive)this.application.getConfig()).storeDeployment();
        }
        catch (IOException e) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }

    private boolean validate() {
        EnterpriseArchive anEar = (EnterpriseArchive)this.application.getConfig();
        JGroupConfig aConfig = null;
        aConfig = this.getJGroupConfig();
        if (aConfig == null || anEar.usingParentClusterConfig()) {
            throw new RuntimeException("OC4J requires <cluster/> setting, please ensure the application is not set to use Parent Cluster Config.  Modifying parent cluster config requires modification from the parent Application mBean");
        }
        return true;
    }

    private JGroupConfig createNewConfig() {
        JGroupConfig aConfig = new JGroupConfig(null);
        if (this.application != null) {
            aConfig.setApplicationConfig(this.application.getConfig());
        }
        return aConfig;
    }

    protected void restart() {
        if (this.application.getstate() == 1) {
            this.application.restart();
        }
    }

    public final void start() {
        try {
            this.state = 0;
            this.startTime = System.currentTimeMillis();
            this.state = 1;
        }
        catch (Exception e) {
            this.state = 4;
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public final void stop() {
        try {
            this.state = 2;
            this.destroy();
            this.state = 3;
        }
        catch (Exception e) {
            this.state = 4;
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public final void stop(Map params) {
        this.stop();
    }

    public final void startRecursive() {
        this.start();
    }

    public final long getstartTime() {
        return this.startTime;
    }

    public final int getstate() {
        return this.state;
    }

    private final void destroy() {
        this.application = null;
    }
}

