/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.AbstractEJBObject;
import com.evermind.server.ejb.DataSourceConnection;
import com.evermind.server.ejb.DataSourceConnectionContainer;
import com.evermind.server.ejb.EntityEJBObject;
import com.evermind.server.ejb.EvermindEntityContext;
import com.evermind.server.ejb.StatefulSessionEJBObject;
import com.evermind.server.ejb.cache.CacheManagerException;
import com.evermind.server.ejb.cache.EntityCacheManager;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.logging.EJBTransactionMessages;
import com.evermind.util.DBProperties;
import com.evermind.util.ServerProperties;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJBException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import oracle.as.j2ee.transaction.TransactionState;
import oracle.oc4j.rmi.OracleRemoteException;

public class ApplicationServerTransactionSynchronization
implements Synchronization {
    public static final int INITIAL_AMOUNT = ServerProperties.getInitialBeanSize();
    private static EntityCacheManager m_cacheManagerInstance = EntityCacheManager.instance();
    private ApplicationServerTransaction transaction;
    private Object[] connections;
    private int connectionsLength;
    private int beanCount;
    private AbstractEJBObject[] beans;
    private List createdEntities;
    protected ThreadState threadState;
    private boolean sessionBeforeCompletionCalled;
    public static final int TX_DEFAULT = 0;
    public static final int TX_REQUIRED = 1;
    public static final int TX_NOT_SUPPORTED = 2;
    public static final int TX_MANDATORY = 3;
    public static final int TX_SUPPORTS = 4;
    public static final int TX_NEVER = 5;
    public static final int TX_REQUIRES_NEW = 6;
    EntityCacheManager _sharedCache = EntityCacheManager.instance();

    ApplicationServerTransactionSynchronization() {
        this.threadState = ThreadState.getCurrentState();
    }

    void handleResume() {
        if (this instanceof ApplicationServerTransaction) {
            int i;
            ApplicationServerTransaction transaction = (ApplicationServerTransaction)this;
            for (i = 0; i < this.beanCount; ++i) {
                this.beans[i].transaction = transaction;
            }
            if (this.createdEntities != null) {
                for (i = 0; i < this.createdEntities.size(); ++i) {
                    ((EntityEJBObject)this.createdEntities.get((int)i)).transaction = transaction;
                }
            }
        }
    }

    void setTransaction(ApplicationServerTransaction transaction) {
        this.transaction = transaction;
        try {
            transaction.registerSynchronization(this);
        }
        catch (RollbackException e) {
            System.err.println("Unable to register EJB synchronization object: " + (Object)((Object)e));
            try {
                transaction.setRollbackOnly();
            }
            catch (SystemException e1) {}
        }
        catch (SystemException e) {
            System.err.println("Unable to register EJB synchronization object: " + (Object)((Object)e));
            try {
                transaction.setRollbackOnly();
            }
            catch (SystemException systemException) {
                // empty catch block
            }
        }
    }

    private void addToArrayListNoDup(ArrayList _al, Object _o) {
        for (int i = 0; i < _al.size(); ++i) {
            if (_al.get(i) != _o) continue;
            return;
        }
        _al.add(_o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void freeEjbResources() {
        if (this.connectionsLength == 0 && this.beanCount == 0) {
            return;
        }
        this.debug("freeResources(): begin");
        try {
            try {
                int i;
                if (this.connectionsLength > 0) {
                    boolean rollback = this.transaction.getStatus() == 4;
                    for (i = 0; i < this.connectionsLength; ++i) {
                        try {
                            ((DataSourceConnection)this.connections[i * 2 + 1]).close(rollback);
                            continue;
                        }
                        catch (Throwable t) {
                            this.log("Error freeing connection after TX", t);
                        }
                    }
                }
                if (this.beanCount > 0) {
                    ArrayList wrappers = new ArrayList();
                    for (i = 0; i < this.beanCount; ++i) {
                        try {
                            EvermindEntityContext ctx;
                            if (this.beans[i] == null) continue;
                            this.addToArrayListNoDup(wrappers, this.beans[i]);
                            if (DBProperties.getJDBCDebug() && this.transaction.getStatus() != 3 && this.transaction.getStatus() != 4) {
                                String thrInfo = Integer.toString(ThreadState.getCurrentState().id);
                                String ss = "THR(" + thrInfo + ") currentMillTime(" + System.currentTimeMillis() + ") conn(NA) bean_tx_info ";
                                System.out.println(ss);
                            }
                            if (!(this.beans[i] instanceof EntityEJBObject) || (ctx = ((EntityEJBObject)this.beans[i]).context) == null) continue;
                            ctx.setBMPStored(false);
                            int wrapListSize = ctx.wrapList.size();
                            for (int j = 0; j < wrapListSize; ++j) {
                                this.addToArrayListNoDup(wrappers, ctx.wrapList.get(j));
                            }
                            ctx.wrapList.clear();
                            ctx.canBeReleased = true;
                            continue;
                        }
                        catch (Throwable t) {
                            this.addException(t);
                            this.beans[i].getEJBHome_X().OC4J_log("Error while delisting bean from TX", t);
                        }
                    }
                    this.endTransaction(wrappers);
                }
                Object var7_11 = null;
                this.connectionsLength = 0;
                this.beanCount = 0;
                this.debug("freeResources(): end");
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                this.connectionsLength = 0;
                this.beanCount = 0;
                this.debug("freeResources(): end");
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private synchronized void endTransaction(ArrayList wrappers) {
        AbstractEJBObject wrapper = null;
        try {
            for (int i = 0; i < wrappers.size(); ++i) {
                wrapper = (AbstractEJBObject)wrappers.get(i);
                wrapper.endTransaction(this.threadState, this.transaction.getStatus() == 3);
            }
        }
        catch (Throwable t) {
            this.addException(t);
            wrapper.getEJBHome_X().OC4J_log("Error while delisting bean from TX", t);
        }
    }

    public synchronized void removeBean(AbstractEJBObject bean) {
        for (int i = 0; i < this.beanCount; ++i) {
            if (this.beans[i] != bean) continue;
            bean.setBeanremoved(true);
            this.beans[i].transaction = null;
            this.beans[i] = this.beans[--this.beanCount];
            this.beans[this.beanCount] = null;
            return;
        }
    }

    public synchronized AbstractEJBObject getCachedEntityObject(String classNmX, Object pk) {
        for (int i = 0; i < this.beanCount; ++i) {
            try {
                AbstractEJBObject bean = this.beans[i];
                if (bean.beanType != 1 && bean.beanType != 4 || !pk.equals(bean.getPrimaryKey_X()) || !classNmX.equals(bean.classNmX)) continue;
                if (bean.OC4J_isCachingOff()) {
                    return null;
                }
                try {
                    bean.transaction = (ApplicationServerTransaction)this;
                }
                catch (Exception e) {
                    System.out.println("the following SHOULD NOT happen");
                    e.printStackTrace(System.out);
                }
                return bean;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public EvermindEntityContext getCachedContextInstance(AbstractEJBHome home, Object pk) throws RemoteException {
        for (int i = 0; i < this.beanCount; ++i) {
            AbstractEJBObject bean = this.beans[i];
            try {
                if (bean.beanType != 1 && bean.beanType != 4 || !home.OC4J_getAppName().equals(bean.getAppName()) || !home.OC4J_getEjbJarName().equals(bean.OC4J_getEjbJarName()) || !home.getBeanName().equals(bean.OC4J_getBeanName()) || !pk.equals(bean.getPrimaryKey_X())) continue;
                return ((EntityEJBObject)bean).context;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return null;
    }

    protected void checkStatus() throws RollbackException {
        if (this.transaction.getTransactionState() != 0 && this.transaction.getTransactionState() != 6) {
            if (this.transaction.getTransactionState() == 2) {
                return;
            }
            if (this.transaction.getRollbackMessage() != null) {
                throw new IllegalStateException("Transaction expired: " + this.transaction.getRollbackMessage());
            }
            throw new IllegalStateException("Transaction expired (" + TransactionState.toString(this.transaction.getTransactionState()) + ")");
        }
    }

    public synchronized void unregisterEntityBean(EntityEJBObject _bean) {
        int i;
        if (this.createdEntities != null) {
            for (i = 0; i < this.createdEntities.size(); ++i) {
                if (_bean != this.createdEntities.get(i)) continue;
                this.createdEntities.remove(i);
                break;
            }
        }
        if (this.beans != null) {
            for (i = 0; i < this.beanCount; ++i) {
                if (this.beans[i] != _bean) continue;
                ((EntityEJBObject)this.beans[i]).setBeanUnRegistered(true);
                this.beans[i].transaction = null;
                if (i != this.beanCount - 1) {
                    this.beans[i] = this.beans[this.beanCount - 1];
                }
                --this.beanCount;
            }
        }
    }

    public synchronized boolean registerBeanUnchecked(AbstractEJBObject bean) {
        try {
            return this.registerBean(bean);
        }
        catch (RollbackException e) {
            return false;
        }
    }

    public synchronized boolean registerBean(AbstractEJBObject bean) throws RollbackException {
        return this.registerBean_X(bean, true);
    }

    public synchronized boolean registerBean(AbstractEJBObject bean, boolean checkDuplicate) throws RollbackException {
        return this.registerBean_X(bean, checkDuplicate);
    }

    public synchronized boolean registerBean_X(AbstractEJBObject bean, boolean checkDuplicate) throws RollbackException {
        try {
            this.debug("registerBean_X(bean, checkDuplicate): begin");
            this.checkStatus();
            if (this.beans == null) {
                this.beans = new AbstractEJBObject[INITIAL_AMOUNT];
            }
            if (bean == null) {
                throw new NullPointerException("Bean instance was null");
            }
            if (checkDuplicate) {
                for (int i = 0; i < this.beanCount; ++i) {
                    if (this.beans[i] != bean) continue;
                    return false;
                }
            }
            this.debug("registered bean ", bean);
            if (bean instanceof StatefulSessionEJBObject) {
                try {
                    ((StatefulSessionEJBObject)bean).afterBegin();
                }
                catch (Throwable t) {
                    System.out.println("error in trying to execute after begin");
                    t.printStackTrace();
                    this.addException(t);
                    bean.getEJBHome_X().OC4J_log(t);
                    try {
                        this.transaction.setRollbackOnly();
                    }
                    catch (SystemException e) {
                        this.addException(e);
                    }
                    bean.transaction = null;
                    return false;
                }
            }
            if (this.beanCount >= this.beans.length) {
                AbstractEJBObject[] oldBeans = this.beans;
                this.beans = new AbstractEJBObject[oldBeans.length * 2];
                System.arraycopy(oldBeans, 0, this.beans, 0, oldBeans.length);
            }
            this.beans[this.beanCount++] = bean;
            bean.transaction = this.transaction;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.debug("registerBean_X(bean, checkDuplicate): end");
        return true;
    }

    public void addCreatedEntity(EntityEJBObject wrapper) throws RollbackException {
        this.checkStatus();
        this.debug("add created entity ", wrapper);
        if (this.createdEntities == null) {
            this.createdEntities = new ArrayList();
        }
        this.createdEntities.add(wrapper);
        wrapper.transaction = (ApplicationServerTransaction)this;
        this.registerBean(wrapper);
    }

    public synchronized DataSourceConnection getConnection(DataSourceConnectionContainer container) throws RemoteException {
        try {
            return this.getLocalConnection(container);
        }
        catch (EJBException e) {
            OracleRemoteException re = new OracleRemoteException(e.getMessage(), e.getCausedByException());
            throw re;
        }
    }

    public synchronized DataSourceConnection getLocalConnection(DataSourceConnectionContainer container) {
        DataSourceConnection connection;
        this.debug("getLocalConnection(container): begin--container = " + container);
        try {
            this.checkStatus();
        }
        catch (RollbackException e) {
            EJBException re = new EJBException("Transaction was rolled back: " + e.getMessage(), (Exception)((Object)e));
            throw re;
        }
        if (this.connections != null) {
            for (int i = 0; i < this.connectionsLength; ++i) {
                if (this.connections[i * 2] != container) continue;
                return (DataSourceConnection)this.connections[i * 2 + 1];
            }
        }
        this.debug("db connection to ", container);
        try {
            connection = new DataSourceConnection(container, (ApplicationServerTransaction)this);
        }
        catch (SQLException e) {
            this.log("Error allocating db connection", e);
            EJBException re = new EJBException("Error allocating db connection: " + e, (Exception)e);
            throw re;
        }
        try {
            connection.flushStatements();
            connection.setIsolationModeIfAny();
        }
        catch (SQLException e) {
            EJBException re = new EJBException("Error enlisting connection resource, SQLException : " + e, (Exception)e);
            throw re;
        }
        if (this.connections == null) {
            this.connections = new Object[4];
        }
        if (2 * this.connectionsLength >= this.connections.length) {
            Object[] newCache = new Object[this.connections.length * 2];
            System.arraycopy(this.connections, 0, newCache, 0, this.connections.length);
            this.connections = newCache;
        }
        this.connections[this.connectionsLength * 2] = container;
        this.connections[this.connectionsLength * 2 + 1] = connection;
        ++this.connectionsLength;
        this.debug("getLocalConnection(container): end");
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareComponentsSuccess() {
        this.debug("prepareComponentsSuccess(): begin");
        try {
            if (this.beans != null) {
                for (int i = 0; i < this.beanCount; ++i) {
                    if (!(this.beans[i] instanceof StatefulSessionEJBObject)) continue;
                    try {
                        ((StatefulSessionEJBObject)this.beans[i]).beforeCompletion();
                        continue;
                    }
                    catch (Throwable t) {
                        this.addException(t);
                        this.beans[i].getEJBHome_X().OC4J_log(t);
                        try {
                            this.transaction.setRollbackOnly();
                            continue;
                        }
                        catch (SystemException e) {
                            this.addException(e);
                        }
                    }
                }
            }
            if (this.transaction.getStatus() == 1) {
                return;
            }
            boolean errorOccurred = false;
            if (this.beans != null) {
                for (int i = 0; i < this.beanCount; ++i) {
                    try {
                        EntityEJBObject aBean;
                        if (!(this.beans[i] instanceof EntityEJBObject) || this.beans[i].OC4J_isCachingOff() || ((EntityBeanDescriptor)(aBean = (EntityEJBObject)this.beans[i]).getBeanDescriptor()).isReadOnlyBMP() || !aBean.getDelayUpdatesUntilCommit()) continue;
                        if (((EntityBeanDescriptor)aBean.getBeanDescriptor()).isBMP() && aBean.context != null) {
                            if (aBean.context.isBMPStored()) continue;
                            aBean.prepare((ApplicationServerTransaction)this);
                            aBean.context.setBMPStored(true);
                            continue;
                        }
                        aBean.prepare((ApplicationServerTransaction)this);
                        continue;
                    }
                    catch (Throwable t) {
                        this.addException(t);
                        try {
                            this.transaction.setRollbackOnly();
                        }
                        catch (SystemException e) {
                            this.addException(e);
                        }
                        this.setRollbackMessage("Error preparing bean instance: " + t);
                        errorOccurred = true;
                    }
                }
            }
            if (errorOccurred) {
                return;
            }
        }
        finally {
            this.flushStatements();
            this.debug("prepareComponentsSuccess(): end");
        }
    }

    public void prepareComponentsRollback() {
        this.debug("prepareComponentsRollback(): begin");
        if (this.createdEntities != null) {
            for (int i = 0; i < this.createdEntities.size(); ++i) {
                EntityEJBObject object = (EntityEJBObject)this.createdEntities.get(i);
                try {
                    object.removeAfterTransaction(this.threadState);
                }
                catch (Throwable t) {
                    this.addException(t);
                    this.log("Error when removing transactionally created entity-bean", t);
                }
                this.debug("removed created entity ", object);
                for (int y = 0; y < this.beanCount; ++y) {
                    if (this.beans[y] != object) continue;
                    this.beans[y] = this.beans[--this.beanCount];
                    this.beans[this.beanCount] = null;
                }
            }
        }
        this.flushStatements();
        this.debug("prepareComponentsRollback(): end");
    }

    protected void callSessionBeforeCompletion() {
        this.debug("callSessionBeforeCompletion(): begin");
        if (!this.sessionBeforeCompletionCalled) {
            this.sessionBeforeCompletionCalled = true;
            for (int i = 0; i < this.beanCount; ++i) {
                if (!(this.beans[i] instanceof StatefulSessionEJBObject)) continue;
                try {
                    ((StatefulSessionEJBObject)this.beans[i]).beforeCompletion();
                    continue;
                }
                catch (Throwable t) {
                    this.addException(t);
                    this.beans[i].getEJBHome_X().OC4J_log(t);
                    try {
                        this.transaction.setRollbackOnly();
                        continue;
                    }
                    catch (SystemException systemException) {
                        // empty catch block
                    }
                }
            }
        }
        this.debug("callSessionBeforeCompletion(): end");
    }

    protected synchronized void flushStatements() {
        if (this.connections != null) {
            for (int i = 0; i < this.connectionsLength; ++i) {
                ((DataSourceConnection)this.connections[i * 2 + 1]).flushStatements();
            }
        }
    }

    void preRollbackNotification() {
        this.prepareComponentsRollback();
    }

    public void beforeCompletion() {
        this.prepareComponentsSuccess();
        m_cacheManagerInstance.beforeCompletion();
    }

    public void afterCompletion(int status) {
        if (m_cacheManagerInstance.isUsed() && status == 3) {
            this.mergeChangesToCache();
        }
        this.freeEjbResources();
    }

    protected void log(String message, Throwable t) {
        ThreadState state = ThreadState.getCurrentState();
        try {
            if (state.contextContainer != null && state.contextContainer.getApplication() != null) {
                state.contextContainer.getApplication().log(message, t);
                return;
            }
        }
        catch (Throwable t2) {
            // empty catch block
        }
        this.logToGlobalServer(message, t);
    }

    protected void logToGlobalServer(String message, Throwable t) {
        ApplicationServer.instance.log(message, t);
    }

    protected void addException(Throwable t) {
    }

    protected void setRollbackMessage(String message) {
    }

    protected void debug(String msg) {
        EJBTransactionMessages.finestSynchronizationMessage(msg);
    }

    protected void debug(String prefix, Object object) {
    }

    public ThreadState getThreadState() {
        return this.threadState;
    }

    public void mergeChangesToCache() {
        EntityEJBObject[] cmpentries = new EntityEJBObject[this.beanCount];
        EntityEJBObject[] bmpentries = new EntityEJBObject[this.beanCount];
        int cmpentriesCount = 0;
        int bmpentriesCount = 0;
        for (int i = 0; i < this.beanCount; ++i) {
            EntityEJBObject b;
            AbstractEJBObject bean = this.beans[i];
            if (bean.beanType != 1 && bean.beanType != 4 || !(b = (EntityEJBObject)bean).OC4J_isCacheable()) continue;
            if (bean.beanType == 1 && !b._isBMP()) {
                cmpentries[cmpentriesCount++] = b;
                continue;
            }
            if (bean.beanType == 4 || b.context.isLazy()) continue;
            bmpentries[bmpentriesCount++] = b;
        }
        if (cmpentriesCount > 0) {
            this._sharedCache.update(cmpentries, cmpentriesCount, false);
        }
        if (bmpentriesCount > 0) {
            this._sharedCache.update(bmpentries, bmpentriesCount, true);
        }
    }

    public void prepareChangesToCache() throws CacheManagerException {
        EntityEJBObject[] cmpentries = new EntityEJBObject[this.beanCount];
        EntityEJBObject[] bmpentries = new EntityEJBObject[this.beanCount];
        int cmpentriesCount = 0;
        int bmpentriesCount = 0;
        for (int i = 0; i < this.beanCount; ++i) {
            EntityEJBObject b;
            AbstractEJBObject bean = this.beans[i];
            if (bean.beanType != 1 && bean.beanType != 4 || !(b = (EntityEJBObject)bean).OC4J_isCacheable()) continue;
            if (bean.beanType == 1 && !b._isBMP()) {
                cmpentries[cmpentriesCount++] = b;
                continue;
            }
            bmpentries[bmpentriesCount++] = b;
        }
        if (cmpentriesCount > 0) {
            this._sharedCache.checkForUpdate(cmpentries, cmpentriesCount, this, false);
        }
        if (bmpentriesCount > 0) {
            this._sharedCache.checkForUpdate(bmpentries, bmpentriesCount, this, true);
        }
    }
}

