/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.ApplicationServerTransactionManager;
import com.evermind.server.ApplicationServerTransactionStats;
import com.evermind.server.InvalidConfigurationException;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationBroadcaster;
import javax.transaction.SystemException;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.TransactionManagerConfiguration;
import oracle.as.j2ee.transaction.tpc.recovery.RecoveryManagerAdmin;
import oracle.oc4j.admin.management.mbeans.JTAResource;

public class ApplicationServerTransactionManagerAdmin {
    private ApplicationServerTransactionManager m_tm;

    public ApplicationServerTransactionManagerAdmin(ApplicationServerTransactionManager tm) {
        this.m_tm = tm;
    }

    public void setJTAResource(JTAResource jtaResource) {
        this.m_tm.setJTAResource(jtaResource);
    }

    public Xid[] getInDoubtXids() {
        return this.m_tm.getInDoubtXids();
    }

    public Xid[] getActiveXids() {
        return this.m_tm.getActiveXids();
    }

    public void adminRollback(Xid xid) throws IllegalStateException {
        this.m_tm.adminSetRollbackOnly(xid);
    }

    public void rollbackTransaction(Xid xid) throws IllegalStateException {
        this.m_tm.adminRollbackTransaction(xid);
    }

    public void heuristicRollback(Xid xid) throws SystemException, IllegalStateException {
        this.m_tm.heuristicRollback(xid);
    }

    public void heuristicCommit(Xid xid) throws SystemException, IllegalStateException {
        this.m_tm.heuristicCommit(xid);
    }

    public Xid[] getHeurCompletedTxsForState(int state) {
        return this.m_tm.getHeurCompletedTxsForState(state);
    }

    public ApplicationServerTransactionStats getStats() {
        return this.m_tm.getStats();
    }

    public RecoveryManagerAdmin getRecoveryManagerAdmin() {
        return this.m_tm.getRecoveryManager().getRecoveryManagerAdmin();
    }

    public void setDefaultTransactionTimeout(int timeout) {
        this.m_tm.setDefaultTransactionTimeout(timeout);
    }

    public void addThresholdEvent(String thresholdStatisticName, int threshold, int repeatNotificationInterval, NotificationBroadcaster notificationBroadcaster) throws InvalidConfigurationException {
        this.m_tm.addThresholdEvent(thresholdStatisticName, threshold, repeatNotificationInterval, notificationBroadcaster);
    }

    public void removeThresholdEvent(String thresholdStatisticName) throws InvalidConfigurationException {
        this.m_tm.removeThresholdEvent(thresholdStatisticName);
    }

    public void setMaxConcurrentTransactions(int maxConcurrentTransactions) {
        this.m_tm.setMaxConcurrentTransactions(maxConcurrentTransactions);
    }

    public int getMaxConcurrentTransactions() {
        return this.m_tm.getMaxConcurrentTransactions();
    }

    public void fireEvent(String type, long sequenceNumber, String message) throws MalformedObjectNameException {
        this.m_tm.fireEvent(type, sequenceNumber, message);
    }

    public ApplicationServerTransaction[] getCopyOfTransactions() {
        return this.m_tm.getCopyOfTransactions();
    }

    public TransactionManagerConfiguration getConfig() {
        return this.m_tm.getConfig();
    }

    public Set getLongDurationInDoubt() {
        return this.m_tm.getLongDurationInDoubt();
    }
}

