/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.reflect;

import com.evermind.bytecode.ClassData;
import com.evermind.bytecode.ClassSerialization;
import com.evermind.bytecode.ConstructorMethodData;
import com.evermind.bytecode.FieldData;
import com.evermind.bytecode.MethodData;
import com.evermind.bytecode.ProxyInitializationCodeAttribute;
import com.evermind.bytecode.ProxyMethodData;
import com.evermind.compiler.CompilationException;
import com.evermind.net.DynamicClassLoader;
import com.evermind.reflect.InterfaceType;
import com.evermind.reflect.InvocationHandler;
import com.evermind.reflect.UndeclaredExceptionTypeException;
import com.evermind.util.ByteString;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.j2ee.util.DynamicClassLoaderAction;

public class Proxy {
    private static final ByteString COM_EVERMIND_REFLECT_PROXY = new ByteString("com/evermind/reflect/Proxy");
    private static final ByteString JAVA_LANG_REFLECT_METHOD = new ByteString("Ljava/lang/reflect/Method;");
    private static final ByteString VOID_SIGNATURE = new ByteString("()V");
    private static final ByteString CLINIT = new ByteString("<clinit>");
    private static final Class[] INVOCATIONHANDLER_ARG = new Class[]{InvocationHandler.class};
    private static final Method[] OBJECT_METHODS = Object.class.getMethods();
    public static final Method JAVA_LANG_OBJECT_HASHCODE = Proxy.getMethod(Object.class, "hashCode", new Class[0]);
    public static final Method JAVA_LANG_OBJECT_EQUALS = Proxy.getMethod(Object.class, "equals", new Class[]{Object.class});
    public static final Method JAVA_LANG_OBJECT_TOSTRING = Proxy.getMethod(Object.class, "toString", new Class[0]);
    protected InvocationHandler handler;
    private static List __currentMethods;
    private static final Object LOCK;
    private static int classID;
    private static Map proxies;
    private static Map loaders;
    static /* synthetic */ Class class$java$rmi$Remote;

    private static Method getMethod(Class type, String name, Class[] args) {
        try {
            return type.getMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public Proxy(InvocationHandler handler) {
        this.handler = handler;
    }

    public static final Method __getCurrentMethod(int i) {
        return (Method)__currentMethods.get(i);
    }

    public static boolean isProxyClass(Class type) {
        return type.isAssignableFrom(Proxy.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object newProxyInstance(ClassLoader parent, Class[] interfaces, InvocationHandler handler) {
        Object object = LOCK;
        synchronized (object) {
            InterfaceType type = new InterfaceType(interfaces, parent, null);
            Class proxyClass = (Class)proxies.get(type);
            if (proxyClass == null) {
                proxyClass = Proxy.getProxyClass(parent, interfaces);
            }
            return null;
        }
    }

    public static Class getProxyClass(ClassLoader parent, Class[] interfaces) {
        return Proxy.getProxyConstructor(parent, interfaces).getDeclaringClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Constructor getProxyConstructor(ClassLoader parent, Class[] interfaces) {
        Object object = LOCK;
        synchronized (object) {
            InterfaceType type = new InterfaceType(interfaces, parent, null);
            InterfaceType existingType = (InterfaceType)proxies.get(type);
            if (existingType != null) {
                return existingType.getProxyConstructor();
            }
            if ((type = Proxy.getProxyType(type)).getProxyConstructor() == null) {
                throw new NullPointerException("constructor was null");
            }
            return type.getProxyConstructor();
        }
    }

    public static InterfaceType getProxyType(InterfaceType type) {
        Object object = LOCK;
        synchronized (object) {
            InterfaceType existingType = (InterfaceType)proxies.get(type);
            if (existingType != null) {
                return existingType;
            }
            try {
                String className = "__Proxy" + classID++;
                ByteString data = Proxy.getClassBinary(className, type);
                DynamicClassLoader loader = null;
                loader = Proxy.getDynamicClassLoader(type);
                loader.addClass(className, data);
                try {
                    Class<?> proxyClass = Class.forName(className, true, loader);
                    __currentMethods = null;
                    type.setProxyConstructor(proxyClass.getConstructor(INVOCATIONHANDLER_ARG));
                    proxies.put(type, type);
                    return type;
                }
                catch (VerifyError e) {
                    try {
                        FileOutputStream fileOut = new FileOutputStream(className + ".class");
                        ((OutputStream)fileOut).write(data.data, data.offset, data.length);
                        ((OutputStream)fileOut).close();
                    }
                    catch (IOException ie) {
                        ie.printStackTrace();
                    }
                    throw e;
                }
            }
            catch (Throwable t) {
                t.printStackTrace(System.out);
                throw new RuntimeException("Unable to create proxy: " + t);
            }
        }
    }

    private static DynamicClassLoader getDynamicClassLoader(InterfaceType type) {
        WeakReference reference = (WeakReference)loaders.get(type.getClassLoader());
        if (reference != null && reference.get() != null) {
            return (DynamicClassLoader)reference.get();
        }
        DynamicClassLoader loaderToReturn = (DynamicClassLoader)AccessController.doPrivileged(new DynamicClassLoaderAction(type.getClassLoader()));
        loaders.put(type.getClassLoader(), new WeakReference<DynamicClassLoader>(loaderToReturn));
        return loaderToReturn;
    }

    public String toString() {
        try {
            return (String)this.handler.invoke(this, JAVA_LANG_OBJECT_TOSTRING, null);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new UndeclaredExceptionTypeException(t.getClass().getName(), t);
        }
    }

    public int hashCode() {
        return ((Object)this.handler).hashCode();
    }

    public boolean equals(Object other) {
        try {
            return (Boolean)this.handler.invoke(this, JAVA_LANG_OBJECT_EQUALS, new Object[]{other});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new UndeclaredExceptionTypeException(t.getClass().getName(), t);
        }
    }

    public void setInvocationHandler(InvocationHandler handler) {
        this.handler = handler;
    }

    public String __getHandlerDescriptor() {
        return this.handler.toString();
    }

    public static ByteString getClassBinary(String className, InterfaceType type) throws NoSuchMethodException {
        try {
            ArrayList<Method> methods = new ArrayList<Method>();
            Class[] interfaces = type.interfaces;
            for (int i = 0; i < interfaces.length; ++i) {
                int methodLength = methods.size();
                Class<?>[] cascadedInterfaces = interfaces[i].getInterfaces();
                boolean hasSuperInterface = cascadedInterfaces.length != 0 && (cascadedInterfaces.length != 1 || cascadedInterfaces[0] != (class$java$rmi$Remote == null ? Proxy.class$("java.rmi.Remote") : class$java$rmi$Remote));
                Method[] interfaceMethods = interfaces[i].getMethods();
                for (int x = 0; x < interfaceMethods.length; ++x) {
                    Method other;
                    int y;
                    Method thisMethod = interfaceMethods[x];
                    List<Class<?>> thisMethodTypes = Arrays.asList(thisMethod.getParameterTypes());
                    boolean contains = false;
                    for (y = 0; y < OBJECT_METHODS.length; ++y) {
                        other = OBJECT_METHODS[y];
                        if (!other.getName().equals(thisMethod.getName()) || !((Object)thisMethodTypes).equals(Arrays.asList(other.getParameterTypes()))) continue;
                        contains = true;
                        if (other.getReturnType() == thisMethod.getReturnType()) break;
                        throw new IllegalArgumentException("Incompatible interface methods: " + other + " and " + interfaceMethods[x]);
                    }
                    if (!contains) {
                        for (y = 0; y < (hasSuperInterface ? methods.size() : methodLength); ++y) {
                            other = (Method)methods.get(y);
                            if (!other.getName().equals(thisMethod.getName()) || !((Object)thisMethodTypes).equals(Arrays.asList(other.getParameterTypes()))) continue;
                            contains = true;
                            if (other.getReturnType() == interfaceMethods[x].getReturnType()) break;
                            throw new IllegalArgumentException("Incompatible interface methods: " + other + " and " + interfaceMethods[x]);
                        }
                    }
                    if (contains) continue;
                    methods.add(thisMethod);
                }
            }
            ClassData proxyClassData = new ClassData(new ByteString(className), COM_EVERMIND_REFLECT_PROXY);
            proxyClassData.addMethod(new ConstructorMethodData(Proxy.class.getConstructor(InvocationHandler.class)));
            for (int i = 0; i < methods.size(); ++i) {
                proxyClassData.addMethod(new ProxyMethodData((Method)methods.get(i), i));
                proxyClassData.addField(new FieldData(new ByteString("METHOD_" + i), JAVA_LANG_REFLECT_METHOD, 24));
            }
            MethodData clinitDefinition = new MethodData(CLINIT, VOID_SIGNATURE, 9);
            clinitDefinition.add(new ProxyInitializationCodeAttribute(methods));
            proxyClassData.addMethod(clinitDefinition);
            for (int i = 0; i < interfaces.length; ++i) {
                proxyClassData.addInterface(new ByteString(interfaces[i].getName().replace('.', '/')));
            }
            __currentMethods = methods;
            return proxyClassData.getBinary(new ClassSerialization());
        }
        catch (CompilationException e) {
            throw new InternalError("Error compiling proxy: " + e.getMessage());
        }
    }

    public InvocationHandler getInvocationHandler() {
        return this.handler;
    }

    public static void clearProxies() {
        proxies.clear();
        loaders.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupProxyClasses(ClassLoader loader) {
        Object object = LOCK;
        synchronized (object) {
            Iterator iterator = loaders.keySet().iterator();
            while (iterator.hasNext()) {
                ClassLoader classLoader = (ClassLoader)iterator.next();
                if (classLoader.getParent() != loader) continue;
                iterator.remove();
            }
            iterator = proxies.keySet().iterator();
            while (iterator.hasNext()) {
                InterfaceType type = (InterfaceType)iterator.next();
                if (type.getClassLoader().getParent() != loader) continue;
                iterator.remove();
            }
        }
    }

    static {
        LOCK = new Object();
        proxies = new WeakHashMap();
        loaders = new WeakHashMap();
    }
}

