/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.net.http;

import java.io.Serializable;
import java.net.ProtocolException;

public class Cookie
implements Serializable {
    protected String name;
    protected String value;
    protected boolean secure;
    protected int version;

    public Cookie() {
    }

    public Cookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static Cookie[] parse(Cookie[] currentCookies, String set_cookie) throws ProtocolException {
        int beg = 0;
        int end = 0;
        char[] buf = set_cookie.toCharArray();
        int len = buf.length;
        Cookie[] cookie_arr = currentCookies;
        while ((beg = Cookie.skipSpace(buf, beg)) < len) {
            int eq;
            if (buf[beg] == ',') {
                ++beg;
                continue;
            }
            Cookie curr = new Cookie();
            end = set_cookie.indexOf(61, beg);
            if (end == -1) {
                throw new ProtocolException("Bad Set-Cookie header: " + set_cookie + "\nNo '=' found " + "for token starting at " + "position " + beg);
            }
            curr.name = set_cookie.substring(beg, end).trim();
            beg = Cookie.skipSpace(buf, end + 1);
            int comma = set_cookie.indexOf(44, beg);
            int semic = set_cookie.indexOf(59, beg);
            end = comma == -1 && semic == -1 ? len : (comma == -1 ? semic : (semic == -1 ? comma : (comma > semic ? semic : ((eq = set_cookie.indexOf(61, comma)) > 0 && eq < semic ? set_cookie.lastIndexOf(44, eq) : semic))));
            curr.value = set_cookie.substring(beg, end).trim();
            beg = end;
            boolean legal = true;
            while (beg < len && buf[beg] != ',') {
                if (buf[beg] == ';') {
                    beg = Cookie.skipSpace(buf, beg + 1);
                    continue;
                }
                if (beg + 6 <= len && set_cookie.regionMatches(true, beg, "secure", 0, 6)) {
                    curr.secure = true;
                    beg += 6;
                    if ((beg = Cookie.skipSpace(buf, beg)) < len && buf[beg] == '=') {
                        beg = Cookie.skipSpace(buf, beg + 1);
                    }
                    if (beg < len && buf[beg] == ';') {
                        beg = Cookie.skipSpace(buf, beg + 1);
                        continue;
                    }
                    if (beg >= len || buf[beg] == ',') continue;
                    throw new ProtocolException("Bad Set-Cookie header: " + set_cookie + "\nExpected " + "';' or ',' at position " + beg);
                }
                end = set_cookie.indexOf(61, beg);
                if (end == -1) {
                    throw new ProtocolException("Bad Set-Cookie header: " + set_cookie + "\nNo '=' found " + "for token starting at " + "position " + beg);
                }
                String name = set_cookie.substring(beg, end).trim();
                beg = Cookie.skipSpace(buf, end + 1);
                if (name.equalsIgnoreCase("expires")) {
                    int pos;
                    if (set_cookie.charAt(beg) == '\"') {
                        beg = Cookie.skipSpace(buf, beg + 1);
                    }
                    for (pos = beg; pos < len && (buf[pos] >= 'a' && buf[pos] <= 'z' || buf[pos] >= 'A' && buf[pos] <= 'Z'); ++pos) {
                    }
                    if ((pos = Cookie.skipSpace(buf, pos)) < len && buf[pos] == ',' && pos > beg) {
                        beg = pos + 1;
                    }
                }
                comma = set_cookie.indexOf(44, beg);
                semic = set_cookie.indexOf(59, beg);
                end = comma == -1 && semic == -1 ? len : (comma == -1 ? semic : (semic == -1 ? comma : Math.min(comma, semic)));
                String value = set_cookie.substring(beg, end).trim();
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
                if ((beg = end) >= len || buf[beg] != ';') continue;
                beg = Cookie.skipSpace(buf, beg + 1);
            }
            if (!legal) continue;
            cookie_arr = Cookie.resizeArray(cookie_arr, cookie_arr.length + 1);
            cookie_arr[cookie_arr.length - 1] = curr;
        }
        return cookie_arr;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Cookie) {
            Cookie other = (Cookie)obj;
            return this.name.equals(other.name);
        }
        return false;
    }

    public String toExternalForm() {
        return this.name + "=" + this.value;
    }

    public String toString() {
        StringBuffer res = new StringBuffer(this.name.length() + this.value.length() + 30);
        res.append(this.name).append('=').append(this.value);
        if (this.secure) {
            res.append("; secure");
        }
        return res.toString();
    }

    static final Cookie[] resizeArray(Cookie[] src, int new_size) {
        Cookie[] tmp = new Cookie[new_size];
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    static final int skipSpace(char[] str, int pos) {
        int len = str.length;
        while (pos < len && Character.isWhitespace(str[pos])) {
            ++pos;
        }
        return pos;
    }
}

