/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.net;

import com.evermind.net.AccessRegion;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.StringTokenizer;
import org.w3c.dom.Node;

public class IPAccessRegion
extends AccessRegion
implements XMLizable {
    public static final String DEFAULT_IP = "255.255.255.255";
    int m_ip;
    int m_hostmask;

    public IPAccessRegion(Node node) throws InstantiationException {
        super(XMLUtils.getNodeAttribute(node, "mode"), false);
        String ipString = XMLUtils.getNodeAttribute(node, "ip");
        String maskString = XMLUtils.getNodeAttribute(node, "netmask");
        if (ipString == null) {
            throw new InstantiationException("No 'ip' attribute specified in <ip-access> tag");
        }
        this.m_hostmask = IPAccessRegion.getIP(maskString);
        this.m_ip = IPAccessRegion.getIP(ipString) & this.m_hostmask;
        this.m_isLocalHost = IPAccessRegion.isLocalHost(ipString);
    }

    IPAccessRegion(int ip, int hostmask, boolean allow, boolean isLocalHost) {
        super(allow, isLocalHost);
        this.m_ip = ip & hostmask;
        this.m_hostmask = hostmask;
    }

    public IPAccessRegion(String ip, String hostmask, boolean allow) throws IllegalArgumentException {
        this(IPAccessRegion.getIP(ip), IPAccessRegion.getIP(hostmask), allow, IPAccessRegion.isLocalHost(ip));
    }

    public static int getIP(String string) {
        if (null == string || string.length() <= 0) {
            string = DEFAULT_IP;
        }
        int ip = 0;
        StringTokenizer tokenizer = new StringTokenizer(string, ".");
        while (tokenizer.hasMoreElements()) {
            try {
                ip = (ip << 8) + Integer.parseInt(tokenizer.nextToken());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException();
            }
        }
        return ip;
    }

    public static int toInt(InetAddress address) {
        if (null == address) {
            return 0;
        }
        byte[] ip = address.getAddress();
        return (((char)ip[0] & 0xFF) << 24) + (((char)ip[1] & 0xFF) << 16) + (((char)ip[2] & 0xFF) << 8) + ((char)ip[3] & 0xFF);
    }

    public boolean implies(InetAddress address, boolean isLocalHost) {
        return this.implies(IPAccessRegion.toInt(address), isLocalHost);
    }

    public boolean implies(int ip, boolean isLocalHost) {
        if (isLocalHost && this.m_isLocalHost) {
            return true;
        }
        return this.m_ip == (ip & this.m_hostmask);
    }

    public boolean equals(Object object) {
        if (!(object instanceof IPAccessRegion)) {
            return false;
        }
        IPAccessRegion other = (IPAccessRegion)object;
        return this.m_ip == other.m_ip && this.m_hostmask == other.m_hostmask;
    }

    public int hashCode() {
        return this.m_ip + this.m_hostmask;
    }

    static String getIPString(int ip) {
        return (ip >> 24 & 0xFF) + "." + (ip >> 16 & 0xFF) + "." + (ip >> 8 & 0xFF) + "." + (ip & 0xFF);
    }

    public String toString() {
        return "[" + IPAccessRegion.getIPString(this.m_ip) + "/" + (this.m_hostmask >> 24 & 0xFF) + "." + (this.m_hostmask >> 16 & 0xFF) + "." + (this.m_hostmask >> 8 & 0xFF) + "." + (this.m_hostmask & 0xFF) + ":" + this.m_allow + "]";
    }

    public void writeXML(PrintWriter out, String indention) {
        out.print(indention + "<ip-access ");
        out.print(" ip=\"" + (this.m_ip >> 24 & 0xFF) + "." + (this.m_ip >> 16 & 0xFF) + "." + (this.m_ip >> 8 & 0xFF) + "." + (this.m_ip & 0xFF) + "\"");
        out.print(" mode=\"" + (this.m_allow ? "allow" : "deny") + "\"");
        out.println(" netmask=\"" + (this.m_hostmask >> 24 & 0xFF) + "." + (this.m_hostmask >> 16 & 0xFF) + "." + (this.m_hostmask >> 8 & 0xFF) + "." + (this.m_hostmask & 0xFF) + "\" />");
    }
}

