/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.net;

import com.evermind.net.IPAccessRegion;
import java.net.InetAddress;
import java.net.UnknownHostException;

public abstract class AccessRegion {
    public static final String LOOPBACK_NAME = "localhost";
    public static final String LOOPBACK_ADDR = "127.0.0.1";
    boolean m_allow;
    boolean m_isLocalHost;

    public AccessRegion(boolean allow, boolean isLocalHost) {
        this.m_allow = allow;
        this.m_isLocalHost = isLocalHost;
    }

    public AccessRegion(String allow, boolean isLocalHost) throws InstantiationException {
        this(AccessRegion.toBoolean(allow), isLocalHost);
    }

    static boolean toBoolean(String allow) throws InstantiationException {
        if (null == allow) {
            return true;
        }
        if (allow.equals("allow")) {
            return true;
        }
        if (allow.equals("deny")) {
            return false;
        }
        throw new InstantiationException("Illegal mode value: '" + allow + "', legal values are allow and deny.");
    }

    public abstract boolean implies(InetAddress var1, boolean var2);

    public boolean implies(InetAddress address) {
        return this.implies(address, AccessRegion.isLocalHost(address));
    }

    public boolean implies(String host, boolean isLocalHost) {
        try {
            InetAddress addr = InetAddress.getByName(host);
            return this.implies(addr, AccessRegion.isLocalHost(addr));
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public boolean implies(int ip, boolean isLocalHost) {
        try {
            InetAddress addr = InetAddress.getByName(IPAccessRegion.getIPString(ip));
            return this.implies(addr, isLocalHost);
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    static boolean isLocalHost(InetAddress address) {
        if (null == address) {
            return false;
        }
        if (address.isLoopbackAddress()) {
            return true;
        }
        try {
            InetAddress localAddress = InetAddress.getLocalHost();
            return localAddress.equals(address);
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    static boolean isLocalHost(String host) {
        if (null == host) {
            return false;
        }
        if (host.equalsIgnoreCase(LOOPBACK_NAME) || host.equals(LOOPBACK_ADDR)) {
            return true;
        }
        try {
            return AccessRegion.isLocalHost(InetAddress.getByName(host));
        }
        catch (UnknownHostException e) {
            return false;
        }
    }
}

