/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.naming;

import com.evermind.naming.FlatContext;
import com.evermind.naming.RelativeContext;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class SubContext
extends FlatContext
implements RelativeContext {
    protected Context context;
    protected String root;
    private String previousLookup;
    private String previousResult;

    public SubContext(Context context, String root) {
        this.context = context;
        this.root = this.isContextPrefix(root) ? root : root + "/";
    }

    private boolean isContextPrefix(String root) {
        return root.equals("") || root.endsWith("/");
    }

    public String getPath() {
        return this.root.substring(0, this.root.length() - 1);
    }

    public String getNameInNamespace() {
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(String path) throws NamingException {
        SubContext subContext = this;
        synchronized (subContext) {
            if (path == this.previousLookup) {
                path = this.previousResult;
            } else {
                this.previousLookup = path;
                this.previousResult = path = this.root.concat(path);
            }
        }
        return this.context.lookup(path);
    }

    public void rebind(String path, Object value) throws NamingException {
        this.context.rebind(this.root.concat(path), value);
    }

    public void unbind(String path) throws NamingException {
        this.context.unbind(this.root.concat(path));
    }

    public void bind(String path, Object value) throws NamingException {
        this.context.bind(this.root.concat(path), value);
    }

    public Context getContext() {
        return this.context;
    }

    public void rename(String from, String to) throws NamingException {
        this.context.rename(this.root.concat(from), this.root.concat(to));
    }

    public NamingEnumeration list(String path) throws NamingException {
        if (path.equals("") && this.root.length() > 0) {
            return this.context.list(this.root.substring(0, this.root.length() - 1));
        }
        return this.context.list(this.root.concat(path));
    }

    public NamingEnumeration listBindings(String path) throws NamingException {
        if (path.equals("") && this.root.length() > 0) {
            return this.context.listBindings(this.root.substring(0, this.root.length() - 1));
        }
        return this.context.listBindings(this.root.concat(path));
    }

    public synchronized void destroySubcontext(String path) throws NamingException {
        this.context.destroySubcontext(this.root.concat(path));
    }

    public synchronized Context createSubcontext(String path) throws NamingException {
        return this.context.createSubcontext(this.root.concat(path));
    }

    public synchronized Object lookupLink(String path) throws NamingException {
        return this.context.lookupLink(this.root.concat(path));
    }

    public Object addToEnvironment(String name, Object object) throws NamingException {
        return null;
    }

    public Object removeFromEnvironment(String name) throws NamingException {
        return null;
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.context.getEnvironment();
    }

    public void close() {
    }

    public String toString() {
        return this.context + "/" + (this.root.length() == 0 ? "" : this.root.substring(0, this.root.length() - 1));
    }

    public Context getRelative(String path) throws NamingException {
        if (this.context instanceof RelativeContext) {
            return ((RelativeContext)((Object)this.context)).getRelative(this.root.concat(path));
        }
        return null;
    }
}

