/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.naming;

import com.evermind.io.LastModifiedContainer;
import com.evermind.naming.AwareSubContext;
import com.evermind.naming.RemoteContext;
import com.evermind.naming.SubContext;
import com.evermind.naming.archive.ArchiveContext;
import com.evermind.naming.archive.ContentArchiveContext;
import com.evermind.naming.archive.MemoryArchiveContext;
import com.evermind.naming.file.ContentFileContext;
import com.evermind.naming.file.FileContext;
import com.evermind.naming.url.ContentURLContext;
import com.evermind.naming.url.URLContext;
import com.evermind.util.ByteString;
import com.evermind.util.NameFilter;
import com.evermind.util.OC4JRuntimeProperties;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class ContextUtils {
    private static boolean DONT_USE_MEMORY_ARCHIVE = OC4JRuntimeProperties.getDontUseMemoryArchive();
    private static Map contextCache = new WeakHashMap();

    public static Context getContext(URL url, boolean autoFlush) throws IOException {
        if (url == null) {
            throw new NullPointerException("url was null");
        }
        if (url.getProtocol().equals("file")) {
            File file = new File(url.getFile()).getCanonicalFile();
            if (file.isDirectory()) {
                return new ContentFileContext(file, null);
            }
            try {
                if (DONT_USE_MEMORY_ARCHIVE) {
                    return new ContentArchiveContext(file, !autoFlush);
                }
                MemoryArchiveContext context = new MemoryArchiveContext(new ContentFileContext(file.getParentFile(), null), file.getName(), null, 0, 0, autoFlush);
                Context oldContext = (Context)contextCache.get(context);
                if (oldContext instanceof MemoryArchiveContext && !((MemoryArchiveContext)oldContext).isUpToDate()) {
                    ((MemoryArchiveContext)oldContext).unload();
                }
                if (oldContext != null) {
                    return oldContext;
                }
                contextCache.put(context, context);
                return context;
            }
            catch (NamingException e) {
                throw new IOException(e.getMessage());
            }
        }
        return new ContentURLContext(url);
    }

    public static URL getURL(Context context, boolean force) throws IOException {
        if (context == null) {
            throw new IllegalArgumentException("context was null");
        }
        if (context instanceof FileContext) {
            return ((FileContext)context).getFile().toURL();
        }
        if (context instanceof ArchiveContext) {
            return ((ArchiveContext)context).getFile().toURL();
        }
        if (context instanceof MemoryArchiveContext) {
            File file;
            MemoryArchiveContext memoryContext = (MemoryArchiveContext)context;
            if (memoryContext.getParent() != null && (file = ContextUtils.getFile(memoryContext.getParent(), memoryContext.getName(), force)) != null) {
                return file.toURL();
            }
            if (force) {
                throw new InternalError("Context copy not implemented (1)");
            }
            return null;
        }
        if (context instanceof URLContext) {
            URL url = ((URLContext)context).getURL();
            return url;
        }
        if (context instanceof SubContext) {
            SubContext sub = (SubContext)context;
            File file = ContextUtils.getFile(sub.getContext(), force);
            if (file != null) {
                String path = file.getPath();
                if (file.isDirectory()) {
                    file = new File(path + File.separatorChar + sub.getPath());
                } else if (path.endsWith(".war") || path.endsWith(".ear")) {
                    path = path.substring(0, path.lastIndexOf("."));
                    file = new File(path + File.separatorChar + sub.getPath());
                }
                if (file != null) {
                    return file.toURL();
                }
            }
            return null;
        }
        if (force) {
            throw new InternalError("Unsupported context type: " + context.getClass().getName());
        }
        return null;
    }

    public static File getFile(Context context, String name, boolean force) {
        SubContext sub;
        File file;
        if (context instanceof FileContext) {
            return new File(((FileContext)context).getFile().getPath() + File.separatorChar + name);
        }
        if (context instanceof ArchiveContext) {
            if (force) {
                throw new InternalError("Context copy not implemented (3)");
            }
            return null;
        }
        if (context instanceof MemoryArchiveContext) {
            if (force) {
                throw new InternalError("Context copy not implemented (4)");
            }
            return null;
        }
        if (context instanceof URLContext) {
            URL url = ((URLContext)context).getURL();
            if (url.getProtocol().equals("file")) {
                return new File(url.getFile() + "/" + name);
            }
            if (force) {
                throw new InternalError("Context copy not implemented (5)");
            }
            return null;
        }
        if (context instanceof SubContext && (file = ContextUtils.getFile((sub = (SubContext)context).getContext(), force)) != null && file.isDirectory()) {
            return new File(file.getPath() + File.separatorChar + sub.getPath() + File.separatorChar + name);
        }
        if (!force) {
            return null;
        }
        throw new InternalError("Unsupported context type: " + context.getClass().getName());
    }

    public static File getFile(Context context, boolean force) {
        SubContext sub;
        File file;
        if (context instanceof FileContext) {
            return ((FileContext)context).getFile();
        }
        if (context instanceof ArchiveContext) {
            return ((ArchiveContext)context).getFile();
        }
        if (context instanceof MemoryArchiveContext) {
            MemoryArchiveContext memoryContext = (MemoryArchiveContext)context;
            if (memoryContext.getParent() != null) {
                return ContextUtils.getFile(memoryContext.getParent(), memoryContext.getName(), force);
            }
            if (force) {
                throw new InternalError("Context copy not implemented (1)");
            }
            return null;
        }
        if (context instanceof SubContext && (file = ContextUtils.getFile((sub = (SubContext)context).getContext(), force)) != null && file.isDirectory()) {
            return new File(file.getPath() + File.separatorChar + sub.getPath());
        }
        try {
            URL url = ContextUtils.getURL(context, force);
            if (url != null) {
                if (!url.getProtocol().equals("file")) {
                    if (force) {
                        throw new InternalError("URL was not a file: " + url);
                    }
                    return null;
                }
                return new File(url.getFile()).getAbsoluteFile();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (force) {
            throw new InternalError("Context copy not implemented (2)");
        }
        return null;
    }

    public static Context getContext(Context parent, String name, boolean autoFlush) throws NamingException, IOException {
        ByteString string;
        if (parent == null) {
            throw new NullPointerException("parent was null");
        }
        if (name == null) {
            throw new NullPointerException("name was null");
        }
        if (parent instanceof FileContext) {
            return ContextUtils.getContext(new URL(((FileContext)parent).getFile().toURL() + "/" + name), autoFlush);
        }
        if (parent instanceof MemoryArchiveContext && (string = ((MemoryArchiveContext)parent).lookupString(name)) != null) {
            MemoryArchiveContext context = new MemoryArchiveContext(parent, name, string.data, string.offset, string.length, autoFlush);
            Context oldContext = (Context)contextCache.get(context);
            if (oldContext instanceof MemoryArchiveContext && !((MemoryArchiveContext)oldContext).isUpToDate()) {
                ((MemoryArchiveContext)oldContext).unload();
            }
            if (oldContext != null) {
                return oldContext;
            }
            return context;
        }
        Object object = parent.lookup(name);
        if (object instanceof Context) {
            return (Context)object;
        }
        byte[] data = (byte[])object;
        MemoryArchiveContext context = new MemoryArchiveContext(parent, name, data, 0, data.length, autoFlush);
        Context oldContext = (Context)contextCache.get(context);
        if (oldContext instanceof MemoryArchiveContext && !((MemoryArchiveContext)oldContext).isUpToDate()) {
            ((MemoryArchiveContext)oldContext).unload();
        }
        if (oldContext != null) {
            return oldContext;
        }
        contextCache.put(context, context);
        return context;
    }

    public static void flush(Context context) throws IOException {
        try {
            if (context instanceof ArchiveContext) {
                ((ArchiveContext)context).flush();
            } else if (context instanceof MemoryArchiveContext) {
                ((MemoryArchiveContext)context).flush();
                if (((MemoryArchiveContext)context).getParent() != null) {
                    ContextUtils.flush(((MemoryArchiveContext)context).getParent());
                }
            } else if (context instanceof RemoteContext) {
                ((RemoteContext)context).storeToParent();
            } else if (context instanceof SubContext) {
                ContextUtils.flush(((SubContext)context).getContext());
            }
        }
        catch (NamingException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static ByteString lookupString(Context[] contexts, String name) throws NamingException {
        NamingException e = null;
        for (int i = 0; i < contexts.length; ++i) {
            try {
                if (contexts[i] instanceof MemoryArchiveContext) {
                    ByteString string = ((MemoryArchiveContext)contexts[i]).lookupString(name);
                    if (string == null) continue;
                    return string;
                }
                Object object = contexts[i].lookup(name);
                if (object instanceof byte[]) {
                    return new ByteString((byte[])object);
                }
                if (object instanceof ByteString) {
                    return (ByteString)object;
                }
                if (!(object instanceof Context)) continue;
                throw new NamingException(name + " was a directory, not a file");
            }
            catch (NamingException ne) {
                if (ne != null) continue;
                e = ne;
            }
        }
        if (e != null) {
            throw e;
        }
        throw new NameNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void listContent(Context context, String prepath, PrintWriter out) throws IOException, NamingException {
        try {
            NamingEnumeration<Binding> enumeration = context.listBindings("");
            while (enumeration.hasMore()) {
                Binding binding = enumeration.next();
                out.println(prepath + binding.getName());
                if (!(binding.getObject() instanceof Context)) continue;
                ContextUtils.listContent((Context)binding.getObject(), prepath + binding.getName() + "/", out);
            }
        }
        finally {
            out.flush();
        }
    }

    public static void unbind(Context context, Collection names) {
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            try {
                context.unbind((String)iterator.next());
            }
            catch (NamingException namingException) {}
        }
    }

    public static void bind(Context context, Map map, boolean overwrite) throws NamingException {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (overwrite) {
                context.rebind((String)entry.getKey(), entry.getValue());
                continue;
            }
            context.bind((String)entry.getKey(), entry.getValue());
        }
    }

    public static int copy(Context from, Context to) throws NamingException {
        return ContextUtils.copy(from, to, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int copy(Context from, Context to, NameFilter filter, boolean checkForPreexisting) throws NamingException {
        int count = 0;
        NamingEnumeration<NameClassPair> enumeration = from.list("");
        boolean autoFlush = false;
        if (to instanceof MemoryArchiveContext) {
            autoFlush = ((MemoryArchiveContext)to).getAutoFlush();
            ((MemoryArchiveContext)to).setAutoFlush(false);
        }
        try {
            while (enumeration.hasMore()) {
                long fromLastModified;
                NameClassPair pair = enumeration.next();
                if (filter != null && pair.getClassName().equals("[B") && !filter.implies(pair.getName())) continue;
                Object object = from.lookup(pair.getName());
                if (object instanceof Context) {
                    try {
                        Context subContext = to.createSubcontext(pair.getName());
                        count += ContextUtils.copy((Context)object, subContext, filter, checkForPreexisting);
                        continue;
                    }
                    catch (NameAlreadyBoundException e) {
                        Object subObject = to.lookup(pair.getName());
                        if (!(subObject instanceof Context)) {
                            throw new NamingException("Incompatible existing entry at target: " + pair.getName());
                        }
                        count += ContextUtils.copy((Context)object, (Context)subObject, filter, checkForPreexisting);
                        continue;
                    }
                }
                if (filter != null && !filter.implies(pair.getName())) continue;
                ++count;
                try {
                    long l = fromLastModified = from instanceof LastModifiedContainer ? ((LastModifiedContainer)((Object)from)).getLastModified(pair.getName()) : 0L;
                    if (checkForPreexisting && fromLastModified > 0L && to instanceof LastModifiedContainer && ((LastModifiedContainer)((Object)to)).getLastModified(pair.getName()) == fromLastModified) {
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new NamingException("Error getting lastModified: " + e.getMessage());
                }
                to.rebind(pair.getName(), object);
                if (fromLastModified <= 0L || !(to instanceof LastModifiedContainer)) continue;
                try {
                    ((LastModifiedContainer)((Object)to)).setLastModified(pair.getName(), fromLastModified);
                }
                catch (IOException e) {
                    throw new NamingException("Error setting lastModified: " + e.getMessage());
                }
            }
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (!(to instanceof MemoryArchiveContext)) throw throwable;
            ((MemoryArchiveContext)to).setAutoFlush(autoFlush);
            ((MemoryArchiveContext)to).save();
            throw throwable;
        }
        if (!(to instanceof MemoryArchiveContext)) return count;
        ((MemoryArchiveContext)to).setAutoFlush(autoFlush);
        ((MemoryArchiveContext)to).save();
        return count;
    }

    public static void main(String[] args) throws InvalidNameException {
        System.out.println("Size: " + new CompositeName("/abc//def").size());
    }

    public static void cleanCache() {
        if (contextCache != null) {
            contextCache.clear();
        }
    }

    public static Object purgeCache(Context ctx) {
        return contextCache.remove(ctx);
    }

    public static Object purgeCache(File file) {
        try {
            MemoryArchiveContext context = new MemoryArchiveContext(new ContentFileContext(file.getParentFile(), null), file.getName(), null, 0, 0, false);
            return contextCache.remove(context);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ByteString readFromContext(Context context, String descriptor, boolean ignore) throws InstantiationException {
        ByteString readBytes;
        block10: {
            if (context == null || descriptor == null) {
                throw new InstantiationException("ContextUtils.readFromContext(): illegal NULL argument. Context: " + context + " ; descriptor: " + descriptor);
            }
            readBytes = null;
            try {
                if (context instanceof MemoryArchiveContext) {
                    readBytes = ((MemoryArchiveContext)context).lookupString(descriptor);
                    if (readBytes == null) {
                        throw new NameNotFoundException(descriptor);
                    }
                    break block10;
                }
                Object lookupObject = context.lookup(descriptor);
                try {
                    byte[] data = (byte[])lookupObject;
                    readBytes = new ByteString(data, 0, data.length);
                }
                catch (ClassCastException e) {
                    if (lookupObject instanceof Context) {
                        throw new InstantiationException(descriptor + " is a directory, not a file as expected");
                    }
                    throw e;
                }
            }
            catch (NameNotFoundException e) {
                if (!ignore) {
                    throw new InstantiationException("Unable to find/read file " + descriptor + " in " + context + " (" + e.getMessage() + ")");
                }
            }
            catch (NamingException e) {
                throw new InstantiationException("Unable to find/read file " + descriptor + " in " + context + " (" + e.getMessage() + ")");
            }
        }
        return readBytes;
    }

    public static boolean isInContext(Context context, String descriptor) throws InstantiationException {
        return ContextUtils.readFromContext(context, descriptor, true) != null;
    }

    public static long getFileLastModified(Context context, String path) {
        try {
            if (context instanceof LastModifiedContainer) {
                return ((LastModifiedContainer)((Object)context)).getLastModified(path);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0L;
    }

    public static ByteString readFromContextWithEmptyFile(Context context, String descriptor, boolean ignore) throws InstantiationException {
        ByteString readBytes;
        block11: {
            if (context == null || descriptor == null) {
                throw new InstantiationException("ContextUtils.readFromContext(): illegal NULL argument. Context: " + context + " ; descriptor: " + descriptor);
            }
            readBytes = null;
            try {
                if (context instanceof MemoryArchiveContext) {
                    readBytes = ((MemoryArchiveContext)context).lookupString(descriptor);
                    if (readBytes == null) {
                        throw new NameNotFoundException(descriptor);
                    }
                    break block11;
                }
                Object lookupObject = context.lookup(descriptor);
                if (lookupObject instanceof AwareSubContext) {
                    AwareSubContext asctx = (AwareSubContext)lookupObject;
                    byte[] emptyData = new byte[]{};
                    readBytes = new ByteString(emptyData, 0, 0);
                    break block11;
                }
                try {
                    byte[] data = (byte[])lookupObject;
                    readBytes = new ByteString(data, 0, data.length);
                }
                catch (ClassCastException e) {
                    if (lookupObject instanceof Context) {
                        throw new InstantiationException(descriptor + " is a directory, not a file as expected");
                    }
                    throw e;
                }
            }
            catch (NameNotFoundException e) {
                if (!ignore) {
                    throw new InstantiationException("Unable to find/read file " + descriptor + " in " + context + " (" + e.getMessage() + ")");
                }
            }
            catch (NamingException e) {
                throw new InstantiationException("Unable to find/read file " + descriptor + " in " + context + " (" + e.getMessage() + ")");
            }
        }
        return readBytes;
    }
}

