/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.mail;

import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MailUtils {
    public static void send(String to, String from, String host, String subject, String messageBody, String encoding) throws MessagingException {
        Properties properties = new Properties();
        properties.put("mail.smtp.host", host);
        Session session = Session.getDefaultInstance((Properties)properties, null);
        MailUtils.send(to, from, session, subject, messageBody, encoding);
    }

    public static void send(String to, String from, Session session, String subject, String messageBody, String encoding) throws MessagingException {
        MailUtils.send(new String[]{to}, from, session, subject, messageBody, encoding);
    }

    public static void send(String[] to, String from, Session session, String subject, String messageBody, String encoding) throws MessagingException {
        InternetAddress[] address = new InternetAddress[to.length];
        for (int i = 0; i < to.length; ++i) {
            address[i] = new InternetAddress(to[i]);
        }
        MailUtils.send(address, from, session, subject, messageBody, encoding);
    }

    public static void send(InternetAddress[] to, String from, Session session, String subject, String messageBody, String encoding) throws MessagingException {
        MailUtils.send(to, from == null ? null : new InternetAddress(from), session, subject, messageBody, encoding);
    }

    public static void send(InternetAddress[] to, InternetAddress from, String host, String subject, String messageBody, String encoding) throws MessagingException {
        Properties properties = new Properties();
        properties.put("mail.smtp.host", host);
        Session session = Session.getDefaultInstance((Properties)properties, null);
        MailUtils.send(to, from, session, subject, messageBody, encoding);
    }

    public static void send(InternetAddress[] to, InternetAddress from, Session session, String subject, String messageBody, String encoding) throws MessagingException {
        if (to.length == 0) {
            return;
        }
        MimeMessage message = new MimeMessage(session);
        if (from != null) {
            message.setFrom((Address)from);
        }
        if (encoding == null) {
            encoding = "utf-8";
        }
        message.setRecipients(Message.RecipientType.TO, (Address[])to);
        message.setSubject(subject, encoding);
        message.setSentDate(new Date());
        message.setText(messageBody, encoding);
        Transport.send((Message)message);
    }
}

