/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io;

import com.evermind.io.Base64OutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.util.Arrays;

public class Base64InputStream
extends FilterInputStream {
    public static final byte[] BYTE_TABLE = new byte[256];
    private int byte0;
    private int byte1;
    private int byte2;
    int bufferPos = 3;
    private boolean eos;
    private byte[] asciiBuffer;

    public Base64InputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        if (this.eos) {
            if (this.bufferPos == 4) {
                this.bufferPos = 0;
                return this.byte1;
            }
            return -1;
        }
        if (this.bufferPos > 2) {
            int i;
            this.bufferPos = 1;
            do {
                if ((i = this.in.read()) != -1) continue;
                this.eos = true;
                return -1;
            } while (BYTE_TABLE[i] == -1);
            this.byte0 = (byte)(BYTE_TABLE[i] << 2);
            do {
                if ((i = this.in.read()) == -1) {
                    throw new StreamCorruptedException();
                }
                if (i != 61) continue;
                throw new StreamCorruptedException();
            } while (BYTE_TABLE[i] == -1);
            this.byte0 += BYTE_TABLE[i] >> 4;
            this.byte1 = (byte)(BYTE_TABLE[i] << 4);
            do {
                if ((i = this.in.read()) == -1) {
                    throw new StreamCorruptedException();
                }
                if (i != 61) continue;
                this.eos = true;
                while ((i = this.in.read()) != 61) {
                    if (i != -1) continue;
                    throw new StreamCorruptedException();
                }
                return this.byte0;
            } while (BYTE_TABLE[i] == -1);
            this.byte1 += BYTE_TABLE[i] >> 2;
            this.byte2 = (byte)(BYTE_TABLE[i] << 6);
            do {
                if ((i = this.in.read()) == -1) {
                    throw new StreamCorruptedException("1");
                }
                if (i != 61) continue;
                this.eos = true;
                this.bufferPos = 4;
                return this.byte0;
            } while (BYTE_TABLE[i] == -1);
            this.byte2 += BYTE_TABLE[i];
            return this.byte0;
        }
        ++this.bufferPos;
        if (this.bufferPos == 2) {
            return this.byte1;
        }
        return this.byte2;
    }

    public int readSlow(byte[] data, int offset, int length) throws IOException {
        int i;
        if (this.eos) {
            return -1;
        }
        if (offset < 0 || length < 0 || data.length < (offset + length & Integer.MAX_VALUE)) {
            throw new IndexOutOfBoundsException();
        }
        int bytesRead = 0;
        while (bytesRead < length && (i = this.read()) != -1) {
            data[offset + bytesRead++] = (byte)i;
        }
        return bytesRead;
    }

    public int read(byte[] data, int offset, int length) throws IOException {
        int asciiReadThisTurn;
        if (this.eos) {
            return -1;
        }
        if (offset < 0 || length < 0 || data.length < (offset + length & Integer.MAX_VALUE)) {
            throw new IndexOutOfBoundsException();
        }
        boolean pos = false;
        int bytesRead = 0;
        while (this.bufferPos != 3) {
            if (bytesRead == length) {
                return bytesRead;
            }
            int i = this.read();
            if (this.eos) {
                return bytesRead;
            }
            data[offset + bytesRead++] = (byte)i;
        }
        int odd = (length - bytesRead) % 3;
        length -= odd;
        if (this.asciiBuffer == null) {
            this.asciiBuffer = new byte[length / 3 * 4];
        }
        int asciiRead = 0;
        while ((asciiReadThisTurn = this.in.read(this.asciiBuffer, 0, this.asciiBuffer.length - asciiRead)) != -1) {
            bytesRead += Base64InputStream.decode(this.asciiBuffer, 0, asciiRead, data, offset + bytesRead);
        }
        return 0;
    }

    public static int decode(byte[] ascii, int pos, int length, byte[] data, int offset) {
        int dataPos = offset;
        length = pos + length;
        try {
            while (pos < length) {
                while (BYTE_TABLE[ascii[pos]] == -1) {
                    ++pos;
                }
                data[dataPos] = (byte)(BYTE_TABLE[ascii[pos++]] << 2);
                while (BYTE_TABLE[ascii[pos]] == -1 && ascii[pos] != 61) {
                    ++pos;
                }
                if (ascii[pos] != 61) {
                    int n = dataPos++;
                    data[n] = (byte)(data[n] + (BYTE_TABLE[ascii[pos]] >> 4));
                    data[dataPos] = (byte)(BYTE_TABLE[ascii[pos++]] << 4);
                    while (BYTE_TABLE[ascii[pos]] == -1 && ascii[pos] != 61) {
                        ++pos;
                    }
                    if (ascii[pos] != 61) {
                        int n2 = dataPos++;
                        data[n2] = (byte)(data[n2] + (BYTE_TABLE[ascii[pos]] >> 2));
                        data[dataPos] = (byte)(BYTE_TABLE[ascii[pos++]] << 6);
                        while (BYTE_TABLE[ascii[pos]] == -1 && ascii[pos] != 61) {
                            ++pos;
                        }
                        if (ascii[pos] != 61) {
                            int n3 = dataPos++;
                            data[n3] = (byte)(data[n3] + BYTE_TABLE[ascii[pos++]]);
                            continue;
                        }
                    }
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Improperly formatted base64 string");
        }
        return dataPos - offset;
    }

    public void close() {
    }

    static {
        Arrays.fill(BYTE_TABLE, (byte)-1);
        for (int i = 0; i < 64; ++i) {
            Base64InputStream.BYTE_TABLE[Base64OutputStream.CHAR_TABLE[i]] = (byte)i;
        }
    }
}

