/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.compiler;

import com.evermind.compiler.ClassDescription;
import com.evermind.compiler.CodeStringTokenizer;
import com.evermind.compiler.CompilationException;
import com.evermind.compiler.JavaCompiler;
import com.evermind.compiler.LiteralMethodDescription;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;

public class LiteralClassDescription
extends ClassDescription {
    public String name;
    public String packageName;
    public Vector imports = new Vector();
    public Vector interfaceNames = new Vector();
    public Vector interfaces = new Vector();
    public Vector contents = new Vector();
    public Vector methods = new Vector();
    public Vector fields = new Vector();
    public int modifier;
    public String superName;
    public String classBody;
    private int dimensions;
    private boolean isNative;

    public LiteralClassDescription(JavaCompiler compiler) {
        this.compiler = compiler;
    }

    public String getName() {
        return this.name;
    }

    public void parseBody(String body) throws CompilationException {
        String line;
        CodeStringTokenizer tokenizer = new CodeStringTokenizer(body);
        this.imports.insertElementAt("java/lang/", 0);
        this.imports.insertElementAt(this.packageName, 1);
        while ((line = tokenizer.readComplicatedLine()) != null) {
            this.contents.add(line);
        }
        this.superClassDescription = this.compiler.findClass(JavaCompiler.emptyVector, this.superName);
        Enumeration enumeration = this.interfaceNames.elements();
        while (enumeration.hasMoreElements()) {
            this.interfaces.add(this.compiler.findClass(this.imports, (String)enumeration.nextElement()));
        }
        enumeration = this.contents.elements();
        while (enumeration.hasMoreElements()) {
            String currentContent = (String)enumeration.nextElement();
            if (currentContent.indexOf(40) >= 0 && (currentContent.indexOf(61) < 0 || currentContent.indexOf(61) > currentContent.indexOf(40))) {
                this.methods.add(new LiteralMethodDescription(this, currentContent));
                System.out.println("Found method: '" + currentContent + '\'');
                continue;
            }
            System.out.println("Found field: '" + currentContent + '\'');
        }
    }

    public ClassDescription getSuper() {
        return this.superClassDescription;
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.modifier);
    }

    public boolean isPrimitive() {
        return false;
    }
}

