/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.compiler;

import com.evermind.compiler.CompilationException;
import com.evermind.compiler.CompilerFactory;
import com.evermind.compiler.FileLinkedCompiler;
import com.evermind.util.CompilerProperties;
import com.evermind.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.StringTokenizer;

public final class ExternalJavac
extends FileLinkedCompiler {
    static final int OUTPUT_BUFFER_SIZE = 16384;
    static final int BUFFER_SIZE = 8192;
    private static final String javaHome = System.getProperty("java.home");
    private static final String osName = System.getProperty("os.name").toLowerCase(Locale.US);
    private static final String pathSep = System.getProperty("path.separator");
    private static final boolean isDos = pathSep.equals(";") && osName.indexOf("netware") <= -1;
    private boolean useJavac = true;
    private String javaCompilerPath = null;

    public ExternalJavac() {
        this.init();
    }

    protected void init() {
        super.init();
        try {
            if (CompilerFactory.instance().isJavac()) {
                this.useJavac = true;
                _compiler = "javac";
                this.javaCompilerPath = ExternalJavac.getSystemJavac();
            } else {
                this.useJavac = false;
                this.javaCompilerPath = ExternalJavac.getOtherJavac(CompilerFactory.instance().getDir(), CompilerFactory.instance().getCommand());
            }
        }
        catch (InstantiationException e) {
            if (CompilerFactory.isDebug()) {
                System.err.println("!!! No valid java compiler found !!!");
                System.err.println(e.getMessage());
            }
            this.javaCompilerPath = ExternalJavac.addExtension(CompilerFactory.instance().getCommand());
        }
        if (CompilerProperties.getBuildDebug()) {
            this.dump();
        }
    }

    protected void dump() {
        System.out.println("javaHome          " + javaHome);
        System.out.println("osName            " + osName);
        System.out.println("pathSep           " + pathSep);
        System.out.println("useJavac          " + this.useJavac);
        System.out.println("javaCompilerPath  " + this.javaCompilerPath);
    }

    public boolean invokeCompiler(String[] args, String firstFileName) throws CompilationException {
        boolean retCode;
        block3: {
            String[] computedArgs = this.computeArgs(args, firstFileName);
            retCode = this.compile(computedArgs);
            if (FileLinkedCompiler.DELETE_INTERMEDIATE_FILES) {
                try {
                    new File(this.getJavacParamsFileName()).delete();
                }
                catch (SecurityException e) {
                    if (!CompilerProperties.getBuildDebug()) break block3;
                    System.out.println("Warning: error trying to delete intermediate file ... " + e.getMessage());
                }
            }
        }
        return retCode;
    }

    public static File normalize(String path) {
        return new File(path);
    }

    public static String getExtClasspath() {
        String extDir = CompilerFactory.instance().getExt();
        StringBuffer extClassPath = new StringBuffer();
        File dir = ExternalJavac.normalize(extDir = extDir != null ? ExternalJavac.stripPath(extDir) : ExternalJavac.stripPath(javaHome + File.separator + "lib" + File.separator + "ext"));
        if (!dir.isDirectory()) {
            String extProp = System.getProperty("java.ext.dirs");
            if (extProp != null) {
                extDir = extProp;
            } else {
                return null;
            }
        }
        extClassPath.append(extDir);
        String[] dirs = dir.list();
        File file = null;
        String jar = null;
        for (int i = 0; i < dirs.length; ++i) {
            file = new File(dirs[i]);
            jar = file.getAbsolutePath();
            extClassPath.append(File.pathSeparatorChar + jar);
        }
        return extClassPath.toString();
    }

    public static String getBootClassPath() {
        String jdkHome = ExternalJavac.stripPath(javaHome);
        StringBuffer bootClassPath = new StringBuffer();
        bootClassPath.append(jdkHome + File.separator + "lib" + File.separator + "rt.jar");
        bootClassPath.append(File.pathSeparatorChar);
        bootClassPath.append(jdkHome + File.separator + "jre" + File.separator + "lib" + File.separator + "rt.jar");
        bootClassPath.append(File.pathSeparatorChar);
        bootClassPath.append(jdkHome + File.separator + ".." + File.separator + "Classes" + File.separator + "classes.jar");
        bootClassPath.append(File.pathSeparatorChar);
        bootClassPath.append(jdkHome + File.separator + ".." + File.separator + "Classes" + File.separator + "ui.jar");
        String path = bootClassPath.toString();
        path = path.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        return path.toString();
    }

    private String getJavacCompiler() throws InstantiationException {
        Object javac = null;
        String path = null;
        if (CompilerProperties.getBuildDebug()) {
            System.out.println("Getting " + _compiler + " ...");
        }
        if (_compiler.equalsIgnoreCase("Javac")) {
            path = ExternalJavac.getSystemJavac();
        }
        if (_compiler.equalsIgnoreCase("Ojc")) {
            path = ExternalJavac.getOtherJavac(_compilerDir, "ojc");
        }
        if (_compiler.equalsIgnoreCase("Jikes")) {
            path = ExternalJavac.getOtherJavac(_compilerDir, "jikes");
        }
        if (CompilerProperties.getBuildDebug()) {
            System.out.println("Got " + _compiler + " ." + path);
        }
        return path;
    }

    private static String addExtension(String command) {
        if (isDos) {
            if (command.endsWith(".exe")) {
                return command;
            }
            return command + ".exe";
        }
        return command;
    }

    private static File findInDir(String dirName, String commandName) {
        File dir;
        File executable = null;
        if (dirName != null && commandName != null && (dir = ExternalJavac.normalize(dirName)).isDirectory() && !(executable = new File(dir, ExternalJavac.addExtension(commandName))).exists()) {
            executable = null;
        }
        return executable;
    }

    public static String getJdkExecutable(String command) throws InstantiationException {
        if (osName.indexOf("netware") > -1) {
            return command;
        }
        File jExecutable = null;
        String jdkHome = null;
        jdkHome = _compilerDir != null ? ExternalJavac.stripPath(_compilerDir) : ExternalJavac.stripPath(javaHome);
        if (jdkHome.endsWith("jre")) {
            jdkHome = jdkHome.substring(0, jdkHome.length() - 3);
        }
        jdkHome = ExternalJavac.stripPath(jdkHome);
        if (osName.equals("aix")) {
            jExecutable = ExternalJavac.findInDir(jdkHome + File.separator + "sh", command);
        }
        if (jExecutable == null) {
            jExecutable = ExternalJavac.findInDir(jdkHome + File.separator + "bin", command);
        }
        if (jExecutable == null) {
            jExecutable = ExternalJavac.findInDir(jdkHome, command);
        }
        if (jExecutable != null) {
            return jExecutable.getAbsolutePath();
        }
        throw new InstantiationException(ExternalJavac.addExtension(command) + " not found under " + jdkHome + ", please use a valid jdk or specify the location of your java compiler in server.xml using the <java-compiler .../> tag");
    }

    private static String stripPath(String path) {
        if (path == null) {
            return path;
        }
        String retPath = null;
        char lastchar = path.charAt(path.length() - 1);
        retPath = (lastchar == '\\' || lastchar == '/') && path.length() > 1 ? path.substring(0, path.length() - 1) : path;
        return retPath;
    }

    protected static String getSystemJavac() throws InstantiationException {
        return ExternalJavac.getJdkExecutable(ExternalJavac.addExtension("javac"));
    }

    protected static String getOtherJavac(String home, String command) throws InstantiationException {
        File jExecutable = null;
        jExecutable = ExternalJavac.findInDir(home, ExternalJavac.addExtension(command));
        if (jExecutable != null) {
            return jExecutable.getAbsolutePath();
        }
        throw new InstantiationException(ExternalJavac.addExtension(command) + " not found under " + home + ", specify the correct location of " + ExternalJavac.addExtension(command) + " in server.xml using the <java-compiler .../> tag");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] computeArgs(String[] args, String firstFileName) throws CompilationException {
        String[] i222;
        File tmpFile = null;
        String argsCmd = Arrays.asList(args).toString();
        PrintWriter out = null;
        String location = this.getJavacParamsFileName();
        try {
            try {
                tmpFile = new File(location);
                out = new PrintWriter(new FileWriter(tmpFile));
                for (int i222 = 0; i222 < args.length; ++i222) {
                    if (args[i222] == null) continue;
                    if (args[i222].indexOf(32) >= 0) {
                        out.println(StringUtils.dq(StringUtils.replace(args[i222], "\\", "\\\\")));
                        continue;
                    }
                    out.println(args[i222]);
                }
                out.flush();
                i222 = new String[]{"@" + tmpFile};
                Object var9_10 = null;
                if (out == null) return i222;
            }
            catch (IOException e) {
                throw new CompilationException("Error creating temporary file" + e + " @ " + location);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (Throwable t) {
                throw throwable;
            }
        }
        try {}
        catch (Throwable t) {
            // empty catch block
            return i222;
        }
        out.close();
        return i222;
    }

    private String getJavacParamsFileName() {
        String javacParamsFileName = CompilerFactory.instance().getTempDir() + File.separator + "javac.params." + Thread.currentThread().hashCode();
        return javacParamsFileName;
    }

    protected void compile(String[] args, String firstFileName) throws InstantiationException, CompilationException {
        try {
            if (CompilerProperties.getBuildDebug()) {
                System.out.println("Start Compilation using " + _compiler);
            }
            if (_compiler.equalsIgnoreCase("Javac")) {
                if (CompilerProperties.getBuildDebug()) {
                    System.out.println("Using External Javac Compiler...");
                }
                this.invokeCompiler(args, firstFileName);
            } else if (_compiler.equalsIgnoreCase("Ojc")) {
                if (CompilerProperties.getBuildDebug()) {
                    System.out.println("Using External OJC Compiler...");
                }
                this.invokeCompiler(args, firstFileName);
            } else if (_compiler.equalsIgnoreCase("Jikes")) {
                if (CompilerProperties.getBuildDebug()) {
                    System.out.println("Using External Jikes Compiler...");
                }
                this.invokeCompiler(args, firstFileName);
            }
        }
        catch (NoClassDefFoundError e) {
            throw new CompilationException("Javac not found (" + e.getMessage() + ")");
        }
    }

    protected String[] getCompilerArgs(String sourceDirectory, String targetDirectory, String encoding, String classpath) {
        int pos = 0;
        int size = 2;
        if (sourceDirectory != null) {
            size += 2;
        }
        if (targetDirectory != null) {
            size += 2;
        }
        if (encoding != null) {
            size += 2;
        }
        ++size;
        if (_compiler.equalsIgnoreCase("Jikes")) {
            size += 4;
            if (encoding != null) {
                size -= 2;
            }
        }
        String[] compilerArgs = new String[size];
        compilerArgs[pos++] = "-classpath";
        compilerArgs[pos++] = classpath + File.pathSeparatorChar + '.';
        if (encoding != null && !_compiler.equalsIgnoreCase("Jikes")) {
            compilerArgs[pos++] = "-encoding";
            compilerArgs[pos++] = encoding;
        }
        if (_compiler.equalsIgnoreCase("Jikes")) {
            compilerArgs[pos++] = "-bootclasspath";
            compilerArgs[pos++] = ExternalJavac.getBootClassPath();
            compilerArgs[pos++] = "-extdirs";
            compilerArgs[pos++] = ExternalJavac.getExtClasspath();
        }
        if (sourceDirectory != null) {
            compilerArgs[pos++] = "-sourcepath";
            compilerArgs[pos++] = sourceDirectory;
        }
        if (targetDirectory != null) {
            compilerArgs[pos++] = "-d";
            compilerArgs[pos++] = targetDirectory;
        }
        compilerArgs[pos++] = CompilerProperties.getKeepWrapperCode() ? "-g" : "-O";
        return compilerArgs;
    }

    private int parseCompilerOptions(ArrayList newOptions) {
        int numberOfOptions = 0;
        boolean isOjc = _compiler.equalsIgnoreCase("ojc");
        if (this.useJavac || isOjc) {
            StringTokenizer st = new StringTokenizer(_compilerOptions);
            while (st.hasMoreTokens()) {
                String option = st.nextToken();
                ++numberOfOptions;
                newOptions.add(option);
            }
        }
        if (!this.useJavac) {
            newOptions.add("-nowarn");
            ++numberOfOptions;
        }
        return numberOfOptions;
    }

    public boolean compile(String[] args) throws CompilationException {
        boolean isOkay;
        int i;
        int exitValue = -1;
        ArrayList newOptions = new ArrayList();
        int numberOfOptions = this.parseCompilerOptions(newOptions);
        String[] compilerCmd = new String[1 + numberOfOptions + args.length];
        compilerCmd[0] = this.javaCompilerPath;
        for (i = 0; i < numberOfOptions; ++i) {
            String option;
            compilerCmd[i + 1] = option = (String)newOptions.get(i);
        }
        System.arraycopy(args, 0, compilerCmd, 1 + numberOfOptions, args.length);
        if (CompilerProperties.getBuildDebug()) {
            System.out.println("Args: " + Arrays.asList(compilerCmd));
        }
        for (i = 0; i < compilerCmd.length; ++i) {
            if (compilerCmd[i] != null) continue;
            if (CompilerProperties.getBuildDebug()) {
                System.out.println("Index " + i + " is null !!!");
            }
            compilerCmd[i] = "";
        }
        ByteArrayOutputStream tmpErr = new ByteArrayOutputStream(16384);
        ByteArrayOutputStream tmpOut = new ByteArrayOutputStream(16384);
        try {
            Process process = Runtime.getRuntime().exec(compilerCmd);
            BufferedInputStream compilerErr = new BufferedInputStream(process.getErrorStream());
            BufferedInputStream compilerOut = new BufferedInputStream(process.getInputStream());
            StreamPumper errPumper = new StreamPumper(compilerErr, tmpErr);
            StreamPumper outPumper = new StreamPumper(compilerOut, tmpOut);
            errPumper.start();
            outPumper.start();
            process.waitFor();
            exitValue = process.exitValue();
            errPumper.join();
            compilerErr.close();
            outPumper.join();
            compilerOut.close();
            process.destroy();
            tmpErr.close();
            tmpErr.writeTo(this.outputStream);
            this.errBuff = tmpErr.toByteArray();
            tmpOut.close();
            tmpOut.writeTo(this.outputStream);
        }
        catch (IOException ioe) {
            throw new CompilationException(ioe.getMessage());
        }
        catch (InterruptedException ie) {
            return false;
        }
        boolean bl = isOkay = exitValue == 0;
        if (tmpErr.size() > 0) {
            isOkay = false;
            if (tmpErr.toString().length() > 7) {
                String trimmedString;
                block13: {
                    if (FileLinkedCompiler.DELETE_INTERMEDIATE_FILES) {
                        try {
                            new File(this.getJavacParamsFileName()).delete();
                        }
                        catch (SecurityException e) {
                            if (!CompilerProperties.getBuildDebug()) break block13;
                            System.out.println("Warning: error trying to delete intermediate file ... " + e.getMessage());
                        }
                    }
                }
                if ((trimmedString = tmpErr.toString().replace('\n', ' ').trim()).substring(trimmedString.length() - 5).equals("error") || trimmedString.substring(trimmedString.length() - 6).equals("errors")) {
                    throw new CompilationException("compilation error occurred");
                }
            }
        }
        return isOkay;
    }

    public boolean needsSecurityManager() {
        return false;
    }

    public void checkIfValid() throws InstantiationException {
        this.getJavacCompiler();
    }

    static class StreamPumper
    extends Thread {
        private BufferedInputStream stream;
        private boolean endOfStream = false;
        private int SLEEP_TIME = 100;
        private OutputStream out;

        public StreamPumper(BufferedInputStream is, OutputStream out) {
            this.stream = is;
            this.out = out;
        }

        public void pumpStream() throws IOException {
            byte[] buf = new byte[8192];
            if (!this.endOfStream) {
                int bytesRead = this.stream.read(buf, 0, 8192);
                if (bytesRead > 0) {
                    this.out.write(buf, 0, bytesRead);
                } else if (bytesRead == -1) {
                    this.endOfStream = true;
                }
            }
        }

        public void run() {
            try {
                while (!this.endOfStream) {
                    this.pumpStream();
                    StreamPumper.sleep(this.SLEEP_TIME);
                }
            }
            catch (InterruptedException ie) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

