/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.client.textcleaner;

import com.evermind.io.ExtensionFileFilter;
import com.evermind.io.FileIterator;
import com.evermind.io.IOUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;

public class TextCleaner {
    private boolean verbose;
    private String endLine;
    private File file;
    private List suffixes;

    public TextCleaner(File file, String endLine, boolean verbose, List suffixes) {
        this.file = file;
        this.verbose = verbose;
        this.endLine = endLine;
        this.suffixes = suffixes;
    }

    public static void main(String[] args) throws IOException {
        boolean verbose = true;
        if (args.length < 2) {
            System.err.println("Usage: textcleaner [-n/-rn/-r] [-verbose] directory extension1 ... extensionN");
            return;
        }
        String endLine = "\r\n";
        if (args[0].equals("-n")) {
            endLine = "\n";
        } else if (args[0].equals("-r")) {
            endLine = "\r";
        } else if (args[0].equals("-rn")) {
            endLine = "\r\n";
        }
        List<String> suffixes = Arrays.asList(args).subList(2, args.length);
        new TextCleaner(new File(args[1]), endLine, verbose, suffixes);
    }

    public void clean() throws IOException {
        FileIterator iterator = new FileIterator(this.file, new ExtensionFileFilter(this.suffixes.isEmpty() ? null : this.suffixes, false));
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (this.verbose) {
                System.out.println("Parsing " + file + "...");
            }
            TextCleaner.parseFile(file, this.endLine);
        }
    }

    public static void parseFile(File file, String endLine) throws IOException {
        String line;
        byte[] content = IOUtils.getContent(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(content)));
        FileWriter out = new FileWriter(file);
        PrintWriter writer = new PrintWriter(out);
        while ((line = reader.readLine()) != null) {
            writer.print(line);
            writer.print(endLine);
        }
        writer.flush();
        ((Writer)out).close();
    }
}

