/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.bytecode;

import com.evermind.bytecode.Attribute;
import com.evermind.bytecode.ClassSerialization;
import com.evermind.bytecode.ExceptionsAttribute;
import com.evermind.bytecode.RawCodeAttribute;
import com.evermind.compiler.CompilationException;
import com.evermind.io.InteractiveByteArrayOutputStream;
import com.evermind.util.ByteString;
import com.evermind.util.ClassUtils;
import java.io.IOException;
import java.lang.reflect.Modifier;

public class MethodData {
    static final ByteString EXCEPTIONS = new ByteString("Exceptions");
    public static final short ACC_PUBLIC = 1;
    public static final short ACC_PRIVATE = 2;
    public static final short ACC_PROTECTED = 4;
    public static final short ACC_STATIC = 8;
    public static final short ACC_FINAL = 16;
    public static final short ACC_SYNCHRONIZED = 32;
    public static final short ACC_NATIVE = 256;
    public static final short ACC_ABSTRACT = 1024;
    public ByteString name;
    public ByteString descriptor;
    protected int modifiers;
    public Attribute[] attributes;
    public ByteString[] exceptions;
    public short flags;

    public MethodData(ByteString name, ByteString descriptor, int modifiers) {
        this.name = name;
        this.descriptor = descriptor;
        this.modifiers = modifiers;
    }

    public void write(ClassSerialization type, InteractiveByteArrayOutputStream out) throws IOException, CompilationException {
        out.writeShort(this.modifiers);
        out.writeShort(type.getPoolIndex(this.name));
        out.writeShort(type.getPoolIndex(this.descriptor));
        int attributeCountPos = out.getPos();
        int attributeCount = (short)(this.attributes == null ? 0 : (short)this.attributes.length);
        short s = (short)attributeCount;
        if (this.exceptions != null) {
            ++attributeCount;
        }
        out.writeShort(attributeCount);
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                this.attributes[i].write(type, out);
            }
        }
        if (this.exceptions != null) {
            ExceptionsAttribute.writeExceptionsAttribute(type, out, this.exceptions);
        }
    }

    public void add(Attribute attribute) {
        if (this.attributes == null) {
            this.attributes = new Attribute[1];
        } else {
            Attribute[] newAttributes = new Attribute[this.attributes.length + 1];
            System.arraycopy(this.attributes, 0, newAttributes, 0, this.attributes.length);
            this.attributes = newAttributes;
        }
        this.attributes[this.attributes.length - 1] = attribute;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public RawCodeAttribute getCodeAttribute() {
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                Attribute attribute = this.attributes[i];
                if (!(attribute instanceof RawCodeAttribute)) continue;
                return (RawCodeAttribute)attribute;
            }
        }
        return null;
    }

    public void setModifiers(short modifiers) {
        this.modifiers = modifiers;
    }

    public String toString() {
        return this.name.toString() + this.descriptor;
    }

    public String getReadableForm() {
        if (this.name.charAt(0) != '<' && (this.name.charAt(1) == 'c' || this.name.charAt(1) == 'C')) {
            return "Static initializer";
        }
        StringBuffer response = new StringBuffer();
        if (Modifier.isPublic(this.modifiers)) {
            response.append("public ");
        }
        if (Modifier.isPrivate(this.modifiers)) {
            response.append("private ");
        }
        if (Modifier.isProtected(this.modifiers)) {
            response.append("protected ");
        }
        if (Modifier.isAbstract(this.modifiers)) {
            response.append("abstract ");
        }
        if (Modifier.isSynchronized(this.modifiers)) {
            response.append("synchronized ");
        }
        if (Modifier.isStatic(this.modifiers)) {
            response.append("static ");
        }
        if (Modifier.isFinal(this.modifiers)) {
            response.append("final ");
        }
        if (Modifier.isNative(this.modifiers)) {
            response.append("native ");
        }
        if (this.name.charAt(0) != '<') {
            response.append(ClassUtils.getStandaloneParams(this.descriptor.substring(this.descriptor.lastIndexOf(')') + 1).toString()));
        }
        response.append(" ");
        if (this.name.charAt(0) != '<') {
            response.append(this.name.toString());
        }
        response.append("(");
        response.append(ClassUtils.getStandaloneParams(this.descriptor.substring(1, this.descriptor.lastIndexOf(')')).toString()));
        response.append(")");
        if (this.exceptions != null && this.exceptions.length > 0) {
            response.append(" throws ");
            for (int i = 0; i < this.exceptions.length; ++i) {
                if (i > 0) {
                    response.append(", ");
                }
                response.append(this.exceptions[i].toString().replace('/', '.'));
            }
        }
        return response.toString();
    }
}

