/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.bytecode;

import com.evermind.bytecode.BasicAttribute;
import com.evermind.bytecode.ClassSerialization;
import com.evermind.bytecode.MethodData;
import com.evermind.io.InteractiveByteArrayOutputStream;
import com.evermind.util.ByteString;
import java.io.DataInputStream;
import java.io.IOException;

public class ExceptionsAttribute
extends BasicAttribute {
    private ByteString[] exceptions;

    public ExceptionsAttribute(ClassSerialization type, DataInputStream in) throws IOException {
        super(MethodData.EXCEPTIONS);
        short count = in.readShort();
        this.exceptions = new ByteString[count];
        for (int i = 0; i < this.exceptions.length; ++i) {
            this.exceptions[i] = type.getClassEntry(in.readShort());
        }
    }

    public ByteString[] getExceptions() {
        return this.exceptions;
    }

    public static void writeExceptionsAttribute(ClassSerialization type, InteractiveByteArrayOutputStream out, ByteString[] exceptions) throws IOException {
        out.writeShort(type.getPoolIndex(MethodData.EXCEPTIONS));
        out.writeInt(2 + exceptions.length * 2);
        out.writeShort(exceptions.length);
        for (int i = 0; i < exceptions.length; ++i) {
            out.writeShort(type.getClassPoolIndex(exceptions[i]));
        }
    }
}

