/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.bytecode;

import com.evermind.bytecode.BasicAttribute;
import com.evermind.bytecode.ClassSerialization;
import com.evermind.bytecode.CodeOutputStream;
import com.evermind.bytecode.ExceptionRegion;
import com.evermind.compiler.CompilationException;
import com.evermind.io.InteractiveByteArrayOutputStream;
import com.evermind.util.ByteString;
import java.io.IOException;
import java.util.List;

public class CodeAttribute
extends BasicAttribute {
    public CodeOutputStream codeOut;
    public ByteString sourceFile;

    public CodeAttribute() {
        super(ClassSerialization.CODE);
    }

    protected void writeContent(ClassSerialization type, InteractiveByteArrayOutputStream out) throws IOException, CompilationException {
        CodeOutputStream codeOut;
        int localsPos = out.getPos();
        out.writeInt(0);
        int codeLengthPos = out.getPos();
        out.writeInt(0);
        this.codeOut = codeOut = new CodeOutputStream(out, type);
        this.writeCode(codeOut);
        int newPos = out.getPos();
        out.setPos(localsPos);
        out.writeShort(codeOut.getMaxStack());
        out.writeShort(codeOut.getMaxLocals());
        out.setPos(newPos);
        out.setPos(codeLengthPos);
        out.writeInt(newPos - (codeLengthPos + 4));
        out.setPos(newPos);
        List exceptions = codeOut.getExceptions();
        CodeAttribute.writeExceptions(type, exceptions, out);
        int attributeCount = 0;
        int lineNumbers = codeOut.getLineNumberCount();
        if (lineNumbers != 0) {
            ++attributeCount;
        }
        out.writeShort(attributeCount);
        if (lineNumbers != 0 && lineNumbers != 0) {
            out.writeShort(type.getPoolIndex(new ByteString("LineNumberTable")));
            out.writeInt(2 + codeOut.getLineNumberCount() * 4);
            int[] lines = codeOut.getLineNumbers();
            out.writeShort(lineNumbers);
            for (int y = 0; y < lineNumbers; ++y) {
                out.writeInt(lines[y]);
            }
        }
    }

    public static void writeExceptions(ClassSerialization type, List exceptions, InteractiveByteArrayOutputStream out) throws IOException {
        out.writeShort(exceptions.size());
        for (int i = 0; i < exceptions.size(); ++i) {
            ExceptionRegion region = (ExceptionRegion)exceptions.get(i);
            out.writeShort(region.getStart());
            out.writeShort(region.getEnd());
            out.writeShort(region.getHandler());
            if (region.getTypeName() == null) {
                out.writeShort(0);
                continue;
            }
            out.writeShort(type.getClassPoolIndex(region.getTypeName()));
        }
    }

    protected void writeCode(CodeOutputStream out) throws IOException, CompilationException {
    }
}

