/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.dms.instrument.Noun;
import oracle.dms.reporter.MetricTreeletNode;
import oracle.dms.reporter.TreeletNode;

class NounTreeletNode
extends TreeletNode {
    Map m_nouns = new HashMap();
    Map m_metrics = new HashMap();

    NounTreeletNode(Noun noun) {
        super(noun);
    }

    NounTreeletNode(String string, NounTreeletNode nounTreeletNode, Noun noun) {
        super(string, nounTreeletNode, noun);
        this.m_parent.addNoun(this.m_name, this);
    }

    String getTable() {
        Noun noun = (Noun)this.m_mappedNode;
        return noun.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        TreeletNode treeletNode;
        Map.Entry entry;
        Iterator iterator;
        super.clear();
        Map map = this.m_nouns;
        synchronized (map) {
            iterator = this.m_nouns.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                treeletNode = (TreeletNode)entry.getValue();
                treeletNode.clear();
            }
            this.m_nouns.clear();
        }
        map = this.m_metrics;
        synchronized (map) {
            iterator = this.m_metrics.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                treeletNode = (TreeletNode)entry.getValue();
                treeletNode.clear();
            }
            this.m_metrics.clear();
        }
    }

    final MetricTreeletNode findMetric(String string) {
        if (string == null) {
            return null;
        }
        return (MetricTreeletNode)this.m_metrics.get(string);
    }

    final NounTreeletNode findNoun(String string) {
        if (string == null) {
            return null;
        }
        return (NounTreeletNode)this.m_nouns.get(string);
    }

    final Collection getNouns(boolean bl) {
        if (!bl) {
            return this.m_nouns.values();
        }
        ArrayList arrayList = new ArrayList(this.m_nouns.values());
        Collections.sort(arrayList);
        return arrayList;
    }

    final Collection getMetrics(boolean bl) {
        if (!bl) {
            return this.m_metrics.values();
        }
        ArrayList arrayList = new ArrayList(this.m_metrics.values());
        Collections.sort(arrayList);
        return arrayList;
    }

    final void addNoun(String string, NounTreeletNode nounTreeletNode) {
        if (string == null || nounTreeletNode == null) {
            return;
        }
        this.m_nouns.put(string, nounTreeletNode);
    }

    final void addMetric(String string, MetricTreeletNode metricTreeletNode) {
        if (string == null || metricTreeletNode == null) {
            return;
        }
        this.m_metrics.put(string, metricTreeletNode);
    }
}

