/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.util.Map;
import oracle.dms.instrument.ExecutionContext;
import oracle.dms.instrument.TransTrace;

public class ExecutionContextForJDBC {
    public static final int ACTION_INDEX = 0;
    public static final int CLIENTID_INDEX = 1;
    public static final int ECID_INDEX = 2;
    public static final int MODULE_INDEX = 3;
    public static final int STATE_INDEX_MAX = 4;
    private static final int[] s_limits = new int[4];
    private String[] m_cached = null;
    private boolean m_statsSet = false;

    public static String[] getExecutionContextState() {
        String[] stringArray = null;
        try {
            ExecutionContext executionContext = ExecutionContext.get();
            ExecutionContextForJDBC executionContextForJDBC = executionContext.getJdbcCtx();
            if (executionContextForJDBC != null) {
                stringArray = executionContextForJDBC.getExecutionContextState(executionContext);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    private String[] getExecutionContextState(ExecutionContext executionContext) {
        if (this.m_cached == null) {
            if (!this.m_statsSet && TransTrace._isEcidEnabled()) {
                this.m_statsSet = true;
            }
            if (this.m_statsSet) {
                Map map = executionContext.getAttributeMap();
                String string = (String)map.get("Action");
                String string2 = (String)map.get("ClientID");
                String string3 = (String)map.get("ECID_UID");
                String string4 = (String)map.get("Module");
                this.m_cached = new String[4];
                this.setValue(string, 0);
                this.setValue(string2, 1);
                this.setValue(string3, 2);
                this.setValue(string4, 3);
            }
        }
        return this.m_cached;
    }

    private void setValue(String string, int n) {
        if (this.m_cached != null) {
            this.m_cached[n] = string == null || string.length() <= s_limits[n] ? string : string.substring(0, s_limits[n] - 1);
        }
    }

    public static int getECIDSequenceNumber() {
        int n = 0;
        try {
            ExecutionContext executionContext = ExecutionContext.get();
            n = executionContext.getECIDSequenceNumber();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public static int getLimit(int n) {
        if (n < 0 || n >= 4) {
            return -1;
        }
        return s_limits[n];
    }

    void invalidate() {
        this.m_cached = null;
    }

    static {
        ExecutionContextForJDBC.s_limits[0] = 32;
        ExecutionContextForJDBC.s_limits[1] = 64;
        ExecutionContextForJDBC.s_limits[2] = 64;
        ExecutionContextForJDBC.s_limits[3] = 48;
    }
}

