/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.clock;

import java.util.HashMap;
import oracle.dms.clock.Clock;
import oracle.dms.clock.ClockState;

public class ClockManager {
    public static boolean DEBUG = false;
    private static HashMap _clocks = new HashMap();
    private static Clock _primary = null;
    public static final String DEFAULT = "default";
    public static final String LOGICAL = "logical";
    public static final String HIGHRES = "highres";
    private static HashMap _clockmap = new HashMap();
    public static final long TICKS = 1L;
    public static final long MSECS = 1000L;
    public static final long USECS = 1000000L;
    public static final long NSECS = 1000000000L;
    private static HashMap _unitmap;

    public static synchronized void shutdown() {
        _clocks.clear();
        _primary = null;
        ClockState.shutdown();
    }

    public static Clock getClock() {
        if (_primary == null) {
            Clock clock;
            _primary = clock = ClockManager.createClock(DEFAULT);
        }
        return _primary;
    }

    public static Clock createClock(String string) {
        Clock clock;
        if (DEBUG) {
            System.out.println("Checking if clock (" + string + ") is loaded");
        }
        String string2 = null;
        if (string.equalsIgnoreCase(HIGHRES) && !ClockManager.validHighRes()) {
            string = DEFAULT;
        }
        if ((clock = (Clock)_clocks.get(string)) != null) {
            return clock;
        }
        string2 = (String)_clockmap.get(string);
        if (DEBUG) {
            System.out.println("The class name for (" + string + ") is " + string2);
        }
        if (string2 == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(string2);
            if (DEBUG) {
                System.out.println("Called Class.forName(\"" + string2 + "\")");
            }
            clock = (Clock)clazz.newInstance();
            if (DEBUG) {
                System.out.println("Created a new instance of " + string2);
            }
            _clocks.put(string.toLowerCase(), clock);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.err.println("Can't find or load class " + string2);
            return null;
        }
        return clock;
    }

    public static long getFrequency(String string) {
        Long l;
        if (string != null && (l = (Long)_unitmap.get(string.toLowerCase())) != null) {
            return l;
        }
        return ClockManager.getClock().getReportedFrequency();
    }

    public static String getUnits(long l) {
        String string = (String)_unitmap.get(new Long(l));
        if (string != null) {
            return string;
        }
        return ClockManager.getClock().getUnits();
    }

    public static Clock setClock(String string) {
        Clock clock = ClockManager.createClock(string);
        if (clock != null) {
            _primary = clock;
        } else {
            clock = ClockManager.getClock();
        }
        return clock;
    }

    private static boolean validHighRes() {
        try {
            System.loadLibrary("dms2");
            if (DEBUG) {
                System.err.println("Loaded dms2 lib");
            }
            return true;
        }
        catch (Throwable throwable) {
            try {
                System.loadLibrary("yod");
                if (DEBUG) {
                    System.err.println("Loaded yod lib");
                }
                return true;
            }
            catch (Throwable throwable2) {
                if (DEBUG) {
                    System.err.println("Couldn't load lib for high resolution clock, using default clock instead.");
                }
                return false;
            }
        }
    }

    static {
        _clockmap.put(DEFAULT, "oracle.dms.clock.SimpleClock");
        _clockmap.put(LOGICAL, "oracle.dms.clock.LogicalClock");
        _clockmap.put(HIGHRES, "oracle.dms.clock.HighResolutionClock");
        _unitmap = new HashMap();
        _unitmap.put("ticks", new Long(1L));
        _unitmap.put("msecs", new Long(1000L));
        _unitmap.put("usecs", new Long(1000000L));
        _unitmap.put("nsecs", new Long(1000000000L));
        _unitmap.put(new Long(1L), "ticks");
        _unitmap.put(new Long(1000L), "msecs");
        _unitmap.put(new Long(1000000L), "usecs");
        _unitmap.put(new Long(1000000000L), "nsecs");
    }
}

