/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxResultSet;
import com.informix.jdbc.IfxBlob;
import com.informix.jdbc.IfxCallableStatement;
import com.informix.jdbc.IfxCollection;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxFParam;
import com.informix.jdbc.IfxLob;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSmBlob;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxSqli;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxUpdateResultSet;
import com.informix.jdbc.ResultSet2;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class IfxResultSet
extends IfxUpdateResultSet
implements IfmxResultSet,
ResultSet2 {
    static final int DIR_FIRST = 3;
    static final int DIR_LAST = 4;
    static final int DIR_ABSL = 6;
    static final int DIR_NEXT = 1;
    static final int DIR_PREV = 2;
    static final int DIR_RELT = 7;
    static final int DIR_CURR = 5;
    protected IfxProtocol prot;
    protected HashMap nameToIdxTable;
    protected int curRowID;
    protected int LastRowID;
    protected boolean lastColWasNull;
    protected Vector colVector;
    protected Vector keyNameVector;
    protected boolean noMoreRows;
    static final int IS_XA_TX = 1;
    private int txType;
    protected boolean isClosed;
    private IfxSmBlob sval = null;
    private int FetchSize = 0;

    IfxResultSet(IfxStatement ifxStatement) throws SQLException {
        this.conn = (IfxConnection)ifxStatement.getConnection();
        try {
            Class<?> clazz = Class.forName(this.conn.getProtoClassName());
            Class<?> clazz2 = Class.forName(this.conn.getConnClassName());
            Class[] classArray = new Class[]{clazz2};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this.conn};
            this.prot = (IfxProtocol)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79735, exception.toString(), this.conn);
        }
        this.stmt = ifxStatement;
        this.setResultSetTxType();
    }

    public IfxResultSet() throws SQLException {
    }

    void init() {
        this.isClosed = false;
    }

    protected void setTrace(Trace trace) {
    }

    void executePrepare() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.prot.executePrepare(this.stmt);
    }

    public void executeQuery() throws SQLException {
        this.executeQuery(false);
    }

    void executeQuery(boolean bl) throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.setResultSetTxType();
        this.prot.executeStatementQuery(this.stmt, bl);
        this.curRowID = 0;
        this.LastRowID = 0;
        this.rsmd = (IfxResultSetMetaData)this.getMetaData();
    }

    void executeQuery(IfxResultSetMetaData ifxResultSetMetaData) throws SQLException {
        this.executeQuery(ifxResultSetMetaData, false);
    }

    void executeQuery(IfxResultSetMetaData ifxResultSetMetaData, boolean bl) throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.setResultSetTxType();
        this.prot.executeStatementQuery(this.stmt, bl, ifxResultSetMetaData);
        this.curRowID = 0;
        this.LastRowID = 0;
    }

    int executeUpdate() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.setResultSetTxType();
        if (this.stmt instanceof IfxPreparedStatement && !((IfxSqliConnect)this.conn).usePut) {
            Vector vector = ((IfxPreparedStatement)this.stmt).getVector();
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                block10: {
                    IfxObject ifxObject = (IfxObject)vector.elementAt(n2);
                    if (ifxObject instanceof IfxSmBlob) {
                        IfxSmBlob ifxSmBlob = (IfxSmBlob)ifxObject;
                        try {
                            short s = ifxSmBlob.blobType;
                            if (s != 2) {
                                if (s != 1) break block10;
                            }
                            if (ifxSmBlob.sm_size >= 0L) {
                                ifxSmBlob.createBlobOnServer(ifxSmBlob.BlobInputStream, (int)ifxSmBlob.sm_size);
                            }
                        }
                        catch (SQLException sQLException) {
                            if (n2 < n) {
                                // empty if block
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        this.prot.executeCommand(this.stmt);
        this.curRowID = 0;
        this.LastRowID = 0;
        return this.prot.getNumberOfRowsProcessed();
    }

    Vector executeFastPath(String string, Vector vector, boolean bl, boolean bl2) throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.setResultSetTxType();
        this.prot.executeFastPath(string, vector, bl, bl2);
        this.curRowID = 0;
        this.LastRowID = 0;
        return this.prot.getFPReturnVector();
    }

    IfxFParam getFParam() {
        return this.prot.getFParam();
    }

    boolean executeExecute() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.setResultSetTxType();
        if (this.stmt instanceof IfxPreparedStatement && !((IfxSqliConnect)this.conn).usePut) {
            Vector vector = ((IfxPreparedStatement)this.stmt).getVector();
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                block10: {
                    IfxObject ifxObject = (IfxObject)vector.elementAt(n2);
                    if (ifxObject instanceof IfxSmBlob) {
                        IfxSmBlob ifxSmBlob = (IfxSmBlob)ifxObject;
                        try {
                            short s = ifxSmBlob.blobType;
                            if (s != 2) {
                                if (s != 1) break block10;
                            }
                            if (ifxSmBlob.sm_size >= 0L) {
                                ifxSmBlob.createBlobOnServer(ifxSmBlob.BlobInputStream, (int)ifxSmBlob.sm_size);
                            }
                        }
                        catch (SQLException sQLException) {
                            if (n2 < n) {
                                // empty if block
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        this.prot.executeExecute(this.stmt);
        this.curRowID = 0;
        this.LastRowID = 0;
        return this.prot.isResultSet();
    }

    boolean executeExecute(IfxResultSetMetaData ifxResultSetMetaData) throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.setResultSetTxType();
        if (this.stmt instanceof IfxPreparedStatement && !((IfxSqliConnect)this.conn).usePut) {
            Vector vector = ((IfxPreparedStatement)this.stmt).getVector();
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                block10: {
                    IfxObject ifxObject = (IfxObject)vector.elementAt(n2);
                    if (ifxObject instanceof IfxSmBlob) {
                        IfxSmBlob ifxSmBlob = (IfxSmBlob)ifxObject;
                        try {
                            short s = ifxSmBlob.blobType;
                            if (s != 2) {
                                if (s != 1) break block10;
                            }
                            if (ifxSmBlob.sm_size >= 0L) {
                                ifxSmBlob.createBlobOnServer(ifxSmBlob.BlobInputStream, (int)ifxSmBlob.sm_size);
                            }
                        }
                        catch (SQLException sQLException) {
                            if (n2 < n) {
                                // empty if block
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        this.prot.executeExecute(this.stmt, ifxResultSetMetaData);
        this.curRowID = 0;
        this.LastRowID = 0;
        return this.prot.isResultSet();
    }

    /*
     * Unable to fully structure code
     */
    public boolean next() throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        this.releaseBlob();
        if (this.prot == null) {
            return false;
        }
        if (this.txType == 1 && !this.conn.inXATransaction() || this.txType != 1 && this.conn.inXATransaction()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        var1_1 = this.stmt.getMaxRows();
        if (var1_1 != 0 && this.curRowID >= var1_1) {
            return false;
        }
        v0 = var2_2 = this.stmt.getResultSetType() == 1004 ? 1 : 0;
        if (var2_2 == 1) {
            var3_3 = this.prot.getaRow(this.stmt.getFetchDirection(), ++this.curRowID, 6, var2_2, this.stmt);
            this.curRowID = this.prot.getTupid();
        } else {
            var3_3 = this.prot.getaRow(this.stmt.getFetchDirection(), 1, 1, var2_2, this.stmt);
        }
        if (!var3_3) {
            return false;
        }
        if (this.colVector == null) {
            try {
                this.colVector = new Vector<E>();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) ** GOTO lbl35
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) ** GOTO lbl35
                this.UpdateColVector = (Vector)this.colVector.clone();
            }
            catch (SQLException var4_4) {
                throw var4_4;
            }
            catch (Exception var5_5) {
                throw IfxErrMsg.getSQLException(-79716, var5_5.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() == 1008) {
                this.clearUpdateColVector();
            }
        }
lbl35:
        // 6 sources

        if (var2_2 != 1) {
            ++this.curRowID;
        }
        return true;
    }

    public int findColumn(String string) throws SQLException {
        Integer n;
        if (this.nameToIdxTable == null) {
            if (this.rsmd == null) {
                this.getMetaData();
            }
            if (this.rsmd == null) {
                throw IfxErrMsg.getSQLException(-79737, this.conn);
            }
            int n2 = this.rsmd.getColumnCount();
            this.nameToIdxTable = new HashMap(n2);
            int n3 = 1;
            while (n3 <= n2) {
                this.nameToIdxTable.put(this.rsmd.getColumnName(n3), new Integer(n3));
                ++n3;
            }
        }
        if (!this.conn.isDelimIdentSet()) {
            if (this.conn != null && this.conn.isDirect()) {
                string = string.trim();
            }
            n = (Integer)this.nameToIdxTable.get(string.toLowerCase());
        } else {
            n = (Integer)this.nameToIdxTable.get(string);
        }
        if (n == null) {
            throw IfxErrMsg.getSQLException(-79738, this.conn);
        }
        return n;
    }

    IfxObject getValue(int n) throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79868, this.conn);
        }
        if (this.colVector == null) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        if (n < 1 || n > this.colVector.size()) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        IfxObject ifxObject = (IfxObject)this.colVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = this.prot.getColumnInRow(n);
            this.colVector.setElementAt(ifxObject, n - 1);
        } else {
            this.prot.loadColumnData(n, ifxObject);
        }
        if (ifxObject.isNull()) {
            this.lastColWasNull = true;
            return null;
        }
        this.lastColWasNull = false;
        this.blobCheck(ifxObject);
        return ifxObject;
    }

    IfxObject getValueFastPath(int n) throws SQLException {
        IfxObject ifxObject = this.prot.getColumnInRow(n);
        return ifxObject;
    }

    public String getString(int n) throws SQLException {
        String string;
        Object object;
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null) {
            return null;
        }
        if (ifxObject.getClass().getName().endsWith("IfxSmBlob")) {
            object = ((IfxSmBlob)ifxObject).toClob(4);
            string = object.getSubString(1L, (int)object.length());
            ((IfxLob)object).close();
        } else {
            int n2;
            string = ifxObject.toString();
            if (this.stmt != null && (n2 = this.stmt.getMaxFieldSize()) > 0) {
                int n3 = this.rsmd.getColumnType(n);
                if (string.length() > n2 && (n3 == 1 || n3 == 12 || n3 == -1 || n3 == -2 || n3 == -3 || n3 == -4)) {
                    string = string.substring(0, n2);
                }
            }
        }
        object = ifxObject.getWarning();
        if (object != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, ((DataTruncation)object).getDataSize(), ((DataTruncation)object).getTransferSize()));
        }
        return string;
    }

    public String getString(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getString(n);
    }

    public Object getObject(int n) throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        Object object = null;
        object = this.conn != null ? this.getObject(n, this.conn.getTypeMap()) : this.getObject(n, (Map)null);
        return object;
    }

    public Object getObject(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getObject(n);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        InputStream inputStream = ifxObject.extendedID == 11 && ((IfxSqliConnect)this.conn).isConvText() ? ((IfxSqli)this.prot).toClobStream((IfxSmBlob)ifxObject) : ifxObject.toAsciiStream();
        return inputStream;
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getAsciiStream(n);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Reader reader = ifxObject.toCharacterStream();
        return reader;
    }

    public Reader getCharacterStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getCharacterStream(n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        BigDecimal bigDecimal = ifxObject.toDecimal().setScale(n2, 4);
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        int n2 = this.findColumn(string);
        return this.getBigDecimal(n2, n);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        return ifxObject.toDecimal();
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBigDecimal(n);
    }

    public boolean getBoolean(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return false;
        }
        boolean bl = ifxObject.toBoolean();
        return bl;
    }

    public boolean getBoolean(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBoolean(n);
    }

    public short getShort(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0;
        }
        short s = ifxObject.toShort();
        return s;
    }

    public short getShort(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getShort(n);
    }

    public int getInt(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0;
        }
        int n2 = ifxObject.toInt();
        return n2;
    }

    public int getInt(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getInt(n);
    }

    public long getLong(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0L;
        }
        long l = ifxObject.toLong();
        return l;
    }

    public long getLong(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getLong(n);
    }

    public float getFloat(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0.0f;
        }
        float f2 = ifxObject.toFloat();
        return f2;
    }

    public float getFloat(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getFloat(n);
    }

    public byte getByte(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0;
        }
        byte by = ifxObject.toByte();
        return by;
    }

    public byte getByte(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getByte(n);
    }

    public byte[] getBytes(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        byte[] byArray = ifxObject.toBytes();
        return byArray;
    }

    public byte[] getBytes(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBytes(n);
    }

    public Date getDate(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Date date = ifxObject.toDate();
        return date;
    }

    public Date getDate(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getDate(n);
    }

    public double getDouble(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return 0.0;
        }
        double d2 = ifxObject.toDouble();
        return d2;
    }

    public double getDouble(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getDouble(n);
    }

    public Time getTime(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Time time = ifxObject.toTime();
        return time;
    }

    public Time getTime(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getTime(n);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        ifxObject.setConnection(this.conn);
        Timestamp timestamp = ifxObject.toTimestamp();
        return timestamp;
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getTimestamp(n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getUnicodeStream(int).", this.conn);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getUnicodeStream(String).", this.conn);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        InputStream inputStream = ifxObject.toBinaryStream();
        return inputStream;
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBinaryStream(n);
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.prot != null) {
            return this.prot.getWarnings();
        }
        return null;
    }

    public void clearWarnings() throws SQLException {
        if (this.prot != null) {
            this.prot.clearWarnings();
        }
    }

    public String getCursorName() throws SQLException {
        if (this.stmt == null) {
            throw IfxErrMsg.getSQLException(-79740, this.conn);
        }
        return this.stmt.getCursorName();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.rsmd = (IfxResultSetMetaData)this.prot.getMetaData();
        return this.rsmd;
    }

    public Object getObject(int n, Map map) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        Object object = null;
        int n2 = this.rsmd.getColumnType(n);
        if (ifxObject != null && !ifxObject.isNull()) {
            ifxObject.setTypeMap(map);
            object = ifxObject.toObject();
        }
        return object;
    }

    public Object getObject(String string, Map map) throws SQLException {
        int n = this.findColumn(string);
        return this.getObject(n, map);
    }

    public boolean wasNull() throws SQLException {
        return this.lastColWasNull;
    }

    int getUpdateCount() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        if (this.prot.isResultSet()) {
            return -1;
        }
        return this.prot.getNumberOfRowsProcessed();
    }

    boolean isEmptyResultSet() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        return !this.prot.isResultSet() || this.prot.getTupleCount() <= 0;
    }

    public void close() throws SQLException {
        this.isClosed = true;
        this.releaseBlob();
        if (this.prot != null && this.stmt.cursorOpen) {
            this.prot.executeClose(this.stmt);
        }
        if (!(this.stmt instanceof IfxPreparedStatement) && !(this.stmt instanceof IfxCallableStatement)) {
            this.closePrev();
        } else {
            this.clear();
        }
    }

    void clear() {
        if (this.nameToIdxTable != null) {
            this.nameToIdxTable.clear();
            this.nameToIdxTable = null;
        }
        this.lastColWasNull = false;
        this.curRowID = 0;
        this.LastRowID = 0;
        this.clearColumnVector();
        if (this.colVector != null) {
            this.colVector.removeAllElements();
            this.colVector = null;
        }
        if (this.keyNameVector != null) {
            this.keyNameVector.removeAllElements();
            this.keyNameVector = null;
        }
        if (this.WhereVal != null) {
            this.WhereVal.removeAllElements();
            this.WhereVal = null;
        }
    }

    void closePrev() throws SQLException {
        if (this.prot != null) {
            this.prot.executeRelease(this.stmt);
        }
        this.clear();
        if (this.UpdateColVector != null) {
            this.UpdateColVector.removeAllElements();
            this.UpdateColVector = null;
        }
    }

    private void clearColumnVector() {
        if (this.colVector != null) {
            int n = this.colVector.size();
            int n2 = 0;
            while (n2 < n) {
                IfxObject ifxObject = (IfxObject)this.colVector.elementAt(n2);
                if (ifxObject != null) {
                    ifxObject.clear();
                }
                ++n2;
            }
        }
    }

    void closeNow() throws SQLException {
        if (this.prot != null) {
            if (this.stmt.cursorOpen) {
                this.prot.executeClose(this.stmt);
            }
            this.prot.executeRelease(this.stmt);
        }
        this.clear();
        this.prot = null;
        this.stmt = null;
        if (this.UpdateColVector != null) {
            this.UpdateColVector.removeAllElements();
            this.UpdateColVector = null;
        }
    }

    protected void blobCheck(IfxObject ifxObject) throws SQLException {
        IfxBlob ifxBlob;
        if (ifxObject instanceof IfxBlob && !(ifxBlob = (IfxBlob)ifxObject).isBlobLoaded()) {
            try {
                this.prot.executeFetchBlob(ifxBlob);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79701, this.conn);
            }
            ifxBlob.setLoaded();
        }
    }

    int getSerial() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        return this.prot.getSerialInsert();
    }

    long getSerial8() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        return this.prot.getSerial8Inserted();
    }

    public Interval getInterval(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Interval interval = ifxObject.toInterval();
        return interval;
    }

    public Interval getInterval(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getInterval(n);
    }

    public IntervalYM getIntervalYM(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        IntervalYM intervalYM = ifxObject.toIntervalYM();
        return intervalYM;
    }

    public IntervalYM getIntervalYM(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getIntervalYM(n);
    }

    public IntervalDF getIntervalDF(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        IntervalDF intervalDF = ifxObject.toIntervalDF();
        return intervalDF;
    }

    public IntervalDF getIntervalDF(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getIntervalDF(n);
    }

    public boolean isBeforeFirst() throws SQLException {
        this.clearWarnings();
        return this.curRowID == 0;
    }

    public boolean isAfterLast() throws SQLException {
        this.clearWarnings();
        if (this.LastRowID == 0) {
            int n = this.curRowID;
            boolean bl = this.last();
            this.LastRowID = this.curRowID;
            if (n == 0) {
                this.curRowID = 0;
            } else {
                bl = this.absolute(n);
            }
        } else if (this.curRowID == this.LastRowID + 1) {
            return true;
        }
        return false;
    }

    public boolean isFirst() throws SQLException {
        this.clearWarnings();
        return this.curRowID == 1;
    }

    public boolean isLast() throws SQLException {
        this.clearWarnings();
        if (this.LastRowID == 0) {
            int n = this.curRowID;
            boolean bl = this.last();
            this.LastRowID = this.curRowID;
            if (n == 0) {
                this.curRowID = 0;
            } else {
                bl = this.absolute(n);
            }
        }
        return this.curRowID > 0 && this.curRowID == this.LastRowID;
    }

    public void beforeFirst() throws SQLException {
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        this.curRowID = 0;
    }

    public void afterLast() throws SQLException {
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.LastRowID != 0) {
            this.curRowID = this.LastRowID + 1;
        } else {
            boolean bl = this.last();
            if (bl) {
                this.curRowID = this.LastRowID + 1;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean first() throws SQLException {
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        boolean bl = this.prot.getaRow(this.stmt.getFetchDirection(), 1, 6, 1, this.stmt);
        this.curRowID = this.prot.getTupid();
        if (!bl) {
            return false;
        }
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) return true;
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) return true;
                this.UpdateColVector = (Vector)this.colVector.clone();
                return true;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() != 1008) return true;
            this.clearUpdateColVector();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean last() throws SQLException {
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        boolean bl = this.prot.getaRow(this.stmt.getFetchDirection(), 0, 4, 1, this.stmt);
        this.LastRowID = this.curRowID = this.prot.getTupid();
        if (!bl) {
            return false;
        }
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) return true;
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) return true;
                this.UpdateColVector = (Vector)this.colVector.clone();
                return true;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() != 1008) return true;
            this.clearUpdateColVector();
        }
        return true;
    }

    public int getRow() throws SQLException {
        return this.curRowID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean absolute(int n) throws SQLException {
        boolean bl = false;
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (n == 0) {
            throw IfxErrMsg.getSQLException(-79768, this.conn);
        }
        if (n > 0) {
            bl = this.prot.getaRow(this.stmt.getFetchDirection(), n, 6, 1, this.stmt);
        } else if (n < 0) {
            bl = this.prot.getaRow(this.stmt.getFetchDirection(), 0, 4, 1, this.stmt);
            this.curRowID = this.prot.getTupid();
            if (n != -1) {
                bl = this.prot.getaRow(this.stmt.getFetchDirection(), this.curRowID + n + 1, 6, 1, this.stmt);
            }
        }
        this.curRowID = this.prot.getTupid();
        if (!bl) {
            return false;
        }
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) return true;
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) return true;
                this.UpdateColVector = (Vector)this.colVector.clone();
                return true;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() != 1008) return true;
            this.clearUpdateColVector();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean relative(int n) throws SQLException {
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.curRowID == 0) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        if (n == 0) {
            return true;
        }
        boolean bl = this.prot.getaRow(this.stmt.getFetchDirection(), this.curRowID + n, 6, 1, this.stmt);
        this.curRowID = this.prot.getTupid();
        if (!bl) {
            return false;
        }
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) return true;
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) return true;
                this.UpdateColVector = (Vector)this.colVector.clone();
                return true;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() != 1008) return true;
            this.clearUpdateColVector();
        }
        return true;
    }

    public boolean current() throws SQLException {
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        return this.curRowID != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean previous() throws SQLException {
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.LastRowID > 0 && this.curRowID > this.LastRowID) {
            return this.last();
        }
        boolean bl = this.prot.getaRow(this.stmt.getFetchDirection(), 1, 2, 1, this.stmt);
        this.curRowID = this.prot.getTupid();
        if (!bl) {
            return false;
        }
        if (this.colVector == null) {
            try {
                this.colVector = new Vector();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) return true;
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) return true;
                this.UpdateColVector = (Vector)this.colVector.clone();
                return true;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() != 1008) return true;
            this.clearUpdateColVector();
        }
        return true;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.stmt.setFetchDirection(n);
    }

    public int getFetchDirection() throws SQLException {
        return this.stmt.getFetchDirection();
    }

    public void setFetchSize(int n) throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79868, this.conn);
        }
        if (n < 0) {
            throw IfxErrMsg.getSQLException(-79700, ": ResultSet.setFetchSize(int).", this.conn);
        }
        this.FetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79868, this.conn);
        }
        return this.FetchSize;
    }

    public int getType() throws SQLException {
        return this.stmt.getResultSetType();
    }

    public int getConcurrency() throws SQLException {
        return this.stmt.getResultSetConcurrency();
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(String string, float f2) throws SQLException {
        this.updateFloat(this.findColumn(string), f2);
    }

    public void updateDouble(String string, double d2) throws SQLException {
        this.updateDouble(this.findColumn(string), d2);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public Statement getStatement() throws SQLException {
        return this.stmt;
    }

    public Ref getRef(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getRef(int).", this.conn);
    }

    public Blob getBlob(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Blob blob = ifxObject.toBlob();
        return blob;
    }

    public Clob getClob(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        int n2 = this.rsmd.getColumnType(n);
        Clob clob = ifxObject.toClob();
        return clob;
    }

    public Array getArray(int n) throws SQLException {
        IfxCollection ifxCollection = (IfxCollection)this.getValue(n);
        Array array = null;
        if (ifxCollection != null && !ifxCollection.isNull()) {
            array = ifxCollection.toArray();
        }
        return array;
    }

    public Ref getRef(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getRef(String).", this.conn);
    }

    public Blob getBlob(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBlob(n);
    }

    public Clob getClob(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getClob(n);
    }

    public Array getArray(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getArray(n);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = this.getDate(n);
        if (date == null) {
            return null;
        }
        Calendar calendar2 = Calendar.getInstance();
        long l = date.getTime() + (long)calendar.get(15) - (long)calendar2.get(15) + (long)calendar.get(16) - (long)calendar2.get(16);
        return new Date(l);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getDate(n, calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = this.getTime(n);
        if (time == null) {
            return null;
        }
        long l = time.getTime() + (long)calendar.get(15) + (long)calendar.get(16);
        return new Time(l);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getTime(n, calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp = this.getTimestamp(n);
        if (timestamp == null) {
            return null;
        }
        long l = timestamp.getTime() + (long)calendar.get(15) + (long)calendar.get(16);
        Timestamp timestamp2 = new Timestamp(l);
        timestamp2.setNanos(timestamp.getNanos());
        return timestamp2;
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getTimestamp(n, calendar);
    }

    protected void getRSPKeys(String string, boolean bl) throws SQLException {
        Object object;
        int n;
        int n2;
        CharSequence charSequence;
        String string2 = null;
        ResultSet resultSet = null;
        DatabaseMetaData databaseMetaData = this.conn.getMetaData();
        if (!bl) {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("insert into ").append(string).append("(");
            boolean bl2 = false;
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.UpdateColVector.size()) {
                IfxObject ifxObject = (IfxObject)this.UpdateColVector.elementAt(n4);
                if (ifxObject != null && ifxObject.get_used_in_update()) {
                    if (bl2) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(this.rsmd.getColumnName(n4 + 1));
                    bl2 = true;
                    ++n3;
                }
                ++n4;
            }
            stringBuffer.append(") values (");
            bl2 = false;
            n4 = 0;
            while (n4 < n3) {
                if (bl2) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("?");
                bl2 = true;
                ++n4;
            }
            stringBuffer.append(");");
            this.insertCmd = stringBuffer.toString();
            return;
        }
        if (this.keyNameVector == null) {
            this.keyNameVector = new Vector();
            this.WhereVal = new Vector();
            if (this.rsmd.findrowid() != -1) {
                this.keyNameVector.add("rowid");
                this.WhereVal.add(this.getValue(this.rsmd.rowidx));
            } else {
                string2 = this.rsmd.findserial();
                if (string2 != null) {
                    this.keyNameVector.add(string2);
                    this.WhereVal.add(this.getValue(this.rsmd.serialidx));
                } else {
                    resultSet = databaseMetaData.getPrimaryKeys("", "", string);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            charSequence = resultSet.getString(4);
                            this.keyNameVector.add(charSequence);
                            n2 = this.findColumn((String)charSequence);
                            this.WhereVal.add(this.getValue(n2));
                        }
                        resultSet.close();
                    }
                }
            }
            if (this.keyNameVector.size() == 0) {
                throw IfxErrMsg.getSQLException(-79817, this.conn);
            }
        } else {
            this.WhereVal.removeAllElements();
            if (this.rsmd.rowidx != -1) {
                this.WhereVal.add(this.getValue(this.rsmd.rowidx));
            } else if (this.rsmd.serialidx != -1) {
                this.WhereVal.add(this.getValue(this.rsmd.serialidx));
            } else {
                n = 0;
                while (n < this.keyNameVector.size()) {
                    charSequence = (String)this.keyNameVector.elementAt(n);
                    n2 = this.findColumn((String)charSequence);
                    this.WhereVal.add(this.getValue(n2));
                    ++n;
                }
            }
        }
        charSequence = new StringBuffer(200);
        n2 = 0;
        ((StringBuffer)charSequence).append("update ").append(string).append(" set ");
        n = 0;
        while (n < this.UpdateColVector.size()) {
            object = (IfxObject)this.UpdateColVector.elementAt(n);
            if (object != null && ((IfxObject)object).get_used_in_update()) {
                if (n2 != 0) {
                    ((StringBuffer)charSequence).append(", ");
                }
                ((StringBuffer)charSequence).append(this.rsmd.getColumnName(n + 1)).append(" = ? ");
                n2 = 1;
            }
            ++n;
        }
        object = new StringBuffer(200);
        ((StringBuffer)object).append("delete from ").append(string).append(" ");
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("where ");
        n = 0;
        while (n < this.keyNameVector.size()) {
            stringBuffer.append((String)this.keyNameVector.elementAt(n)).append(" = ?");
            if (n < this.keyNameVector.size() - 1) {
                stringBuffer.append(" and ");
            } else {
                stringBuffer.append(" ");
            }
            ++n;
        }
        stringBuffer.append(";");
        ((StringBuffer)object).append(stringBuffer.toString());
        ((StringBuffer)charSequence).append(stringBuffer.toString());
        this.updateCmd = ((StringBuffer)charSequence).toString();
        this.deleteCmd = ((StringBuffer)object).toString();
    }

    private void validate_update_call(boolean bl) throws SQLException {
        String string = null;
        if (this.stmt.getResultSetConcurrency() != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (this.UpdateColVector == null || this.updatecanceled) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        string = this.stmt != null ? IfxResultSetMetaData.parseTableName(this.stmt.commandString) : this.rsmd.getTableName(1);
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79816, this.conn);
        }
        this.getRSPKeys(string, bl);
        this.updatecanceled = false;
    }

    public void insertRow() throws SQLException {
        if (!this.MoveToInsert) {
            throw IfxErrMsg.getSQLException(-79815, this.conn);
        }
        this.validate_update_call(false);
        super.insertRow();
    }

    public void updateRow() throws SQLException {
        if (this.MoveToInsert) {
            throw IfxErrMsg.getSQLException(-79819, this.conn);
        }
        this.validate_update_call(true);
        super.updateRow();
    }

    public void deleteRow() throws SQLException {
        if (this.MoveToInsert) {
            throw IfxErrMsg.getSQLException(-79819, this.conn);
        }
        this.validate_update_call(true);
        super.deleteRow();
    }

    int getTupleBufferSize() {
        return ((IfxSqli)this.prot).getTupleBufferSize();
    }

    int getTupleSize() throws SQLException {
        return ((IfxSqli)this.prot).getTupleSize();
    }

    public IfxProtocol getProtocol() {
        return this.prot;
    }

    public URL getURL(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.getURL(int)", this.conn);
    }

    public URL getURL(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.getURL(String)", this.conn);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateRef(int)", this.conn);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateRef(String)", this.conn);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateBlob(int, Blob)", this.conn);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateBlob(String, Blob)", this.conn);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateClob(int, Clob)", this.conn);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateClob(String, Clob)", this.conn);
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateArray(int, Array)", this.conn);
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateArray(String, Array)", this.conn);
    }

    public void releaseBlob() {
        Vector vector = ((IfxSqliConnect)this.conn).getBlobList();
        if (vector != null) {
            int n = vector.size();
            while (n > 0) {
                IfxSmartBlob ifxSmartBlob = (IfxSmartBlob)vector.remove(n - 1);
                if (ifxSmartBlob != null && ifxSmartBlob.getHandle() != -1) {
                    try {
                        ifxSmartBlob.IfxLoClose(ifxSmartBlob.getHandle());
                        ifxSmartBlob.IfxLoRelease();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                --n;
            }
        }
    }

    private void setResultSetTxType() {
        this.txType = this.conn.isXAConnection() && this.conn.inXATransaction() ? 1 : 0;
    }

    IfxResultSetMetaData executeDescribeInput() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        return this.prot.executeDescribeInput();
    }
}

