/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DDMReplyDataStream;
import java.io.IOException;
import java.util.Vector;

class DDMAS400MessageReply
extends DDMReplyDataStream {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    ConverterImplRemote conv;
    Vector messages_ = new Vector();
    String msgId_ = null;
    String msgFile_ = null;
    String msgReplData_ = null;
    String msgText_ = null;
    int msgType_ = -1;
    String srvDiagnostic_ = null;
    int svrCode_ = -1;

    DDMAS400MessageReply(AS400ImplRemote aS400ImplRemote, byte[] byArray) throws AS400SecurityException, InterruptedException, IOException {
        super(byArray);
        this.conv = ConverterImplRemote.getConverter(aS400ImplRemote.getCcsid(), aS400ImplRemote);
        this.parseMessageInfo();
    }

    AS400Message getAS400Message() {
        return this.messages_.size() > 0 ? (AS400Message)this.messages_.elementAt(0) : new AS400Message();
    }

    AS400Message[] getAS400MessageList() {
        if (this.messages_.size() > 0) {
            Object[] objectArray = new AS400Message[this.messages_.size()];
            this.messages_.copyInto(objectArray);
            return objectArray;
        }
        return new AS400Message[0];
    }

    void parseMessageInfo() {
        int n;
        for (int i = 8; i < this.data_.length; i += n) {
            int n2 = this.get16bit(i);
            n = this.get16bit(i - 2);
            if (n2 != 53761) continue;
            AS400Message aS400Message = this.getMessage(i + 2, n - 4);
            this.messages_.addElement(aS400Message);
        }
    }

    AS400Message getMessage(int n, int n2) {
        int n3 = n + n2;
        boolean bl = false;
        int n4 = this.get16bit(n + 2);
        block6: while (!bl && n < n3) {
            int n5 = this.get16bit(n);
            n4 = this.get16bit(n + 2);
            switch (n4) {
                case 4425: {
                    this.svrCode_ = this.get16bit(n + 4);
                    n += n5;
                    continue block6;
                }
                case 53522: {
                    this.msgId_ = this.conv.byteArrayToString(this.data_, n + 4, n5 - 4);
                    n += n5;
                    continue block6;
                }
                case 53526: {
                    this.msgText_ = this.conv.byteArrayToString(this.data_, n + 6, this.get16bit(n + 4));
                    n += n5;
                    continue block6;
                }
                case 4435: 
                case 53518: 
                case 53521: 
                case 53527: {
                    n += n5;
                    continue block6;
                }
            }
            bl = true;
        }
        AS400Message aS400Message = new AS400Message(this.msgId_, this.msgText_);
        if (this.svrCode_ != -1) {
            aS400Message.setSeverity(this.svrCode_);
        }
        return aS400Message;
    }
}

