/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.utils;

import java.util.EmptyStackException;
import java.util.NoSuchElementException;

public class Queue {
    private Object[] _list = null;
    private int _head = -1;
    private int _tail = -1;
    private int _size = 0;
    private int _incr = 0;
    private int _iter = -1;

    public Queue() {
        this.init(1, 0);
    }

    public Queue(int n) {
        this.init(n, n);
    }

    public Queue(int n, int n2) {
        this.init(n, n2);
    }

    private void init(int n, int n2) {
        this._size = n < 1 ? 1 : n;
        this._incr = n2 < 0 ? 1 : n2;
        this._list = new Object[this._size];
    }

    public boolean empty() {
        return this._head == -1;
    }

    public synchronized Object peek() throws EmptyStackException {
        if (this._head == -1) {
            EmptyStackException emptyStackException = new EmptyStackException();
            throw emptyStackException;
        }
        return this._list[this._head];
    }

    public synchronized Object peek(int n) throws EmptyStackException {
        if (this._head == -1 || n < 0) {
            EmptyStackException emptyStackException = new EmptyStackException();
            throw emptyStackException;
        }
        if (this._head <= this._tail) {
            if (n <= this._tail - this._head) {
                return this._list[n + this._head];
            }
            EmptyStackException emptyStackException = new EmptyStackException();
            throw emptyStackException;
        }
        if (n < this._size - this._head) {
            return this._list[n + this._head];
        }
        if ((n -= this._head - this._size + 1) <= this._tail) {
            return this._list[n];
        }
        EmptyStackException emptyStackException = new EmptyStackException();
        throw emptyStackException;
    }

    public synchronized Object pop() throws EmptyStackException {
        Object object = this.peek();
        this._list[this._head] = null;
        if (this._tail == this._head) {
            this._head = -1;
            this._tail = -1;
        } else {
            ++this._head;
            if (this._head == this._size) {
                this._head = 0;
            }
        }
        return object;
    }

    public synchronized Object popNoEx() {
        if (this._head == -1) {
            return null;
        }
        try {
            return this.pop();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    public synchronized Object push(Object object) {
        if (this._tail == -1) {
            this._tail = 0;
            this._head = 0;
            this._list[0] = object;
            return object;
        }
        ++this._tail;
        if (this._tail == this._size) {
            this._tail = 0;
        }
        if (this._tail == this._head) {
            this.expand();
        }
        this._list[this._tail] = object;
        return object;
    }

    public void reset() throws NoSuchElementException {
        this._iter = this._head;
    }

    public Object next() throws NoSuchElementException {
        if (this._iter == -1) {
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            throw noSuchElementException;
        }
        Object object = this._list[this._iter];
        this._iter = this._iter == this._tail ? -1 : ++this._iter;
        if (this._iter == this._size) {
            this._iter = 0;
        }
        if (object == null) {
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            throw noSuchElementException;
        }
        return object;
    }

    public synchronized boolean removeElement(Object object) {
        int n = this.search(object);
        if (n == -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    private int search(Object object) {
        if (this._head == -1) {
            return -1;
        }
        int n = this._head <= this._tail ? this._tail + 1 : this._size;
        int n2 = this._head;
        while (n2 < n) {
            if (object == this._list[n2]) {
                return n2;
            }
            ++n2;
        }
        if (this._tail < this._head) {
            n2 = 0;
            while (n2 <= this._tail) {
                if (object == this._list[n2]) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    private void remove(int n) {
        if (n == this._tail && this._head == this._tail) {
            this._head = -1;
            this._tail = -1;
            return;
        }
        if (n > this._tail) {
            while (n < this._size - 1) {
                this._list[n] = this._list[n + 1];
                ++n;
            }
            this._list[n] = this._list[0];
            n = 0;
        }
        while (n < this._tail) {
            this._list[n] = this._list[n + 1];
            ++n;
        }
        if (this._tail == 0) {
            this._tail = this._size - 1;
            return;
        }
        --this._tail;
    }

    private void expand() {
        int n = this._incr == 0 ? this._size : this._incr;
        Object[] objectArray = new Object[this._size + n];
        int n2 = 0;
        int n3 = this._head;
        while (n3 < this._size) {
            objectArray[n2++] = this._list[n3];
            ++n3;
        }
        this._head = 0;
        int n4 = 0;
        while (n4 < this._tail) {
            objectArray[n2++] = this._list[n4];
            ++n4;
        }
        this._list = objectArray;
        this._tail = this._size;
        this._size += n;
    }
}

