/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.Cursor;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.Param;
import com.sybase.jdbc2.jdbc.ParamManager;
import com.sybase.jdbc2.jdbc.ProtocolContext;
import com.sybase.jdbc2.jdbc.ProtocolResultSet;
import com.sybase.jdbc2.jdbc.SybPreparedStatement;
import com.sybase.jdbc2.tds.CurCloseToken;
import com.sybase.jdbc2.tds.CurDeclare2Token;
import com.sybase.jdbc2.tds.CurDeclareToken;
import com.sybase.jdbc2.tds.CurDeleteToken;
import com.sybase.jdbc2.tds.CurFetchToken;
import com.sybase.jdbc2.tds.CurInfoToken;
import com.sybase.jdbc2.tds.CurOpenToken;
import com.sybase.jdbc2.tds.CurUpdateToken;
import com.sybase.jdbc2.tds.KeyToken;
import com.sybase.jdbc2.tds.ParamFormat2Token;
import com.sybase.jdbc2.tds.ParamFormatToken;
import com.sybase.jdbc2.tds.ParamsToken;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.tds.TdsParam2;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.tds.TdsResultSet;
import com.sybase.jdbc2.tds.Token;
import java.io.IOException;
import java.sql.SQLException;

public class TdsCursor
implements Cursor {
    private boolean _langCur;
    protected int _hasArgs;
    protected int _id;
    private static int _cursorNum = 0;
    protected String _name;
    protected int _state = 0;
    protected int _type = 0;
    private int _fetchSize = 1;
    protected String _table = null;
    protected String[] _columns = null;
    private Tds _tds;
    private TdsProtocolContext _tpc;
    private TdsProtocolContext _curPC;
    private SybPreparedStatement _utilStmt;

    public TdsCursor(Tds tds, ProtocolContext protocolContext, boolean bl, ProtocolContext protocolContext2) {
        this._tds = tds;
        this._tpc = (TdsProtocolContext)protocolContext;
        this._tpc._cursor = this;
        this._langCur = bl;
        this._curPC = (TdsProtocolContext)protocolContext2;
        this._curPC._cursor = this;
    }

    public String getName() {
        if (this._name == null) {
            TdsCursor tdsCursor = this;
            synchronized (tdsCursor) {
                this._name = "jconnect_implicit_" + ++_cursorNum;
            }
        }
        return this._name;
    }

    public void setName(String string) throws SQLException {
        this.checkState();
        this._name = string;
    }

    public void setType(int n) throws SQLException {
        switch (n) {
            case 1: 
            case 1007: {
                this._type |= 1;
                this._type &= 0xFFFFFFFD;
                break;
            }
            case 2: 
            case 1008: {
                this._type &= 0xFFFFFFFE;
                this._type |= 2;
                break;
            }
            case 8: {
                this._type |= 8;
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0BD");
            }
        }
    }

    public int getConcurrency() throws SQLException {
        if (!this._langCur && this._state == 1) {
            this.doCurInfo(2);
        }
        if ((this._type & 1) != 0) {
            return 1007;
        }
        return 1008;
    }

    public boolean isLanguageCursor() {
        return this._langCur;
    }

    public void setFetchSize(int n) throws SQLException {
        if (n == 0) {
            return;
        }
        if (n < 0) {
            ErrorMessage.raiseError("JZ0BI");
        }
        int n2 = this._fetchSize;
        this._fetchSize = n;
        if (this._state == 1 && n2 != n) {
            this.doCurInfo(1);
        }
    }

    public int getFetchSize() {
        return this._fetchSize;
    }

    public ProtocolResultSet open(String string, ParamManager paramManager, boolean bl) throws SQLException {
        if (this._name == null) {
            this.getName();
        }
        if (this._state == 1) {
            ErrorMessage.raiseError("JZ00E");
        }
        this._tds._outStreamMgr.getSendLock(this._tpc);
        this._tpc.setSponsor(this._tpc);
        if (paramManager != null) {
            this._hasArgs = paramManager.hasInParams() ? 1 : 0;
        }
        ProtocolResultSet protocolResultSet = null;
        try {
            block11: {
                try {
                    if (bl) {
                        string = new String("EXECUTE " + string);
                    }
                    if ((this._type & 8) != 0) {
                        bl = true;
                    }
                    if (!this._langCur) {
                        this.tdsCursor(string, paramManager, bl);
                    } else {
                        this.languageCursor(string, paramManager);
                    }
                    if (!this._tds.getResultSetResult(this._tpc, !this._langCur)) break block11;
                    protocolResultSet = this._tds.resultSet(this._tpc);
                }
                catch (SQLException sQLException) {
                    this._tds.cancel(this._tpc, false);
                    throw sQLException;
                }
            }
            Object var7_5 = null;
            this._tpc.setSponsor(null);
            this._tds._outStreamMgr.endRequest(this._tpc);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this._tpc.setSponsor(null);
            this._tds._outStreamMgr.endRequest(this._tpc);
            throw throwable;
        }
        this._state = 1;
        return protocolResultSet;
    }

    public ProtocolResultSet fetch() throws SQLException {
        this._tds._outStreamMgr.getSendLock(this._tpc);
        TdsResultSet tdsResultSet = null;
        try {
            block7: {
                if (!this._langCur) {
                    tdsResultSet = this._tpc._trs;
                    this._tds._outStreamMgr.beginRequest(this._tpc);
                    try {
                        CurFetchToken curFetchToken = new CurFetchToken(this, 1, 0);
                        curFetchToken.send(this._tds._out);
                        this._tds._out.flush();
                    }
                    catch (IOException iOException) {
                        this._tds._outStreamMgr.abortRequest(this._tpc);
                        this.handleIOE(iOException);
                    }
                    int n = this._tds.nextResult(this._tpc);
                    tdsResultSet.prepareForNextFetch();
                    this._tpc._trs = tdsResultSet;
                    this._tds.ungetResult(this._tpc, n);
                    break block7;
                }
                this._utilStmt.sendQuery(null, null);
                if (!this._tds.getResultSetResult(this._tpc, false)) break block7;
                tdsResultSet = (TdsResultSet)this._tds.resultSet(this._tpc);
            }
            Object var4_6 = null;
            this._tds._outStreamMgr.endRequest(this._tpc);
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this._tds._outStreamMgr.endRequest(this._tpc);
            throw throwable;
        }
        return tdsResultSet;
    }

    public int delete(ProtocolResultSet protocolResultSet) throws SQLException {
        TdsResultSet tdsResultSet = (TdsResultSet)protocolResultSet;
        this._tds._outStreamMgr.getSendLock(this._curPC);
        try {
            block7: {
                if (!this._langCur) {
                    this._tds._outStreamMgr.beginRequest(this._curPC);
                    try {
                        CurDeleteToken curDeleteToken = new CurDeleteToken(this, tdsResultSet);
                        curDeleteToken.send(this._tds._out);
                        KeyToken keyToken = new KeyToken(tdsResultSet);
                        keyToken.send(this._tds._out);
                        this._tds._out.flush();
                    }
                    catch (IOException iOException) {
                        this._tds._outStreamMgr.abortRequest(this._curPC);
                        this.handleIOE(iOException);
                    }
                    break block7;
                }
                this._tds.language(this._curPC, "DELETE " + this._table + " WHERE CURRENT OF " + this._name, null);
            }
            Object var6_7 = null;
            this._tds._outStreamMgr.endRequest(this._curPC);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this._tds._outStreamMgr.endRequest(this._curPC);
            throw throwable;
        }
        return this._tds.getDoneResult(this._curPC);
    }

    public int insert(ProtocolResultSet protocolResultSet, ParamManager paramManager, String string) throws SQLException {
        TdsResultSet tdsResultSet = (TdsResultSet)protocolResultSet;
        this._tds._outStreamMgr.getSendLock(this._curPC);
        try {
            this._tds.language(this._curPC, string, paramManager);
            Object var7_5 = null;
            this._tds._outStreamMgr.endRequest(this._curPC);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this._tds._outStreamMgr.endRequest(this._curPC);
            throw throwable;
        }
        return this._tds.getDoneResult(this._curPC);
    }

    public int update(ProtocolResultSet protocolResultSet, ParamManager paramManager, String object) throws SQLException {
        Object object2;
        boolean bl = false;
        if (paramManager != null) {
            paramManager.parseParamsAgain();
            paramManager.checkParams(this._tds, false);
            object2 = null;
            object2 = paramManager.processParamMarkers((String)object);
            if (object2 != null) {
                object = object2;
            }
            bl = paramManager.hasInParams();
        }
        object2 = (TdsResultSet)protocolResultSet;
        this._tds._outStreamMgr.getSendLock(this._curPC);
        try {
            block9: {
                if (!this._langCur) {
                    this._tds._outStreamMgr.beginRequest(this._curPC);
                    try {
                        CurUpdateToken curUpdateToken = new CurUpdateToken(this, (TdsResultSet)object2, (String)object, bl);
                        curUpdateToken.send(this._tds._out);
                        KeyToken keyToken = new KeyToken((TdsResultSet)object2);
                        keyToken.send(this._tds._out);
                        this._tds.sendParamStream(paramManager, this._tds._out);
                        this._tds._out.flush();
                    }
                    catch (IOException iOException) {
                        this._tds._outStreamMgr.abortRequest(this._curPC);
                        this.handleIOE(iOException);
                    }
                    break block9;
                }
                this._tds.language(this._curPC, (String)object + " WHERE CURRENT OF " + this._name, paramManager);
            }
            Object var9_10 = null;
            this._tds._outStreamMgr.endRequest(this._curPC);
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this._tds._outStreamMgr.endRequest(this._curPC);
            throw throwable;
        }
        return this._tds.getDoneResult(this._curPC);
    }

    public void close(boolean bl) throws SQLException {
        if (bl ? this._state == 0 || this._state == 3 : this._state != 1) {
            return;
        }
        int n = this._id;
        this._tpc._conn.removeCursorResultSet(this._name);
        this._tds._outStreamMgr.getSendLock(this._tpc);
        try {
            block10: {
                if (!this._langCur) {
                    this._tds._outStreamMgr.beginRequest(this._tpc);
                    try {
                        CurCloseToken curCloseToken = new CurCloseToken(this, bl);
                        curCloseToken.send(this._tds._out);
                        this._tds._out.flush();
                    }
                    catch (IOException iOException) {
                        this._tds._outStreamMgr.abortRequest(this._tpc);
                        this.handleIOE(iOException);
                    }
                    if (bl) {
                        this._state = 3;
                        this._id = 0;
                    } else {
                        this._state = 2;
                    }
                    break block10;
                }
                this._tds.language(this._tpc, "DEALLOCATE CURSOR " + this._name, null);
                this._state = 3;
                this._utilStmt = null;
            }
            Object var5_6 = null;
            this._tds._outStreamMgr.endRequest(this._tpc);
            this._curPC.drop();
            this._tds._cursors.remove(new Integer(n));
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this._tds._outStreamMgr.endRequest(this._tpc);
            this._curPC.drop();
            this._tds._cursors.remove(new Integer(n));
            throw throwable;
        }
        this._tds.getDoneResult(this._tpc);
    }

    public void setTable(String string) {
        if (string != null) {
            this._table = string;
        }
    }

    public String getTable() {
        return this._table;
    }

    private void checkState() throws SQLException {
        if (this._state == 1 || this._state == 2) {
            ErrorMessage.raiseError("JZ00F");
        }
    }

    private void tdsCursor(String object, ParamManager paramManager, boolean bl) throws SQLException {
        this._tds._outStreamMgr.beginRequest(this._tpc);
        try {
            Token token;
            Object object2;
            if (this._state == 0 || this._state == 3) {
                this._id = 0;
                object2 = null;
                if (paramManager != null) {
                    paramManager.checkParams(this._tds, false);
                    if (!bl && (object2 = paramManager.processParamMarkers((String)object)) != null) {
                        object = object2;
                    }
                }
                token = null;
                boolean bl2 = false;
                long l = 65529 - this.getName().length();
                if (this._columns != null) {
                    int n = 0;
                    while (n < this._columns.length) {
                        --l;
                        l -= (long)this._columns[n].length();
                        ++n;
                    }
                }
                if ((long)((String)object).length() > l) {
                    bl2 = true;
                }
                if (bl2) {
                    if (!this._tds.isWidetableEnabled()) {
                        ErrorMessage.raiseError("JZ0PE");
                    } else {
                        token = new CurDeclare2Token(this, (String)object);
                    }
                } else {
                    token = new CurDeclareToken(this, (String)object);
                }
                ((CurDeclareToken)token).send(this._tds._out);
                if (!bl && this._hasArgs == 1) {
                    this.buildParamfmtToken(paramManager);
                }
            }
            if (this._fetchSize > 1) {
                object2 = new CurInfoToken(this);
                ((CurInfoToken)object2).send(this._tds._out, 1, this._fetchSize);
            }
            object2 = new CurOpenToken(this);
            ((CurOpenToken)object2).send(this._tds._out);
            if (this._hasArgs == 1) {
                this.buildParamfmtToken(paramManager);
                token = new ParamsToken();
                token.send(this._tds._out);
                paramManager.send(this._tds._out);
            }
            this._tds._out.flush();
        }
        catch (IOException iOException) {
            this._tds._outStreamMgr.abortRequest(this._tpc);
            this.handleIOE(iOException);
        }
    }

    private void buildParamfmtToken(ParamManager paramManager) throws IOException, SQLException {
        ParamFormatToken paramFormatToken = null;
        Param[] paramArray = paramManager.getParams();
        paramFormatToken = paramArray[0] instanceof TdsParam2 ? new ParamFormat2Token(paramManager) : new ParamFormatToken(paramManager);
        paramFormatToken.send(this._tds._out);
    }

    private void languageCursor(String string, ParamManager paramManager) throws SQLException {
        String string2 = new String("DECLARE " + this._name + " CURSOR FOR ");
        if (paramManager != null && this._state == 0) {
            paramManager.adjustOffsets(string2.length());
        }
        if (this._state == 0 || this._state == 3) {
            this._tds.language(this._tpc, string2 + string, paramManager);
            this._tds.getDoneResult(this._tpc);
        }
        if (this._fetchSize > 1) {
            this._tds.language(this._tpc, "SET CURSOR ROWS " + this._fetchSize + " FOR " + this._name, null);
            this._tds.getDoneResult(this._tpc);
        }
        this._tds.language(this._tpc, "OPEN " + this._name, null);
        this._tds.getDoneResult(this._tpc);
        if (this._utilStmt == null) {
            this._utilStmt = (SybPreparedStatement)this._tpc._conn.prepareStatement("FETCH " + this.getName(), false);
            this._utilStmt.switchContext(this._tpc);
        }
        this._utilStmt.sendQuery(null, null);
    }

    private void doCurInfo(int n) throws SQLException {
        this._tds._outStreamMgr.getSendLock(this._curPC);
        try {
            block7: {
                if (!this._langCur) {
                    try {
                        this._tds._outStreamMgr.beginRequest(this._curPC);
                        CurInfoToken curInfoToken = new CurInfoToken(this);
                        curInfoToken.send(this._tds._out, n, this._fetchSize);
                        this._tds._out.flush();
                    }
                    catch (IOException iOException) {
                        this._tds._outStreamMgr.abortRequest(this._curPC);
                        this.handleIOE(iOException);
                    }
                    break block7;
                }
                this._tds.language(this._curPC, "SET CURSOR ROWS " + this._fetchSize + "FOR " + this._name, null);
            }
            Object var4_5 = null;
            this._tds._outStreamMgr.endRequest(this._curPC);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this._tds._outStreamMgr.endRequest(this._curPC);
            throw throwable;
        }
        this._tds.getDoneResult(this._curPC);
    }

    private void handleIOE(IOException iOException) throws SQLException {
        ErrorMessage.raiseErrorCheckDead(iOException);
    }
}

