/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.EscapeTokenizer;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

class Escape {
    protected static final int CALL = 1;
    protected static final int RETURN_CALL = 2;
    protected static final int DATE = 3;
    protected static final int TIME = 4;
    protected static final int TIMESTAMP = 5;
    protected static final int FUNCTION = 6;
    protected static final int LIKE_ESCAPE = 7;
    protected static final int OUTER_JOIN = 8;
    protected static final int UNKNOWN = -1;
    private static final char LEFT_CURLY = '{';
    private static final char RIGHT_CURLY = '}';
    private static final char COMMA = ',';
    private static final char LEFT_PAREN = '(';
    private static final char RIGHT_PAREN = ')';
    private static final char PERCENT_SIGN = '%';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final int MAX_ARGUMENTS = 4;
    private int _type;
    private String _body;

    Escape(String string) throws SQLException {
        String string2;
        int n = string.length();
        int n2 = 1;
        while (n2 < n && Character.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        if (n2 == n) {
            ErrorMessage.raiseError("JZ0S8", string);
        }
        int n3 = n2;
        while (n3 < n && !Character.isWhitespace(string.charAt(n3))) {
            ++n3;
        }
        if (n3 == n) {
            ErrorMessage.raiseError("JZ0S8", string);
        }
        if ((string2 = string.substring(n2, n3).toLowerCase()).equals("call")) {
            this._type = 1;
        } else if (string2.equals("?") || string2.equals("?=") || string2.equals("?=call")) {
            n3 = string.toLowerCase().indexOf("call") + 4;
            this._type = 2;
        } else if (string2.equals("d")) {
            this._type = 3;
        } else if (string2.equals("t")) {
            this._type = 4;
        } else if (string2.equals("ts")) {
            this._type = 5;
        } else if (string2.equals("fn")) {
            this._type = 6;
        } else if (string2.equals("escape")) {
            this._type = 7;
        } else if (string2.equals("oj")) {
            this._type = 8;
        } else {
            ErrorMessage.raiseError("JZ0S8", string);
        }
        int n4 = n3;
        while (n4 < n && Character.isWhitespace(string.charAt(n4))) {
            ++n4;
        }
        if (n4 == n - 1) {
            ErrorMessage.raiseError("JZ0S8", string);
        }
        int n5 = n - 2;
        while (Character.isWhitespace(string.charAt(n5))) {
            --n5;
        }
        this._body = string.substring(n4, n5 + 1);
    }

    Escape(String string, int n) throws SQLException {
        this._body = string;
        this._type = n;
    }

    protected int getType() {
        return this._type;
    }

    protected String getBody() {
        return this._body;
    }

    protected String functionName() throws SQLException {
        String string = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this._body, " \t\n\r(");
            string = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            ErrorMessage.raiseError("JZ0S8", this._body);
        }
        string = string.toLowerCase();
        if (string.equals("convert") || string.equals("timestampadd") || string.equals("timestampdiff")) {
            int n;
            int n2;
            if (string.equals("convert")) {
                n2 = this._body.lastIndexOf(44) + 1;
                n = this._body.lastIndexOf(41) - 1;
            } else {
                n2 = this._body.indexOf(40) + 1;
                n = this._body.indexOf(44) - 1;
            }
            int n3 = this._body.length();
            while (n2 <= n3 && Character.isWhitespace(this._body.charAt(n2))) {
                ++n2;
            }
            while (n > 0 && Character.isWhitespace(this._body.charAt(n))) {
                --n;
            }
            if (n2 < 0 || n < 0 || n < n2 + 1) {
                ErrorMessage.raiseError("JZ0S8", this._body);
            }
            string = string + this._body.substring(n2, n + 1).toLowerCase();
        }
        return string;
    }

    protected String doMap(String string) throws SQLException {
        String[] stringArray = new String[5];
        int n = this._body.indexOf(40);
        int n2 = this._body.lastIndexOf(41);
        if (n < 0 || n2 < 0 || n2 < n + 1) {
            ErrorMessage.raiseError("JZ0S8", this._body);
        }
        String string2 = this._body.substring(n + 1, n2);
        int n3 = 1;
        while (n3 <= 4 && string2.length() > 0) {
            int n4 = this.nextComma(string2);
            if (n4 < 0) {
                stringArray[n3] = string2;
                break;
            }
            if (n4 == 0) {
                ErrorMessage.raiseError("JZ0S8", this._body);
            } else {
                stringArray[n3] = string2.substring(0, n4);
                string2 = string2.substring(n4 + 1);
            }
            ++n3;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = string.length();
        int n6 = 0;
        while (n6 < n5) {
            if (string.charAt(n6) == '%') {
                int n7 = 0;
                try {
                    n7 = Integer.parseInt(string.substring(n6 + 1, n6 + 2));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (stringArray[n7] == null) {
                    ErrorMessage.raiseError("JZ0S8", this._body);
                } else {
                    stringBuffer.append(stringArray[n7]);
                }
                ++n6;
            } else {
                stringBuffer.append(string.charAt(n6));
            }
            ++n6;
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private int nextComma(String string) throws SQLException {
        int n = string.length();
        int n2 = -1;
        int n3 = 1;
        int n4 = 0;
        while (n4 < n) {
            char c = string.charAt(n4);
            switch (c) {
                case '\"': 
                case '\'': {
                    n3 = EscapeTokenizer.nextState(n3, c);
                    break;
                }
                case '(': {
                    if (n3 != 1 || (n4 = EscapeTokenizer.matchClosingChar(c, new StringBuffer(string), n4)) >= 0) break;
                    ErrorMessage.raiseError("JZ0S8", this._body);
                    break;
                }
                case ',': {
                    if (n3 != 1) break;
                    return n4;
                }
            }
            ++n4;
        }
        return n2;
    }
}

