/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.comm;

import com.tmax.tibero.DriverConstants;
import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbClobBase;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.TbSQLInfo;
import com.tmax.tibero.jdbc.TbSQLInfo2;
import com.tmax.tibero.jdbc.comm.TbBlobAccessor;
import com.tmax.tibero.jdbc.comm.TbClobAccessor;
import com.tmax.tibero.jdbc.comm.TbComm;
import com.tmax.tibero.jdbc.comm.TbSocketRegistry;
import com.tmax.tibero.jdbc.comm.TbStream;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.BatchInfo;
import com.tmax.tibero.jdbc.data.BatchUpdateInfo;
import com.tmax.tibero.jdbc.data.BindData;
import com.tmax.tibero.jdbc.data.BindItem;
import com.tmax.tibero.jdbc.data.ConnectionInfo;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.NodeInfo;
import com.tmax.tibero.jdbc.data.ServerInfo;
import com.tmax.tibero.jdbc.data.ZoneInfo;
import com.tmax.tibero.jdbc.data.binder.Binder;
import com.tmax.tibero.jdbc.data.charset.Charset;
import com.tmax.tibero.jdbc.data.charset.CharsetMetaData;
import com.tmax.tibero.jdbc.dpl.TbDirPathMetaData;
import com.tmax.tibero.jdbc.dpl.TbDirPathStream;
import com.tmax.tibero.jdbc.driver.TbCallableStatementImpl;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.driver.TbPreparedStatementImpl;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.driver.TbResultSetBase;
import com.tmax.tibero.jdbc.driver.TbResultSetFactory;
import com.tmax.tibero.jdbc.driver.TbSavepoint;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.msg.TbClntInfoParam;
import com.tmax.tibero.jdbc.msg.TbColNameList;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import com.tmax.tibero.jdbc.msg.TbMsgBatchUpdateReply;
import com.tmax.tibero.jdbc.msg.TbMsgConnectReply;
import com.tmax.tibero.jdbc.msg.TbMsgDplLoadStreamReply;
import com.tmax.tibero.jdbc.msg.TbMsgDplPrepareReply;
import com.tmax.tibero.jdbc.msg.TbMsgEreply;
import com.tmax.tibero.jdbc.msg.TbMsgExecuteCallReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecuteCountReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecuteNeedDataReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecutePivotReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecutePrefetchNoDescReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecutePrefetchReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecutePsmPrefetchReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecutePsmReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecuteRsetNoDescReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecuteRsetReply;
import com.tmax.tibero.jdbc.msg.TbMsgFetchPivotReply;
import com.tmax.tibero.jdbc.msg.TbMsgFetchReply;
import com.tmax.tibero.jdbc.msg.TbMsgGetLastExecutedSqlinfo2Reply;
import com.tmax.tibero.jdbc.msg.TbMsgGetLastExecutedSqlinfoReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobCloseReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobCreateTempReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobInlobReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobInstrReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobLengthReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobOpenReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobReadReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobTruncReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobWriteReply;
import com.tmax.tibero.jdbc.msg.TbMsgLongReadReply;
import com.tmax.tibero.jdbc.msg.TbMsgOkReply;
import com.tmax.tibero.jdbc.msg.TbMsgPrepareReply;
import com.tmax.tibero.jdbc.msg.TbMsgSend;
import com.tmax.tibero.jdbc.msg.TbMsgSessInfoReply;
import com.tmax.tibero.jdbc.msg.TbMsgSesskeyReply;
import com.tmax.tibero.jdbc.msg.TbNlsParam;
import com.tmax.tibero.jdbc.msg.TbOutParam;
import com.tmax.tibero.jdbc.msg.TbPivotInfo;
import com.tmax.tibero.jdbc.msg.TbPvValType;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import com.tmax.tibero.jdbc.util.TbCommon;
import com.tmax.tibero.jdbc.util.TbSQLTypeScanner;
import java.io.ByteArrayOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.crypto.Cipher;

public class TbCommType4
implements TbComm,
TbClobAccessor,
TbBlobAccessor {
    public TbConnection conn = null;
    public TbStream stream = null;
    public DataTypeConverter typeConverter = null;

    public TbCommType4() {
    }

    public TbCommType4(TbConnection tbConnection) {
        this.conn = tbConnection;
        this.typeConverter = tbConnection.getTypeConverter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] batchUpdate(TbPreparedStatementImpl tbPreparedStatementImpl, BatchUpdateInfo batchUpdateInfo, int n, int n2, int n3) throws SQLException {
        int n4 = 0;
        int n5 = tbPreparedStatementImpl.getParameterCnt();
        int n6 = n2 - n;
        boolean bl = true;
        byte[][] byArray = tbPreparedStatementImpl.getParamTypes();
        Binder[][] binderArray = tbPreparedStatementImpl.getBinder();
        BatchUpdateException batchUpdateException = null;
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            Object object;
            try {
                object = this.stream.getMsgWriter();
                this.stream.startWritingPacketData();
                ((TbStreamDataWriter)object).writeInt(31, 4);
                ((TbStreamDataWriter)object).writeInt(0, 4);
                ((TbStreamDataWriter)object).writeLong(0L, 8);
                ((TbStreamDataWriter)object).writeLenAndDBEncodedPadString(tbPreparedStatementImpl.getOriginalSql());
                int n7 = ((TbStreamDataWriter)object).getBufferedDataSize();
                ((TbStreamDataWriter)object).makeBufferAvailable(20);
                ((TbStreamDataWriter)object).moveOffset(20);
                int n8 = ((TbStreamDataWriter)object).getBufferedDataSize();
                for (int i = n; i < n2; ++i) {
                    BindData bindData = batchUpdateInfo.get(i).getBindData();
                    for (int j = 0; j < binderArray[i].length; ++j) {
                        int n9 = 1;
                        ((TbStreamDataWriter)object).writeInt(n9 |= byArray[i][j] << 8 & 0xFFFFFF00, 4);
                        binderArray[i][j].bind(this.conn, tbPreparedStatementImpl, (TbStreamDataWriter)object, i, j, bindData.getBindItem(j).getLength());
                    }
                    ++n4;
                    if (((TbStreamDataWriter)object).getBufferedDataSize() <= DriverConstants.BATCH_SEND_SIZE) continue;
                    this.batchUpdateFlush(tbPreparedStatementImpl, n7, n6, n4, n3, bl);
                    bl = false;
                    n4 = 0;
                    ((TbStreamDataWriter)object).setCurDataSize(n8);
                }
                if (bl || ((TbStreamDataWriter)object).getBufferedDataSize() - n8 > 0) {
                    this.batchUpdateFlush(tbPreparedStatementImpl, n7, n6, n4, n3, bl);
                }
            }
            catch (SQLException sQLException) {
                int n10 = sQLException.getErrorCode();
                if (n10 <= -90400 && n10 > -90500) {
                    throw sQLException;
                }
                batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), new int[0]);
                if (bl) {
                    throw batchUpdateException;
                }
                this.cancelStatement();
            }
            catch (Exception exception) {
                SQLException sQLException = TbError.newSQLException(-90651, exception);
                batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), new int[0]);
                if (bl) {
                    throw batchUpdateException;
                }
                this.cancelStatement();
            }
            object = this.stream.readMsg();
            switch (((TbMsg)object).getMsgType()) {
                case 32: {
                    return this.batchUpdateReply((TbMsgBatchUpdateReply)object, n6, n5);
                }
                case 76: {
                    if (batchUpdateException == null) {
                        this.throwEreply(-90515, (TbMsg)object);
                        break;
                    }
                    throw batchUpdateException;
                }
            }
            this.throwProtocolError(((TbMsg)object).getMsgType());
        }
        return null;
    }

    private void batchUpdateFlush(TbPreparedStatementImpl tbPreparedStatementImpl, int n, int n2, int n3, int n4, boolean bl) throws SQLException {
        int n5 = tbPreparedStatementImpl.getParameterCnt();
        TbStreamDataWriter tbStreamDataWriter = this.stream.getMsgWriter();
        tbStreamDataWriter.reWriteInt(n, n2, 4);
        tbStreamDataWriter.reWriteInt(n + 4, n3, 4);
        tbStreamDataWriter.reWriteInt(n + 8, n5, 4);
        if (this.conn.getAutoCommit()) {
            n4 |= 1;
        }
        if (!bl) {
            n4 |= 0x1000;
        }
        tbStreamDataWriter.reWriteInt(n + 12, n4, 4);
        tbStreamDataWriter.reWriteInt(n + 16, n3 * n5, 4);
        tbStreamDataWriter.reWriteInt(4, tbStreamDataWriter.getBufferedDataSize() - 16, 4);
        this.stream.flush();
    }

    public int[] batchUpdateLoop(TbPreparedStatementImpl tbPreparedStatementImpl, BatchUpdateInfo batchUpdateInfo) throws SQLException {
        int n = tbPreparedStatementImpl.getBatchFlag();
        int n2 = batchUpdateInfo.getDeferredRowCount();
        int n3 = tbPreparedStatementImpl.getBatchRowCount();
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[n3];
        try {
            int[] nArray2;
            if (n2 == 0) {
                return this.batchUpdate(tbPreparedStatementImpl, batchUpdateInfo, 0, n3, n);
            }
            for (int i = 0; i < n2; ++i) {
                int n6 = batchUpdateInfo.getDeferredRowIndex(i);
                BatchInfo batchInfo = batchUpdateInfo.get(n6);
                if (n4 < n6) {
                    nArray2 = this.batchUpdate(tbPreparedStatementImpl, batchUpdateInfo, n4, n6, n);
                    System.arraycopy(nArray2, 0, nArray, n5, nArray2.length);
                    n5 += nArray2.length;
                    n4 = n6;
                }
                tbPreparedStatementImpl.setBindData(batchInfo.getBindData());
                nArray[n5] = this.prepareExecute(tbPreparedStatementImpl, tbPreparedStatementImpl.getOriginalSql(), batchInfo.getCurrentRowIndex());
                ++n5;
                ++n4;
            }
            if (n4 < n3) {
                nArray2 = this.batchUpdate(tbPreparedStatementImpl, batchUpdateInfo, n4, n3, n);
                System.arraycopy(nArray2, 0, nArray, n5, nArray2.length);
            }
            return nArray;
        }
        catch (BatchUpdateException batchUpdateException) {
            int n7 = batchUpdateException.getUpdateCounts().length;
            int[] nArray3 = new int[n5 + n7];
            System.arraycopy(nArray, 0, nArray3, 0, n5);
            System.arraycopy(batchUpdateException.getUpdateCounts(), 0, nArray3, n5, n7);
            throw new BatchUpdateException(batchUpdateException.getMessage(), batchUpdateException.getSQLState(), batchUpdateException.getErrorCode(), nArray3);
        }
        catch (SQLException sQLException) {
            int n8 = sQLException.getErrorCode();
            if (n8 <= -90400 && n8 > -90500) {
                throw sQLException;
            }
            int[] nArray4 = new int[n5];
            System.arraycopy(nArray, 0, nArray4, 0, n5);
            throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray4);
        }
    }

    private int[] batchUpdateReply(TbMsgBatchUpdateReply tbMsgBatchUpdateReply, int n, int n2) throws SQLException {
        int n3;
        int[] nArray = new int[tbMsgBatchUpdateReply.executedCnt];
        if (tbMsgBatchUpdateReply.affectedCnt == null) {
            for (n3 = 0; n3 < tbMsgBatchUpdateReply.executedCnt; ++n3) {
                nArray[n3] = 1;
            }
        } else {
            for (n3 = 0; n3 < tbMsgBatchUpdateReply.executedCnt; ++n3) {
                nArray[n3] = tbMsgBatchUpdateReply.affectedCnt[n3].cnt;
            }
        }
        if (n2 > 0 && n != tbMsgBatchUpdateReply.executedCnt) {
            SQLException sQLException = tbMsgBatchUpdateReply.getException(-90515);
            throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray);
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.CANCEL(this.stream);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)tbMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90526, tbMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
        }
    }

    public void cancelStatement() throws SQLException {
        TbMsgSend.STMTCANCEL(this.stream, this.conn.getSessionId(), this.conn.getSerialNo(), 0);
    }

    public void close() throws SQLException {
        this.reset();
    }

    public boolean close(TbLob tbLob) throws SQLException {
        return this.lobClose(tbLob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCursor(TbResultSet tbResultSet, int n) throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.CLOSE_CSR(this.stream, n);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)tbMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90507, tbMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession() throws SQLException {
        int n = this.conn.getAutoCommit() ? 1 : 0;
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.CLOSE_SESS(this.stream, n);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)tbMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90503, tbMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.COMMIT(this.stream);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)tbMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90510, tbMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createStream() throws SQLException {
        String string = null;
        if (this.conn.info.isInternal()) {
            Socket socket = TbSocketRegistry.getSocket();
            if (socket == null) {
                throw TbError.newSQLException(-590720);
            }
            string = "server internally";
            if (this.stream != null) {
                TbStream tbStream = this.stream;
                synchronized (tbStream) {
                    this.stream = new TbStream(this.conn, socket, this.typeConverter, this.conn.info);
                    return;
                }
            } else {
                this.stream = new TbStream(this.conn, socket, this.typeConverter, this.conn.info);
            }
            return;
        }
        NodeInfo nodeInfo = this.conn.info.getClusterNode();
        if (nodeInfo == null) {
            throw TbError.newSQLException(-590721);
        }
        while (true) {
            string = nodeInfo.getAddress() + ":" + nodeInfo.getPort();
            if (this.stream != null) {
                TbStream tbStream = this.stream;
                synchronized (tbStream) {
                    try {
                        this.stream = new TbStream(this.conn, nodeInfo.getAddress(), nodeInfo.getPort(), this.typeConverter, this.conn.info);
                        return;
                    }
                    catch (SQLException sQLException) {
                        this.stream = null;
                        nodeInfo = this.conn.info.getSecondaryNode();
                        if (nodeInfo == null) {
                            throw sQLException;
                        }
                    }
                }
            }
            try {
                this.stream = new TbStream(this.conn, nodeInfo.getAddress(), nodeInfo.getPort(), this.typeConverter, this.conn.info);
                return;
            }
            catch (SQLException sQLException) {
                this.stream = null;
                nodeInfo = this.conn.info.getSecondaryNode();
                if (nodeInfo == null) throw sQLException;
                continue;
            }
            break;
        }
    }

    public byte[] createTemporaryBlob() throws SQLException {
        return this.lobCreateTemporary(12);
    }

    public byte[] createTemporaryClob() throws SQLException {
        return this.lobCreateTemporary(13);
    }

    public byte[] createTemporaryNClob() throws SQLException {
        return this.lobCreateTemporary(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void describeConnectInfo() throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.DESCRIBE_CONNECT_INFO(this.stream);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 0: {
                    this.logonConnectReply((TbMsgConnectReply)tbMsg, false);
                    break;
                }
                case 76: {
                    this.throwEreply(-90502, tbMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void describeSessInfo() throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.DESCRIBE_SESS_INFO(this.stream);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 2: {
                    this.logonSessInfoReply((TbMsgSessInfoReply)tbMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90502, tbMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dirPathAbort() throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.DPL_ABORT(this.stream);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)tbMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90541, tbMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dirPathDataSave(int n) throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.DPL_DATASAVE(this.stream, n);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)tbMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90538, tbMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dirPathFinish() throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.DPL_FINISH(this.stream);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)tbMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90539, tbMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dirPathFlushRow() throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.DPL_FLUSH_ROW(this.stream);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)tbMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90540, tbMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dirPathLoadStream(TbDirPathStream tbDirPathStream, TbStreamDataWriter tbStreamDataWriter, int n) throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            try {
                tbStreamDataWriter.reWriteInt(0, 57, 4);
                tbStreamDataWriter.reWriteLong(8, 0L, 8);
                tbStreamDataWriter.reWriteInt(16, n, 4);
                tbStreamDataWriter.reWriteInt(20, tbStreamDataWriter.getBufferedDataSize() - 24, 4);
                tbStreamDataWriter.putPadding(4);
                tbStreamDataWriter.reWriteInt(4, tbStreamDataWriter.getBufferedDataSize() - 16, 4);
                this.stream.flush(tbStreamDataWriter);
            }
            finally {
                tbStreamDataWriter.clearDPLBuffer();
            }
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 58: {
                    TbMsgDplLoadStreamReply tbMsgDplLoadStreamReply = (TbMsgDplLoadStreamReply)tbMsg;
                    int n2 = tbMsgDplLoadStreamReply.rowCnt;
                    int n3 = tbMsgDplLoadStreamReply.returnCode;
                    tbDirPathStream.addRowCnt(n2);
                    tbDirPathStream.addTotalRowCnt(n2);
                    tbDirPathStream.setReturnCode(n3);
                    if (n3 != 3) break;
                    throw tbMsgDplLoadStreamReply.getException(-90537);
                }
                case 76: {
                    this.throwEreply(-90537, tbMsg);
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dirPathPrepare(TbDirPathStream tbDirPathStream) throws SQLException {
        int n;
        TbDirPathMetaData tbDirPathMetaData = tbDirPathStream.getDPLMetaData();
        int n2 = tbDirPathMetaData.getColumnCnt();
        TbColNameList[] tbColNameListArray = new TbColNameList[n2];
        for (n = 0; n < n2; ++n) {
            tbColNameListArray[n] = new TbColNameList();
            tbColNameListArray[n].set(tbDirPathMetaData.getColumn(n + 1));
        }
        n = tbDirPathMetaData.getLogFlag() ? 1 : 0;
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.DPL_PREPARE(this.stream, n, tbDirPathMetaData.getSchema(), tbDirPathMetaData.getTable(), n2, tbColNameListArray);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 56: {
                    if (n2 != ((TbMsgDplPrepareReply)tbMsg).colMeta.length) {
                        throw TbError.newSQLException(-90544);
                    }
                    TbColumnDesc[] tbColumnDescArray = ((TbMsgDplPrepareReply)tbMsg).colMeta;
                    tbDirPathStream.getDPLMetaData().setColumnMetas(tbColumnDescArray);
                    return;
                }
                case 76: {
                    this.throwEreply(-90536, tbMsg);
                }
            }
            this.throwProtocolError(tbMsg.getMsgType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dirPathPrepareParallel(TbDirPathStream tbDirPathStream) throws SQLException {
        int n;
        TbDirPathMetaData tbDirPathMetaData = tbDirPathStream.getDPLMetaData();
        int n2 = tbDirPathMetaData.getColumnCnt();
        TbColNameList[] tbColNameListArray = new TbColNameList[n2];
        for (n = 0; n < n2; ++n) {
            tbColNameListArray[n] = new TbColNameList();
            tbColNameListArray[n].set(tbDirPathMetaData.getColumn(n + 1));
        }
        n = tbDirPathMetaData.getLogFlag() ? 1 : 0;
        int n3 = tbDirPathMetaData.getParallelFlag() ? 1 : 0;
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.DPL_PREPARE_PARALLEL(this.stream, n, n3, tbDirPathMetaData.getSchema(), tbDirPathMetaData.getTable(), tbDirPathMetaData.getPartition(), n2, tbColNameListArray);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 56: {
                    if (n2 != ((TbMsgDplPrepareReply)tbMsg).colMeta.length) {
                        throw TbError.newSQLException(-90544);
                    }
                    TbColumnDesc[] tbColumnDescArray = ((TbMsgDplPrepareReply)tbMsg).colMeta;
                    tbDirPathStream.getDPLMetaData().setColumnMetas(tbColumnDescArray);
                    return;
                }
                case 76: {
                    this.throwEreply(-90536, tbMsg);
                }
            }
            this.throwProtocolError(tbMsg.getMsgType());
        }
    }

    public int execute(TbPreparedStatementImpl tbPreparedStatementImpl, String string, int n) throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            this.processExecute(tbPreparedStatementImpl, string, n, true);
            TbMsg tbMsg = this.stream.readMsg();
            block16: while (true) {
                switch (tbMsg.getMsgType()) {
                    case 75: {
                        this.justOKReply((TbMsgOkReply)tbMsg);
                        return TbSQLTypeScanner.isPSMStmt(tbPreparedStatementImpl.getSqlType()) ? 1 : 0;
                    }
                    case 2: {
                        this.executeSessInfoReply((TbMsgSessInfoReply)tbMsg);
                        return 0;
                    }
                    case 12: {
                        return this.executePrefetchNoDescReply(tbPreparedStatementImpl, (TbMsgExecutePrefetchNoDescReply)tbMsg);
                    }
                    case 13: {
                        return this.executeCountReply(tbPreparedStatementImpl, (TbMsgExecuteCountReply)tbMsg);
                    }
                    case 8: {
                        return this.executeRsetReply(tbPreparedStatementImpl, (TbMsgExecuteRsetReply)tbMsg);
                    }
                    case 10: {
                        return this.executeRsetNoDescReply(tbPreparedStatementImpl, (TbMsgExecuteRsetNoDescReply)tbMsg);
                    }
                    case 16: {
                        return this.executeNeedDataReply(tbMsg, tbPreparedStatementImpl, n);
                    }
                    case 15: {
                        TbMsgExecutePsmReply tbMsgExecutePsmReply = (TbMsgExecutePsmReply)tbMsg;
                        return this.executeCallReply(tbPreparedStatementImpl, n, tbMsgExecutePsmReply.paramData);
                    }
                    case 9: {
                        tbMsg = this.executePivotReply(tbPreparedStatementImpl, (TbMsgExecutePivotReply)tbMsg);
                        continue block16;
                    }
                    case 183: {
                        TbMsgExecutePsmPrefetchReply tbMsgExecutePsmPrefetchReply = (TbMsgExecutePsmPrefetchReply)tbMsg;
                        tbPreparedStatementImpl.buildColMetaArray(tbMsgExecutePsmPrefetchReply.colCnt, tbMsgExecutePsmPrefetchReply.hiddenColCnt, tbMsgExecutePsmPrefetchReply.colMeta);
                        if (!(tbPreparedStatementImpl instanceof TbCallableStatementImpl)) {
                            return 1;
                        }
                        return this.executePsmPrefetchReply((TbCallableStatementImpl)tbPreparedStatementImpl, n, tbMsgExecutePsmPrefetchReply);
                    }
                    case 76: {
                        return this.executeEreply(tbPreparedStatementImpl, string, tbMsg, n);
                    }
                }
                this.throwProtocolError(tbMsg.getMsgType());
            }
        }
    }

    private int executeCallReply(TbPreparedStatementImpl tbPreparedStatementImpl, int n, TbOutParam[] tbOutParamArray) throws SQLException {
        int n2 = -1;
        int n3 = tbOutParamArray == null ? 0 : tbOutParamArray.length;
        BindData bindData = tbPreparedStatementImpl.getBindData();
        int n4 = tbPreparedStatementImpl.getParameterCnt();
        if (bindData.getOutParameterCnt() != n3) {
            throw TbError.newSQLException(-90618);
        }
        if (tbOutParamArray == null || !(tbPreparedStatementImpl instanceof TbCallableStatementImpl)) {
            return 1;
        }
        TbCallableStatementImpl tbCallableStatementImpl = (TbCallableStatementImpl)tbPreparedStatementImpl;
        for (int i = 0; i < n3; ++i) {
            ++n2;
            while (n2 < n4 && !bindData.isOutParameterOn(n2)) {
                ++n2;
            }
            if (n2 >= n4) {
                throw TbError.newSQLException(-90618);
            }
            BindItem bindItem = bindData.getBindItem(n2);
            BindItem bindItem2 = tbCallableStatementImpl.getOutItems(n2);
            bindItem2.set(bindItem.getSQLType(), tbOutParamArray[i].value.length, tbOutParamArray[i].colMeta, null);
            tbCallableStatementImpl.setOutParam(n2, tbOutParamArray[i].dataType, tbOutParamArray[i].value, null);
        }
        return 1;
    }

    private int executePsmPrefetchReply(TbCallableStatementImpl tbCallableStatementImpl, int n, TbMsgExecutePsmPrefetchReply tbMsgExecutePsmPrefetchReply) throws SQLException {
        TbOutParam[] tbOutParamArray = tbMsgExecutePsmPrefetchReply.paramData;
        int n2 = -1;
        int n3 = tbOutParamArray == null ? 0 : tbOutParamArray.length;
        BindData bindData = tbCallableStatementImpl.getBindData();
        int n4 = tbCallableStatementImpl.getParameterCnt();
        if (bindData.getOutParameterCnt() != n3) {
            throw TbError.newSQLException(-90618);
        }
        if (tbOutParamArray == null) {
            return 1;
        }
        TbResultSet tbResultSet = null;
        for (int i = 0; i < n3; ++i) {
            ++n2;
            while (n2 < n4 && !bindData.isOutParameterOn(n2)) {
                ++n2;
            }
            if (n2 >= n4) {
                throw TbError.newSQLException(-90618);
            }
            BindItem bindItem = bindData.getBindItem(n2);
            BindItem bindItem2 = tbCallableStatementImpl.getOutItems(n2);
            bindItem2.set(bindItem.getSQLType(), tbOutParamArray[i].value.length, tbOutParamArray[i].colMeta, null);
            if (tbResultSet == null && tbOutParamArray[i].dataType == 16) {
                tbResultSet = this.typeConverter.toResultSet(tbMsgExecutePsmPrefetchReply.colCnt, tbMsgExecutePsmPrefetchReply.hiddenColCnt, tbMsgExecutePsmPrefetchReply.csrId, tbMsgExecutePsmPrefetchReply.colMeta, tbCallableStatementImpl);
                tbCallableStatementImpl.setOutParam(n2, tbOutParamArray[i].dataType, tbOutParamArray[i].value, tbResultSet);
                continue;
            }
            tbCallableStatementImpl.setOutParam(n2, tbOutParamArray[i].dataType, tbOutParamArray[i].value, null);
        }
        byte[] byArray = tbResultSet.getRowChunk(tbMsgExecutePsmPrefetchReply.rowChunkSize);
        this.stream.readChunkData(byArray, tbMsgExecutePsmPrefetchReply.rowChunkSize);
        tbResultSet.setFetchCompleted(tbMsgExecutePsmPrefetchReply.isFetchCompleted);
        tbResultSet.buildRowTable(tbMsgExecutePsmPrefetchReply.rowCnt, byArray);
        return 1;
    }

    private int executeCountReply(TbStatement tbStatement, TbMsgExecuteCountReply tbMsgExecuteCountReply) throws SQLException {
        long l = (0xFFFFFFFF00000000L & (long)tbMsgExecuteCountReply.cntHigh << 32) + (0xFFFFFFFFL & (long)tbMsgExecuteCountReply.cntLow);
        return (int)l;
    }

    public int executeDirect(TbStatement tbStatement, String string) throws SQLException {
        int n = this.conn.getAutoCommit() ? 1 : 0;
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.EXECDIR(this.stream, n, tbStatement.getPreFetchSize(), string);
            TbMsg tbMsg = this.stream.readMsg();
            block13: while (true) {
                switch (tbMsg.getMsgType()) {
                    case 75: {
                        this.justOKReply((TbMsgOkReply)tbMsg);
                        return TbSQLTypeScanner.isPSMStmt(tbStatement.getSqlType()) ? 1 : 0;
                    }
                    case 2: {
                        this.executeSessInfoReply((TbMsgSessInfoReply)tbMsg);
                        return 0;
                    }
                    case 13: {
                        return this.executeCountReply(tbStatement, (TbMsgExecuteCountReply)tbMsg);
                    }
                    case 8: {
                        return this.executeRsetReply(tbStatement, (TbMsgExecuteRsetReply)tbMsg);
                    }
                    case 14: 
                    case 15: {
                        return 1;
                    }
                    case 11: {
                        return this.executePrefetchReply(tbStatement, (TbMsgExecutePrefetchReply)tbMsg);
                    }
                    case 9: {
                        tbMsg = this.executePivotReply(tbStatement, (TbMsgExecutePivotReply)tbMsg);
                        continue block13;
                    }
                    case 76: {
                        return this.executeDirectEreply(tbStatement, string, tbMsg);
                    }
                }
                this.throwProtocolError(tbMsg.getMsgType());
            }
        }
    }

    private int executeDirectEreply(TbStatement tbStatement, String string, TbMsg tbMsg) throws SQLException {
        SQLException sQLException = this.getErrorMessage(-90508, tbMsg);
        if (sQLException.getErrorCode() == -12018) {
            return this.executeDirect(tbStatement, string);
        }
        throw sQLException;
    }

    private int executeEreply(TbPreparedStatementImpl tbPreparedStatementImpl, String string, TbMsg tbMsg, int n) throws SQLException {
        SQLException sQLException = this.getErrorMessage(-90508, tbMsg);
        if (sQLException.getErrorCode() == -12018) {
            tbPreparedStatementImpl.setPPID(null);
            tbPreparedStatementImpl.buildColMetaArray(0, 0, null);
            return this.prepareExecute(tbPreparedStatementImpl, string, n);
        }
        throw sQLException;
    }

    private int executeNeedDataReply(TbMsg tbMsg, TbPreparedStatementImpl tbPreparedStatementImpl, int n) throws SQLException {
        BindData bindData = tbPreparedStatementImpl.getBindData();
        Binder[][] binderArray = tbPreparedStatementImpl.getBinder();
        TbMsg tbMsg2 = tbMsg;
        int n2 = tbPreparedStatementImpl.getCurCsrId();
        TbStreamDataWriter tbStreamDataWriter = this.stream.getMsgWriter();
        for (int i = bindData.getDFRParameterCnt(); i > 0; --i) {
            int n3 = ((TbMsgExecuteNeedDataReply)tbMsg2).paramIndex;
            BindItem bindItem = bindData.getBindItem(n3);
            if (bindItem.getParamMode() != 8) {
                throw TbError.newSQLException(-590717, bindItem.toString());
            }
            this.stream.startWritingPacketData();
            tbStreamDataWriter.writeInt(54, 4);
            tbStreamDataWriter.writeInt(0, 4);
            tbStreamDataWriter.writeLong(0L, 8);
            tbStreamDataWriter.writeInt(n3, 4);
            tbStreamDataWriter.writeInt(n2, 4);
            binderArray[n][n3].bindDFR(this.conn, tbPreparedStatementImpl, tbStreamDataWriter, n, n3, bindItem.getLength());
            TbMsgSend.PUT_DATA(this.stream, n3, n2, new byte[0], 0);
            tbMsg2 = this.stream.readMsg();
            if (tbMsg2.getMsgType() == 16) {
                tbPreparedStatementImpl.setCurCsrId(((TbMsgExecuteNeedDataReply)tbMsg2).csrId);
                continue;
            }
            if (tbMsg2.getMsgType() != 76) break;
            this.throwEreply(-90508, tbMsg2);
        }
        switch (tbMsg2.getMsgType()) {
            case 14: {
                TbMsgExecuteCallReply tbMsgExecuteCallReply = (TbMsgExecuteCallReply)tbMsg2;
                return this.executeCallReply(tbPreparedStatementImpl, n, tbMsgExecuteCallReply.paramData);
            }
            case 13: {
                return this.executeCountReply(tbPreparedStatementImpl, (TbMsgExecuteCountReply)tbMsg2);
            }
            case 75: {
                this.justOKReply((TbMsgOkReply)tbMsg2);
                return TbSQLTypeScanner.isPSMStmt(tbPreparedStatementImpl.getSqlType()) ? 1 : 0;
            }
            case 8: {
                return this.executeRsetReply(tbPreparedStatementImpl, (TbMsgExecuteRsetReply)tbMsg2);
            }
            case 11: {
                TbMsgExecutePrefetchReply tbMsgExecutePrefetchReply = (TbMsgExecutePrefetchReply)tbMsg2;
                tbPreparedStatementImpl.setPPID(tbMsgExecutePrefetchReply.ppid);
                tbPreparedStatementImpl.buildColMetaArray(tbMsgExecutePrefetchReply.colCnt, tbMsgExecutePrefetchReply.hiddenColCnt, tbMsgExecutePrefetchReply.colMeta);
                return this.executePrefetchReply(tbPreparedStatementImpl, tbMsgExecutePrefetchReply);
            }
            case 12: {
                return this.executePrefetchNoDescReply(tbPreparedStatementImpl, (TbMsgExecutePrefetchNoDescReply)tbMsg2);
            }
        }
        this.throwProtocolError(tbMsg2.getMsgType());
        return 0;
    }

    private TbMsg executePivotReply(TbStatement tbStatement, TbMsgExecutePivotReply tbMsgExecutePivotReply) throws SQLException {
        TbMsg tbMsg;
        TbPivotInfo[] tbPivotInfoArray = new TbPivotInfo[tbMsgExecutePivotReply.pivotInfo.length];
        for (int i = 0; i < tbMsgExecutePivotReply.pivotInfo.length; ++i) {
            tbPivotInfoArray[i] = new TbPivotInfo();
            tbPivotInfoArray[i].colIdx = tbMsgExecutePivotReply.pivotInfo[i].colIdx;
            tbPivotInfoArray[i].chunkCnt = tbMsgExecutePivotReply.pivotInfo[i].chunkCnt;
            if (tbMsgExecutePivotReply.pivotInfo[i].valType == null) continue;
            tbPivotInfoArray[i].valType = new TbPvValType[tbMsgExecutePivotReply.pivotInfo[i].valType.length];
            for (int j = 0; j < tbMsgExecutePivotReply.pivotInfo[i].valType.length; ++j) {
                tbPivotInfoArray[i].valType[j] = new TbPvValType();
                tbPivotInfoArray[i].valType[j].type = tbMsgExecutePivotReply.pivotInfo[i].valType[j].type;
            }
        }
        tbStatement.setPivotInfo(tbPivotInfoArray);
        tbStatement.addPivotData(tbMsgExecutePivotReply.chunk);
        block5: while (true) {
            TbMsgSend.FETCH_PIVOT(this.stream);
            tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 21: {
                    tbStatement.addPivotData(((TbMsgFetchPivotReply)tbMsg).chunk);
                    continue block5;
                }
            }
            break;
        }
        return tbMsg;
    }

    private int executePrefetchNoDescReply(TbPreparedStatementImpl tbPreparedStatementImpl, TbMsgExecutePrefetchNoDescReply tbMsgExecutePrefetchNoDescReply) throws SQLException {
        TbResultSet tbResultSet = this.typeConverter.toResultSet(tbPreparedStatementImpl.getOutColCnt(), tbPreparedStatementImpl.getHiddenColCnt(), tbMsgExecutePrefetchNoDescReply.csrId, tbPreparedStatementImpl.getColMetaArray(), tbPreparedStatementImpl);
        byte[] byArray = tbResultSet.getRowChunk(tbMsgExecutePrefetchNoDescReply.rowChunkSize);
        this.stream.readChunkData(byArray, tbMsgExecutePrefetchNoDescReply.rowChunkSize);
        tbResultSet.setFetchCompleted(tbMsgExecutePrefetchNoDescReply.isFetchCompleted);
        tbResultSet.buildRowTable(tbMsgExecutePrefetchNoDescReply.rowCnt, byArray);
        tbPreparedStatementImpl.setResultSet(tbResultSet);
        return (int)tbResultSet.getUpdateCount();
    }

    private int executePrefetchReply(TbStatement tbStatement, TbMsgExecutePrefetchReply tbMsgExecutePrefetchReply) throws SQLException {
        TbResultSet tbResultSet = this.typeConverter.toResultSet(tbMsgExecutePrefetchReply.colCnt, tbMsgExecutePrefetchReply.hiddenColCnt, tbMsgExecutePrefetchReply.csrId, tbMsgExecutePrefetchReply.colMeta, tbStatement);
        byte[] byArray = tbResultSet.getRowChunk(tbMsgExecutePrefetchReply.rowChunkSize);
        this.stream.readChunkData(byArray, tbMsgExecutePrefetchReply.rowChunkSize);
        tbResultSet.setFetchCompleted(tbMsgExecutePrefetchReply.isFetchCompleted);
        tbResultSet.buildRowTable(tbMsgExecutePrefetchReply.rowCnt, byArray);
        tbStatement.setResultSet(tbResultSet);
        return (int)tbResultSet.getUpdateCount();
    }

    private int executeRsetNoDescReply(TbPreparedStatementImpl tbPreparedStatementImpl, TbMsgExecuteRsetNoDescReply tbMsgExecuteRsetNoDescReply) throws SQLException {
        TbResultSet tbResultSet = this.typeConverter.toResultSet(tbPreparedStatementImpl.getOutColCnt(), tbPreparedStatementImpl.getHiddenColCnt(), tbMsgExecuteRsetNoDescReply.csrId, tbPreparedStatementImpl.getColMetaArray(), tbPreparedStatementImpl);
        tbPreparedStatementImpl.setResultSet(tbResultSet);
        return (int)tbResultSet.getUpdateCount();
    }

    private int executeRsetReply(TbStatement tbStatement, TbMsgExecuteRsetReply tbMsgExecuteRsetReply) throws SQLException {
        TbResultSet tbResultSet = this.typeConverter.toResultSet(tbMsgExecuteRsetReply.colCnt, tbMsgExecuteRsetReply.hiddenColCnt, tbMsgExecuteRsetReply.csrId, tbMsgExecuteRsetReply.colMeta, tbStatement);
        tbStatement.setResultSet(tbResultSet);
        return tbMsgExecuteRsetReply.affectedCnt;
    }

    private void executeSessInfoReply(TbMsgSessInfoReply tbMsgSessInfoReply) {
        this.conn.setSessionId(tbMsgSessInfoReply.sessionId);
        this.conn.setSerialNo(tbMsgSessInfoReply.serialNo);
        this.conn.setNLSDate(tbMsgSessInfoReply.nlsData[0].nlsParamVal);
        this.conn.setNLSTimestamp(tbMsgSessInfoReply.nlsData[2].nlsParamVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetch(TbStatement tbStatement, TbResultSetBase tbResultSetBase) throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            int n = tbResultSetBase.getFetchSize();
            int n2 = tbResultSetBase.getPreparedFetchCnt();
            if (n2 <= 0) {
                TbMsgSend.FETCH(this.stream, tbResultSetBase.getCursorId(), n);
                n2 = n * -1;
            }
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 19: {
                    this.fetchReply(tbStatement, (TbMsgFetchReply)tbMsg, tbResultSetBase);
                    --n2;
                    break;
                }
                case 76: {
                    SQLException sQLException = this.getErrorMessage(-90509, tbMsg);
                    String string = sQLException.getSQLState();
                    if (sQLException.getErrorCode() == -12018) {
                        ((TbMsgEreply)tbMsg).changeRootException(new SQLException(TbError.getMsg(-12031), string, -12031));
                    }
                    this.throwEreply(-90509, tbMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
            tbResultSetBase.setPreparedFetchCnt(n2);
        }
    }

    private void fetchReply(TbStatement tbStatement, TbMsgFetchReply tbMsgFetchReply, TbResultSetBase tbResultSetBase) throws SQLException {
        byte[] byArray = tbResultSetBase.getRowChunk(tbMsgFetchReply.rowChunkSize);
        this.stream.readChunkData(byArray, tbMsgFetchReply.rowChunkSize);
        tbResultSetBase.setFetchCompleted(tbMsgFetchReply.isFetchCompleted);
        tbResultSetBase.buildRowTable(tbMsgFetchReply.rowCnt, byArray);
    }

    public void freeTemporary(TbLob tbLob) throws SQLException {
        this.lobFreeTemporary(tbLob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TbResultSet describeCSRReply(TbStatement tbStatement, int n) throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.DESCRIBE_CSR(this.stream, n);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 11: {
                    return this.doDescribeCSRPrefetch(tbStatement, (TbMsgExecutePrefetchReply)tbMsg);
                }
                case 76: {
                    this.throwEreply(-90546, tbMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
        }
        return null;
    }

    private TbResultSet doDescribeCSRPrefetch(TbStatement tbStatement, TbMsgExecutePrefetchReply tbMsgExecutePrefetchReply) throws SQLException {
        if (tbMsgExecutePrefetchReply.colMeta == null) {
            throw TbError.newSQLException(-90644);
        }
        TbResultSet tbResultSet = TbResultSetFactory.buildResultSet(tbStatement, tbMsgExecutePrefetchReply.csrId, tbMsgExecutePrefetchReply.colMeta.length, 0);
        this.typeConverter.buildColumnMetadata(tbMsgExecutePrefetchReply.colMeta, tbResultSet, tbMsgExecutePrefetchReply.colMeta.length);
        byte[] byArray = tbResultSet.getRowChunk(tbMsgExecutePrefetchReply.rowChunkSize);
        this.stream.readChunkData(byArray, tbMsgExecutePrefetchReply.rowChunkSize);
        tbResultSet.setFetchCompleted(tbMsgExecutePrefetchReply.isFetchCompleted);
        tbResultSet.buildRowTable(tbMsgExecutePrefetchReply.rowCnt, byArray);
        tbStatement.addSubResultSet(tbResultSet);
        return tbResultSet;
    }

    public SQLException getErrorMessage(int n, TbMsg tbMsg) throws SQLException {
        TbMsgEreply tbMsgEreply = (TbMsgEreply)tbMsg;
        if (tbMsgEreply.flag == Integer.MIN_VALUE) {
            this.reset();
        }
        return tbMsgEreply.getException(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TbSQLInfo getLastExecutedSqlinfo() throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.GET_LAST_EXECUTED_SQLINFO(this.stream, this.conn.getSessionId());
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 74: {
                    TbMsgGetLastExecutedSqlinfoReply tbMsgGetLastExecutedSqlinfoReply = (TbMsgGetLastExecutedSqlinfoReply)tbMsg;
                    TbSQLInfo tbSQLInfo = new TbSQLInfo();
                    tbSQLInfo.setSqlid(tbMsgGetLastExecutedSqlinfoReply.sqlid);
                    tbSQLInfo.setHashval(tbMsgGetLastExecutedSqlinfoReply.hashval);
                    return tbSQLInfo;
                }
                case 76: {
                    this.throwEreply(-90535, tbMsg);
                }
            }
            this.throwProtocolError(tbMsg.getMsgType());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TbSQLInfo2 getLastExecutedSqlinfo2() throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.GET_LAST_EXECUTED_SQLINFO2(this.stream, this.conn.getSessionId());
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 249: {
                    TbMsgGetLastExecutedSqlinfo2Reply tbMsgGetLastExecutedSqlinfo2Reply = (TbMsgGetLastExecutedSqlinfo2Reply)tbMsg;
                    TbSQLInfo2 tbSQLInfo2 = new TbSQLInfo2();
                    tbSQLInfo2.setSqlId(tbMsgGetLastExecutedSqlinfo2Reply.sqlid);
                    tbSQLInfo2.setChildNum(tbMsgGetLastExecutedSqlinfo2Reply.childNum);
                    return tbSQLInfo2;
                }
                case 76: {
                    this.throwEreply(-90535, tbMsg);
                }
            }
            this.throwProtocolError(tbMsg.getMsgType());
        }
        return null;
    }

    public TbStream getStream() {
        return this.stream;
    }

    protected TbConnection getTbConnection() {
        return this.conn;
    }

    public TbStream getTbStream() {
        return this.stream;
    }

    public SQLWarning getWarningMessage() throws SQLException {
        return null;
    }

    private void justOKReply(TbMsgOkReply tbMsgOkReply) {
        if (tbMsgOkReply.warningMsg != null && tbMsgOkReply.warningMsg.length() > 0) {
            this.conn.addWarning(new SQLWarning(tbMsgOkReply.warningMsg));
        }
    }

    public long length(TbLob tbLob) throws SQLException {
        long l = this.lobLength(tbLob);
        return tbLob instanceof TbBlob ? l : l / (long)this.typeConverter.getUCS2MaxBytesPerChar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lobClose(TbLob tbLob) throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.LOB_CLOSE(this.stream, tbLob.getLocator(), tbLob.getLocatorLength());
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 51: {
                    tbLob.setLocator(((TbMsgLobCloseReply)tbMsg).slobLoc);
                    return true;
                }
                case 76: {
                    throw this.getErrorMessage(-90522, tbMsg);
                }
            }
            this.throwProtocolError(tbMsg.getMsgType());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] lobCreateTemporary(int n) throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.LOB_CREATE_TEMP(this.stream, n);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 44: {
                    return ((TbMsgLobCreateTempReply)tbMsg).slobLoc;
                }
                case 76: {
                    throw this.getErrorMessage(-90524, tbMsg);
                }
            }
            this.throwProtocolError(tbMsg.getMsgType());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lobFreeTemporary(TbLob tbLob) throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.LOB_DELETE_TEMP(this.stream, tbLob.getLocator(), tbLob.getLocatorLength());
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)tbMsg);
                    break;
                }
                case 76: {
                    throw this.getErrorMessage(-90525, tbMsg);
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lobLength(TbLob tbLob) throws SQLException {
        if (tbLob.isInline()) {
            return tbLob.getIlobLength();
        }
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.LOB_LENGTH(this.stream, tbLob.getLocator(), tbLob.getLocatorLength());
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 34: {
                    TbMsgLobLengthReply tbMsgLobLengthReply = (TbMsgLobLengthReply)tbMsg;
                    return (0xFFFFFFFF00000000L & (long)tbMsgLobLengthReply.lenHigh << 32) + (0xFFFFFFFFL & (long)tbMsgLobLengthReply.lenLow);
                }
                case 76: {
                    throw this.getErrorMessage(-90523, tbMsg);
                }
            }
            this.throwProtocolError(tbMsg.getMsgType());
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lobOpen(TbLob tbLob, int n) throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.LOB_OPEN(this.stream, n, tbLob.getLocator(), tbLob.getLocatorLength());
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 49: {
                    tbLob.setLocator(((TbMsgLobOpenReply)tbMsg).slobLoc);
                    return true;
                }
                case 76: {
                    throw this.getErrorMessage(-90521, tbMsg);
                }
            }
            this.throwProtocolError(tbMsg.getMsgType());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lobPosition(TbLob tbLob, String string, long l) throws SQLException {
        int n = (int)(l >> 32);
        int n2 = (int)(l & 0xFFFFFFFFL);
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.LOB_INSTR(this.stream, n, n2, tbLob.getLocator(), tbLob.getLocatorLength(), string);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 40: {
                    TbMsgLobInstrReply tbMsgLobInstrReply = (TbMsgLobInstrReply)tbMsg;
                    long l2 = 0xFFFFFFFF00000000L & (long)(tbMsgLobInstrReply.offsetHigh << 32) + (0xFFFFFFFFL & (long)tbMsgLobInstrReply.offsetLow);
                    return l2;
                }
                case 76: {
                    throw this.getErrorMessage(-90518, tbMsg);
                }
            }
            this.throwProtocolError(tbMsg.getMsgType());
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lobPosition(TbLob tbLob, TbLob tbLob2, long l) throws SQLException {
        int n = (int)(l >> 32);
        int n2 = (int)(l & 0xFFFFFFFFL);
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.LOB_INLOB(this.stream, n, n2, tbLob.getLocator(), tbLob.getLocatorLength(), tbLob2.getLocator(), tbLob2.getLocatorLength());
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 47: {
                    TbMsgLobInlobReply tbMsgLobInlobReply = (TbMsgLobInlobReply)tbMsg;
                    long l2 = 0xFFFFFFFF00000000L & (long)(tbMsgLobInlobReply.offsetHigh << 32) + (0xFFFFFFFFL & (long)tbMsgLobInlobReply.offsetLow);
                    return l2;
                }
                case 76: {
                    throw this.getErrorMessage(-90519, tbMsg);
                }
            }
            this.throwProtocolError(tbMsg.getMsgType());
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lobRead(TbLob tbLob, long l, char[] cArray, byte[] byArray, long l2, int n) throws SQLException {
        if (tbLob.isInline()) {
            boolean bl = false;
            if (tbLob.isRemote()) {
                if (!tbLob.isXML()) {
                    throw TbError.newSQLException(-90902);
                }
                bl = true;
            }
            return tbLob.readIlob((int)l, cArray, byArray, (int)l2, n, this.typeConverter, bl);
        }
        int n2 = (int)(l >> 32);
        int n3 = (int)(l & 0xFFFFFFFFL);
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.LOB_READ(this.stream, n2, n3, n, tbLob.getLocator(), tbLob.getLocatorLength());
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 36: {
                    return this.lobReadReply((TbMsgLobReadReply)tbMsg, tbLob, l, cArray, byArray, l2, n);
                }
                case 76: {
                    throw this.getErrorMessage(-90516, tbMsg);
                }
            }
            this.throwProtocolError(tbMsg.getMsgType());
        }
        return 0;
    }

    private int lobReadReply(TbMsgLobReadReply tbMsgLobReadReply, TbLob tbLob, long l, char[] cArray, byte[] byArray, long l2, int n) throws SQLException {
        int n2 = 0;
        if (tbMsgLobReadReply.data != null) {
            n2 = tbMsgLobReadReply.data.length;
        }
        if (n2 == n) {
            tbLob.setEndOfStream(false);
        } else {
            tbLob.setEndOfStream(true);
        }
        if (n2 <= 0) {
            return 0;
        }
        if (tbLob instanceof TbClob || tbLob instanceof TbNClob) {
            return this.typeConverter.fixedBytesToChars(tbMsgLobReadReply.data, 0, n2, cArray, (int)l2, (int)((long)cArray.length - l2));
        }
        System.arraycopy(tbMsgLobReadReply.data, 0, byArray, (int)l2, n2);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lobTruncate(TbLob tbLob, long l) throws SQLException {
        int n = (int)(l >> 32);
        int n2 = (int)(l & 0xFFFFFFFFL);
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.LOB_TRUNC(this.stream, n, n2, tbLob.getLocator(), tbLob.getLocatorLength());
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 38: {
                    tbLob.setLocator(((TbMsgLobTruncReply)tbMsg).slobLoc);
                    break;
                }
                case 76: {
                    throw this.getErrorMessage(-90520, tbMsg);
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lobWrite(TbLob tbLob, long l, char[] cArray, byte[] byArray, long l2, long l3, int n) throws SQLException {
        int n2;
        int n3 = (int)(l >> 32);
        int n4 = (int)(l & 0xFFFFFFFFL);
        int n5 = 0;
        byte[] byArray2 = null;
        if (tbLob instanceof TbClob || tbLob instanceof TbNClob) {
            n2 = this.typeConverter.getUCS2MaxBytesPerChar() * (int)l3;
            byArray2 = new byte[n2];
            n5 = n2;
            this.typeConverter.charsToFixedBytes(cArray, (int)l2, (int)l3, byArray2, 0, n5);
        } else {
            n2 = TbCommon.getPadLength((int)l3);
            byArray2 = new byte[(int)l3 + n2];
            n5 = (int)l3;
            System.arraycopy(byArray, (int)l2, byArray2, 0, (int)l3);
            TbCommon.writePadding(byArray2, (int)l3, n2);
        }
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.LOB_WRITE(this.stream, n3, n4, n, tbLob.getLocator(), tbLob.getLocatorLength(), byArray2, n5);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)tbMsg);
                    break;
                }
                case 42: {
                    this.lobWriteReply(tbLob, (TbMsgLobWriteReply)tbMsg, n);
                    break;
                }
                case 76: {
                    throw this.getErrorMessage(-90517, tbMsg);
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
        }
    }

    private void lobWriteReply(TbLob tbLob, TbMsgLobWriteReply tbMsgLobWriteReply, int n) {
        if ((n & 0x2000000) == 0) {
            return;
        }
        tbLob.setLocator(tbMsgLobWriteReply.slobLoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void logon(boolean bl) throws SQLException {
        while (true) {
            TbStream tbStream = this.stream;
            synchronized (tbStream) {
                TbMsg tbMsg = this.stream.readMsg();
                switch (tbMsg.getMsgType()) {
                    case 0: {
                        if (!this.logonConnectReply((TbMsgConnectReply)tbMsg, bl)) {
                            return;
                        }
                        this.logonAuthRequest(bl);
                        break;
                    }
                    case 2: {
                        this.logonSessInfoReply((TbMsgSessInfoReply)tbMsg);
                        return;
                    }
                    case 144: {
                        break;
                    }
                    case 76: {
                        this.logonEreply(tbMsg, bl);
                        return;
                    }
                    default: {
                        this.throwProtocolError(tbMsg.getMsgType());
                    }
                }
            }
        }
    }

    private void logonAuthRequest(boolean bl) throws SQLException {
        Object object;
        Object object2;
        int n;
        String string;
        String string2;
        String string3 = this.conn.info.getUser();
        String string4 = this.conn.info.getPassword();
        if (string4.length() >= 2 && string4.startsWith("\"") && string4.endsWith("\"")) {
            string4 = string4.substring(1, string4.length() - 1);
        }
        if ((string2 = this.conn.info.getDatabaseName()).length() >= 2 && string2.startsWith("\"") && string2.endsWith("\"")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if ((string = this.conn.info.getProgramName()) == null) {
            string = "JDBC Thin Client";
        }
        String string5 = System.getProperty("user.name");
        String string6 = null;
        try {
            string6 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        TbClntInfoParam[] tbClntInfoParamArray = new TbClntInfoParam[7];
        for (n = 0; n < 7; ++n) {
            tbClntInfoParamArray[n] = new TbClntInfoParam();
        }
        tbClntInfoParamArray[0].set(0, "-1");
        tbClntInfoParamArray[1].set(1, string);
        tbClntInfoParamArray[2].set(2, null);
        tbClntInfoParamArray[3].set(3, string5);
        tbClntInfoParamArray[4].set(4, string6);
        n = 0;
        String string7 = this.conn.info.getNewPassword();
        String string8 = null;
        if (string7 != null && string7.length() != 0) {
            n |= 0x10;
            string8 = string4;
            string4 = string7;
        }
        if (this.conn.getServerInfo().getProtocolMajorVersion() >= 2 && this.conn.getServerInfo().getProtocolMinorVersion() >= 9 && this.conn.getSessKey() != null) {
            try {
                object2 = this.conn.getTypeConverter();
                String string9 = this.conn.getSessKey();
                object = DataTypeConverter.tbBase64Decode(string9.getBytes("ASCII"));
                string9 = new String((byte[])object, "ASCII");
                String string10 = string9.substring("-----BEGIN PUBLIC KEY-----\n".length(), string9.lastIndexOf("-----END PUBLIC KEY-----"));
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(DataTypeConverter.base64Decode(string10.getBytes("ASCII")));
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
                Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
                cipher.init(1, publicKey);
                byte[] byArray = cipher.doFinal(((DataTypeConverter)object2).getDBEncodedBytes(string4));
                string4 = DataTypeConverter.tbBase64Encode(byArray);
                if (string8 != null) {
                    byArray = cipher.doFinal(((DataTypeConverter)object2).getDBEncodedBytes(string8));
                    string8 = DataTypeConverter.tbBase64Encode(byArray);
                }
            }
            catch (Exception exception) {
                System.err.println(exception);
                throw TbError.newSQLException(-90502);
            }
        }
        tbClntInfoParamArray[5].set(5, string8);
        object2 = new TbNlsParam[11];
        for (int i = 0; i < 11; ++i) {
            object2[i] = new TbNlsParam();
        }
        object2[0].set(0, null);
        object2[1].set(1, null);
        object2[2].set(2, null);
        object2[3].set(6, null);
        object2[4].set(3, CharsetMetaData.getNLSLanguage(Locale.getDefault()));
        object2[5].set(4, null);
        object2[6].set(5, null);
        TimeZone timeZone = TimeZone.getDefault();
        object = ZoneInfo.convertStandardTimeZoneID(timeZone.getID());
        if (ZoneInfo.getTimeZoneIdByName((String)object) == 581) {
            int n2 = timeZone.getRawOffset();
            String string11 = "";
            string11 = n2 >= 0 ? string11 + "+" : string11 + "-";
            int n3 = Math.abs(n2) / 3600000;
            int n4 = n2 / 60000 % 60;
            string11 = n3 >= 10 ? string11 + String.valueOf(n3) : string11 + "0" + String.valueOf(n3);
            string11 = n4 == 0 ? string11 + ":00" : string11 + ":" + String.valueOf(n4);
            timeZone.setID("GMT" + string11);
            object = ZoneInfo.convertStandardTimeZoneID(timeZone.getID());
        }
        ((TbNlsParam)object2[7]).set(7, (String)object);
        TbMsgSend.AUTH_REQ_WITH_VER(this.stream, 2, 13, n, string3, string2, string4, tbClntInfoParamArray.length, tbClntInfoParamArray, ((Object)object2).length, (TbNlsParam[])object2, 1);
    }

    private boolean logonConnectReply(TbMsgConnectReply tbMsgConnectReply, boolean bl) throws SQLException {
        if (this.conn.info.isLoadBalance() && !this.conn.isMiddleOfFailover() && tbMsgConnectReply.flags == 4096) {
            ConnectionInfo connectionInfo = this.conn.info;
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.conn.openConnection(connectionInfo, bl);
            return false;
        }
        int n = Charset.getCharset(this.conn.info.getCharacterSet());
        if (n == -1) {
            n = tbMsgConnectReply.charset;
        }
        if (tbMsgConnectReply.protocolMajor < 2) {
            throw TbError.newSQLException(-90203);
        }
        ServerInfo serverInfo = new ServerInfo(n, tbMsgConnectReply.ncharset, tbMsgConnectReply.svrIsBigendian, tbMsgConnectReply.svrIsNanobase, tbMsgConnectReply.tbMajor, tbMsgConnectReply.tbMinor, tbMsgConnectReply.tbProductName, tbMsgConnectReply.tbProductVersion, tbMsgConnectReply.protocolMajor, tbMsgConnectReply.protocolMinor);
        this.conn.setServerInfo(serverInfo);
        this.conn.setMthrPid(tbMsgConnectReply.mthrPid);
        this.typeConverter.setCharset(this.conn.getServerCharSet(), this.conn.getServerNCharSet());
        this.conn.setMaxDFRCharCount();
        if (tbMsgConnectReply.protocolMinor >= 2 && tbMsgConnectReply.protocolMinor >= 9) {
            TbMsgSend.REQUEST_SESSKEY(this.stream);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 283: {
                    TbMsgSesskeyReply tbMsgSesskeyReply = (TbMsgSesskeyReply)tbMsg;
                    if (tbMsgSesskeyReply.sesskey == null || tbMsgSesskeyReply.sesskey.length() == 0) {
                        this.conn.setSessKey(null);
                        break;
                    }
                    this.conn.setSessKey(tbMsgSesskeyReply.sesskey);
                    break;
                }
                case 76: {
                    this.logonEreply(tbMsg, bl);
                    return false;
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
        }
        return true;
    }

    private void logonEreply(TbMsg tbMsg, boolean bl) throws SQLException {
        ConnectionInfo connectionInfo = this.conn.info;
        SQLException sQLException = this.getErrorMessage(-90502, tbMsg);
        if (sQLException.getErrorCode() == -12060) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            this.conn.openConnection(connectionInfo, bl);
        } else if (sQLException.getErrorCode() == -12004) {
            this.logon(bl);
        } else {
            throw sQLException;
        }
    }

    private void logonSessInfoReply(TbMsgSessInfoReply tbMsgSessInfoReply) {
        this.conn.setSessionId(tbMsgSessInfoReply.sessionId);
        this.conn.setSerialNo(tbMsgSessInfoReply.serialNo);
        this.conn.setNLSDate(tbMsgSessInfoReply.nlsData[0].nlsParamVal);
        this.conn.setNLSTimestamp(tbMsgSessInfoReply.nlsData[2].nlsParamVal);
        boolean bl = false;
        if (tbMsgSessInfoReply.nlsData.length > 8 && tbMsgSessInfoReply.nlsData[8].nlsParamVal != null && tbMsgSessInfoReply.nlsData[8].nlsParamVal.equals("Y")) {
            bl = true;
        }
        if (bl) {
            this.conn.setNLSWarning(bl);
            SQLException sQLException = TbError.newSQLException(-90547);
            this.conn.addWarning(new SQLWarning(sQLException.getMessage(), sQLException.getSQLState(), -90547));
        }
    }

    public boolean open(TbLob tbLob, int n) throws SQLException {
        return this.lobOpen(tbLob, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openSession() throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.OPEN_SESS(this.stream);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)tbMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90504, tbMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
        }
    }

    public long position(TbBlob tbBlob, byte[] byArray, long l) throws SQLException {
        return this.lobPosition((TbLob)tbBlob, byArray.toString(), l);
    }

    public long position(TbClobBase tbClobBase, char[] cArray, long l) throws SQLException {
        long l2 = this.lobPosition((TbLob)tbClobBase, cArray.toString(), l);
        return l2 * (long)this.typeConverter.getUCS2MaxBytesPerChar();
    }

    public long position(TbLob tbLob, TbLob tbLob2, long l) throws SQLException {
        long l2 = this.lobPosition(tbLob, tbLob2, l);
        return tbLob instanceof TbBlob ? l2 : l2 * (long)this.typeConverter.getUCS2MaxBytesPerChar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(TbPreparedStatementImpl tbPreparedStatementImpl, String string, Vector vector) throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.PREPARE(this.stream, string);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 4: {
                    this.prepareReply(tbPreparedStatementImpl, (TbMsgPrepareReply)tbMsg, vector);
                    return;
                }
                case 76: {
                    this.throwEreply(-90506, tbMsg);
                    return;
                }
            }
            this.throwProtocolError(tbMsg.getMsgType());
        }
    }

    public int prepareExecute(TbPreparedStatementImpl tbPreparedStatementImpl, String string, int n) throws SQLException {
        if (tbPreparedStatementImpl.getPPID() != null) {
            return this.execute(tbPreparedStatementImpl, string, n);
        }
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            this.processExecute(tbPreparedStatementImpl, string, n, false);
            TbMsg tbMsg = this.stream.readMsg();
            block16: while (true) {
                switch (tbMsg.getMsgType()) {
                    case 75: {
                        this.justOKReply((TbMsgOkReply)tbMsg);
                        return TbSQLTypeScanner.isPSMStmt(tbPreparedStatementImpl.getSqlType()) ? 1 : 0;
                    }
                    case 2: {
                        this.executeSessInfoReply((TbMsgSessInfoReply)tbMsg);
                        return 0;
                    }
                    case 13: {
                        TbMsgExecuteCountReply tbMsgExecuteCountReply = (TbMsgExecuteCountReply)tbMsg;
                        tbPreparedStatementImpl.setPPID(tbMsgExecuteCountReply.ppid);
                        return this.executeCountReply(tbPreparedStatementImpl, tbMsgExecuteCountReply);
                    }
                    case 11: {
                        TbMsgExecutePrefetchReply tbMsgExecutePrefetchReply = (TbMsgExecutePrefetchReply)tbMsg;
                        tbPreparedStatementImpl.setPPID(tbMsgExecutePrefetchReply.ppid);
                        tbPreparedStatementImpl.buildColMetaArray(tbMsgExecutePrefetchReply.colCnt, tbMsgExecutePrefetchReply.hiddenColCnt, tbMsgExecutePrefetchReply.colMeta);
                        return this.executePrefetchReply(tbPreparedStatementImpl, tbMsgExecutePrefetchReply);
                    }
                    case 8: {
                        TbMsgExecuteRsetReply tbMsgExecuteRsetReply = (TbMsgExecuteRsetReply)tbMsg;
                        tbPreparedStatementImpl.setPPID(tbMsgExecuteRsetReply.ppid);
                        tbPreparedStatementImpl.buildColMetaArray(tbMsgExecuteRsetReply.colCnt, tbMsgExecuteRsetReply.hiddenColCnt, tbMsgExecuteRsetReply.colMeta);
                        return this.executeRsetReply(tbPreparedStatementImpl, tbMsgExecuteRsetReply);
                    }
                    case 16: {
                        return this.executeNeedDataReply(tbMsg, tbPreparedStatementImpl, n);
                    }
                    case 15: {
                        TbMsgExecutePsmReply tbMsgExecutePsmReply = (TbMsgExecutePsmReply)tbMsg;
                        return this.executeCallReply(tbPreparedStatementImpl, n, tbMsgExecutePsmReply.paramData);
                    }
                    case 14: {
                        TbMsgExecuteCallReply tbMsgExecuteCallReply = (TbMsgExecuteCallReply)tbMsg;
                        return this.executeCallReply(tbPreparedStatementImpl, n, tbMsgExecuteCallReply.paramData);
                    }
                    case 183: {
                        TbMsgExecutePsmPrefetchReply tbMsgExecutePsmPrefetchReply = (TbMsgExecutePsmPrefetchReply)tbMsg;
                        tbPreparedStatementImpl.setPPID(tbMsgExecutePsmPrefetchReply.ppid);
                        tbPreparedStatementImpl.buildColMetaArray(tbMsgExecutePsmPrefetchReply.colCnt, tbMsgExecutePsmPrefetchReply.hiddenColCnt, tbMsgExecutePsmPrefetchReply.colMeta);
                        if (!(tbPreparedStatementImpl instanceof TbCallableStatementImpl)) {
                            return 1;
                        }
                        return this.executePsmPrefetchReply((TbCallableStatementImpl)tbPreparedStatementImpl, n, tbMsgExecutePsmPrefetchReply);
                    }
                    case 9: {
                        tbMsg = this.executePivotReply(tbPreparedStatementImpl, (TbMsgExecutePivotReply)tbMsg);
                        continue block16;
                    }
                    case 76: {
                        this.throwEreply(-90508, tbMsg);
                    }
                }
                this.throwProtocolError(tbMsg.getMsgType());
            }
        }
    }

    private void prepareReply(TbPreparedStatementImpl tbPreparedStatementImpl, TbMsgPrepareReply tbMsgPrepareReply, Vector vector) {
        if (tbMsgPrepareReply.isPreparedDdl == 1) {
            tbPreparedStatementImpl.setPPID(null);
            tbPreparedStatementImpl.setParameterCnt(0);
        } else {
            int n = tbMsgPrepareReply.bindParamCnt;
            tbPreparedStatementImpl.setPPID(tbMsgPrepareReply.ppid);
            tbPreparedStatementImpl.setParameterCnt(n);
            for (int i = 0; i < n; ++i) {
                vector.add(i, new Integer(tbMsgPrepareReply.bindParamMeta[i].type));
            }
            tbPreparedStatementImpl.buildColMetaArray(tbMsgPrepareReply.outColCnt, tbMsgPrepareReply.hiddenColCnt, tbMsgPrepareReply.colDesc);
        }
    }

    private void processExecute(TbPreparedStatementImpl tbPreparedStatementImpl, String string, int n, boolean bl) throws SQLException {
        TbStreamDataWriter tbStreamDataWriter = this.stream.getMsgWriter();
        int n2 = this.conn.getAutoCommit() ? 1 : 0;
        BindData bindData = tbPreparedStatementImpl.getBindData();
        Binder[][] binderArray = tbPreparedStatementImpl.getBinder();
        int n3 = bindData.getParameterCnt();
        this.stream.startWritingPacketData();
        if (bl) {
            tbStreamDataWriter.writeInt(5, 4);
        } else {
            tbStreamDataWriter.writeInt(7, 4);
        }
        tbStreamDataWriter.writeInt(0, 4);
        tbStreamDataWriter.writeLong(0L, 8);
        if (bl) {
            tbStreamDataWriter.writeBytes(tbPreparedStatementImpl.getPPID());
        } else {
            tbStreamDataWriter.writeLenAndDBEncodedPadString(string == null ? "" : string);
        }
        tbStreamDataWriter.writeInt(n2, 4);
        tbStreamDataWriter.writeInt(tbPreparedStatementImpl.getPreFetchSize(), 4);
        tbStreamDataWriter.writeInt(n3, 4);
        for (int i = 0; i < n3; ++i) {
            if (binderArray[n][i] == null) {
                throw TbError.newSQLException(-90627);
            }
            BindItem bindItem = bindData.getBindItem(i);
            int n4 = bindItem.getParamMode() & 0xFF | tbPreparedStatementImpl.getParamType(n, i) << 8 & 0xFFFFFF00;
            tbStreamDataWriter.writeInt(n4, 4);
            binderArray[n][i].bind(this.conn, tbPreparedStatementImpl, tbStreamDataWriter, n, i, bindItem.getLength());
        }
        tbStreamDataWriter.reWriteInt(4, tbStreamDataWriter.getBufferedDataSize() - 16, 4);
        this.stream.flush();
    }

    public long read(TbBlob tbBlob, long l, byte[] byArray, long l2, long l3) throws SQLException {
        int n = 0;
        int n2 = 0;
        long l4 = 0L;
        do {
            n = l3 - l4 >= (long)TbLob.getMaxChunkSize() ? TbLob.getMaxChunkSize() : (int)(l3 - l4);
        } while (l3 > (l4 += (long)(n2 = this.lobRead(tbBlob, l + l4, null, byArray, l2 + l4, n))) && n == n2);
        return l4;
    }

    public long read(TbClobBase tbClobBase, long l, char[] cArray, long l2, long l3) throws SQLException {
        int n = 0;
        int n2 = 0;
        long l4 = 0L;
        int n3 = 2;
        long l5 = l * (long)n3;
        int n4 = TbLob.getMaxChunkSize() / n3;
        do {
            n = l3 - l4 >= (long)n4 ? n4 : (int)(l3 - l4);
            n2 = this.lobRead(tbClobBase, l5, cArray, null, l2 + l4, n * n3);
            l5 += (long)(n2 * n3);
        } while (l3 > (l4 += (long)n2) && !tbClobBase.isEndOfStream());
        return l4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLong(byte[] byArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        TbMsgLongReadReply tbMsgLongReadReply = null;
        byte[] byArray2 = new byte[3];
        int n = 0;
        char[] cArray = new char[65532];
        do {
            TbStream tbStream = this.stream;
            synchronized (tbStream) {
                TbMsgSend.LONG_READ(this.stream, 65532, byArray, byArray.length);
                TbMsg tbMsg = this.stream.readMsg();
                switch (tbMsg.getMsgType()) {
                    case 53: {
                        byte[] byArray3;
                        tbMsgLongReadReply = (TbMsgLongReadReply)tbMsg;
                        byArray = new byte[tbMsgLongReadReply.longLoc.length];
                        System.arraycopy(tbMsgLongReadReply.longLoc, 0, byArray, 0, byArray.length);
                        if (tbMsgLongReadReply.data == null || tbMsgLongReadReply.data.length == 0) break;
                        if (n > 0) {
                            byArray3 = new byte[tbMsgLongReadReply.data.length + n];
                            System.arraycopy(byArray2, 0, byArray3, 0, n);
                            System.arraycopy(tbMsgLongReadReply.data, 0, byArray3, n, tbMsgLongReadReply.data.length);
                            n = 0;
                        } else {
                            byArray3 = tbMsgLongReadReply.data;
                        }
                        int n2 = this.typeConverter.getEndingBytePos(byArray3, byArray3.length - 1);
                        if (n2 > byArray3.length - 1) {
                            n2 = this.typeConverter.getLeadingBytePos(byArray3, byArray3.length - 1);
                            n = byArray3.length - n2;
                            System.arraycopy(byArray3, n2, byArray2, 0, n);
                        }
                        int n3 = this.typeConverter.bytesToChars(byArray3, 0, n2 + 1, cArray, 0, n2 + 1);
                        stringBuffer.append(cArray, 0, n3);
                        break;
                    }
                    case 76: {
                        throw this.getErrorMessage(-90534, tbMsg);
                    }
                    default: {
                        this.throwProtocolError(tbMsg.getMsgType());
                    }
                }
            }
        } while (tbMsgLongReadReply.isLastData == 0);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readLongRaw(byte[] byArray) throws SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TbMsgLongReadReply tbMsgLongReadReply = null;
        do {
            TbStream tbStream = this.stream;
            synchronized (tbStream) {
                TbMsgSend.LONG_READ(this.stream, 65532, byArray, byArray.length);
                TbMsg tbMsg = this.stream.readMsg();
                switch (tbMsg.getMsgType()) {
                    case 53: {
                        tbMsgLongReadReply = (TbMsgLongReadReply)tbMsg;
                        byArray = new byte[tbMsgLongReadReply.longLoc.length];
                        System.arraycopy(tbMsgLongReadReply.longLoc, 0, byArray, 0, byArray.length);
                        byteArrayOutputStream.write(tbMsgLongReadReply.data, 0, tbMsgLongReadReply.data.length);
                        break;
                    }
                    case 76: {
                        throw this.getErrorMessage(-90534, tbMsg);
                    }
                    default: {
                        this.throwProtocolError(tbMsg.getMsgType());
                    }
                }
            }
        } while (tbMsgLongReadReply.isLastData == 0);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        try {
            TbStream tbStream = this.stream;
            synchronized (tbStream) {
                if (this.stream != null) {
                    this.stream.close();
                    this.stream = null;
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.conn != null) {
            this.conn.reset();
            this.conn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSession() throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.RESET_SESS(this.stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.ROLLBACK(this.stream, null);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)tbMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90511, tbMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(TbSavepoint tbSavepoint) throws SQLException {
        String string = null;
        if (tbSavepoint != null) {
            try {
                string = tbSavepoint.getSavepointName();
            }
            catch (SQLException sQLException) {
                string = "SVPT" + tbSavepoint.getSavepointId();
            }
        }
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.ROLLBACK(this.stream, string);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)tbMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90511, tbMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsolationLevel(int n) throws SQLException {
        int n2 = 0;
        if (n == 2) {
            n2 = 0;
        } else if (n == 8) {
            n2 = 1;
        } else {
            throw TbError.newSQLException(-590722);
        }
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.SET_ISL_LVL(this.stream, n2);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)tbMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90513, tbMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSavePoint(TbSavepoint tbSavepoint) throws SQLException {
        String string = null;
        try {
            string = tbSavepoint.getSavepointName();
        }
        catch (SQLException sQLException) {
            string = "SVPT" + tbSavepoint.getSavepointId();
        }
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.SAVEPT(this.stream, string);
            TbMsg tbMsg = this.stream.readMsg();
            switch (tbMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)tbMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90514, tbMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(tbMsg.getMsgType());
                }
            }
        }
    }

    private void throwEreply(int n, TbMsg tbMsg) throws SQLException {
        SQLException sQLException = this.getErrorMessage(n, tbMsg);
        throw sQLException;
    }

    private void throwProtocolError(int n) throws SQLException {
        throw TbError.newSQLException(-590727, n);
    }

    public void truncate(TbLob tbLob, long l) throws SQLException {
        if (tbLob instanceof TbNClob) {
            l *= (long)this.typeConverter.getMaxBytesPerNChar();
        } else if (tbLob instanceof TbClob) {
            l *= (long)this.typeConverter.getUCS2MaxBytesPerChar();
        }
        this.lobTruncate(tbLob, l);
    }

    public long write(TbBlob tbBlob, long l, byte[] byArray, long l2, long l3) throws SQLException {
        boolean bl = true;
        boolean bl2 = false;
        int n = 0;
        long l4 = 0L;
        int n2 = 0;
        if (l3 <= (long)TbLob.getMaxChunkSize()) {
            this.lobWrite(tbBlob, l, null, byArray, l2, l3, 0x3000000);
            return l3;
        }
        do {
            if (l3 - l4 > (long)TbLob.getMaxChunkSize()) {
                n = TbLob.getMaxChunkSize();
            } else {
                n = (int)(l3 - l4);
                bl2 = true;
            }
            n2 = 0;
            if (bl) {
                n2 = 0x1000000;
            } else if (bl2) {
                n2 = 0x2000000;
            }
            this.lobWrite(tbBlob, l + l4, null, byArray, l2 + l4, n, n2);
            bl = false;
        } while (l3 > (l4 += (long)n));
        return l4;
    }

    public long write(TbClobBase tbClobBase, long l, char[] cArray, long l2, long l3) throws SQLException {
        boolean bl = true;
        boolean bl2 = false;
        int n = 0;
        long l4 = 0L;
        int n2 = 0;
        int n3 = 2;
        int n4 = TbLob.getMaxChunkSize() / n3;
        long l5 = l * (long)n3;
        if (l3 <= (long)n4) {
            this.lobWrite(tbClobBase, l5, cArray, null, l2, l3, 0x3000000);
            return l3;
        }
        do {
            if (l3 - l4 > (long)n4) {
                n = n4;
            } else {
                n = (int)(l3 - l4);
                bl2 = true;
            }
            n2 = 0;
            if (bl) {
                n2 = 0x1000000;
            } else if (bl2) {
                n2 = 0x2000000;
            }
            this.lobWrite(tbClobBase, l5, cArray, null, l2 + l4, n, n2);
            l5 += (long)(n * n3);
            bl = false;
        } while (l3 > (l4 += (long)n));
        return l4;
    }
}

