/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.util.TbCommon;
import java.text.NumberFormat;

public class TbIntervalYtm {
    private final int MID_INT = 0x40000000;
    public static final int TB_INTERVAL_YTM_SIZE = 5;
    private byte[] bytes;
    private int precision = 2;

    public TbIntervalYtm(byte[] byArray, int n) {
        this.bytes = byArray;
        if (n >= 0) {
            this.precision = n;
        }
    }

    public TbIntervalYtm(int n, int n2) {
        if (this.bytes == null) {
            this.bytes = new byte[5];
        }
        TbCommon.int2Bytes(n += 0x40000000, this.bytes, 0, 4);
        this.bytes[4] = (byte)(n2 += 11);
    }

    public String toString() {
        int n = this.getIntFromBigEndianBytes(this.bytes, 0);
        int n2 = (0xFF & this.bytes[4]) - 11;
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(this.precision);
        NumberFormat numberFormat2 = NumberFormat.getIntegerInstance();
        numberFormat2.setGroupingUsed(false);
        numberFormat2.setMinimumIntegerDigits(2);
        n2 = Math.abs(n2);
        StringBuffer stringBuffer = new StringBuffer();
        if (n >= 0) {
            stringBuffer.append("+");
        }
        stringBuffer.append(numberFormat.format(n) + "-" + numberFormat2.format(n2));
        return stringBuffer.toString();
    }

    private int getIntFromBigEndianBytes(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            n2 |= (0xFF & byArray[n + i]) << 8 * (3 - i);
        }
        return n2 -= 0x40000000;
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

