/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.jdbc.data.BigLiteral;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.RsetType;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.driver.TbPreparedStatement;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.driver.TbResultSetBase;
import com.tmax.tibero.jdbc.driver.TbResultSetFactory;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.msg.TbPivotInfo;
import com.tmax.tibero.jdbc.util.TbSQLParser;
import com.tmax.tibero.jdbc.util.TbSQLTypeScanner;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TbStatement
extends com.tmax.tibero.jdbc.TbStatement {
    protected int queryTimeout = 0;
    protected int fetchDirection = 1000;
    protected int maxRow = 0;
    protected int sqlType = 0;
    protected TbConnection conn;
    protected DataTypeConverter typeConverter;
    protected RsetType userRsetType;
    protected RsetType realRsetType;
    protected String originalSql;
    protected String sqlWithRowId;
    protected boolean rsetTypeDowngraded;
    protected SQLWarning warnings;
    protected TbSQLTypeScanner sqlTypeScanner;
    protected boolean enableEscapeProcessing = true;
    private boolean closed;
    protected boolean isExecuting;
    protected List batchStmts;
    protected int[] batchCounts;
    protected TbResultSet currentRs;
    protected ArrayList subResultSets;
    protected int rowsUpdated = -1;
    protected boolean noMoreUpdateCount;
    protected int curCsrId = -1;
    protected int maxFieldSize = 65535;
    protected int preFetchSize;
    protected int fetchSize = this.preFetchSize = 64000;
    protected TbPivotInfo[] pivotInfo;
    protected Vector pivotData = new Vector();
    protected boolean returnAutoGeneratedKeys = false;
    protected boolean poolable;
    private TbSQLParser sqlParser;

    public TbStatement(TbConnection tbConnection) {
        this(tbConnection, 1003, 1007, 64000);
    }

    public TbStatement(TbConnection tbConnection, int n, int n2, int n3) {
        this.conn = tbConnection;
        this.typeConverter = tbConnection.typeConverter;
        this.userRsetType = RsetType.getRsetType(n, n2);
        this.preFetchSize = n3;
        this.fetchSize = n3;
        this.closed = false;
        this.isExecuting = false;
        this.subResultSets = new ArrayList();
        this.poolable = tbConnection.info.isStmtCache();
        this.rsetTypeDowngraded = false;
        this.sqlParser = new TbSQLParser();
    }

    public synchronized void addBatch(String string) throws SQLException {
        if (this.batchStmts == null) {
            this.batchStmts = new ArrayList();
        }
        this.batchStmts.add(string);
    }

    public void addPivotData(byte[] byArray) {
        this.pivotData.add(byArray);
    }

    public void cancel() throws SQLException {
        if (this.closed || this.conn == null || this.conn.isClosed()) {
            return;
        }
        if (this.isExecuting) {
            this.conn.getTbComm().cancelStatement();
        }
    }

    protected void checkBatchStmtRemained() throws SQLException {
        if (this.batchStmts.size() > 0) {
            throw TbError.newSQLException(-90606);
        }
    }

    protected void checkConnectionOpen() throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
    }

    public synchronized void clearBatch() throws SQLException {
        if (this.batchStmts != null) {
            this.batchStmts.clear();
            this.batchStmts = null;
        }
    }

    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public synchronized void close() throws SQLException {
        if (this.conn != null && this.conn.getStmtCache() != null && this.conn.getStmtCache().add(this, 0)) {
            return;
        }
        this.closeInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeInternal() throws SQLException {
        try {
            this.closeResultSets();
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.reset();
        }
    }

    private void closeResultSets() throws SQLException {
        if (this.subResultSets.size() > 0) {
            Iterator iterator = this.subResultSets.iterator();
            while (iterator.hasNext()) {
                ResultSet resultSet = (ResultSet)iterator.next();
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            this.subResultSets.removeAll(this.subResultSets);
        }
        if (this.currentRs != null) {
            this.currentRs.close();
            this.currentRs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean execute(String string) throws SQLException {
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = false;
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(string);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        return this.currentRs != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String string, int n) throws SQLException {
        if (n == 2) {
            return this.execute(string);
        }
        if (n != 1) {
            TbError.newSQLException(-590733);
        }
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(string);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String string, int[] nArray) throws SQLException {
        if (nArray == null || nArray.length == 0) {
            TbError.newSQLException(-590732);
        }
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(string, nArray);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String string, String[] stringArray) throws SQLException {
        if (stringArray == null || stringArray.length == 0) {
            TbError.newSQLException(-590734);
        }
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(string, stringArray);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        return false;
    }

    boolean isInsertStmt(String string) {
        if (string != null) {
            return this.sqlType == 36;
        }
        return false;
    }

    public synchronized int[] executeBatch() throws SQLException {
        this.checkConnectionOpen();
        this.initBeforeExecute();
        if (this.batchStmts == null) {
            return new int[0];
        }
        int n = this.batchStmts.size();
        if (n <= 0) {
            return new int[0];
        }
        this.batchCounts = new int[n];
        int n2 = 0;
        try {
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
            }
            this.isExecuting = true;
            for (n2 = 0; n2 < n; ++n2) {
                this.batchCounts[n2] = this.executeInternal((String)this.batchStmts.get(n2));
                if (this.currentRs == null) continue;
                throw TbError.newSQLException(-90630);
            }
            int[] nArray = this.batchCounts;
            return nArray;
        }
        catch (SQLException sQLException) {
            int[] nArray = new int[n2];
            System.arraycopy(this.batchCounts, 0, nArray, 0, n2);
            this.batchCounts = nArray;
            throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), this.batchCounts);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
            this.clearBatch();
        }
    }

    private synchronized int executeInternal(String string) throws SQLException {
        return this.executeInternal(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int executeInternal(String string, Object object) throws SQLException {
        Object object2;
        Object object3;
        this.initSql(string);
        if (!this.isInsertStmt(string)) {
            this.returnAutoGeneratedKeys = false;
        }
        int n = this.conn.typeConverter.getMaxBytesPerChar();
        if (this.originalSql.length() > 65535 / n) {
            object3 = new ArrayList();
            object2 = TbSQLParser.getBigLiteral(this.originalSql, n, object3);
            int n2 = ((ArrayList)object3).size();
            if (n2 > 0) {
                TbPreparedStatement tbPreparedStatement = (TbPreparedStatement)this.conn.prepareStatement((String)object2);
                for (int i = 0; i < n2; ++i) {
                    BigLiteral bigLiteral = (BigLiteral)((ArrayList)object3).get(i);
                    tbPreparedStatement.setString(i + 1, bigLiteral.getLiteralValue());
                }
                ((ArrayList)object3).clear();
                return tbPreparedStatement.impl().executeInternal((String)object2);
            }
        }
        if (TbSQLTypeScanner.isQueryStmt(this.sqlType) && (this.userRsetType.getType() == 1005 || this.userRsetType.getConcurrency() == 1008)) {
            this.sqlWithRowId = this.getQueryWithRowId(this.originalSql);
            try {
                this.realRsetType = this.userRsetType;
                object3 = this.conn;
                synchronized (object3) {
                    return this.conn.getTbComm().executeDirect(this, this.sqlWithRowId);
                }
            }
            catch (SQLException sQLException) {
                this.realRsetType = RsetType.getDownGradedRsetType(this.userRsetType.getRank());
                object2 = this.conn;
                synchronized (object2) {
                    return this.conn.getTbComm().executeDirect(this, this.originalSql);
                }
            }
        }
        if (TbSQLTypeScanner.isDMLStmt(this.sqlType) || !TbSQLTypeScanner.isQueryStmt(this.sqlType) && !TbSQLTypeScanner.isPSMStmt(this.sqlType)) {
            this.realRsetType = this.userRsetType;
            object3 = this.originalSql;
            if (this.returnAutoGeneratedKeys) {
                if (this.realRsetType.isSensitive() || this.realRsetType.isUpdatable()) {
                    this.realRsetType = RsetType.SIRD;
                }
                if (object == null) {
                    object3 = this.getAutoGenSql(this.originalSql);
                } else if (object instanceof int[]) {
                    object3 = this.getAutoGenSql(this.originalSql, (int[])object);
                } else if (object instanceof String[]) {
                    object3 = this.getAutoGenSql(this.originalSql, (String[])object);
                }
            }
            object2 = this.conn;
            synchronized (object2) {
                this.rowsUpdated = this.conn.getTbComm().executeDirect(this, (String)object3);
            }
            return this.rowsUpdated;
        }
        this.realRsetType = this.userRsetType;
        object3 = this.conn;
        synchronized (object3) {
            return this.conn.getTbComm().executeDirect(this, this.originalSql);
        }
    }

    protected String getAutoGenSql(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(" RETURNING ROWID INTO GENKEY0");
        return stringBuffer.toString();
    }

    protected String getAutoGenSql(String string, String[] stringArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(" RETURNING ");
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[n]);
        }
        stringBuffer.append(" INTO ");
        for (n = 0; n < n2; ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("GENKEY").append(n);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getAutoGenSql(String string, int[] nArray) throws SQLException {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(" RETURNING ");
        int n3 = nArray.length;
        int n4 = string.toUpperCase().indexOf("INTO", this.sqlTypeScanner.getCurrentIndex());
        if (n4 < 0) {
            TbError.newSQLException(-90608);
        }
        int n5 = string.length();
        for (n2 = n4 + 5; n2 < n5 && string.charAt(n2) == ' '; ++n2) {
        }
        if (n2 >= n5) {
            TbError.newSQLException(-90608);
        }
        for (n = n2 + 1; n < n5 && string.charAt(n) != ' ' && string.charAt(n) != '('; ++n) {
        }
        String string2 = string.substring(n2, n);
        Statement statement = null;
        try {
            int n6;
            statement = this.conn.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * FROM " + string2);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n7 = resultSetMetaData.getColumnCount();
            for (n6 = 0; n6 < n3; ++n6) {
                if (nArray[n6] < 1 || nArray[n6] > n7) {
                    TbError.newSQLException(-90608);
                }
                if (n6 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(resultSetMetaData.getColumnName(nArray[n6]));
            }
            stringBuffer.append(" INTO ");
            for (n6 = 0; n6 < n3; ++n6) {
                if (n6 > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("GENKEY").append(n6);
            }
            String string3 = stringBuffer.toString();
            return string3;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultSet executeQuery(String string) throws SQLException {
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        if (this.queryTimeout > 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(string);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout > 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        if (this.currentRs == null) {
            this.currentRs = TbResultSetFactory.buildResultSet(this, -1, 0, 0);
        }
        return this.currentRs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int executeUpdate(String string) throws SQLException {
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = false;
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            int n = this.executeInternal(string);
            return n;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string, int n) throws SQLException {
        if (n == 2) {
            return this.executeUpdate(string);
        }
        if (n != 1) {
            TbError.newSQLException(-590733);
        }
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            int n2 = this.executeInternal(string);
            return n2;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        if (nArray == null || nArray.length == 0) {
            TbError.newSQLException(-590732);
        }
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            int n = this.executeInternal(string, nArray);
            return n;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        if (stringArray == null || stringArray.length == 0) {
            TbError.newSQLException(-590732);
        }
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            int n = this.executeInternal(string, stringArray);
            return n;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fetch(TbResultSetBase tbResultSetBase) throws SQLException {
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            this.conn.getTbComm().fetch(this, tbResultSetBase);
        }
    }

    public Connection getConnection() throws SQLException {
        this.checkConnectionOpen();
        return this.conn;
    }

    public int getCurCsrId() {
        return this.curCsrId;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.returnAutoGeneratedKeys) {
            return this.currentRs;
        }
        throw TbError.newSQLException(-90600);
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRow;
    }

    public synchronized boolean getMoreResults() throws SQLException {
        return false;
    }

    public boolean getMoreResults(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public String getOriginalSql() {
        return this.originalSql;
    }

    protected void initSql(String string) throws SQLException {
        if (string == null || string.length() <= 0) {
            throw TbError.newSQLException(-590737);
        }
        String string2 = null;
        string2 = this.conn.serverInfo.getServerCharSet() == 3 ? TbSQLParser.replaceIDEOGraphicSpace(string) : string;
        this.sqlTypeScanner = new TbSQLTypeScanner();
        this.sqlType = this.sqlTypeScanner.getSQLType(string2);
        if (136 != this.sqlType) {
            if (this.enableEscapeProcessing && string2.indexOf(123) >= 0) {
                string2 = this.sqlParser.parse(string2);
            }
            if (string2.indexOf(63) > 0) {
                string2 = TbSQLParser.replace(string2);
            }
        }
        this.originalSql = string2;
    }

    public Vector getPivotData() {
        return this.pivotData;
    }

    public TbPivotInfo[] getPivotInfo() {
        return this.pivotInfo;
    }

    public int getPreFetchSize() {
        if (TbSQLTypeScanner.isQueryStmt(this.getSqlType()) && this.getRealRsetType().getType() != 1005) {
            return this.preFetchSize;
        }
        return 0;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    protected String getQueryWithRowId(String string) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("select ROWIDTOCHAR(ROWID) _ROWID_CHAR0_, ROWID_ALIAS0.* from (").append(string).append(") ROWID_ALIAS0");
        return stringBuffer.toString();
    }

    public RsetType getUserRsetType() {
        return this.userRsetType;
    }

    public RsetType getRealRsetType() {
        return this.realRsetType;
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.returnAutoGeneratedKeys) {
            return null;
        }
        return this.currentRs;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.userRsetType.getConcurrency();
    }

    public int getResultSetHoldability() throws SQLException {
        return this.userRsetType.getHoldability();
    }

    public int getResultSetType() throws SQLException {
        return this.userRsetType.getType();
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public String getSqlWithRowId() {
        return this.sqlWithRowId;
    }

    public int getUpdateCount() throws SQLException {
        if (this.batchCounts != null) {
            int n = 0;
            for (int i = 0; i < this.batchCounts.length; ++i) {
                n += this.batchCounts[i];
            }
            return n;
        }
        if (!this.noMoreUpdateCount) {
            this.noMoreUpdateCount = true;
            return this.rowsUpdated;
        }
        return -1;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    protected void initBatchStmts() {
        if (this.batchStmts != null) {
            this.batchStmts.clear();
            this.batchStmts = null;
        }
    }

    protected void initBeforeExecute() throws SQLException {
        this.batchCounts = null;
        this.rowsUpdated = -1;
        this.noMoreUpdateCount = false;
        if (this.currentRs != null) {
            this.currentRs.close();
            this.currentRs = null;
        }
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public boolean isPoolable() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        return this.poolable;
    }

    protected void reset() {
        this.closed = true;
        this.warnings = null;
        this.conn = null;
        this.typeConverter = null;
        this.userRsetType = null;
        this.noMoreUpdateCount = false;
        this.returnAutoGeneratedKeys = false;
        this.currentRs = null;
        this.batchCounts = null;
        this.maxRow = 0;
        this.rsetTypeDowngraded = false;
        this.subResultSets.removeAll(this.subResultSets);
        if (this.batchStmts != null) {
            this.batchStmts.clear();
            this.batchStmts = null;
        }
    }

    public void resetForCache() {
        this.currentRs = null;
        this.batchCounts = null;
        this.warnings = null;
        this.subResultSets.removeAll(this.subResultSets);
        if (this.batchStmts != null) {
            this.batchStmts.clear();
            this.batchStmts = null;
        }
    }

    public void setCurCsrId(int n) {
        this.curCsrId = n;
    }

    public void setCursorName(String string) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public synchronized void setEscapeProcessing(boolean bl) throws SQLException {
        this.enableEscapeProcessing = bl;
    }

    public synchronized void setFetchDirection(int n) throws SQLException {
        switch (n) {
            case 1000: 
            case 1002: {
                this.fetchDirection = 1000;
                return;
            }
            case 1001: {
                this.fetchDirection = 1001;
            }
        }
        throw TbError.newSQLException(-590738);
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        if (n == 0) {
            this.fetchSize = 50;
        } else if (n > 0) {
            this.fetchSize = n;
        } else {
            throw TbError.newSQLException(-590735);
        }
    }

    public synchronized void setPreparedFetchSize(int n) throws SQLException {
        if (n == 0) {
            this.fetchSize = 50;
        } else if (n > 0) {
            this.fetchSize = n > 64 ? -64 : n * -1;
        } else {
            throw TbError.newSQLException(-590735);
        }
    }

    public void setMaxFieldSize(int n) throws SQLException {
        if (n < 0) {
            throw TbError.newSQLException(-590739);
        }
        this.maxFieldSize = n;
    }

    public synchronized void setMaxRows(int n) throws SQLException {
        if (n < 0) {
            throw TbError.newSQLException(-590740);
        }
        this.maxRow = n;
    }

    public void setPivotInfo(TbPivotInfo[] tbPivotInfoArray) {
        this.pivotInfo = tbPivotInfoArray;
    }

    public void setPoolable(boolean bl) throws SQLException {
        this.poolable = bl;
    }

    public synchronized void setQueryTimeout(int n) throws SQLException {
        if (n < 0) {
            throw TbError.newSQLException(-590741);
        }
        this.queryTimeout = n;
    }

    public void setResultSet(TbResultSet tbResultSet) {
        this.currentRs = tbResultSet;
    }

    public void addSubResultSet(TbResultSet tbResultSet) {
        this.subResultSets.add(tbResultSet);
    }

    public synchronized void setRowPreFetch(int n) throws SQLException {
        if (n < 0) {
            throw TbError.newSQLException(-590735);
        }
        this.preFetchSize = n;
        if (n == 0) {
            this.setFetchSize(50);
        } else {
            this.setFetchSize(n);
        }
    }

    boolean isReturnAutoGeneratedKeys() {
        return this.returnAutoGeneratedKeys;
    }

    protected void setReturnAutoGeneratedKeys(boolean bl) {
        this.returnAutoGeneratedKeys = bl;
    }
}

