/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import sun.misc.Unsafe;
import sun.nio.fs.AbstractPoller;
import sun.nio.fs.AbstractWatchKey;
import sun.nio.fs.AbstractWatchService;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileKey;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class SolarisWatchService
extends AbstractWatchService {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static int addressSize = unsafe.addressSize();
    private static final int SIZEOF_PORT_EVENT = SolarisWatchService.dependsArch(16, 24);
    private static final int OFFSETOF_EVENTS = 0;
    private static final int OFFSETOF_SOURCE = 4;
    private static final int OFFSETOF_OBJECT = 8;
    private static final int SIZEOF_FILEOBJ = SolarisWatchService.dependsArch(40, 80);
    private static final int OFFSET_FO_NAME = SolarisWatchService.dependsArch(36, 72);
    private static final short PORT_SOURCE_USER = 3;
    private static final short PORT_SOURCE_FILE = 7;
    private static final int FILE_MODIFIED = 2;
    private static final int FILE_ATTRIB = 4;
    private static final int FILE_NOFOLLOW = 0x10000000;
    private static final int FILE_DELETE = 16;
    private static final int FILE_RENAME_TO = 32;
    private static final int FILE_RENAME_FROM = 64;
    private static final int UNMOUNTED = 0x20000000;
    private static final int MOUNTEDOVER = 0x40000000;
    private final Poller poller;

    private static int dependsArch(int n, int n2) {
        return addressSize == 4 ? n : n2;
    }

    SolarisWatchService(UnixFileSystem unixFileSystem) throws IOException {
        int n = -1;
        try {
            n = SolarisWatchService.portCreate();
        }
        catch (UnixException unixException) {
            throw new IOException(unixException.errorString());
        }
        this.poller = new Poller(unixFileSystem, this, n);
        this.poller.start();
    }

    @Override
    WatchKey register(Path path, WatchEvent.Kind<?>[] kindArray, WatchEvent.Modifier ... modifierArray) throws IOException {
        return this.poller.register(path, kindArray, modifierArray);
    }

    @Override
    void implClose() throws IOException {
        this.poller.close();
    }

    private static native void init();

    private static native int portCreate() throws UnixException;

    private static native void portAssociate(int var0, int var1, long var2, int var4) throws UnixException;

    private static native void portDissociate(int var0, int var1, long var2) throws UnixException;

    private static native void portSend(int var0, int var1) throws UnixException;

    private static native int portGetn(int var0, long var1, int var3) throws UnixException;

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("nio");
                return null;
            }
        });
        SolarisWatchService.init();
    }

    private static class EntryNode
    implements Node {
        private final long object;
        private final Path name;
        private final DirectoryNode parent;

        EntryNode(long l, Path path, DirectoryNode directoryNode) {
            this.object = l;
            this.name = path;
            this.parent = directoryNode;
        }

        @Override
        public long object() {
            return this.object;
        }

        Path name() {
            return this.name;
        }

        DirectoryNode parent() {
            return this.parent;
        }
    }

    private static interface DirectoryNode
    extends Node {
        public void addChild(Path var1, EntryNode var2);

        public void removeChild(Path var1);

        public EntryNode getChild(Path var1);
    }

    private static interface Node {
        public long object();
    }

    private class Poller
    extends AbstractPoller {
        private static final int MAX_EVENT_COUNT = 128;
        private static final int FILE_REMOVED = 112;
        private static final int FILE_EXCEPTION = 0x60000070;
        private final long bufferAddress;
        private final SolarisWatchService watcher;
        private final int port;
        private final Map<UnixFileKey, SolarisWatchKey> fileKey2WatchKey;
        private final Map<Long, Node> object2Node;

        Poller(UnixFileSystem unixFileSystem, SolarisWatchService solarisWatchService2, int n) {
            this.watcher = solarisWatchService2;
            this.port = n;
            this.bufferAddress = unsafe.allocateMemory(SIZEOF_PORT_EVENT * 128);
            this.fileKey2WatchKey = new HashMap<UnixFileKey, SolarisWatchKey>();
            this.object2Node = new HashMap<Long, Node>();
        }

        @Override
        void wakeup() throws IOException {
            try {
                SolarisWatchService.portSend(this.port, 0);
            }
            catch (UnixException unixException) {
                throw new IOException(unixException.errorString());
            }
        }

        @Override
        Object implRegister(Path path, Set<? extends WatchEvent.Kind<?>> set, WatchEvent.Modifier ... modifierArray) {
            if (modifierArray.length > 0) {
                for (WatchEvent.Modifier object2 : modifierArray) {
                    if (object2 == null) {
                        return new NullPointerException();
                    }
                    if (object2 instanceof SensitivityWatchEventModifier) continue;
                    return new UnsupportedOperationException("Modifier not supported");
                }
            }
            UnixPath unixPath = (UnixPath)path;
            UnixFileAttributes unixFileAttributes = null;
            try {
                unixFileAttributes = UnixFileAttributes.get(unixPath, true);
            }
            catch (UnixException unixException) {
                return unixException.asIOException(unixPath);
            }
            if (!unixFileAttributes.isDirectory()) {
                return new NotDirectoryException(unixPath.getPathForExceptionMessage());
            }
            UnixFileKey unixFileKey = unixFileAttributes.fileKey();
            SolarisWatchKey solarisWatchKey = this.fileKey2WatchKey.get(unixFileKey);
            if (solarisWatchKey != null) {
                this.updateEvents(solarisWatchKey, set);
                return solarisWatchKey;
            }
            long l = 0L;
            try {
                l = this.registerImpl(unixPath, 6);
            }
            catch (UnixException unixException) {
                return unixException.asIOException(unixPath);
            }
            SolarisWatchKey solarisWatchKey2 = new SolarisWatchKey(this.watcher, unixPath, unixFileKey, l, set);
            this.object2Node.put(l, solarisWatchKey2);
            this.fileKey2WatchKey.put(unixFileKey, solarisWatchKey2);
            this.registerChildren(unixPath, solarisWatchKey2, false);
            return solarisWatchKey2;
        }

        @Override
        void implCancelKey(WatchKey watchKey) {
            SolarisWatchKey solarisWatchKey = (SolarisWatchKey)watchKey;
            if (solarisWatchKey.isValid()) {
                this.fileKey2WatchKey.remove(solarisWatchKey.getFileKey());
                if (solarisWatchKey.children != null) {
                    for (Map.Entry entry : solarisWatchKey.children.entrySet()) {
                        EntryNode entryNode = (EntryNode)entry.getValue();
                        long l = entryNode.object();
                        this.object2Node.remove(l);
                        this.releaseObject(l, true);
                    }
                }
                long l = solarisWatchKey.object();
                this.object2Node.remove(l);
                this.releaseObject(l, true);
                solarisWatchKey.invalidate();
            }
        }

        @Override
        void implCloseAll() {
            for (Long object : this.object2Node.keySet()) {
                this.releaseObject(object, true);
            }
            for (Map.Entry entry : this.fileKey2WatchKey.entrySet()) {
                ((SolarisWatchKey)entry.getValue()).invalidate();
            }
            this.object2Node.clear();
            this.fileKey2WatchKey.clear();
            unsafe.freeMemory(this.bufferAddress);
            UnixNativeDispatcher.close(this.port);
        }

        @Override
        public void run() {
            try {
                block2: while (true) {
                    int n = SolarisWatchService.portGetn(this.port, this.bufferAddress, 128);
                    assert (n > 0);
                    long l = this.bufferAddress;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block2;
                        boolean bl = this.processEvent(l);
                        if (bl) {
                            return;
                        }
                        l += (long)SIZEOF_PORT_EVENT;
                        ++n2;
                    }
                    break;
                }
            }
            catch (UnixException unixException) {
                unixException.printStackTrace();
                return;
            }
        }

        boolean processEvent(long l) {
            short s = unsafe.getShort(l + 4L);
            long l2 = unsafe.getAddress(l + 8L);
            int n = unsafe.getInt(l + 0L);
            if (s != 7) {
                boolean bl;
                return s == 3 && (bl = this.processRequests());
            }
            Node node = this.object2Node.get(l2);
            if (node == null) {
                return false;
            }
            boolean bl = true;
            boolean bl2 = node instanceof SolarisWatchKey;
            if (bl2) {
                this.processDirectoryEvents((SolarisWatchKey)node, n);
            } else {
                boolean bl3 = this.processEntryEvents((EntryNode)node, n);
                if (bl3) {
                    bl = false;
                }
            }
            if (bl) {
                try {
                    n = 6;
                    if (!bl2) {
                        n |= 0x10000000;
                    }
                    SolarisWatchService.portAssociate(this.port, 7, l2, n);
                }
                catch (UnixException unixException) {
                    bl = false;
                }
            }
            if (!bl) {
                this.object2Node.remove(l2);
                this.releaseObject(l2, false);
                if (bl2) {
                    SolarisWatchKey solarisWatchKey = (SolarisWatchKey)node;
                    this.fileKey2WatchKey.remove(solarisWatchKey.getFileKey());
                    solarisWatchKey.invalidate();
                    solarisWatchKey.signal();
                } else {
                    EntryNode entryNode = (EntryNode)node;
                    SolarisWatchKey solarisWatchKey = (SolarisWatchKey)entryNode.parent();
                    solarisWatchKey.removeChild(entryNode.name());
                }
            }
            return false;
        }

        void processDirectoryEvents(SolarisWatchKey solarisWatchKey, int n) {
            if ((n & 6) != 0) {
                this.registerChildren(solarisWatchKey.getDirectory(), solarisWatchKey, solarisWatchKey.events().contains(StandardWatchEventKinds.ENTRY_CREATE));
            }
        }

        boolean processEntryEvents(EntryNode entryNode, int n) {
            SolarisWatchKey solarisWatchKey = (SolarisWatchKey)entryNode.parent();
            Set<WatchEvent.Kind<?>> set = solarisWatchKey.events();
            if (set == null) {
                return true;
            }
            if ((n & 6) != 0 && set.contains(StandardWatchEventKinds.ENTRY_MODIFY)) {
                solarisWatchKey.signalEvent(StandardWatchEventKinds.ENTRY_MODIFY, entryNode.name());
            }
            if ((n & 0x70) != 0 && set.contains(StandardWatchEventKinds.ENTRY_DELETE)) {
                boolean bl = true;
                try {
                    UnixFileAttributes.get(solarisWatchKey.getDirectory().resolve(entryNode.name()), false);
                    bl = false;
                }
                catch (UnixException unixException) {
                    // empty catch block
                }
                if (bl) {
                    solarisWatchKey.signalEvent(StandardWatchEventKinds.ENTRY_DELETE, entryNode.name());
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerChildren(UnixPath unixPath, SolarisWatchKey solarisWatchKey, boolean bl) {
            int n = 0x10000000;
            if (solarisWatchKey.events().contains(StandardWatchEventKinds.ENTRY_MODIFY)) {
                n |= 6;
            }
            DirectoryStream<Path> directoryStream = null;
            try {
                directoryStream = Files.newDirectoryStream(unixPath);
            }
            catch (IOException iOException) {
                return;
            }
            try {
                for (Path path : directoryStream) {
                    Path path2 = path.getFileName();
                    if (solarisWatchKey.getChild(path2) != null) continue;
                    if (bl) {
                        solarisWatchKey.signalEvent(StandardWatchEventKinds.ENTRY_CREATE, path2);
                    }
                    long l = 0L;
                    try {
                        l = this.registerImpl((UnixPath)path, n);
                    }
                    catch (UnixException unixException) {
                        continue;
                    }
                    EntryNode entryNode = new EntryNode(l, path.getFileName(), solarisWatchKey);
                    solarisWatchKey.addChild(path.getFileName(), entryNode);
                    this.object2Node.put(l, entryNode);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
            }
            finally {
                try {
                    directoryStream.close();
                }
                catch (IOException iOException) {}
            }
        }

        void updateEvents(SolarisWatchKey solarisWatchKey, Set<? extends WatchEvent.Kind<?>> set) {
            boolean bl = solarisWatchKey.events().contains(StandardWatchEventKinds.ENTRY_MODIFY);
            solarisWatchKey.setEvents(set);
            boolean bl2 = set.contains(StandardWatchEventKinds.ENTRY_MODIFY);
            if (bl == bl2) {
                return;
            }
            if (solarisWatchKey.children != null) {
                int n = 0x10000000;
                if (bl2) {
                    n |= 6;
                }
                for (Map.Entry entry : solarisWatchKey.children.entrySet()) {
                    long l = ((EntryNode)entry.getValue()).object();
                    try {
                        SolarisWatchService.portAssociate(this.port, 7, l, n);
                    }
                    catch (UnixException unixException) {}
                }
            }
        }

        long registerImpl(UnixPath unixPath, int n) throws UnixException {
            byte[] byArray = unixPath.getByteArrayForSysCalls();
            int n2 = byArray.length;
            long l = unsafe.allocateMemory(n2 + 1);
            unsafe.copyMemory(byArray, Unsafe.ARRAY_BYTE_BASE_OFFSET, null, l, n2);
            unsafe.putByte(l + (long)n2, (byte)0);
            long l2 = unsafe.allocateMemory(SIZEOF_FILEOBJ);
            unsafe.setMemory(null, l2, SIZEOF_FILEOBJ, (byte)0);
            unsafe.putAddress(l2 + (long)OFFSET_FO_NAME, l);
            try {
                SolarisWatchService.portAssociate(this.port, 7, l2, n);
            }
            catch (UnixException unixException) {
                if (unixException.errno() == 11) {
                    System.err.println("The maximum number of objects associated with the port has been reached");
                }
                unsafe.freeMemory(l);
                unsafe.freeMemory(l2);
                throw unixException;
            }
            return l2;
        }

        void releaseObject(long l, boolean bl) {
            if (bl) {
                try {
                    SolarisWatchService.portDissociate(this.port, 7, l);
                }
                catch (UnixException unixException) {
                    // empty catch block
                }
            }
            long l2 = unsafe.getAddress(l + (long)OFFSET_FO_NAME);
            unsafe.freeMemory(l2);
            unsafe.freeMemory(l);
        }
    }

    private class SolarisWatchKey
    extends AbstractWatchKey
    implements DirectoryNode {
        private final UnixFileKey fileKey;
        private final long object;
        private volatile Set<? extends WatchEvent.Kind<?>> events;
        private Map<Path, EntryNode> children;

        SolarisWatchKey(SolarisWatchService solarisWatchService2, UnixPath unixPath, UnixFileKey unixFileKey, long l, Set<? extends WatchEvent.Kind<?>> set) {
            super(unixPath, solarisWatchService2);
            this.fileKey = unixFileKey;
            this.object = l;
            this.events = set;
        }

        UnixPath getDirectory() {
            return (UnixPath)this.watchable();
        }

        UnixFileKey getFileKey() {
            return this.fileKey;
        }

        @Override
        public long object() {
            return this.object;
        }

        void invalidate() {
            this.events = null;
        }

        Set<? extends WatchEvent.Kind<?>> events() {
            return this.events;
        }

        void setEvents(Set<? extends WatchEvent.Kind<?>> set) {
            this.events = set;
        }

        @Override
        public boolean isValid() {
            return this.events != null;
        }

        @Override
        public void cancel() {
            if (this.isValid()) {
                SolarisWatchService.this.poller.cancel(this);
            }
        }

        @Override
        public void addChild(Path path, EntryNode entryNode) {
            if (this.children == null) {
                this.children = new HashMap<Path, EntryNode>();
            }
            this.children.put(path, entryNode);
        }

        @Override
        public void removeChild(Path path) {
            this.children.remove(path);
        }

        @Override
        public EntryNode getChild(Path path) {
            if (this.children != null) {
                return this.children.get(path);
            }
            return null;
        }
    }
}

