/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import sun.misc.Unsafe;
import sun.nio.ch.Util;

class DevPoll {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int SIZEOF_EPOLLEVENT = DevPoll.eventSize();
    private static final int OFFSETOF_EVENTS = DevPoll.eventsOffset();
    private static final int OFFSETOF_FD = DevPoll.descriptorOffset();
    private static final int OFFSETOF_REVENTS = DevPoll.reventsOffset();

    private DevPoll() {
    }

    static long allocatePollArray(int n) {
        return unsafe.allocateMemory(n * SIZEOF_EPOLLEVENT);
    }

    static void freePollArray(long l) {
        unsafe.freeMemory(l);
    }

    static long getEvent(long l, int n) {
        return l + (long)(SIZEOF_EPOLLEVENT * n);
    }

    static int getDescriptor(long l) {
        return unsafe.getInt(l + (long)OFFSETOF_FD);
    }

    static int getEvents(long l) {
        return unsafe.getShort(l + (long)OFFSETOF_EVENTS);
    }

    static int getRevents(long l) {
        return unsafe.getShort(l + (long)OFFSETOF_REVENTS);
    }

    private static native int eventSize();

    private static native int eventsOffset();

    private static native int reventsOffset();

    private static native int descriptorOffset();

    static native int devPollOpen() throws IOException;

    static native int devPollWrite(int var0, int var1, int var2);

    static native int devPollioctl(int var0, long var1, int var3) throws IOException;

    static {
        Util.load();
    }
}

